/*
 * Decompiled with CFR 0.152.
 */
package factorization.beauty;

import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.util.SpaceUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraftforge.common.util.ForgeDirection;

public class Symmetry {
    final Coord center;
    final int max_radius;
    ForgeDirection normal;
    ForgeDirection right;
    ForgeDirection up;
    public int score = 0;
    public int asymetry = 0;
    public int max_score;
    public double measured_radius = 1.0;

    public Symmetry(Coord center, int max_radius, ForgeDirection normal) {
        this.center = center;
        this.max_radius = max_radius;
        this.normal = normal;
        this.score += this.scoreBlock(center);
        int normAxis = SpaceUtil.getAxis(normal);
        int upAxis = -1;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int axis = SpaceUtil.getAxis(dir);
            if (upAxis == -1 && axis != normAxis) {
                upAxis = axis;
                this.up = dir;
                continue;
            }
            if (axis == normAxis || axis == upAxis) continue;
            this.right = dir;
            break;
        }
        this.max_score = max_radius * max_radius * 4 * 1;
        assert (normal != null && this.right != null && this.up != null);
    }

    public void calculate() {
        ForgeDirection[] rights = new ForgeDirection[4];
        ForgeDirection[] ups = new ForgeDirection[4];
        DeltaCoord[] dRight = new DeltaCoord[4];
        DeltaCoord[] dUp = new DeltaCoord[4];
        ForgeDirection _R = this.right;
        ForgeDirection _U = this.up;
        for (int i = 0; i < 4; ++i) {
            rights[i] = _R;
            ups[i] = _U;
            _R = _R.getRotation(this.normal);
            _U = _U.getRotation(this.normal);
            dRight[i] = new DeltaCoord();
        }
        for (int r = 1; r <= this.max_radius; ++r) {
            this.move(dRight, rights);
            for (int i = 0; i < 4; ++i) {
                dUp[i] = new DeltaCoord(dRight[i]);
            }
            for (int y = 0; y <= this.max_radius; ++y) {
                Block found = null;
                boolean all_match = true;
                int spoke_score = 0;
                for (int i = 0; i < 4; ++i) {
                    Coord spoke = this.center.add(dUp[i]);
                    Block peeked = spoke.getBlock();
                    if (spoke.isSolid()) {
                        this.measured_radius = Math.max(this.measured_radius, dUp[i].magnitude());
                    }
                    if (found == null) {
                        found = peeked;
                        spoke_score = this.scoreBlock(spoke);
                        continue;
                    }
                    if (peeked == found) continue;
                    all_match = false;
                    break;
                }
                if (all_match) {
                    this.score += spoke_score;
                } else {
                    ++this.asymetry;
                }
                this.move(dUp, ups);
            }
        }
    }

    void move(DeltaCoord[] deltas, ForgeDirection[] dirs) {
        for (int i = 0; i < 4; ++i) {
            deltas[i].move(dirs[i]);
        }
    }

    int scoreBlock(Coord at) {
        Block block = at.getBlock();
        Material mat = block.func_149688_o();
        if (mat == Material.field_151580_n || mat == Material.field_151575_d || mat == Material.field_151593_r || mat == Material.field_151573_f || mat == Material.field_76233_E || mat == Material.field_151571_B || mat == Material.field_151592_s || mat == Material.field_151569_G) {
            return 1;
        }
        if (block instanceof BlockLog || block instanceof BlockCarpet || block instanceof BlockFence || block instanceof BlockStairs) {
            return 1;
        }
        return 0;
    }
}

