/*
 * Decompiled with CFR 0.152.
 */
package factorization.beauty;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.ICoordFunction;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.charge.TileEntityCaliometricBurner;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.NetworkFactorization;
import factorization.shared.TileEntityCommon;
import factorization.util.InvUtil;
import factorization.util.ItemUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.INpc;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityAnthroGen
extends TileEntityCommon
implements IInventory,
ICoordFunction {
    public static int UPDATE_RATE = 8400;
    public static int MIN_WANDER_DISTANCE = 144;
    public static int VILLAGER_CHECKS_PER_ENTHEAS = 8;
    public static final int CHUNK_RANGE = 1;
    ItemStack entheas;
    int satisfactory_villagers;
    transient boolean isLit;
    private static final String hash_key = "anthrogen_last_seen";

    public TileEntityAnthroGen() {
        this.entheas = new ItemStack((Item)Core.registry.entheas, 0, 0);
        this.satisfactory_villagers = 0;
        this.isLit = false;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Default;
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        this.entheas = data.as(Share.PRIVATE, "entheas").putItemStack(this.entheas);
        this.satisfactory_villagers = data.as(Share.PRIVATE, "foundVillagers").putInt(this.satisfactory_villagers);
        this.isLit = data.as(Share.VISIBLE_TRANSIENT, "isLit").putBoolean(ItemUtil.stackSize(this.entheas) > 0);
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.ANTHRO_GEN;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        long now = this.field_145850_b.func_82737_E() + (long)this.hashCode();
        if (now % (long)UPDATE_RATE != 0L) {
            int entheasRate;
            int max_particle_rate = 16;
            if (now % (long)max_particle_rate == 0L && ItemUtil.stackSize(this.entheas) > 0 && (entheasRate = 1 + this.entheas.func_77976_d() - this.entheas.field_77994_a) > 0 && (now /= (long)max_particle_rate) % (long)entheasRate == 0L) {
                this.broadcastMessage(null, NetworkFactorization.MessageType.GeneratorParticles, new Object[0]);
            }
            return;
        }
        if (this.entheas == null) {
            this.entheas = new ItemStack((Item)Core.registry.entheas, 0, 0);
        }
        if (this.entheas.field_77994_a >= this.entheas.func_77976_d()) {
            return;
        }
        Coord at = this.getCoord();
        int d = 16;
        Coord min = at.add(-d, -d, -d);
        Coord max = at.add(d, d, d);
        Coord.iterateChunks(min, max, this);
        int add_entheas = this.satisfactory_villagers / VILLAGER_CHECKS_PER_ENTHEAS;
        this.satisfactory_villagers %= VILLAGER_CHECKS_PER_ENTHEAS;
        int oldSize = this.entheas.field_77994_a;
        this.entheas.field_77994_a += add_entheas;
        if (this.entheas.field_77994_a > this.entheas.func_77976_d()) {
            this.entheas.field_77994_a = this.entheas.func_77976_d();
        }
        if (oldSize == 0 && this.entheas.field_77994_a > 0) {
            this.sync();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (messageType == NetworkFactorization.MessageType.GeneratorParticles) {
            this.field_145850_b.func_72869_a("flame", (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 0.0, 0.0, 0.0);
            return true;
        }
        return super.handleMessageFromServer(messageType, input);
    }

    @Override
    public void handle(Coord here) {
        for (List list : here.getChunk().field_76645_j) {
            for (Object obj : list) {
                Entity ent = (Entity)obj;
                if (!(ent instanceof INpc) || !this.hashEnt(ent)) continue;
                ++this.satisfactory_villagers;
            }
        }
    }

    boolean hashEnt(Entity ent) {
        int oldZ;
        int oldY;
        int oldX;
        NBTTagCompound sub;
        if (ent.func_70115_ae()) {
            return false;
        }
        if (!ent.field_70122_E) {
            return false;
        }
        NBTTagCompound tag = ent.getEntityData();
        if (tag.func_74764_b(hash_key)) {
            sub = tag.func_74775_l(hash_key);
            oldX = sub.func_74762_e("x");
            oldY = sub.func_74762_e("y");
            oldZ = sub.func_74762_e("z");
        } else {
            sub = new NBTTagCompound();
            oldZ = Integer.MAX_VALUE;
            oldY = Integer.MAX_VALUE;
            oldX = Integer.MAX_VALUE;
        }
        int newX = (int)ent.field_70165_t;
        int newY = (int)ent.field_70163_u;
        int newZ = (int)ent.field_70161_v;
        int dx = newX - oldX;
        int dy = newY - oldY;
        int dz = newZ - oldZ;
        int dist = dx * dx + dy * dy + dz * dz;
        if (dist < MIN_WANDER_DISTANCE) {
            return false;
        }
        sub.func_74768_a("x", newX);
        sub.func_74768_a("y", newY);
        sub.func_74768_a("z", newZ);
        tag.func_74782_a(hash_key, (NBTBase)sub);
        return true;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot == 0) {
            return this.entheas;
        }
        return null;
    }

    void sync() {
        Coord at = this.getCoord();
        at.syncTE();
        at.sendRedraw();
    }

    public ItemStack func_70298_a(int slot, int amount) {
        int oldSize = ItemUtil.getStackSize(this.entheas);
        if (slot == 0 && this.entheas != null && this.entheas.field_77994_a > 0) {
            ItemStack ret = this.entheas.func_77979_a(amount);
            if (oldSize > 0 && ItemUtil.getStackSize(this.entheas) <= 0) {
                this.sync();
            }
            return ret;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot == 0) {
            boolean newState;
            boolean oldState = ItemUtil.getStackSize(this.entheas) > 0;
            this.entheas = stack;
            boolean bl = newState = ItemUtil.getStackSize(this.entheas) > 0;
            if (oldState != newState) {
                this.sync();
            }
        }
    }

    public String func_145825_b() {
        return "fz.AnthroGen";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public IIcon getIcon(ForgeDirection dir) {
        return BlockIcons.beauty$anthrogen;
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        if (ItemUtil.normalize(this.entheas) == null) {
            return;
        }
        Coord here = new Coord(this);
        InvUtil.spawnItemStack(here, this.entheas);
    }

    @Override
    public void click(EntityPlayer entityplayer) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (ItemUtil.normalize(this.entheas) == null) {
            return;
        }
        InvUtil.givePlayerItem(entityplayer, this.entheas);
        this.entheas = new ItemStack((Item)Core.registry.entheas, 0, 0);
        this.sync();
    }

    @Override
    public boolean isBlockSolidOnSide(int side) {
        return side == 0;
    }

    static {
        TileEntityCaliometricBurner.register(Core.registry.entheas, 2, 16.0);
    }
}

