/*
 * Decompiled with CFR 0.152.
 */
package factorization.beauty;

import factorization.api.Coord;
import factorization.api.ICoordFunction;
import factorization.api.IMeterInfo;
import factorization.api.IRotationalEnergySource;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.common.FactoryType;
import factorization.notify.Notice;
import factorization.notify.Style;
import factorization.shared.BlockClass;
import factorization.shared.BlockFactorization;
import factorization.shared.TileEntityCommon;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBiblioGen
extends TileEntityCommon
implements IRotationalEnergySource,
IMeterInfo {
    int bookCount = -1;
    double angle = 0.0;
    double prev_angle = 0.0;
    double availablePower = 0.0;
    static int LIBRARY_RADIUS = 24;
    static double POWER_PER_BOOK = 3.4147746234671665E-4;

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.BIBLIO_GEN;
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        this.bookCount = data.as(Share.VISIBLE, "bookCount").putInt(this.bookCount);
        this.availablePower = data.as(Share.PRIVATE, "availablePower").putDouble(this.availablePower);
    }

    void countBooks() {
        BookCounter bookCounter = new BookCounter(this.getCoord());
        int old_count = this.bookCount;
        this.bookCount = bookCounter.count();
        if (bookCounter.interference != null) {
            new Notice(bookCounter.interference, "x", new String[0]).withStyle(Style.LONG, Style.DRAWFAR, Style.SCALE_SIZE).sendToAll();
            new Notice(this, "factorization:bibliogen.interference", new String[0]).sendToAll();
        }
        if (this.bookCount != old_count) {
            this.broadcastMessage(null, this.getDescriptionPacket());
        }
    }

    @Override
    public boolean activate(EntityPlayer entityplayer, ForgeDirection side) {
        if (entityplayer.func_70093_af()) {
            this.bookCount = -1;
            return true;
        }
        return false;
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            this.prev_angle = this.angle;
            this.angle += this.getVelocity(ForgeDirection.DOWN);
        }
        long now = this.field_145850_b.func_82737_E() + (long)this.hashCode();
        if (this.bookCount == -1 || now % 2000L == 0L) {
            this.countBooks();
        }
        this.availablePower = (double)this.bookCount * POWER_PER_BOOK;
    }

    @Override
    public String getInfo() {
        return "Books: " + this.bookCount;
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        return direction == ForgeDirection.DOWN;
    }

    @Override
    public double availableEnergy(ForgeDirection direction) {
        if (direction != ForgeDirection.DOWN) {
            return 0.0;
        }
        return this.availablePower;
    }

    @Override
    public double takeEnergy(ForgeDirection direction, double maxPower) {
        if (direction != ForgeDirection.DOWN) {
            return 0.0;
        }
        return this.availablePower;
    }

    @Override
    public boolean isTileEntityInvalid() {
        return this.func_145837_r();
    }

    @Override
    public double getVelocity(ForgeDirection direction) {
        if (direction != ForgeDirection.DOWN) {
            return 0.0;
        }
        double v = (double)this.bookCount * POWER_PER_BOOK;
        if (v > 0.39269908169872414) {
            v = 0.39269908169872414;
        }
        return v;
    }

    @Override
    public void setBlockBounds(Block b) {
        b.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
    }

    @Override
    public IIcon getIcon(ForgeDirection dir) {
        return Blocks.field_150381_bn.func_149691_a(0, 0);
    }

    class BookCounter
    implements ICoordFunction {
        int books = 1;
        TileEntity interference = null;
        final Coord min;
        final Coord max;

        BookCounter(Coord start) {
            this.min = start.add(-LIBRARY_RADIUS, -LIBRARY_RADIUS, -LIBRARY_RADIUS);
            this.max = start.add(LIBRARY_RADIUS, LIBRARY_RADIUS, LIBRARY_RADIUS);
        }

        int count() {
            Coord.iterateCube(this.min, this.max, this);
            if (this.interference != null) {
                return 0;
            }
            return this.books;
        }

        @Override
        public void handle(Coord here) {
            TileEntity te;
            Block block = here.getBlock();
            if (block instanceof BlockFactorization && (te = (TileEntity)here.getTE(TileEntityBiblioGen.class)) != null && te != TileEntityBiblioGen.this) {
                this.interference = te;
            }
            this.books += block.getEnchantPowerBonus(here.w, here.x, here.y, here.z) > 0.0f ? 1 : 0;
        }
    }
}

