/*
 * Decompiled with CFR 0.152.
 */
package factorization.beauty;

import factorization.algos.FastBag;
import factorization.api.Coord;
import factorization.api.ICoordFunction;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.charge.TileEntityCaliometricBurner;
import factorization.common.FactoryType;
import factorization.notify.Notice;
import factorization.notify.Style;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.TileEntityCommon;
import factorization.util.FzUtil;
import factorization.util.InvUtil;
import factorization.util.ItemUtil;
import java.io.IOException;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySapTap
extends TileEntityCommon
implements ISidedInventory {
    ItemStack sap;
    int log_count;
    int leaf_count;
    long sap_rate;
    int ticks;
    static final int search_radius = 16;

    public TileEntitySapTap() {
        this.sap = new ItemStack((Item)Core.registry.sap, 0, 0);
        this.log_count = 0;
        this.leaf_count = 0;
        this.sap_rate = 0L;
        this.ticks = 0;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SAP_TAP;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot == 0) {
            return this.sap;
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (slot == 0) {
            if (this.sap.field_77994_a <= 0) {
                return null;
            }
            return this.sap.func_77979_a(amount);
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot == 0) {
            if (ItemUtil.getStackSize(stack) == 0) {
                stack = new ItemStack((Item)Core.registry.sap, 0, 0);
            }
            this.sap = stack;
        }
    }

    public String func_145825_b() {
        return "fz.sapextractor";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack == null;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Barrel;
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        this.sap = data.as(Share.PRIVATE, "sap").putItemStack(this.sap);
        this.log_count = data.as(Share.PRIVATE, "logCount").putInt(this.log_count);
        this.leaf_count = data.as(Share.PRIVATE, "leafCount").putInt(this.leaf_count);
        this.sap_rate = data.as(Share.PRIVATE, "sapRate").putLong(this.sap_rate);
        this.ticks = data.as(Share.PRIVATE, "ticks").putInt(this.ticks);
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        long nowish = this.field_145850_b.func_82737_E() + (long)this.hashCode();
        if (0L == nowish % 36000L) {
            this.scanTree(null);
        }
        if (this.sap_rate > 0L && (long)this.ticks++ > this.sap_rate) {
            this.ticks = 0;
            if (this.sap == null) {
                this.sap = new ItemStack((Item)Core.registry.sap, 0);
            }
            if (this.sap.field_77994_a < this.sap.func_77976_d()) {
                ++this.sap.field_77994_a;
            }
        }
    }

    void scanTree(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        try {
            Coord level = this.getCoord();
            TreeCounter ruler = new TreeCounter(level.add(-16, -8, -16), level.add(16, 32, 16), this.getCoord());
            ruler.calculate(1000);
            this.log_count = ruler.logs;
            this.leaf_count = ruler.leaves;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        int max_logs = this.leaf_count / 3;
        int effective_logs = Math.min(max_logs, this.log_count);
        int real_minimum = 192;
        if (effective_logs < 192) {
            effective_logs = (int)((float)effective_logs * ((float)effective_logs / 192.0f));
        }
        long ticks_per_log = 288000L;
        if (effective_logs <= 0) {
            this.sap_rate = 0L;
        } else {
            this.sap_rate = 288000L / (long)effective_logs;
            if (this.sap_rate < 10L) {
                this.sap_rate = 10L;
            }
        }
        if (player != null) {
            String sap_units = this.sap_rate <= 0L ? "\u221e" : FzUtil.unitTranslateTimeTicks(this.sap_rate, 2);
            new Notice(this, "factorization.factoryBlock.SAP_TAP.info", "" + this.log_count, "" + this.leaf_count, "" + effective_logs, sap_units).withStyle(Style.LONG).sendTo(player);
        }
    }

    @Override
    public void onPlacedBy(EntityPlayer player, ItemStack is, int side, float hitX, float hitY, float hitZ) {
        super.onPlacedBy(player, is, side, hitX, hitY, hitZ);
        this.scanTree(player);
    }

    @Override
    public boolean activate(EntityPlayer player, ForgeDirection side) {
        this.scanTree(player);
        return super.activate(player, side);
    }

    @Override
    public IIcon getIcon(ForgeDirection dir) {
        int md;
        Block bup;
        Block block = bup = this.field_145850_b == null ? Blocks.field_150344_f : this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        if (this.field_145850_b != null && bup.func_149688_o() == Material.field_151575_d && bup instanceof BlockLog) {
            md = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        } else {
            bup = Blocks.field_150363_s;
            md = 1;
        }
        return bup.func_149691_a(dir.ordinal(), md);
    }

    boolean isLog(Coord c) {
        Block b = c.getBlock();
        return b.func_149688_o() == Material.field_151575_d && b instanceof BlockLog;
    }

    @Override
    public boolean canPlaceAgainst(EntityPlayer player, Coord c, int side) {
        Coord at = this.getCoord();
        if (!this.isLog(at.add(ForgeDirection.UP))) {
            if (!this.field_145850_b.field_72995_K) {
                new Notice(at, "factorization.factoryBlock.SAP_TAP.belowlog", new String[0]).sendTo(player);
            }
            return false;
        }
        Coord min = at.add(-16, -16, -16);
        Coord max = at.add(16, 16, 16);
        CrowdedCheck cc = new CrowdedCheck();
        cc.at = at;
        Coord.iterateChunks(min, max, cc);
        if (cc.crowd != null) {
            if (!this.field_145850_b.field_72995_K) {
                new Notice(at, "factorization.factoryBlock.SAP_TAP.crowded", new String[0]).withStyle(Style.FORCE).sendTo(player);
                new Notice(cc.crowd, "factorization.factoryBlock.SAP_TAP.thecrowd", new String[0]).withStyle(Style.FORCE).sendTo(player);
            }
            return false;
        }
        return super.canPlaceAgainst(player, c, side);
    }

    public int[] func_94128_d(int side) {
        if (side == ForgeDirection.DOWN.ordinal()) {
            return new int[]{0};
        }
        return new int[0];
    }

    public boolean func_102007_a(int side, ItemStack stack, int slot) {
        return false;
    }

    public boolean func_102008_b(int side, ItemStack stack, int slot) {
        return slot == 0 && this.sap.field_77994_a > 1;
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        if (ItemUtil.normalize(this.sap) != null) {
            Coord here = new Coord(this);
            InvUtil.spawnItemStack(here, this.sap);
        }
    }

    @Override
    public void click(EntityPlayer entityplayer) {
        if (ItemUtil.normalize(this.sap) == null) {
            return;
        }
        InvUtil.givePlayerItem(entityplayer, this.sap);
        this.sap = new ItemStack((Item)Core.registry.sap, 0);
    }

    static {
        TileEntityCaliometricBurner.register(Core.registry.sap, 8, 0.5);
    }

    private class TreeCounter {
        final Coord start;
        final Coord min;
        final Coord max;
        final FastBag<Coord> frontier = new FastBag();
        final HashSet<Coord> visited = new HashSet();
        int logs = 0;
        int leaves = 0;
        static final byte WOOD = 1;
        static final byte LEAF = 2;
        static final byte NON = 0;

        public TreeCounter(Coord min, Coord max, Coord start) {
            this.start = start;
            this.min = min.copy();
            this.max = max.copy();
            Coord.sort(min, max);
            for (Coord c : start.getNeighborsAdjacent()) {
                if (this.kind(c) != 1) continue;
                this.check(c, (byte)1);
                this.frontier.add(c);
            }
        }

        void calculate(int n) {
            while (n-- > 0 && !this.frontier.isEmpty()) {
                Coord c = this.frontier.remove(0);
                this.visit(c);
            }
        }

        byte kind(Coord at) {
            Block block = at.getBlock();
            Material mat = block.func_149688_o();
            if (mat == Material.field_151575_d && block instanceof BlockLog) {
                return 1;
            }
            if (mat == Material.field_151584_j || mat == Material.field_151582_l) {
                return 2;
            }
            return 0;
        }

        boolean check(Coord at, byte kind) {
            this.visited.add(at);
            if (kind == 1) {
                ++this.logs;
                return true;
            }
            if (kind == 2) {
                ++this.leaves;
                return true;
            }
            return false;
        }

        void visit(Coord at) {
            byte atKind = this.kind(at);
            for (Coord n : at.getNeighborsDiagonal()) {
                if (!n.inside(this.min, this.max) || this.visited.contains(n)) continue;
                byte nKind = this.kind(n);
                if (atKind == 2 && nKind != 2 || !this.check(n, nKind)) continue;
                this.frontier.add(n);
            }
        }
    }

    private class CrowdedCheck
    implements ICoordFunction {
        Coord at;
        TileEntity crowd = null;

        private CrowdedCheck() {
        }

        @Override
        public void handle(Coord here) {
            Chunk chunk = here.getChunk();
            for (TileEntity te : chunk.field_150816_i.values()) {
                Coord tec;
                if (te.func_145837_r() || !(te instanceof TileEntitySapTap) || (tec = new Coord(te)).distanceSq(this.at) > 16) continue;
                this.crowd = te;
                return;
            }
        }
    }
}

