/*
 * Decompiled with CFR 0.152.
 */
package factorization.beauty;

import factorization.api.Coord;
import factorization.api.IRotationalEnergySource;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockClass;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.TileEntityCommon;
import factorization.util.NumUtil;
import factorization.util.SpaceUtil;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityShaft
extends TileEntityCommon
implements IRotationalEnergySource {
    ForgeDirection axis = ForgeDirection.UP;
    IRotationalEnergySource _src = null;
    Coord srcPos = null;
    double angle = 0.0;
    double prev_angle = 0.0;
    ForgeDirection srcConnection = ForgeDirection.UNKNOWN;
    boolean useCustomVelocity = false;
    double customVelocity = 0.0;
    byte velocitySign = 1;
    private static ThreadLocal<Boolean> working = new ThreadLocal();

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        this.axis = data.as(Share.VISIBLE, "axis").putEnum(this.axis);
        if (this.srcPos == null) {
            this.srcPos = this.getCoord();
        }
        this.srcPos = data.as(Share.VISIBLE, "src").putIDS(this.srcPos);
        this.srcConnection = data.as(Share.VISIBLE, "connectDir").putEnum(this.srcConnection);
        if (data.isReader()) {
            this._src = null;
        }
        this.useCustomVelocity = data.as(Share.VISIBLE, "useCustom").putBoolean(this.useCustomVelocity);
        this.customVelocity = data.as(Share.VISIBLE, "customVel").putDouble(this.customVelocity);
        this.velocitySign = data.as(Share.VISIBLE, "velocitySign").putByte(this.velocitySign);
        if (this.velocitySign == 0) {
            this.velocitySign = 1;
        }
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        if (this.srcPos != null) {
            this.srcPos.w = world;
        }
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SHAFT;
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            this.prev_angle = this.angle;
            if (this.useCustomVelocity) {
                this.angle += this.customVelocity * (double)this.velocitySign;
                return;
            }
            IRotationalEnergySource src = this.getSrc();
            if (src == null) {
                return;
            }
            this.angle += src.getVelocity(this.srcConnection) * (double)this.velocitySign;
        } else if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            IRotationalEnergySource src = this.getSrc();
            if (!(src instanceof TileEntity) && src != null) {
                this.useCustomVelocity = true;
                double newv = src.getVelocity(this.srcConnection);
                if (NumUtil.significantChange(newv, this.customVelocity)) {
                    this.customVelocity = newv;
                    this.broadcastMessage(null, this.getDescriptionPacket());
                }
            } else if (this.useCustomVelocity) {
                this.useCustomVelocity = false;
                this.customVelocity = 0.0;
                this.broadcastMessage(null, this.getDescriptionPacket());
            }
        }
    }

    public IRotationalEnergySource getSrc() {
        if (this._src == null) {
            if (this.srcPos == null) {
                return null;
            }
            if (this.srcPos.equals(this.getCoord())) {
                this._src = this.find();
                this.broadcastMessage(null, this.getDescriptionPacket());
                if (this._src == null) {
                    this._src = this;
                    return null;
                }
                return this._src;
            }
            TileEntity te = this.srcPos.getTE();
            this._src = IRotationalEnergySource.adapter.cast(te);
            if (this._src == null) {
                this._src = this;
            }
        }
        if (this._src == this) {
            return null;
        }
        if (this._src.isTileEntityInvalid()) {
            this._src = this;
        }
        return this._src;
    }

    private IRotationalEnergySource find() {
        this.srcPos = new Coord(this);
        Coord at = this.getCoord();
        IRotationalEnergySource found = this.find(at.copy(), this.axis.getOpposite());
        int p = 1;
        if (this.axis.offsetX != 0) {
            p = -1;
        }
        if (found != null) {
            this.velocitySign = (byte)p;
            return found;
        }
        this.velocitySign = (byte)(-p);
        return this.find(at, this.axis);
    }

    private IRotationalEnergySource find(Coord at, ForgeDirection dir) {
        TileEntity te;
        block3: {
            TileEntityShaft shaft;
            do {
                at.adjust(dir);
                if (at.isAir()) {
                    return null;
                }
                te = at.getTE();
                if (!(te instanceof TileEntityShaft) || te.func_145837_r()) break block3;
                shaft = (TileEntityShaft)te;
            } while (shaft.axis == this.axis);
            return null;
        }
        IRotationalEnergySource ret = IRotationalEnergySource.adapter.cast(te);
        if (ret != null) {
            this.srcConnection = dir.getOpposite();
            this.srcPos = at.copy();
        }
        return ret;
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        return direction == this.axis || direction == this.axis.getOpposite();
    }

    @Override
    public double availableEnergy(ForgeDirection direction) {
        IRotationalEnergySource src = this.getSrc();
        if (src == null) {
            return 0.0;
        }
        return src.availableEnergy(direction);
    }

    @Override
    public double takeEnergy(ForgeDirection direction, double maxPower) {
        IRotationalEnergySource src = this.getSrc();
        if (src == null) {
            return 0.0;
        }
        return src.takeEnergy(direction, maxPower);
    }

    @Override
    public double getVelocity(ForgeDirection direction) {
        IRotationalEnergySource src = this.getSrc();
        if (src == null) {
            return 0.0;
        }
        return src.getVelocity(direction) * (double)this.velocitySign;
    }

    @Override
    public boolean isTileEntityInvalid() {
        return this.func_145837_r();
    }

    @Override
    public void setBlockBounds(Block b) {
        ForgeDirection dir = this.axis;
        float l = 0.375f;
        float h = 1.0f - l;
        if (dir == ForgeDirection.SOUTH) {
            b.func_149676_a(l, l, 0.0f, h, h, 1.0f);
        } else if (dir == ForgeDirection.EAST) {
            b.func_149676_a(0.0f, l, l, 1.0f, h, h);
        } else {
            b.func_149676_a(l, 0.0f, l, h, 1.0f, h);
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        ForgeDirection dir = this.axis;
        float l = 0.375f;
        float h = 1.0f - l;
        if (dir == ForgeDirection.SOUTH) {
            return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + l), (double)((float)this.field_145848_d + l), (double)(this.field_145849_e + 0), (double)((float)this.field_145851_c + h), (double)((float)this.field_145848_d + h), (double)(this.field_145849_e + 1));
        }
        if (dir == ForgeDirection.EAST) {
            return AxisAlignedBB.func_72330_a((double)(this.field_145851_c + 0), (double)((float)this.field_145848_d + l), (double)((float)this.field_145849_e + l), (double)(this.field_145851_c + 1), (double)((float)this.field_145848_d + h), (double)((float)this.field_145849_e + h));
        }
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + l), (double)(this.field_145848_d + 0), (double)((float)this.field_145849_e + l), (double)((float)this.field_145851_c + h), (double)(this.field_145848_d + 1), (double)((float)this.field_145849_e + h));
    }

    @Override
    public MovingObjectPosition collisionRayTrace(Vec3 startVec, Vec3 endVec) {
        BlockRenderHelper block = this.field_145850_b.field_72995_K ? Core.registry.clientTraceHelper : Core.registry.serverTraceHelper;
        this.setBlockBounds(block);
        return block.func_149731_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, startVec, endVec);
    }

    @Override
    public void neighborChanged(Block neighbor) {
        this.invalidateConnections();
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        this.invalidateConnections();
    }

    private void invalidateConnections() {
        if (working.get() != null) {
            return;
        }
        working.set(true);
        try {
            this._src = null;
            this.srcPos = new Coord(this);
            Coord at = this.getCoord();
            this.invalidateLine(at.copy(), this.axis);
            this.invalidateLine(at, this.axis.getOpposite());
        }
        finally {
            working.remove();
        }
    }

    void invalidateLine(Coord at, ForgeDirection dir) {
        while (true) {
            at.adjust(dir);
            TileEntityShaft shaft = at.getTE(TileEntityShaft.class);
            if (shaft == null || shaft.axis != this.axis) break;
            shaft._src = null;
            shaft.srcPos = new Coord(shaft);
            shaft.getSrc();
        }
    }

    public static ForgeDirection normalizeDirection(ForgeDirection dir) {
        return SpaceUtil.sign(dir) == -1 ? dir.getOpposite() : dir;
    }

    public void setAxis(ForgeDirection axis) {
        this.axis = TileEntityShaft.normalizeDirection(axis);
    }

    private boolean isUnconnected() {
        ForgeDirection back = this.axis.getOpposite();
        boolean a = IRotationalEnergySource.adapter.cast(this.getCoord().add(this.axis).getTE()) == null;
        boolean b = IRotationalEnergySource.adapter.cast(this.getCoord().add(back).getTE()) == null;
        return a && b;
    }

    @Override
    public void onPlacedBy(EntityPlayer player, ItemStack is, int side, float hitX, float hitY, float hitZ) {
        super.onPlacedBy(player, is, side, hitX, hitY, hitZ);
        this.joinAdjacent(player, side);
        this.invalidateConnections();
    }

    private void joinAdjacent(EntityPlayer player, int side) {
        ForgeDirection defaultDirection = ForgeDirection.getOrientation((int)side);
        Coord at = this.getCoord();
        ArrayList<Coord> lockedNeighbors = new ArrayList<Coord>();
        ArrayList<Coord> freeNeighbors = new ArrayList<Coord>();
        ForgeDirection lockedDirection = ForgeDirection.UNKNOWN;
        ForgeDirection free_direction = ForgeDirection.UNKNOWN;
        TileEntityShaft free_neighbor = null;
        for (ForgeDirection neighborDirection : ForgeDirection.VALID_DIRECTIONS) {
            Coord neighbor = at.add(neighborDirection);
            TileEntityShaft tes = at.getTE(TileEntityShaft.class);
            if (tes != null) {
                IRotationalEnergySource isrc = tes.getSrc();
                if (isrc != null && isrc.getVelocity(tes.axis) + isrc.getVelocity(tes.axis.getOpposite()) > 0.0) continue;
                if (tes.isUnconnected()) {
                    freeNeighbors.add(neighbor);
                    free_neighbor = tes;
                    free_direction = neighborDirection;
                    continue;
                }
                if (tes.axis != neighborDirection && tes.axis != neighborDirection.getOpposite()) continue;
                lockedDirection = tes.axis;
                lockedNeighbors.add(neighbor);
                continue;
            }
            IRotationalEnergySource res = IRotationalEnergySource.adapter.cast(neighbor.getTE());
            if (res == null || !res.canConnect(neighborDirection.getOpposite())) continue;
            lockedDirection = neighborDirection.getOpposite();
            lockedNeighbors.add(neighbor);
        }
        int n = lockedNeighbors.size() + freeNeighbors.size();
        if (n != 1 || player.func_70093_af()) {
            this.setAxis(defaultDirection);
            return;
        }
        if (!lockedNeighbors.isEmpty()) {
            this.setAxis(lockedDirection);
            return;
        }
        if (free_neighbor == null) {
            this.setAxis(defaultDirection);
            return;
        }
        free_neighbor.setAxis(free_direction);
        this.setAxis(free_direction);
    }

    @Override
    public void spawnPacketReceived() {
        if (this.srcPos == null) {
            return;
        }
        Coord at = this.getCoord();
        TileEntityShaft shaft = this;
        while (true) {
            at.adjust(this.axis);
            TileEntityShaft tes = at.getTE(TileEntityShaft.class);
            if (tes == null) break;
            shaft = tes;
        }
        at.adjust(this.axis.getOpposite());
        double baseAngle = shaft.angle;
        while (true) {
            at.adjust(this.axis.getOpposite());
            TileEntityShaft tes = at.getTE(TileEntityShaft.class);
            if (tes == null) break;
            tes.angle = baseAngle;
        }
    }

    @Override
    public boolean rotate(ForgeDirection axis) {
        if ((axis = TileEntityShaft.normalizeDirection(axis)) == this.axis) {
            return false;
        }
        this.invalidateConnections();
        this.axis = axis;
        return true;
    }

    @Override
    public IIcon getIcon(ForgeDirection dir) {
        return BlockIcons.beauty$shaft;
    }
}

