/*
 * Decompiled with CFR 0.152.
 */
package factorization.beauty;

import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import factorization.api.IRotationalEnergySource;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockClass;
import factorization.shared.NetworkFactorization;
import factorization.shared.TileEntityCommon;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityShaftGen
extends TileEntityCommon
implements IChargeConductor {
    final Charge charge = new Charge(this);
    double rotor_angle;
    ForgeDirection shaft_direction = ForgeDirection.DOWN;
    IRotationalEnergySource shaft;
    transient double last_power;
    public static double MAX_POWER = 1024.0;
    public static double CHARGE_PER_POWER = 720.0;
    boolean on;
    boolean working = false;

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        if (this.shaftIsBroken()) {
            return "Missing shaft";
        }
        return "";
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public void onPlacedBy(EntityPlayer player, ItemStack is, int side, float hitX, float hitY, float hitZ) {
        super.onPlacedBy(player, is, side, hitX, hitY, hitZ);
        this.shaft_direction = ForgeDirection.getOrientation((int)side);
        if (player.func_70093_af()) {
            this.shaft_direction = this.shaft_direction.getOpposite();
            return;
        }
        Coord at = this.getCoord();
        ForgeDirection use = ForgeDirection.UNKNOWN;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IRotationalEnergySource res = IRotationalEnergySource.adapter.cast(at.add(dir).getTE());
            if (res == null || !res.canConnect(dir.getOpposite())) continue;
            if (use != ForgeDirection.UNKNOWN) {
                return;
            }
            use = dir;
        }
        if (use == ForgeDirection.UNKNOWN) {
            return;
        }
        this.shaft_direction = use;
    }

    @Override
    public boolean rotate(ForgeDirection axis) {
        if (axis == this.shaft_direction) {
            return false;
        }
        this.shaft_direction = axis;
        return true;
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        this.charge.serialize("", data);
        this.rotor_angle = data.as(Share.VISIBLE, "rotorAngle").putDouble(this.rotor_angle);
        this.shaft_direction = data.as(Share.VISIBLE, "shaft_direction").putEnum(this.shaft_direction);
        this.on = data.as(Share.VISIBLE, "on").putBoolean(this.on);
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SHAFT_GEN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNeighborTileChanged(int tilex, int tiley, int tilez) {
        super.onNeighborTileChanged(tilex, tiley, tilez);
        if (this.working) {
            return;
        }
        this.working = true;
        try {
            if (this.shaft == null || this.shaft.isTileEntityInvalid()) {
                this.shaft = IRotationalEnergySource.adapter.cast(this.getCoord().adjust(this.shaft_direction).getTE());
            }
        }
        finally {
            this.working = false;
        }
    }

    boolean shaftIsBroken() {
        if (this.shaft == null) {
            return true;
        }
        if (this.shaft.isTileEntityInvalid()) {
            this.shaft = null;
            return true;
        }
        return false;
    }

    public void func_145845_h() {
        boolean is_on;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.charge.update();
        if (this.shaftIsBroken()) {
            if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                this.shaft = IRotationalEnergySource.adapter.cast(this.getCoord().add(this.shaft_direction).getTE());
            }
            return;
        }
        ForgeDirection shaftOutputDirection = this.shaft_direction.getOpposite();
        double avail = this.shaft.availableEnergy(shaftOutputDirection);
        double usable = Math.min(MAX_POWER, avail);
        this.last_power = this.shaft.takeEnergy(shaftOutputDirection, usable);
        int line = (int)(this.last_power * CHARGE_PER_POWER);
        this.charge.raiseValue(line);
        this.rotor_angle += this.shaft.getVelocity(shaftOutputDirection);
        boolean bl = is_on = line > 0;
        if (is_on != this.on) {
            this.on = is_on;
            this.broadcastMessage(null, NetworkFactorization.MessageType.ShaftGenState, this.on);
        }
    }

    @Override
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (messageType == NetworkFactorization.MessageType.ShaftGenState) {
            this.on = input.readBoolean();
            this.getCoord().redraw();
        }
        return super.handleMessageFromServer(messageType, input);
    }

    @Override
    public IIcon getIcon(ForgeDirection dir) {
        return BlockIcons.beauty$shaft_gen_side;
    }
}

