/*
 * Decompiled with CFR 0.152.
 */
package factorization.beauty;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.IMeterInfo;
import factorization.api.IRotationalEnergySource;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.beauty.EntityFXSteam;
import factorization.charge.TileEntitySolarBoiler;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.NetworkFactorization;
import factorization.shared.TileEntityCommon;
import factorization.util.FzUtil;
import factorization.util.NumUtil;
import factorization.util.SpaceUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntitySteamShaft
extends TileEntityCommon
implements IFluidHandler,
IRotationalEnergySource,
IMeterInfo {
    FluidTank steamTank = new FluidTank(TileEntitySolarBoiler.steam_stack.copy(), 800);
    public static double Z = 1.6;
    public static int TURBINE_MASS = 1000;
    public static double BEARING_DRAG = 0.05;
    public static double DRAW_EFFICIENCY = 0.1;
    public static double FORCE_PER_STEAM = 3.0;
    private double velocity = 0.0;
    private double drawable_velocity = 0.0;
    public double angle;
    public double prev_angle = this.angle = Math.PI * Math.random();
    private int take_spead = 1;
    private int take_accel = 0;
    boolean dry = true;
    private transient double last_sent_velocity = 0.0;

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.STEAM_SHAFT;
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        this.velocity = data.as(Share.VISIBLE, "velocity").putDouble(this.velocity);
        this.drawable_velocity = data.as(Share.PRIVATE, "drawableVelocity").putDouble(this.drawable_velocity);
        this.steamTank = data.as(Share.PRIVATE, "steam").putTank(this.steamTank);
        this.take_spead = data.as(Share.PRIVATE, "lastTake").putInt(this.take_spead);
        if (this.take_spead < 0) {
            this.take_spead = 1;
        }
    }

    @Override
    public IIcon getIcon(ForgeDirection dir) {
        switch (dir) {
            case UP: {
                return BlockIcons.turbine_top;
            }
            case DOWN: {
                return BlockIcons.turbine_bottom;
            }
        }
        return BlockIcons.turbine_side;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (from == ForgeDirection.DOWN) {
            if (doFill && resource.amount > 0) {
                this.dry = false;
            }
            return this.steamTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (from == ForgeDirection.DOWN && fluid != null) {
            return fluid.getID() == TileEntitySolarBoiler.steam.getID();
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.steamTank.getInfo()};
    }

    public void func_145845_h() {
        double drag;
        if (this.field_145850_b.field_72995_K) {
            this.prev_angle = this.angle;
            if (this.velocity != 0.0) {
                this.angle += this.getVelocity(ForgeDirection.UP);
                this.emitParticles();
            }
            return;
        }
        double force = 0.0;
        if (this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 0) {
            FluidStack steam = this.steamTank.getFluid();
            if (steam == null) {
                steam = FluidRegistry.getFluidStack((String)"steam", (int)0);
                this.steamTank.setFluid(steam);
            } else {
                boolean rare = this.field_145850_b.func_82737_E() % 40L == 0L;
                int takable = this.take_spead;
                if (takable < 1) {
                    takable = 1;
                }
                if (takable > steam.amount) {
                    takable = steam.amount;
                    if (!this.dry) {
                        this.dry = true;
                        --this.take_spead;
                        if (this.take_spead < 1) {
                            this.take_spead = 1;
                        }
                        this.take_accel = -1;
                    }
                }
                if (steam.amount >= this.steamTank.getCapacity()) {
                    if (rare) {
                        this.take_spead += this.take_accel;
                        ++this.take_accel;
                    }
                } else if (this.take_accel > 0) {
                    this.take_accel = 0;
                }
                force = (double)takable * FORCE_PER_STEAM;
                steam.amount -= takable;
            }
        }
        if ((drag = BEARING_DRAG * Math.pow(Math.abs(this.velocity), Z)) != drag) {
            drag = 0.0;
        }
        double acceleration = force / (double)TURBINE_MASS;
        this.velocity = this.velocity - drag + acceleration;
        this.velocity = Math.max(0.0, this.velocity);
        this.drawable_velocity = this.velocity * DRAW_EFFICIENCY;
        if (this.velocity > 0.0 && force == 0.0 && this.velocity < 0.03 && this.field_145850_b.func_82737_E() % 60L == 0L) {
            this.velocity = 0.0;
        }
        this.shareTurbineSpeed();
    }

    @SideOnly(value=Side.CLIENT)
    private void emitParticles() {
        int particleLevel = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (particleLevel >= 2) {
            return;
        }
        double r = 0.4375;
        double v = this.getVelocity(ForgeDirection.UP) * r;
        double bottom = -0.1875;
        double left = -0.25;
        double scootch_x = 0.1875;
        double scootch_y = 0.1875;
        Quaternion rot = Quaternion.getRotationQuaternionRadians(this.angle, ForgeDirection.UP);
        double motFuzz = v / 20.0;
        Random rng = this.field_145850_b.field_73012_v;
        double threshold = this.velocity / (double)(particleLevel == 1 ? 1 : 4);
        for (int side = 0; side < 4; ++side) {
            for (int y = 0; y < 3; ++y) {
                if ((double)rng.nextFloat() > threshold) continue;
                Vec3 pos = Vec3.func_72443_a((double)(left + scootch_x * (double)y), (double)(bottom + scootch_y * (double)y), (double)r);
                Vec3 mot = Vec3.func_72443_a((double)(-v + rng.nextGaussian() * motFuzz * 3.0), (double)(rng.nextGaussian() * motFuzz), (double)(rng.nextGaussian() * motFuzz + r * 0.125));
                rot.applyRotation(pos);
                rot.applyRotation(mot);
                EntityFXSteam steam = new EntityFXSteam(this.field_145850_b, (double)this.field_145851_c + 0.5 + pos.field_72450_a, (double)this.field_145848_d + 0.5 + pos.field_72448_b, (double)this.field_145849_e + 0.5 + pos.field_72449_c, BlockIcons.steam);
                SpaceUtil.toEntVel((Entity)steam, mot);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)steam);
            }
            rot.incrMultiply(Quaternion.getRotationQuaternionRadians(1.5707963267948966, ForgeDirection.UP));
        }
    }

    public void shareTurbineSpeed() {
        if (this.last_sent_velocity == this.velocity) {
            return;
        }
        if (NumUtil.significantChange(this.last_sent_velocity, this.velocity, 0.1)) {
            this.last_sent_velocity = this.velocity;
            this.broadcastMessage(null, NetworkFactorization.MessageType.TurbineSpeed, Float.valueOf((float)this.velocity));
        }
    }

    @Override
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.TurbineSpeed) {
            this.velocity = input.readFloat();
            return true;
        }
        return false;
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        return direction == ForgeDirection.UP;
    }

    @Override
    public double availableEnergy(ForgeDirection direction) {
        if (direction == ForgeDirection.UP) {
            return this.drawable_velocity;
        }
        return 0.0;
    }

    @Override
    public double takeEnergy(ForgeDirection direction, double maxPower) {
        double d = Math.min(this.drawable_velocity, maxPower);
        this.drawable_velocity -= d;
        this.velocity -= d * DRAW_EFFICIENCY;
        return d;
    }

    @Override
    public double getVelocity(ForgeDirection direction) {
        if (direction == ForgeDirection.UP) {
            if (this.velocity > 0.39269908169872414) {
                return 0.39269908169872414;
            }
            if (this.velocity < -0.39269908169872414) {
                return -0.39269908169872414;
            }
            return this.velocity;
        }
        return 0.0;
    }

    @Override
    public boolean isTileEntityInvalid() {
        return this.func_145837_r();
    }

    @Override
    public String getInfo() {
        return FzUtil.toRpm(this.getVelocity(ForgeDirection.UP)) + "\nPower: " + (int)(this.velocity * 10.0) + "\nSteam: " + this.steamTank.getFluidAmount() + "mB" + (!Core.dev_environ ? "" : "\nTake-speed: " + this.take_spead + "\nLast-sync: " + this.last_sent_velocity + "\nAccel: " + this.take_accel);
    }

    @Override
    public boolean isBlockSolidOnSide(int side) {
        return false;
    }
}

