/*
 * Decompiled with CFR 0.152.
 */
package factorization.beauty;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.ICoordFunction;
import factorization.api.IMeterInfo;
import factorization.api.IRotationalEnergySource;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.fzds.DeltaChunk;
import factorization.fzds.TransferLib;
import factorization.fzds.interfaces.DeltaCapability;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.shared.BlockClass;
import factorization.shared.EntityReference;
import factorization.shared.NetworkFactorization;
import factorization.shared.TileEntityCommon;
import factorization.util.FzUtil;
import factorization.util.NumUtil;
import factorization.util.PlayerUtil;
import factorization.util.SpaceUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenOcean;
import net.minecraft.world.biome.BiomeGenRiver;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWaterWheel
extends TileEntityCommon
implements IRotationalEnergySource,
IMeterInfo {
    ForgeDirection wheelDirection = ForgeDirection.UP;
    double power_per_tick;
    double power_this_tick;
    double target_velocity;
    double velocity;
    double water_strength = 0.0;
    boolean rs_power = false;
    int non_air_block_count;
    final EntityReference<IDeltaChunk> idcRef = new EntityReference();
    static int channel_id = 100;
    static final int MAX_OUT = 8;
    static final int MAX_IN = 8;
    static final int MAX_RADIUS = 6;
    boolean working = false;
    static double V_SCALE = 0.025;
    static double WATER_POWER_SCALE = 0.02;
    static double riverFlow = 1.0 / (Math.sqrt(2.0) * 8.0);
    static double oceanFlow = riverFlow / 8.0;
    static double otherFlowNerf = 0.25;
    static double MAX_SPEED = Math.min(1.0 / (Math.sqrt(2.0) * 2.0) / 64.0, 0.006135923151542565);
    static int sea_level_range_min = -4;
    static int sea_level_range_max = 2;
    static double MAX_TOTAL_POWER = 20.0;
    static double MIN_POWER = 0.15;
    static double MIN_POWER_FLOOR = 1.5;

    public void func_145834_a(World w) {
        super.func_145834_a(w);
        this.idcRef.setWorld(w);
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.WATER_WHEEL_GEN;
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        return direction == this.wheelDirection.getOpposite();
    }

    @Override
    public double availableEnergy(ForgeDirection direction) {
        if (direction != this.wheelDirection.getOpposite()) {
            return 0.0;
        }
        return this.power_this_tick;
    }

    @Override
    public double takeEnergy(ForgeDirection direction, double maxPower) {
        if (direction != this.wheelDirection.getOpposite()) {
            return 0.0;
        }
        if (maxPower > this.power_this_tick) {
            maxPower = this.power_this_tick;
        }
        this.power_this_tick -= maxPower;
        return maxPower;
    }

    @Override
    public double getVelocity(ForgeDirection direction) {
        if (direction != this.wheelDirection.getOpposite()) {
            return 0.0;
        }
        boolean sign = true;
        if (this.velocity < -MAX_SPEED) {
            return -MAX_SPEED * (double)sign;
        }
        if (this.velocity > MAX_SPEED) {
            return MAX_SPEED * (double)sign;
        }
        return this.velocity * (double)sign;
    }

    @Override
    protected boolean removedByPlayer(EntityPlayer player, boolean willHarvest) {
        if (!willHarvest) {
            return super.removedByPlayer(player, willHarvest);
        }
        if (PlayerUtil.isPlayerCreative(player) && player.func_70093_af()) {
            IDeltaChunk idc = this.idcRef.getEntity();
            if (idc != null) {
                idc.func_70106_y();
            }
            return super.removedByPlayer(player, willHarvest);
        }
        if (this.idcRef.trackedAndAlive()) {
            return false;
        }
        return super.removedByPlayer(player, willHarvest);
    }

    @Override
    public void onPlacedBy(EntityPlayer player, ItemStack is, int side, float hitX, float hitY, float hitZ) {
        super.onPlacedBy(player, is, side, hitX, hitY, hitZ);
        this.wheelDirection = ForgeDirection.getOrientation((int)side);
        if (this.wheelDirection.offsetY != 0) {
            this.wheelDirection = ForgeDirection.getOrientation((int)SpaceUtil.determineFlatOrientation(player)).getOpposite();
        }
    }

    @Override
    public boolean isTileEntityInvalid() {
        return this.func_145837_r();
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        this.wheelDirection = data.as(Share.VISIBLE, "wheelDirection").putEnum(this.wheelDirection);
        data.as(Share.VISIBLE, "idcRef").putIDS(this.idcRef);
        this.power_per_tick = data.as(Share.VISIBLE, "powerPerTick").putDouble(this.power_per_tick);
        this.power_this_tick = data.as(Share.VISIBLE, "powerThisTick").putDouble(this.power_this_tick);
        this.target_velocity = data.as(Share.VISIBLE, "targetVelocity").putDouble(this.target_velocity);
        this.velocity = data.as(Share.VISIBLE, "velocity").putDouble(this.velocity);
        this.water_strength = data.as(Share.PRIVATE, "water_strength").putDouble(this.water_strength);
        this.rs_power = data.as(Share.PRIVATE, "rs_power").putBoolean(this.rs_power);
    }

    @Override
    public void representYoSelf() {
        super.representYoSelf();
    }

    @Override
    public void onNeighborTileChanged(int tilex, int tiley, int tilez) {
        this.neighborChanged(null);
    }

    @Override
    public void neighborChanged(Block neighbor) {
        if (this.working) {
            return;
        }
        if (this.idcRef.trackedAndAlive()) {
            if (this.getCoord().isWeaklyPowered() != this.rs_power) {
                boolean bl = this.rs_power = !this.rs_power;
                if (this.rs_power) {
                    this.target_velocity = 0.0;
                } else {
                    this.calculateWaterForce();
                }
            }
            return;
        }
        this.working = true;
        try {
            this.trySpawnMill();
        }
        finally {
            this.working = false;
        }
    }

    @Override
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.MillVelocity) {
            this.velocity = input.readDouble();
        }
        return false;
    }

    void sendVelocity() {
        this.broadcastMessage(null, NetworkFactorization.MessageType.MillVelocity, this.velocity);
    }

    private boolean trySpawnMill() {
        Coord fenceLocation = new Coord(this);
        fenceLocation.adjust(this.wheelDirection);
        if (!this.isFenceish(fenceLocation)) {
            return false;
        }
        DeltaCoord idcSize = new DeltaCoord(12, 16, 12);
        DeltaCoord offset = new DeltaCoord(6, 8, 6);
        IDeltaChunk idc = DeltaChunk.allocateSlice(this.field_145850_b, channel_id, idcSize);
        idc.permit(DeltaCapability.BLOCK_PLACE, DeltaCapability.BLOCK_MINE, DeltaCapability.INTERACT, DeltaCapability.ROTATE, DeltaCapability.DIE_WHEN_EMPTY, DeltaCapability.REMOVE_ALL_ENTITIES);
        idc.forbid(DeltaCapability.COLLIDE_WITH_WORLD, DeltaCapability.COLLIDE, DeltaCapability.VIOLENT_COLLISIONS, DeltaCapability.DRAG);
        idc.setRotationalCenterOffset(offset.toVector().func_72441_c(0.5, 0.5, 0.5));
        ForgeDirection normal = this.wheelDirection.getOpposite();
        Coord at = new Coord(this).add(this.wheelDirection);
        at.setAsEntityLocation(idc);
        if (normal.offsetY == 0) {
            idc.field_70163_u += 0.5;
        } else {
            double a = 0.5;
            idc.field_70165_t += (double)this.wheelDirection.offsetX * a;
            idc.field_70163_u += (double)this.wheelDirection.offsetY * a;
            idc.field_70161_v += (double)this.wheelDirection.offsetZ * a;
            if (normal.offsetY == 1) {
                idc.field_70163_u += 1.0;
            }
        }
        TransferLib.move(fenceLocation, idc.getCenter(), false, true);
        idc.setPartName("Waterwheel");
        fenceLocation.setAir();
        this.field_145850_b.func_72838_d((Entity)idc);
        this.idcRef.trackEntity(idc);
        return true;
    }

    private boolean isFenceish(Coord fenceLocation) {
        Block block = fenceLocation.getBlock();
        if (block instanceof BlockFence) {
            return true;
        }
        if (block.func_149645_b() == Blocks.field_150422_aJ.func_149645_b()) {
            return true;
        }
        if (block instanceof BlockWall) {
            return true;
        }
        if (block.func_149645_b() == Blocks.field_150463_bK.func_149645_b()) {
            return true;
        }
        if (block instanceof BlockLog) {
            return true;
        }
        return block.func_149688_o() == Material.field_151573_f;
    }

    public boolean canUpdate() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.idcRef.entityFound()) {
            if (this.velocity != 0.0) {
                this.velocity = 0.0;
                this.sendVelocity();
            }
            this.idcRef.getEntity();
            return;
        }
        this.power_this_tick = this.power_per_tick;
        if (this.velocity != this.target_velocity) {
            IDeltaChunk idc;
            double error = this.target_velocity > this.velocity ? this.velocity / this.target_velocity : 1.0;
            this.velocity = (this.velocity * 95.0 + this.target_velocity) / 100.0;
            this.power_this_tick *= error;
            if (error > 0.9999) {
                this.velocity = this.target_velocity;
            }
            if ((idc = this.idcRef.getEntity()) != null) {
                idc.setRotationalVelocity(Quaternion.getRotationQuaternionRadians(this.getVelocity(this.wheelDirection.getOpposite()), this.wheelDirection));
            }
            this.sendVelocity();
        }
        if (this.field_145850_b.func_82737_E() % 200L != 0L) {
            return;
        }
        this.calculateWaterForce();
    }

    void updatePowerPerTick() {
        this.power_per_tick = Math.abs(this.water_strength);
        if (this.power_per_tick > MIN_POWER && this.power_per_tick < MIN_POWER_FLOOR) {
            this.power_per_tick = MIN_POWER_FLOOR;
        }
        if (this.power_per_tick > MAX_TOTAL_POWER) {
            this.power_per_tick = MAX_TOTAL_POWER;
        }
        this.target_velocity = this.water_strength * V_SCALE;
        if (this.target_velocity > MAX_SPEED) {
            this.target_velocity = MAX_SPEED;
        } else if (this.target_velocity < -MAX_SPEED) {
            this.target_velocity = -MAX_SPEED;
        }
        if (this.power_per_tick < MIN_POWER) {
            this.power_per_tick = 0.0;
            this.target_velocity = 0.0;
        }
        this.power_per_tick *= WATER_POWER_SCALE;
    }

    @Override
    public String getInfo() {
        double spr;
        if (!this.idcRef.trackedAndAlive()) {
            return "No waterhweel";
        }
        String speed = this.velocity == 0.0 ? "stopped" : ((spr = 1.0 / (Math.toDegrees(this.velocity) * 20.0 / 360.0)) > 60.0 ? (int)spr + " SPR" : FzUtil.toRpm(this.velocity));
        return "Water power: " + (int)Math.abs(this.water_strength * 10.0) + "\nSpeed: " + speed;
    }

    void calculateWaterForce() {
        final IDeltaChunk idc = this.idcRef.getEntity();
        if (idc == null || this.getCoord().isWeaklyPowered()) {
            this.water_strength = 0.0;
            this.updatePowerPerTick();
            return;
        }
        this.non_air_block_count = 0;
        final Vec3 tmp = SpaceUtil.newVec();
        final int sea_min = this.field_145850_b.field_73011_w.func_76557_i() + sea_level_range_min;
        final int sea_max = this.field_145850_b.field_73011_w.func_76557_i() + sea_level_range_max;
        final Vec3 water_torque = SpaceUtil.newVec();
        final Vec3 centerOfMass = idc.getCenter().toMiddleVector();
        ForgeDirection a = this.wheelDirection;
        if (SpaceUtil.sign(a) == -1) {
            a = a.getOpposite();
        }
        final DeltaCoord fwd = new DeltaCoord(this.wheelDirection).incrScale(3);
        Vec3 mask = SpaceUtil.fromDirection(a);
        final Vec3 antiMask = SpaceUtil.fromDirection(a.getOpposite());
        SpaceUtil.incrAdd(antiMask, Vec3.func_72443_a((double)1.0, (double)1.0, (double)1.0));
        ICoordFunction measure = new ICoordFunction(){

            boolean waterOkay(Coord here, Block hereBlock) {
                if (hereBlock.func_149688_o() != Material.field_151575_d) {
                    return false;
                }
                if (hereBlock.func_149721_r()) {
                    int exposedSides = 0;
                    for (Coord n : here.getNeighborsAdjacent()) {
                        if (n.isAir()) continue;
                        exposedSides = (byte)(exposedSides + 1);
                    }
                    if (exposedSides <= 4) {
                        return false;
                    }
                }
                return true;
            }

            boolean lavaOkay(Coord here, Block hereBlock) {
                return hereBlock.func_149688_o() == Material.field_151573_f;
            }

            @Override
            public void handle(Coord here) {
                Block hereBlock = here.getBlock();
                if (!hereBlock.isAir((IBlockAccess)here.w, here.x, here.y, here.z)) {
                    ++TileEntityWaterWheel.this.non_air_block_count;
                } else {
                    return;
                }
                boolean waterOkay = this.waterOkay(here, hereBlock);
                boolean lavaOkay = this.lavaOkay(here, hereBlock);
                if (!waterOkay && !lavaOkay) {
                    return;
                }
                Coord real = idc.shadow2realCoordPrecise(here);
                Block realBlock = real.getBlock();
                tmp.field_72449_c = 0.0;
                tmp.field_72448_b = 0.0;
                tmp.field_72450_a = 0.0;
                if (waterOkay && realBlock.func_149688_o() == Material.field_151586_h) {
                    if (realBlock.func_149656_h() == 0) {
                        return;
                    }
                    realBlock.func_149640_a(TileEntityWaterWheel.this.field_145850_b, real.x, real.y, real.z, null, tmp);
                    if (tmp.field_72450_a == 0.0 && tmp.field_72448_b == 0.0 && tmp.field_72449_c == 0.0) {
                        BiomeGenBase biome = real.getBiome();
                        if (NumUtil.intersect(sea_min, sea_max, real.y, real.y)) {
                            for (int forward = 0; forward < 1; ++forward) {
                                if (biome instanceof BiomeGenRiver) {
                                    tmp.field_72450_a = riverFlow;
                                    tmp.field_72449_c = riverFlow;
                                    break;
                                }
                                if (biome instanceof BiomeGenOcean) {
                                    tmp.field_72450_a = oceanFlow;
                                    tmp.field_72449_c = oceanFlow;
                                    break;
                                }
                                biome = real.add(fwd).getBiome();
                            }
                        }
                    } else {
                        SpaceUtil.incrScale(tmp, otherFlowNerf);
                    }
                } else if (lavaOkay && realBlock.func_149688_o() == Material.field_151587_i) {
                    realBlock.func_149640_a(TileEntityWaterWheel.this.field_145850_b, real.x, real.y, real.z, null, tmp);
                } else {
                    return;
                }
                idc.getRotation().applyReverseRotation(tmp);
                Vec3 P = SpaceUtil.incrSubtract(here.toMiddleVector(), centerOfMass);
                SpaceUtil.incrComponentMultiply(P, antiMask);
                SpaceUtil.incrComponentMultiply(tmp, antiMask);
                Vec3 torque = tmp.func_72431_c(P);
                SpaceUtil.incrAdd(water_torque, torque);
            }
        };
        Coord.iterateCube(idc.getCorner(), idc.getFarCorner(), measure);
        this.water_strength = SpaceUtil.sum(water_torque) * (double)(-SpaceUtil.sign(this.wheelDirection));
        this.updatePowerPerTick();
    }

    @Override
    public IIcon getIcon(ForgeDirection dir) {
        return BlockIcons.beauty$water_side;
    }
}

