/*
 * Decompiled with CFR 0.152.
 */
package factorization.beauty;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.IMeterInfo;
import factorization.api.IRotationalEnergySource;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.api.wind.IWindmill;
import factorization.api.wind.WindModel;
import factorization.beauty.Symmetry;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.fzds.DeltaChunk;
import factorization.fzds.TransferLib;
import factorization.fzds.interfaces.DeltaCapability;
import factorization.fzds.interfaces.IDCController;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.shared.BlockClass;
import factorization.shared.EntityReference;
import factorization.shared.NetworkFactorization;
import factorization.shared.TileEntityCommon;
import factorization.util.FzUtil;
import factorization.util.NumUtil;
import factorization.util.PlayerUtil;
import factorization.util.SpaceUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCompressed;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockWall;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWindMill
extends TileEntityCommon
implements IRotationalEnergySource,
IDCController,
IWindmill,
IMeterInfo {
    ForgeDirection sailDirection = ForgeDirection.UP;
    boolean dirty = true;
    double power_per_tick;
    double power_this_tick;
    double target_velocity;
    double velocity;
    double wind_strength = 0.0;
    double efficiency = 0.0;
    double radius = 0.0;
    final EntityReference<IDeltaChunk> idcRef = new EntityReference<IDeltaChunk>().whenFound(new IDCController.AutoControl(this));
    static int channel_id = 100;
    static final int MAX_OUT = 2;
    static final int MAX_IN = 2;
    static final int MAX_RADIUS = 6;
    boolean working = false;
    static double MAX_SPEED = 0.09817477042468103;
    static double V_SCALE = 0.05;
    static double WIND_POWER_SCALE = 0.1;
    private static final byte UNSET = 0;
    private static final byte POWERED = 1;
    private static final byte UNPOWERED = 2;
    private byte redstone_mode = 0;

    public void func_145834_a(World w) {
        super.func_145834_a(w);
        this.idcRef.setWorld(w);
        WindModel.activeModel.registerWindmillTileEntity(this);
        if (this.radius > 0.0) {
            WindModel.activeModel.registerWindmillTileEntity(this);
        }
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.WIND_MILL_GEN;
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        return direction == this.sailDirection.getOpposite();
    }

    @Override
    public double availableEnergy(ForgeDirection direction) {
        if (direction != this.sailDirection.getOpposite()) {
            return 0.0;
        }
        return this.power_this_tick;
    }

    @Override
    public double takeEnergy(ForgeDirection direction, double maxPower) {
        if (direction != this.sailDirection.getOpposite()) {
            return 0.0;
        }
        if (maxPower > this.power_this_tick) {
            maxPower = this.power_this_tick;
        }
        this.power_this_tick -= maxPower;
        return maxPower;
    }

    @Override
    public double getVelocity(ForgeDirection direction) {
        if (direction != this.sailDirection.getOpposite()) {
            return 0.0;
        }
        return this.velocity;
    }

    @Override
    protected boolean removedByPlayer(EntityPlayer player, boolean willHarvest) {
        if (!willHarvest) {
            return super.removedByPlayer(player, willHarvest);
        }
        if (PlayerUtil.isPlayerCreative(player) && player.func_70093_af()) {
            IDeltaChunk idc = this.idcRef.getEntity();
            if (idc != null) {
                idc.func_70106_y();
            }
            return super.removedByPlayer(player, willHarvest);
        }
        if (this.idcRef.trackedAndAlive()) {
            return false;
        }
        return super.removedByPlayer(player, willHarvest);
    }

    @Override
    public void onPlacedBy(EntityPlayer player, ItemStack is, int side, float hitX, float hitY, float hitZ) {
        super.onPlacedBy(player, is, side, hitX, hitY, hitZ);
        this.sailDirection = ForgeDirection.getOrientation((int)side);
    }

    @Override
    public boolean isTileEntityInvalid() {
        return this.func_145837_r();
    }

    @Override
    public boolean placeBlock(IDeltaChunk idc, EntityPlayer player, Coord at) {
        this.dirty = true;
        return false;
    }

    @Override
    public boolean breakBlock(IDeltaChunk idc, EntityPlayer player, Coord at, byte sideHit) {
        this.dirty = true;
        return false;
    }

    @Override
    public boolean hitBlock(IDeltaChunk idc, EntityPlayer player, Coord at, byte sideHit) {
        return false;
    }

    @Override
    public boolean useBlock(IDeltaChunk idc, EntityPlayer player, Coord at, byte sideHit) {
        return false;
    }

    @Override
    public void idcDied(IDeltaChunk idc) {
    }

    @Override
    public void beforeUpdate(IDeltaChunk idc) {
    }

    @Override
    public void afterUpdate(IDeltaChunk idc) {
    }

    @Override
    public boolean onAttacked(IDeltaChunk idc, DamageSource damageSource, float damage) {
        return false;
    }

    @Override
    public IDCController.CollisionAction collidedWithWorld(World realWorld, AxisAlignedBB realBox, World shadowWorld, AxisAlignedBB shadowBox) {
        return IDCController.CollisionAction.STOP_BEFORE;
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        this.sailDirection = data.as(Share.VISIBLE, "sailDirection").putEnum(this.sailDirection);
        this.dirty = data.as(Share.PRIVATE, "dirty").putBoolean(this.dirty);
        data.as(Share.VISIBLE, "idcRef").putIDS(this.idcRef);
        this.power_per_tick = data.as(Share.VISIBLE, "powerPerTick").putDouble(this.power_per_tick);
        this.power_this_tick = data.as(Share.VISIBLE, "powerThisTick").putDouble(this.power_this_tick);
        this.target_velocity = data.as(Share.VISIBLE, "targetVelocity").putDouble(this.target_velocity);
        this.velocity = data.as(Share.VISIBLE, "velocity").putDouble(this.velocity);
        this.wind_strength = data.as(Share.PRIVATE, "wind_strength").putDouble(this.wind_strength);
        this.efficiency = data.as(Share.PRIVATE, "efficiency").putDouble(this.efficiency);
        this.radius = data.as(Share.PRIVATE, "radius").putDouble(this.radius);
    }

    @Override
    public void representYoSelf() {
        super.representYoSelf();
        channel_id = DeltaChunk.getHammerRegistry().makeChannelFor("factorization", "fluidMill", channel_id, -1, "waterwheels & windmills");
    }

    @Override
    public void onNeighborTileChanged(int tilex, int tiley, int tilez) {
        this.neighborChanged(null);
    }

    @Override
    public void neighborChanged(Block neighbor) {
        if (this.working) {
            return;
        }
        if (this.idcRef.trackedAndAlive()) {
            this.updateRedstoneState();
        }
        this.working = true;
        try {
            this.trySpawnMill();
        }
        finally {
            this.working = false;
        }
    }

    @Override
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.MillVelocity) {
            this.velocity = input.readDouble();
        }
        return false;
    }

    void sendVelocity() {
        this.broadcastMessage(null, NetworkFactorization.MessageType.MillVelocity, this.velocity);
    }

    private boolean trySpawnMill() {
        Coord fenceLocation = new Coord(this);
        fenceLocation.adjust(this.sailDirection);
        if (!this.isFenceish(fenceLocation)) {
            return false;
        }
        DeltaCoord idcSize = new DeltaCoord(12, 4, 12);
        DeltaCoord offset = new DeltaCoord(6, 2, 6);
        IDeltaChunk idc = DeltaChunk.allocateSlice(this.field_145850_b, channel_id, idcSize);
        idc.permit(DeltaCapability.BLOCK_PLACE, DeltaCapability.BLOCK_MINE, DeltaCapability.INTERACT, DeltaCapability.ROTATE, DeltaCapability.DIE_WHEN_EMPTY, DeltaCapability.REMOVE_ALL_ENTITIES);
        idc.forbid(DeltaCapability.COLLIDE_WITH_WORLD, DeltaCapability.COLLIDE, DeltaCapability.VIOLENT_COLLISIONS, DeltaCapability.DRAG);
        idc.setRotationalCenterOffset(offset.toVector().func_72441_c(0.5, 0.5, 0.5));
        ForgeDirection normal = this.sailDirection.getOpposite();
        Coord at = new Coord(this).add(this.sailDirection);
        at.setAsEntityLocation(idc);
        if (normal.offsetY == 0) {
            Vec3 up = SpaceUtil.fromDirection(ForgeDirection.UP);
            Vec3 vnorm = SpaceUtil.fromDirection(normal);
            Vec3 axis = up.func_72431_c(vnorm);
            Quaternion rot = Quaternion.getRotationQuaternionRadians(-1.5707963267948966, axis);
            idc.setRotation(rot);
            idc.field_70163_u += 0.5;
        } else {
            double a = 0.5;
            idc.field_70165_t += (double)this.sailDirection.offsetX * a;
            idc.field_70163_u += (double)this.sailDirection.offsetY * a;
            idc.field_70161_v += (double)this.sailDirection.offsetZ * a;
            if (normal.offsetY == 1) {
                idc.field_70163_u += 1.0;
            }
        }
        TransferLib.move(fenceLocation, idc.getCenter(), false, true);
        fenceLocation.setAir();
        this.field_145850_b.func_72838_d((Entity)idc);
        this.idcRef.trackEntity(idc);
        this.updateWindStrength(true);
        idc.setPartName("Windmill");
        this.updateRedstoneState();
        return true;
    }

    private boolean isFenceish(Coord fenceLocation) {
        Block block = fenceLocation.getBlock();
        if (block instanceof BlockFence) {
            return true;
        }
        if (block.func_149645_b() == Blocks.field_150422_aJ.func_149645_b()) {
            return true;
        }
        if (block instanceof BlockWall) {
            return true;
        }
        if (block.func_149645_b() == Blocks.field_150463_bK.func_149645_b()) {
            return true;
        }
        if (block instanceof BlockLog) {
            return true;
        }
        return block instanceof BlockCompressed;
    }

    public boolean canUpdate() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.idcRef.entityFound()) {
            if (this.velocity != 0.0) {
                this.velocity = 0.0;
                this.sendVelocity();
            }
            this.idcRef.getEntity();
            return;
        }
        this.updateWindStrength(false);
        this.power_this_tick = this.power_per_tick;
        if (this.velocity != this.target_velocity) {
            IDeltaChunk idc;
            double error = this.target_velocity > this.velocity ? this.velocity / this.target_velocity : 1.0;
            this.velocity = (this.velocity * 5.0 + this.target_velocity) / 6.0;
            this.power_this_tick *= error;
            if (error > 0.9999) {
                this.velocity = this.target_velocity;
            }
            if ((idc = this.idcRef.getEntity()) != null) {
                idc.setRotationalVelocity(Quaternion.getRotationQuaternionRadians(this.velocity, this.sailDirection));
            }
            this.sendVelocity();
        }
        if (!this.dirty) {
            if (this.field_145850_b.func_82737_E() % 1200L == 0L) {
                this.dirty = true;
            }
            return;
        }
        if (this.field_145850_b.func_82737_E() % 40L != 0L) {
            return;
        }
        this.calculate();
    }

    void calculate() {
        double sum;
        IDeltaChunk idc = this.idcRef.getEntity();
        if (idc == null) {
            return;
        }
        this.dirty = false;
        int score = 0;
        int asymetry = 0;
        Coord center = idc.getCenter();
        center.y -= 2;
        int ys = 4;
        double max_score = 1.0;
        double new_radius = 0.0;
        while (ys-- > 0) {
            Symmetry symmetry = new Symmetry(center, 6, ForgeDirection.UP);
            symmetry.calculate();
            score += symmetry.score;
            asymetry += symmetry.asymetry;
            ++center.y;
            max_score = symmetry.max_score;
            new_radius = Math.max(symmetry.measured_radius, new_radius);
        }
        max_score = 72.0;
        if (this.radius != new_radius) {
            if (this.radius != 0.0) {
                WindModel.activeModel.deregisterWindmillTileEntity(this);
            }
            this.radius = new_radius;
            if (this.radius != 0.0) {
                WindModel.activeModel.registerWindmillTileEntity(this);
            }
        }
        if ((sum = (double)((score -= 5) - asymetry * 20)) < 0.0) {
            this.efficiency = 0.0;
            return;
        }
        if (sum > max_score) {
            sum = max_score;
        }
        this.efficiency = sum / (max_score / 8.0);
        this.efficiency = NumUtil.clip(this.efficiency, 0.0, 1.0);
        this.updatePowerPerTick();
    }

    void updatePowerPerTick() {
        this.power_per_tick = this.efficiency * this.wind_strength;
        if (this.power_this_tick < 0.0) {
            this.power_this_tick = 0.0;
        }
        this.target_velocity = this.power_per_tick * V_SCALE;
        if (this.target_velocity > MAX_SPEED) {
            this.target_velocity = MAX_SPEED;
        }
        this.power_per_tick *= WIND_POWER_SCALE;
    }

    @Override
    public int getWindmillRadius() {
        return 6;
    }

    @Override
    public ForgeDirection getDirection() {
        return this.sailDirection;
    }

    void updateWindStrength(boolean force) {
        if (!force && this.field_145850_b.func_82737_E() % 200L != 0L) {
            return;
        }
        if (this.getCoord().isWeaklyPowered()) {
            this.wind_strength = 0.0;
            this.updatePowerPerTick();
            return;
        }
        Vec3 wind = WindModel.activeModel.getWindPower(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this);
        this.wind_strength = wind.func_72433_c();
        this.updatePowerPerTick();
    }

    @Override
    public String getInfo() {
        double spr;
        if (!this.idcRef.trackedAndAlive()) {
            return "No windmill";
        }
        String speed = this.velocity == 0.0 ? "stopped" : ((spr = 1.0 / (Math.toDegrees(this.velocity) * 20.0 / 360.0)) > 60.0 ? (int)spr + " SPR" : FzUtil.toRpm(this.velocity));
        return "Efficiency: " + (int)(this.efficiency * 100.0) + "%\nWind: " + this.wind_strength + "\nSpeed: " + speed;
    }

    @Override
    public IIcon getIcon(ForgeDirection dir) {
        return BlockIcons.beauty$wind_side;
    }

    private void updateRedstoneState() {
        byte next;
        byte by = next = this.getCoord().isWeaklyPowered() ? (byte)1 : 2;
        if (next == this.redstone_mode) {
            return;
        }
        this.redstone_mode = next;
        this.updateWindStrength(true);
    }
}

