/*
 * Decompiled with CFR 0.152.
 */
package factorization.ceramics;

import factorization.api.datahelpers.DataInNBT;
import factorization.ceramics.TileEntityGreenware;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.common.ResourceType;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.FactorizationBlockRender;
import java.io.IOException;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class BlockRenderGreenware
extends FactorizationBlockRender {
    static BlockRenderGreenware instance;
    private boolean texture_init = false;
    private static TileEntityGreenware loader;
    private static Random rawMimicRandom;
    private boolean spammed = false;

    public BlockRenderGreenware() {
        instance = this;
        this.setup();
    }

    public void setup() {
        if (this.texture_init) {
            return;
        }
    }

    @Override
    public boolean render(RenderBlocks rb) {
        TileEntityGreenware.ClayState state;
        if (!this.world_mode) {
            if (this.is == null) {
                return false;
            }
            GL11.glPushMatrix();
            boolean stand = true;
            boolean rescale = false;
            if (this.is.func_77942_o() && this.is.func_77978_p().func_74764_b("parts")) {
                try {
                    loader.putData(new DataInNBT(this.is.func_77978_p()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.is.func_77982_d(new NBTTagCompound());
                }
                int minX = 32;
                int minY = 32;
                int minZ = 32;
                int maxX = 0;
                int maxY = 32;
                int maxZ = 32;
                for (TileEntityGreenware.ClayLump cl : BlockRenderGreenware.loader.parts) {
                    minX = Math.min(minX, cl.minX);
                    minY = Math.min(minY, cl.minY);
                    minZ = Math.min(minZ, cl.minZ);
                    maxX = Math.max(maxX, cl.maxX);
                    maxY = Math.max(maxY, cl.maxY);
                    maxZ = Math.max(maxZ, cl.maxZ);
                    int min = Math.min(Math.min(minX, minY), minZ);
                    int max = Math.max(Math.max(maxX, maxY), maxZ);
                    if (min >= 16 && max <= 32) continue;
                    rescale = true;
                    break;
                }
                if (rescale) {
                    float scale = 0.33333334f;
                    GL11.glScalef((float)scale, (float)scale, (float)scale);
                }
                GL11.glPushAttrib((int)64);
                GL11.glDisable((int)2896);
                float d = -0.5f;
                Tessellator.field_78398_a.func_78373_b((double)d, (double)d, (double)d);
                this.renderDynamic(loader);
                Tessellator.field_78398_a.func_78373_b(0.0, 0.0, 0.0);
                GL11.glPopAttrib();
                TileEntityGreenware.ClayState cs = loader.getState();
                stand = cs == TileEntityGreenware.ClayState.WET;
            } else {
                this.setupRenderGenericLump().renderForInventory(rb);
            }
            GL11.glPopMatrix();
            if (stand) {
                this.setupRenderStand().renderForInventory(rb);
            }
            return false;
        }
        TileEntityGreenware gw = (TileEntityGreenware)this.te;
        if (gw == null) {
            return false;
        }
        if (this.world_mode) {
            Tessellator.field_78398_a.func_78380_c(Core.registry.factory_block.func_149677_c(this.w, this.x, this.y, this.z));
        }
        if ((state = gw.getState()) == TileEntityGreenware.ClayState.WET) {
            BlockRenderHelper block = this.setupRenderStand();
            block.render(rb, this.x, this.y, this.z);
        }
        if (!gw.canEdit()) {
            this.renderStatic(gw);
        }
        gw.shouldRenderTesr = state == TileEntityGreenware.ClayState.WET;
        return true;
    }

    int getColor(TileEntityGreenware.ClayLump rc) {
        if (rc.raw_color == -1) {
            if (rc.icon_id == Core.registry.resource_block && rc.icon_md == ResourceType.BISQUE.md) {
                rc.raw_color = 0;
                return rc.raw_color;
            }
            rawMimicRandom.setSeed(rc.icon_id.func_149739_a().hashCode() << 4 + rc.icon_md);
            int c = 0;
            for (int i = 0; i < 3; ++i) {
                c <<= 8;
                c += rawMimicRandom.nextInt(128) + 40;
            }
            rc.raw_color = c;
        }
        return rc.raw_color;
    }

    void renderToTessellator(TileEntityGreenware greenware) {
        BlockRenderHelper block = BlockRenderHelper.instance;
        TileEntityGreenware.ClayState state = greenware.getState();
        if (state != TileEntityGreenware.ClayState.HIGHFIRED) {
            switch (state) {
                case WET: {
                    block.useTexture(Blocks.field_150435_aG.func_149733_h(0));
                    break;
                }
                case DRY: {
                    block.useTexture(BlockIcons.ceramics$dry);
                    break;
                }
                case BISQUED: {
                    block.useTexture(BlockIcons.ceramics$bisque);
                    break;
                }
                case UNFIRED_GLAZED: {
                    block.useTexture(BlockIcons.ceramics$rawglaze);
                    break;
                }
                default: {
                    block.useTexture(BlockIcons.error);
                }
            }
        }
        boolean colors_changed = false;
        int total = greenware.parts.size();
        double d = 1.0 / (4096.0 * (double)total);
        int offset = -total / 2;
        int rci = -1;
        for (TileEntityGreenware.ClayLump rc : greenware.parts) {
            ++rci;
            if (state == TileEntityGreenware.ClayState.HIGHFIRED) {
                Block it = rc.icon_id;
                if (it == null || it == Blocks.field_150350_a) {
                    block.useTexture(BlockIcons.error);
                } else {
                    for (int i = 0; i < 6; ++i) {
                        int useIIcon = i;
                        if (rc.icon_side == -1) {
                            block.setTexture(i, it.func_149691_a(useIIcon, (int)rc.icon_md));
                        } else {
                            useIIcon = rc.icon_side;
                            block.useTexture(it.func_149691_a(useIIcon, (int)rc.icon_md));
                        }
                        int color = 0xFFFFFF;
                        if (greenware.func_145831_w() != null) {
                            try {
                                color = it.func_149720_d((IBlockAccess)greenware.func_145831_w(), greenware.field_145851_c, greenware.field_145848_d, greenware.field_145849_e);
                            }
                            catch (Throwable t) {
                                if (!this.spammed) {
                                    this.spammed = true;
                                    Core.logWarning("%s: could not get a Blocks.colorMultiplier from %s", greenware.getCoord(), it);
                                    t.printStackTrace();
                                }
                            }
                        } else {
                            color = it.func_149741_i(useIIcon);
                        }
                        if (color != 0xFFFFFF) {
                            colors_changed = true;
                            if (rc.icon_side == -1) {
                                block.setColor(i, color);
                            } else {
                                block.setColor(color);
                            }
                        }
                        if (rc.icon_side != -1) break;
                    }
                }
            }
            if (state == TileEntityGreenware.ClayState.UNFIRED_GLAZED) {
                int color = this.getColor(rc);
                if (color == 0) {
                    block.useTexture(BlockIcons.ceramics$bisque);
                    block.setColor(-1);
                } else {
                    block.useTexture(BlockIcons.ceramics$rawglaze);
                    block.setColor(color);
                }
                colors_changed = true;
            }
            rc.toBlockBounds(block);
            block.beginWithMirroredUVs();
            block.rotateMiddle(rc.quat);
            if (greenware.front != ForgeDirection.UNKNOWN && greenware.rotation > 0) {
                block.rotateCenter(greenware.rotation_quat);
            }
            float o = (float)((double)(offset + rci) * d);
            block.translate(o, o, o);
            block.renderRotated(Tessellator.field_78398_a, this.x, this.y, this.z);
        }
        if (colors_changed) {
            block.resetColors();
        }
    }

    void renderDynamic(TileEntityGreenware greenware) {
        Tessellator.field_78398_a.func_78382_b();
        this.renderToTessellator(greenware);
        Tessellator.field_78398_a.func_78381_a();
    }

    void renderStatic(TileEntityGreenware greenware) {
        this.renderToTessellator(greenware);
    }

    BlockRenderHelper setupRenderStand() {
        BlockRenderHelper block = BlockRenderHelper.instance;
        block.useTexture(BlockIcons.ceramics$stand);
        block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        return block;
    }

    BlockRenderHelper setupRenderGenericLump() {
        BlockRenderHelper block = BlockRenderHelper.instance;
        block.useTexture(Blocks.field_150435_aG.func_149733_h(0));
        block.func_149676_a(0.1875f, 0.125f, 0.1875f, 0.8125f, 0.875f, 0.8125f);
        return block;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.CERAMIC;
    }

    static {
        loader = new TileEntityGreenware();
        rawMimicRandom = new Random();
    }
}

