/*
 * Decompiled with CFR 0.152.
 */
package factorization.ceramics;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.ceramics.TileEntityGreenware;
import factorization.common.BlockIcons;
import factorization.common.ItemIcons;
import factorization.notify.Notice;
import factorization.shared.Core;
import factorization.shared.ItemFactorization;
import factorization.util.DataUtil;
import factorization.util.ItemUtil;
import factorization.util.LangUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ItemGlazeBucket
extends ItemFactorization {
    public static final int MAX_CHARGES = 64;
    static final int CONTENTS_PASS = 10;
    private boolean spammed = false;
    private ArrayList<ItemStack> subItems = new ArrayList();
    private boolean done;
    int md_for_nei = 0;

    public ItemGlazeBucket() {
        super("ceramics/glaze_bucket", Core.TabType.ART);
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.setNoRepair();
        Core.tab(this, Core.TabType.ART);
    }

    public IIcon getIcon(ItemStack is, int renderPass) {
        if (renderPass != 10) {
            if (!is.func_77942_o()) {
                return ItemIcons.ceramics$glaze_bucket_empty;
            }
            if (ItemUtil.couldMerge(is, Core.registry.base_common)) {
                return ItemIcons.ceramics$glaze_bucket_base;
            }
            if (ItemUtil.couldMerge(is, Core.registry.glaze_base_mimicry)) {
                return ItemIcons.ceramics$glaze_bucket_mimic;
            }
            if (ItemUtil.couldMerge(is, Core.registry.empty_glaze_bucket)) {
                return ItemIcons.ceramics$glaze_bucket_empty;
            }
            if (!is.func_77942_o()) {
                return ItemIcons.ceramics$glaze_bucket_empty;
            }
            if (is.func_77978_p().func_82582_d()) {
                return ItemIcons.ceramics$glaze_bucket_empty;
            }
            return super.func_77650_f(is);
        }
        Block block = this.getBlockId(is);
        if (block == null) {
            return BlockIcons.uv_test;
        }
        try {
            IIcon ret;
            byte side = this.getBlockSide(is);
            if (side == -1) {
                side = 1;
            }
            if ((ret = block.func_149691_a((int)side, (int)this.getBlockMd(is))) == null) {
                ret = BlockIcons.error;
            }
            return ret;
        }
        catch (Throwable t) {
            if (!this.spammed) {
                t.printStackTrace();
                this.spammed = true;
            }
            return BlockIcons.error;
        }
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 1;
    }

    public String func_77667_c(ItemStack is) {
        String base = super.func_77667_c(is);
        NBTTagCompound tag = ItemUtil.getTag(is);
        if (tag.func_74764_b("gid")) {
            String key = tag.func_74779_i("gid");
            return base + "." + key;
        }
        return base;
    }

    public String func_77653_i(ItemStack is) {
        ItemStack hint;
        String base = super.func_77653_i(is);
        if (this.isMimic(is) && (hint = this.getSource(is)) != null && hint.func_77973_b() != null) {
            return LangUtil.translate(this.func_77658_a() + ".mimicry_prefix") + " " + hint.func_82833_r();
        }
        return base;
    }

    public float getFullness(ItemStack is) {
        int c = this.getCharges(is);
        if (c >= 32) {
            return 1.0f;
        }
        if (c <= 0) {
            return 0.0f;
        }
        return (float)c / 64.0f;
    }

    public int getCharges(ItemStack is) {
        NBTTagCompound tag = ItemUtil.getTag(is);
        return tag.func_74762_e("remaining");
    }

    public boolean useCharge(ItemStack is) {
        NBTTagCompound tag = ItemUtil.getTag(is);
        int remaining = tag.func_74762_e("remaining");
        if (remaining <= 0) {
            return false;
        }
        tag.func_74768_a("remaining", --remaining);
        return remaining > 0;
    }

    private Block getBlockId(ItemStack is) {
        return DataUtil.getBlock(ItemUtil.getTag(is).func_74765_d("bid"));
    }

    private byte getBlockMd(ItemStack is) {
        return ItemUtil.getTag(is).func_74771_c("bmd");
    }

    private byte getBlockSide(ItemStack is) {
        return ItemUtil.getTag(is).func_74771_c("bsd");
    }

    private boolean isMimic(ItemStack is) {
        return ItemUtil.getTag(is).func_74767_n("mimic");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemId, CreativeTabs tab, List list) {
        list.addAll(this.subItems);
    }

    public void doneMakingStandardGlazes() {
        this.done = true;
    }

    public void notDoneMakingStandardGlazes() {
        this.done = false;
    }

    public void addGlaze(ItemStack is) {
        if (this.subItems.isEmpty()) {
            this.subItems.add(Core.registry.empty_glaze_bucket.func_77946_l());
        }
        if (!this.done) {
            this.subItems.add(is);
        }
    }

    void setGid(ItemStack is, String unique_id) {
        ItemUtil.getTag(is).func_74778_a("gid", unique_id);
    }

    public ItemStack makeCraftingGlaze(String unique_id) {
        ItemStack is = new ItemStack((Item)this);
        NBTTagCompound tag = ItemUtil.getTag(is);
        tag.func_74757_a("fake", true);
        this.setGid(is, unique_id);
        is.func_77964_b(this.md_for_nei++);
        this.addGlaze(is);
        return is;
    }

    private ItemStack makeGlazeWith(Block id, int md, int side) {
        ItemStack is = new ItemStack((Item)this);
        NBTTagCompound tag = ItemUtil.getTag(is);
        tag.func_74777_a("bid", (short)DataUtil.getId(id));
        tag.func_74774_a("bmd", (byte)md);
        tag.func_74774_a("bsd", (byte)side);
        tag.func_74768_a("remaining", 64);
        this.addGlaze(is);
        return is;
    }

    public ItemStack makeMimicingGlaze(Block id, int md, int side) {
        ItemStack is = this.makeGlazeWith(id, md, side);
        this.setMimicry(is);
        return is;
    }

    public void setMimicry(ItemStack is) {
        NBTTagCompound tag = ItemUtil.getTag(is);
        tag.func_74757_a("mimic", true);
    }

    public boolean isUsable(ItemStack is) {
        if (ItemUtil.getTag(is).func_74767_n("fake")) {
            return false;
        }
        return this.getBlockId(is) != null;
    }

    ItemStack getSource(ItemStack is) {
        Block b = this.getBlockId(is);
        if (b == null) {
            return null;
        }
        return new ItemStack(b, 1, (int)this.getBlockMd(is));
    }

    private ItemStack loadMimicingGlaze(ItemStack is, Coord at, int side, EntityPlayer player) {
        if (!ItemUtil.identical(is, Core.registry.glaze_base_mimicry)) {
            return is;
        }
        Block id = at.getId();
        int md = at.getMd();
        if (!player.func_70093_af()) {
            side = -1;
        }
        return this.makeMimicingGlaze(id, md, side);
    }

    public ItemStack func_77659_a(ItemStack is, World w, EntityPlayer player) {
        boolean repairMissingBlock;
        if (w.field_72995_K) {
            return is;
        }
        MovingObjectPosition mop = this.func_77621_a(w, player, true);
        if (mop == null) {
            return is;
        }
        if (mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return is;
        }
        Coord at = new Coord(w, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
        TileEntityGreenware clay = at.getTE(TileEntityGreenware.class);
        if (clay == null) {
            return this.loadMimicingGlaze(is, at, mop.field_72310_e, player);
        }
        if (!this.isUsable(is)) {
            return is;
        }
        if (mop.subHit == -1) {
            return is;
        }
        TileEntityGreenware.ClayState state = clay.getState();
        TileEntityGreenware.ClayLump part = clay.parts.get(mop.subHit);
        boolean bl = repairMissingBlock = part.icon_id == null || part.icon_id == Blocks.field_150350_a || part.icon_id == Core.registry.resource_block && part.icon_md > 15;
        if (player.field_71075_bZ.field_75098_d) {
            if (state != TileEntityGreenware.ClayState.HIGHFIRED) {
                clay.totalHeat = TileEntityGreenware.highfireHeat + 1;
            }
        } else {
            switch (state) {
                case WET: 
                case DRY: {
                    new Notice(clay, "Use a {ITEM_NAME} to bisque", new String[0]).withItem(Core.registry.heater_item).send(player);
                    return is;
                }
                case HIGHFIRED: {
                    if (repairMissingBlock) break;
                    new Notice(clay, "Already high-fired", new String[0]).send(player);
                    return is;
                }
            }
        }
        Block id = this.getBlockId(is);
        byte md = this.getBlockMd(is);
        byte sd = this.getBlockSide(is);
        if (part.icon_id == id && part.icon_md == md && part.icon_side == sd) {
            return is;
        }
        if (this.getCharges(is) > 0) {
            part.icon_id = id;
            part.icon_md = md;
            part.icon_side = sd;
            clay.changeLump(mop.subHit, part);
            clay.glazesApplied = true;
            if (!player.field_71075_bZ.field_75098_d && !repairMissingBlock) {
                this.useCharge(is);
                if (this.getCharges(is) <= 0) {
                    return Core.registry.empty_glaze_bucket.func_77946_l();
                }
            }
        }
        return is;
    }
}

