/*
 * Decompiled with CFR 0.152.
 */
package factorization.ceramics;

import factorization.api.Coord;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataInNBT;
import factorization.ceramics.TileEntityGreenware;
import factorization.common.ItemIcons;
import factorization.notify.Notice;
import factorization.shared.Core;
import factorization.shared.ItemFactorization;
import factorization.util.InvUtil;
import factorization.util.ItemUtil;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemSculptingTool
extends ItemFactorization {
    public ItemSculptingTool() {
        super("sculptTool", Core.TabType.ART);
        this.setNoRepair();
        this.func_77656_e(0);
        this.func_77625_d(4);
        this.func_77664_n();
        this.func_77627_a(true);
    }

    public static void addModeChangeRecipes() {
        int length = ToolMode.values().length;
        ToolMode[] mode = ToolMode.values();
        for (int i = 0; i < length; ++i) {
            int j;
            for (j = i + 1; j < length && !mode[j].craftable; ++j) {
            }
            if (j == length) {
                j = 0;
            }
            Core.registry.shapelessOreRecipe(ItemSculptingTool.fromMode(mode[j]), ItemSculptingTool.fromMode(mode[i]));
        }
    }

    public void func_94581_a(IIconRegister reg) {
    }

    ToolMode getMode(int damage) {
        if (damage < 0) {
            return ToolMode.MOVER;
        }
        if (damage >= ToolMode.values().length) {
            return ToolMode.MOVER;
        }
        return ToolMode.values()[damage];
    }

    static ItemStack fromMode(ToolMode mode) {
        return new ItemStack((Item)Core.registry.sculpt_tool, 1, mode.ordinal());
    }

    public IIcon func_77617_a(int damage) {
        switch (this.getMode(damage)) {
            default: {
                return ItemIcons.move;
            }
            case RESETTER: {
                return ItemIcons.reset;
            }
            case ROTATE_LOCAL: {
                return ItemIcons.rotate_local;
            }
            case ROTATE_GLOBAL: {
                return ItemIcons.rotate_global;
            }
            case STRETCHER: {
                return ItemIcons.stretch;
            }
            case MOLD: 
        }
        return ItemIcons.mold;
    }

    @Override
    public void addExtraInformation(ItemStack is, EntityPlayer player, List list, boolean verbose) {
        ToolMode mode = this.getMode(is.func_77960_j());
        String pre = "item.factorization:sculptTool.";
        list.add(StatCollector.func_74838_a((String)(pre + (Object)((Object)mode))));
        ToolMode nextMode = mode.next;
        while (nextMode != mode) {
            list.add(EnumChatFormatting.DARK_GRAY + "(" + StatCollector.func_74838_a((String)(pre + (Object)((Object)nextMode))) + ")");
            nextMode = nextMode.next;
        }
    }

    void changeMode(ItemStack is) {
        ToolMode mode = this.getMode(is.func_77960_j());
        is.func_77964_b(mode.next.ordinal());
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        return this.tryPlaceIntoWorld(par1ItemStack, par2EntityPlayer, par3World, par4, par5, par6, par7, par8, par9, par10);
    }

    public static MovingObjectPosition doRayTrace(EntityPlayer player) {
        return Core.registry.sculpt_tool.func_77621_a(player.field_70170_p, player, true);
    }

    public boolean tryPlaceIntoWorld(ItemStack is, EntityPlayer player, World w, int x, int y, int z, int side, float vx, float vy, float vz) {
        if (w.field_72995_K) {
            return true;
        }
        Coord here = new Coord(w, x, y, z);
        TileEntityGreenware gw = here.getTE(TileEntityGreenware.class);
        if (gw == null) {
            if (player.func_70093_af()) {
                this.changeMode(is);
                if (player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] == is) {
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = is.func_77946_l();
                }
                return true;
            }
            return false;
        }
        TileEntityGreenware.ClayState state = gw.getState();
        ToolMode mode = this.getMode(is.func_77960_j());
        if (mode == ToolMode.MOLD) {
            int is_fired = state.compareTo(TileEntityGreenware.ClayState.BISQUED);
            if (is_fired < 0 && !player.field_71075_bZ.field_75098_d) {
                new Notice(here, "Not fired", new String[0]).send(player);
                return true;
            }
            TileEntityGreenware rep = new TileEntityGreenware();
            NBTTagCompound tag = gw.getItem().func_77978_p();
            try {
                rep.putData(new DataInNBT(tag));
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            rep.totalHeat = 0;
            rep.glazesApplied = false;
            rep.lastTouched = 0;
            for (TileEntityGreenware.ClayLump part : rep.parts) {
                part.icon_id = null;
                part.icon_md = 0;
                part.icon_side = (byte)-1;
            }
            ItemStack toDrop = rep.getItem();
            if (gw.customName != null) {
                toDrop.func_151001_c(gw.customName);
            }
            InvUtil.FzInv inv = InvUtil.openInventory((IInventory)player.field_71071_by, 0);
            if (!player.field_71075_bZ.field_75098_d) {
                ItemStack theSlab = null;
                int materialCount = 0;
                int neededClay = gw.parts.size();
                for (int i = 0; i < inv.size(); ++i) {
                    ItemStack it = inv.get(i);
                    if (it == null) continue;
                    if (it.func_77973_b() == Items.field_151119_aD) {
                        materialCount += it.field_77994_a;
                    }
                    if (theSlab != null || !ItemUtil.oreDictionarySimilar("slabWood", it)) continue;
                    theSlab = it;
                }
                if (theSlab == null || materialCount < neededClay) {
                    new Notice(here, "item.factorization:sculptTool.MOLD.needs", "" + neededClay).send(player);
                    return false;
                }
                inv.pull(theSlab, 1, false);
                inv.pull(new ItemStack(Items.field_151119_aD), gw.parts.size(), false);
            }
            if (inv.push(toDrop) != null) {
                player.func_71019_a(toDrop, false);
            }
            Core.proxy.updatePlayerInventory(player);
            return true;
        }
        if (state != TileEntityGreenware.ClayState.WET) {
            if (w.field_72995_K) {
                return false;
            }
            Notice msg = new Notice(gw.getCoord(), "", new String[0]);
            switch (state) {
                case DRY: {
                    msg.withItem(new ItemStack(Items.field_151131_as)).setMessage("The clay is dry\nUse a {ITEM_NAME}", new String[0]);
                    break;
                }
                case BISQUED: 
                case HIGHFIRED: {
                    msg.setMessage("This has been fired", new String[0]);
                    break;
                }
                default: {
                    msg.setMessage("This clay can not be reshaped.", new String[0]);
                }
            }
            msg.send(player);
            return false;
        }
        if (w.field_72995_K) {
            return true;
        }
        MovingObjectPosition hitPart = this.func_77621_a(w, player, true);
        if (hitPart == null) {
            return false;
        }
        if (hitPart.subHit == -1) {
            return true;
        }
        int strength = Math.max(1, is.field_77994_a);
        TileEntityGreenware.ClayLump selection = gw.parts.get(hitPart.subHit);
        TileEntityGreenware.ClayLump test = selection.copy();
        boolean sneaking = player.func_70093_af();
        switch (mode) {
            case MOVER: {
                this.move(test, sneaking, side, strength);
                break;
            }
            case STRETCHER: {
                this.stretch(test, sneaking, side, strength);
                break;
            }
            case ROTATE_LOCAL: {
                this.rotate_local(test, sneaking, side, strength);
                break;
            }
            case ROTATE_GLOBAL: {
                this.rotate_global(test, sneaking, side, strength);
                break;
            }
            case RESETTER: {
                if (sneaking) {
                    Quaternion orig = test.quat;
                    test.asDefault();
                    test.quat = orig;
                    break;
                }
                test.quat = new Quaternion();
                break;
            }
            case MOLD: {
                new Notice(here, "Not fired", new String[0]).send(player);
                return true;
            }
        }
        if (gw.isValidLump(test)) {
            gw.changeLump(hitPart.subHit, test);
        }
        return true;
    }

    void rotate_local(TileEntityGreenware.ClayLump cube, boolean reverse, int side, int strength) {
        float delta = (float)Math.toRadians(-11.25f * (float)strength);
        if (reverse) {
            delta *= -1.0f;
        }
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        cube.quat.incrMultiply(Quaternion.getRotationQuaternionRadians(delta, direction.offsetX, direction.offsetY, direction.offsetZ));
    }

    void rotate_global(TileEntityGreenware.ClayLump cube, boolean reverse, int side, int strength) {
        float delta = (float)Math.toRadians(-11.25f * (float)strength);
        if (reverse) {
            delta *= -1.0f;
        }
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        Quaternion global = Quaternion.getRotationQuaternionRadians(delta, direction.offsetX, direction.offsetY, direction.offsetZ);
        global.incrMultiply(cube.quat);
        cube.quat = global;
    }

    void move(TileEntityGreenware.ClayLump cube, boolean reverse, int side, int strength) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        this.stretch(cube, reverse, dir.ordinal(), strength);
        this.stretch(cube, !reverse, dir.getOpposite().ordinal(), strength);
    }

    void stretch(TileEntityGreenware.ClayLump cube, boolean reverse, int side, int strength) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        int delta = reverse ? -strength : strength;
        switch (dir) {
            case SOUTH: {
                cube.maxZ = (byte)(cube.maxZ + delta);
                break;
            }
            case NORTH: {
                cube.minZ = (byte)(cube.minZ - delta);
                break;
            }
            case EAST: {
                cube.maxX = (byte)(cube.maxX + delta);
                break;
            }
            case WEST: {
                cube.minX = (byte)(cube.minX - delta);
                break;
            }
            case UP: {
                cube.maxY = (byte)(cube.maxY + delta);
                break;
            }
            case DOWN: {
                cube.minY = (byte)(cube.minY - delta);
                break;
            }
        }
    }

    public boolean func_77616_k(ItemStack is) {
        return true;
    }

    static enum ToolMode {
        MOVER("move", true),
        STRETCHER("stretch", false),
        ROTATE_GLOBAL("rotate_global", true),
        ROTATE_LOCAL("rotate_local", false),
        RESETTER("reset", true),
        MOLD("mold", true);

        String name;
        boolean craftable;
        ToolMode next;

        private ToolMode(String english, boolean craftable) {
            this.name = english;
            this.craftable = craftable;
            this.next = this;
        }

        static void group(ToolMode ... group) {
            ToolMode prev = group[group.length - 1];
            for (ToolMode me : group) {
                me.next = prev;
                prev = me;
            }
        }

        static {
            ToolMode.group(MOVER, STRETCHER);
            ToolMode.group(RESETTER);
            ToolMode.group(ROTATE_GLOBAL, ROTATE_LOCAL);
            ToolMode.group(MOLD);
        }
    }
}

