/*
 * Decompiled with CFR 0.152.
 */
package factorization.charge;

import factorization.api.Coord;
import factorization.api.Quaternion;
import factorization.charge.TileEntityMirror;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.common.FzConfig;
import factorization.common.ResourceType;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.FactorizationBlockRender;
import factorization.util.NumUtil;
import factorization.util.SpaceUtil;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockRenderMirrorStand
extends FactorizationBlockRender {
    private static final int[] frontFace = new int[]{1};
    private static final int[] backFace = new int[]{0};
    private static final int[] sideFace = new int[]{2, 3, 4, 5};
    private static Quaternion mirrorTilt = Quaternion.getRotationQuaternionRadians(Math.toRadians(-45.0), 1.0, 0.0, 0.0);

    @Override
    public boolean render(RenderBlocks rb) {
        TileEntityMirror mirror;
        if (!this.world_mode) {
            return false;
        }
        Core.profileStart("mirror");
        float height = 0.453125f;
        float radius = 0.0625f;
        float c = 0.5f;
        IIcon silver = Core.registry.resource_block.func_149691_a(0, ResourceType.SILVERBLOCK.md);
        BlockRenderHelper block = Core.registry.blockRender;
        block.useTexture(silver);
        block.setTexture(0, null);
        block.func_149676_a(c - radius, 0.0f, c - radius, c + radius, height, c + radius);
        block.render(rb, this.x, this.y, this.z);
        float trim = 0.1875f;
        float trim_height = 0.125f;
        this.renderPart(rb, silver, trim, 0.0f, trim, 1.0f - trim, trim_height, 1.0f - trim);
        block.setBlockBoundsOffset(0.125f, 0.46875f, 0.125f);
        IIcon side = BlockIcons.mirror_side;
        IIcon face = BlockIcons.mirror_front;
        block.useTextures(face, face, side, side, side, side);
        block.beginWithMirroredUVs();
        Coord here = this.getCoord();
        if (this.world_mode && (mirror = (TileEntityMirror)this.te) != null && mirror.target_rotation >= 0) {
            block.translate(-0.5f, 0.0f, 0.0f);
            Quaternion trans = Quaternion.getRotationQuaternionRadians(Math.toRadians(mirror.target_rotation - 90), ForgeDirection.UP);
            trans.incrMultiply(mirrorTilt);
            block.rotate(trans);
            block.translate(0.5f, -0.2f, 0.5f);
        }
        if (!this.world_mode) {
            Tessellator.field_78398_a.func_78382_b();
        }
        block.renderRotated(Tessellator.field_78398_a, here);
        if (!this.world_mode) {
            Tessellator.field_78398_a.func_78381_a();
        }
        Core.profileEnd();
        return true;
    }

    @Override
    public boolean renderSecondPass(RenderBlocks rb) {
        boolean sun;
        if (!this.world_mode) {
            return false;
        }
        if (!FzConfig.mirror_sunbeams) {
            return false;
        }
        if (rb.field_147840_d != null) {
            return false;
        }
        TileEntityMirror mirror = (TileEntityMirror)this.te;
        Coord hit = mirror.reflection_target;
        if (hit == null) {
            return false;
        }
        if (hit.x == this.x && hit.z == this.z && hit.y == this.y) {
            return false;
        }
        mirror.last_drawn_as_lit = sun = mirror.hasSun();
        if (!sun) {
            return false;
        }
        float[] poses = new float[]{-0.375f, 0.375f};
        Quaternion trans = Quaternion.getRotationQuaternionRadians(Math.toRadians(mirror.target_rotation - 90), ForgeDirection.UP);
        trans.incrMultiply(mirrorTilt);
        Vec3[] points = new Vec3[4];
        int i = 0;
        for (int sx = 0; sx < 2; ++sx) {
            for (int sz = 0; sz < 2; ++sz) {
                Vec3 vec = Vec3.func_72443_a((double)poses[sx], (double)0.0, (double)poses[sz]);
                trans.applyRotation(vec);
                vec.field_72450_a += (double)((float)this.x + 0.5f);
                vec.field_72448_b += (double)((float)this.y + 0.5f);
                vec.field_72449_c += (double)((float)this.z + 0.5f);
                points[i++] = vec;
            }
        }
        Vec3 src = Vec3.func_72443_a((double)((double)this.x + 0.5), (double)((double)this.y + 0.5), (double)((double)this.z + 0.5));
        Vec3 middle = mirror.reflection_target.toMiddleVector();
        Vec3 dif = SpaceUtil.subtract(middle, src);
        float N = 1.125f;
        float invN = 1.0f / N;
        SpaceUtil.incrScale(dif, N);
        Vec3 far = SpaceUtil.add(src, dif);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78380_c(Blocks.field_150426_aN.func_149677_c(this.w, this.x, this.y, this.z));
        IIcon icon = BlockIcons.mirror_beam;
        tess.func_78386_a(1.0f, 1.0f, 1.0f);
        byte[] as = new byte[]{2, 1, 0, 3};
        byte[] bs = new byte[]{0, 3, 1, 2};
        Vec3 work = SpaceUtil.newVec();
        float min_opacity = 0.09411765f;
        float opacity_per_power = 0.015686275f;
        float alpha = min_opacity + (float)mirror.getPower() * opacity_per_power;
        Tessellator.field_78398_a.func_78369_a(1.0f, 1.0f, 1.0f, alpha);
        for (i = 0; i < 4; ++i) {
            Vec3 a = points[as[i]];
            Vec3 b = points[bs[i]];
            NumUtil.interp(b, far, invN, work);
            tess.func_78374_a(work.field_72450_a, work.field_72448_b, work.field_72449_c, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            NumUtil.interp(a, far, invN, work);
            tess.func_78374_a(work.field_72450_a, work.field_72448_b, work.field_72449_c, (double)icon.func_94212_f(), (double)icon.func_94206_g());
            tess.func_78374_a(a.field_72450_a, a.field_72448_b, a.field_72449_c, (double)icon.func_94209_e(), (double)icon.func_94210_h());
            tess.func_78374_a(b.field_72450_a, b.field_72448_b, b.field_72449_c, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        }
        return true;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.MIRROR;
    }
}

