/*
 * Decompiled with CFR 0.152.
 */
package factorization.charge;

import factorization.charge.TileEntitySolarBoiler;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockRenderHelper;
import factorization.shared.FactorizationBlockRender;
import factorization.shared.TileEntityCommon;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;

public class BlockRenderSolarBoiler
extends FactorizationBlockRender {
    @Override
    public boolean render(RenderBlocks rb) {
        if (this.world_mode) {
            TileEntityCommon c = this.getCoord().getTE(TileEntityCommon.class);
            if (c == null) {
                return false;
            }
            return this.renderNormalBlock(rb, c.getFactoryType().md);
        }
        this.renderNormalBlock(rb, this.metadata);
        return false;
    }

    @Override
    public boolean renderSecondPass(RenderBlocks rb) {
        if (!this.world_mode) {
            return false;
        }
        TileEntitySolarBoiler boiler = (TileEntitySolarBoiler)this.te;
        float alpha = boiler.last_synced_heat;
        if (alpha <= 0.0f) {
            return false;
        }
        if ((alpha = (float)Math.log10(alpha) / 6.0f) > 0.4f) {
            alpha = 0.4f;
        }
        BlockRenderHelper block = BlockRenderHelper.instance;
        block.useTexture(BlockIcons.heater_heat);
        float s = -0.001953125f;
        block.setBlockBoundsOffset(s, s, s);
        block.alpha = alpha;
        block.beginWithRotatedUVs();
        block.renderRotated(Tessellator.field_78398_a, this.x, this.y, this.z);
        block.alpha = 1.0f;
        return true;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SOLARBOILER;
    }
}

