/*
 * Decompiled with CFR 0.152.
 */
package factorization.charge;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.shared.Core;
import java.util.Random;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class ChargeSparks {
    public long last_update = -1L;
    private SparkInfo[] sparks;
    private int index = 0;
    private static Random creationRandom = new Random();
    private static Random rand = new Random();
    private static int segments_drawn;
    private static int end_segment;
    private static SparkInfo current_spark;
    private static Vec3 work;
    private static Vec3 work2;
    private static Vec3 delta;

    public ChargeSparks(int count) {
        this.sparks = new SparkInfo[count];
        for (int i = 0; i < this.sparks.length; ++i) {
            this.sparks[i] = new SparkInfo();
        }
    }

    SparkInfo take() {
        if (this.index == this.sparks.length) {
            this.index = 0;
        }
        return this.sparks[this.index++];
    }

    public void spark(Vec3 src, Vec3 dest, int life, int stepTime, int depth, double variance, double width, int color) {
        SparkInfo info = this.take();
        info.src = src;
        info.dest = dest;
        info.life = info.max_life = life;
        info.stepTime = stepTime;
        info.depth = depth;
        info.color = color;
        info.variance = variance;
        info.width = width;
        info.seed = creationRandom.nextInt();
    }

    public void update() {
        for (int i = 0; i < this.sparks.length; ++i) {
            --this.sparks[i].life;
        }
    }

    double interpolate(double a, double perc) {
        double b = a * a + 0.2;
        b = Math.min(1.0, b);
        return a * (1.0 - perc) + b * perc;
    }

    double alpha_interpolate(double a, double perc) {
        perc *= perc * perc;
        double b = Math.min(0.0, a);
        return a * (1.0 - perc) + b * perc;
    }

    @SideOnly(value=Side.CLIENT)
    public void render() {
        Tessellator tess = Tessellator.field_78398_a;
        Core.profileStart("fz_spark");
        int last_color = -1;
        tess.func_78378_d(0xFFFFFF);
        boolean any = false;
        for (int i = 0; i < this.sparks.length; ++i) {
            SparkInfo spark = this.sparks[i];
            if (spark.life <= 0) continue;
            if (!any) {
                GL11.glPushAttrib((int)24576);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)3553);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)1);
                any = true;
            }
            current_spark = spark;
            end_segment = (spark.max_life - spark.life) / spark.stepTime;
            rand.setSeed(spark.seed);
            segments_drawn = 0;
            double f = 255.0;
            double r = (double)(spark.color >> 16 & 0xFF) / f;
            double g = (double)(spark.color >> 8 & 0xFF) / f;
            double b = (double)(spark.color & 0xFF) / f;
            double alpha = 0.8;
            double depth_end = 1 << spark.depth;
            double perc = (double)end_segment / depth_end;
            GL11.glColor4d((double)this.interpolate(r, perc), (double)this.interpolate(g, perc), (double)this.interpolate(b, perc), (double)this.alpha_interpolate(alpha, perc));
            GL11.glLineWidth((float)((float)spark.width));
            tess.func_78371_b(1);
            this.drawSpark(spark.src, spark.dest, spark.depth);
            tess.func_78381_a();
        }
        if (any) {
            GL11.glPopAttrib();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        Core.profileEnd();
    }

    void drawSpark(Vec3 start, Vec3 end, int depth) {
        if (segments_drawn > end_segment) {
            return;
        }
        if (depth == 0) {
            ChargeSparks.work.field_72448_b = start.field_72448_b;
            ChargeSparks.work.field_72449_c = start.field_72449_c;
            ChargeSparks.work.field_72450_a = end.field_72450_a;
            this.drawLine(start, work);
            ChargeSparks.work2.field_72450_a = end.field_72450_a;
            ChargeSparks.work2.field_72448_b = end.field_72448_b;
            ChargeSparks.work2.field_72449_c = start.field_72449_c;
            this.drawLine(work, work2);
            this.drawLine(work2, end);
            ++segments_drawn;
            return;
        }
        ChargeSparks.delta.field_72450_a = end.field_72450_a - start.field_72450_a;
        ChargeSparks.delta.field_72448_b = end.field_72448_b - start.field_72448_b;
        ChargeSparks.delta.field_72449_c = end.field_72449_c - start.field_72449_c;
        double d = ChargeSparks.current_spark.variance;
        d = d * (double)(--depth) / (double)ChargeSparks.current_spark.depth;
        Vec3 mid = start.func_72441_c(end.field_72450_a, end.field_72448_b, end.field_72449_c);
        mid.field_72450_a /= 2.0;
        mid.field_72448_b /= 2.0;
        mid.field_72449_c /= 2.0;
        mid.field_72450_a += ChargeSparks.delta.field_72450_a * d * (rand.nextDouble() - 0.5);
        mid.field_72448_b += ChargeSparks.delta.field_72448_b * d * (rand.nextDouble() - 0.5);
        mid.field_72449_c += ChargeSparks.delta.field_72449_c * d * (rand.nextDouble() - 0.5);
        this.drawSpark(start, mid, depth);
        if (segments_drawn > end_segment) {
            return;
        }
        this.drawSpark(mid, end, depth);
    }

    void drawLine(Vec3 start, Vec3 end) {
        Tessellator.field_78398_a.func_78377_a(start.field_72450_a, start.field_72448_b, start.field_72449_c);
        Tessellator.field_78398_a.func_78377_a(end.field_72450_a, end.field_72448_b, end.field_72449_c);
    }

    static {
        work = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        work2 = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        delta = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    }

    private static class SparkInfo {
        Vec3 src;
        Vec3 dest;
        int life;
        int max_life;
        int stepTime;
        int depth;
        double width;
        double variance;
        int color;
        int seed;

        private SparkInfo() {
        }
    }
}

