/*
 * Decompiled with CFR 0.152.
 */
package factorization.charge;

import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.HeatConverters;
import factorization.api.IChargeConductor;
import factorization.api.IFurnaceHeatable;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockClass;
import factorization.shared.NetworkFactorization;
import factorization.shared.TileEntityCommon;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityHeater
extends TileEntityCommon
implements IChargeConductor {
    Charge charge = new Charge(this);
    public byte heat = 0;
    public static final byte maxHeat = 32;
    byte last_heat = (byte)-99;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.HEATER;
    }

    @Override
    public IIcon getIcon(ForgeDirection dir) {
        return BlockIcons.heater_spiral;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        return null;
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        this.charge.serialize("", data);
        this.heat = data.as(Share.VISIBLE, "heat").putByte(this.heat);
    }

    int charge2heat(int i) {
        return (int)((double)i / 1.5);
    }

    void updateClient() {
        int delta = Math.abs(this.heat - this.last_heat);
        if (delta > 2) {
            this.broadcastMessage(null, NetworkFactorization.MessageType.HeaterHeat, this.heat);
            this.last_heat = this.heat;
        }
    }

    @Override
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.HeaterHeat) {
            this.heat = input.readByte();
            return true;
        }
        return false;
    }

    public void func_145845_h() {
        int heatToRemove;
        int avail;
        int rate;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.updateClient();
        Coord here = this.getCoord();
        if (here.isPowered()) {
            this.charge.update();
            return;
        }
        long now = this.field_145850_b.func_82737_E() + (long)here.seed();
        if (now % (long)(rate = 4) == 0L && (avail = Math.min(heatToRemove = 32 - this.heat, this.charge.getValue())) > 0 && this.charge2heat(heatToRemove) > 0) {
            this.heat = (byte)(this.heat + this.charge2heat(this.charge.deplete(heatToRemove)));
        }
        this.charge.update();
        if (!this.canSendHeat()) {
            return;
        }
        boolean recurs = false;
        int action = 0;
        ArrayList<Coord> randomNeighbors = here.getRandomNeighborsAdjacent();
        ArrayList<TileEntityHeater> heaters = null;
        for (Coord c : randomNeighbors) {
            if (action == 0 && c.getBlock() == this.field_145854_h && c.getTE() instanceof TileEntityHeater) {
                if (heaters == null) {
                    heaters = new ArrayList<TileEntityHeater>();
                }
                heaters.add(c.getTE(TileEntityHeater.class));
                continue;
            }
            IFurnaceHeatable furnace = HeatConverters.convert(c.w, c.x, c.y, c.z);
            if (furnace == null || !this.sendHeat(furnace)) continue;
            ++action;
            if (this.canSendHeat()) continue;
            return;
        }
        if (action == 0 && heaters != null) {
            for (TileEntityHeater heater : heaters) {
                this.recursiveHeat(heater);
            }
        }
    }

    void recursiveHeat(TileEntityHeater heater) {
        byte to_take = 2;
        if (this.heat < to_take) {
            return;
        }
        for (Coord c : heater.getCoord().getRandomNeighborsAdjacent()) {
            IFurnaceHeatable adj = HeatConverters.convert(c.w, c.x, c.y, c.z);
            if (adj == null || !heater.sendHeat(adj)) continue;
            this.heat = (byte)(this.heat - to_take);
            return;
        }
    }

    boolean shouldHeat(int cookTime) {
        if ((double)this.heat >= 16.0) {
            return true;
        }
        return cookTime > 0;
    }

    boolean canSendHeat() {
        return this.heat > 16;
    }

    boolean sendHeat(IFurnaceHeatable furnace) {
        if (!furnace.acceptsHeat()) {
            return false;
        }
        if (furnace.hasLaggyStart()) {
            boolean can_jumpstart;
            boolean bl = can_jumpstart = (double)this.heat >= 30.4;
            if (!can_jumpstart && !furnace.isStarted()) {
                return false;
            }
        }
        boolean any = false;
        for (int i = 1; i <= 2; ++i) {
            furnace.giveHeat();
            this.heat = (byte)(this.heat - i);
            any = true;
            if (this.canSendHeat()) continue;
            return true;
        }
        return true;
    }

    void cookEntity(Entity ent) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (ent == null) {
            return;
        }
        if (this.heat <= 8) {
            return;
        }
        if (ent.func_70027_ad()) {
            return;
        }
        if (!ent.func_70104_M()) {
            return;
        }
        if (!(ent instanceof EntityLivingBase)) {
            return;
        }
        if (this.getCoord().isPowered()) {
            return;
        }
        this.heat = (byte)(this.heat - 8);
        ent.func_70015_d(1);
    }

    @Override
    public boolean addCollisionBoxesToList(Block block, AxisAlignedBB aabb, List list, Entity entity) {
        this.cookEntity(entity);
        return super.addCollisionBoxesToList(block, aabb, list, entity);
    }
}

