/*
 * Decompiled with CFR 0.152.
 */
package factorization.charge;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.ICoord;
import factorization.api.IReflectionTarget;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.common.FzConfig;
import factorization.shared.BlockClass;
import factorization.shared.BlockFactorization;
import factorization.shared.Core;
import factorization.shared.NetworkFactorization;
import factorization.shared.TileEntityCommon;
import factorization.util.DataUtil;
import factorization.util.ItemUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityMirror
extends TileEntityCommon {
    public Coord reflection_target = null;
    public boolean is_lit = false;
    int next_check = 1;
    public transient int target_rotation = -99;
    private boolean covered_by_other_mirror = false;
    public byte silver = 1;
    int last_shared = -1;
    boolean gotten_info_packet = false;
    public boolean last_drawn_as_lit = false;
    private static ItemStack[] _silver_blocks = null;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.MIRROR;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        if (this.reflection_target == null) {
            this.reflection_target = this.getCoord();
        }
        this.reflection_target = data.as(Share.VISIBLE, "target").putIDS(this.reflection_target);
        if (this.reflection_target.equals(this.getCoord())) {
            this.reflection_target = null;
        } else if (data.isReader()) {
            this.updateRotation();
        }
        this.covered_by_other_mirror = data.as(Share.VISIBLE, "covered").putBoolean(this.covered_by_other_mirror);
        this.silver = data.as(Share.VISIBLE, "silver").putByte(this.silver);
    }

    public void func_145834_a(World w) {
        super.func_145834_a(w);
        if (this.reflection_target != null) {
            this.reflection_target.w = w;
        }
    }

    @Override
    public boolean activate(EntityPlayer entityplayer, ForgeDirection side) {
        this.neighborChanged();
        return false;
    }

    @Override
    public void neighborChanged() {
        this.next_check = -1;
        IReflectionTarget target = this.reflection_target == null ? null : this.reflection_target.getTE(IReflectionTarget.class);
        byte new_silver = this.countSilver();
        if (new_silver == this.silver) {
            return;
        }
        if (target == null) {
            this.silver = new_silver;
            return;
        }
        int oldPower = -this.getPower();
        this.silver = new_silver;
        int newPower = this.getPower();
        target.addReflector(oldPower + newPower);
        this.broadcastTargetInfoIfChanged(true);
    }

    int getPower() {
        return this.silver;
    }

    int clipAngle(int angle) {
        if ((angle %= 360) < 0) {
            angle += 360;
        }
        return angle;
    }

    public boolean hasSun() {
        boolean raining;
        boolean bl = raining = this.func_145831_w().func_72896_J() && this.func_145831_w().func_72807_a((int)this.field_145851_c, (int)this.field_145848_d).field_76751_G > 0.0f;
        if (raining) {
            return false;
        }
        if (this.field_145850_b.func_72972_b(EnumSkyBlock.Sky, this.field_145851_c, this.field_145848_d, this.field_145849_e) < 15) {
            return false;
        }
        if (this.covered_by_other_mirror) {
            return false;
        }
        return (double)this.field_145850_b.getSunBrightnessFactor(0.0f) > 0.7;
    }

    void broadcastTargetInfoIfChanged(boolean force) {
        if (force || this.getTargetInfo() != this.last_shared) {
            Coord target = this.reflection_target == null ? new Coord(this) : this.reflection_target;
            this.broadcastMessage(null, NetworkFactorization.MessageType.MirrorDescription, this.getTargetInfo(), target.x, target.y, target.z, this.silver);
            this.last_shared = this.getTargetInfo();
        }
    }

    int getTargetInfo() {
        return this.reflection_target == null ? -99 : this.target_rotation;
    }

    void setRotationTarget(int new_target) {
        if (this.target_rotation != new_target) {
            this.target_rotation = new_target;
        }
    }

    @Override
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.MirrorDescription) {
            this.target_rotation = input.readInt();
            this.reflection_target = new Coord(this);
            this.reflection_target.x = input.readInt();
            this.reflection_target.y = input.readInt();
            this.reflection_target.z = input.readInt();
            this.silver = input.readByte();
            this.getCoord().redraw();
            this.gotten_info_packet = true;
            return true;
        }
        return false;
    }

    void setBelowObscured(Coord at, boolean state) {
        while (at.y > 0) {
            TileEntityMirror below;
            --at.y;
            if (!(at.getBlock() instanceof BlockFactorization) || (below = at.getTE(TileEntityMirror.class)) == null) continue;
            below.covered_by_other_mirror = state;
            break;
        }
    }

    @Override
    public void onPlacedBy(EntityPlayer player, ItemStack is, int side, float hitX, float hitY, float hitZ) {
        super.onPlacedBy(player, is, side, hitX, hitY, hitZ);
        this.setBelowObscured(this.getCoord(), true);
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        if (!this.covered_by_other_mirror) {
            this.setBelowObscured(this.getCoord(), false);
        }
        if (this.reflection_target == null) {
            return;
        }
        this.reflection_target.w = this.field_145850_b;
        if (this.field_145850_b == null) {
            return;
        }
        IReflectionTarget target = this.reflection_target.getTE(IReflectionTarget.class);
        if (target == null) {
            return;
        }
        if (this.is_lit) {
            target.addReflector(-this.getPower());
            this.is_lit = false;
        }
        this.reflection_target = null;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b != null) {
            this.onRemove();
        }
    }

    void setNextCheck() {
        this.next_check = 80 + this.field_145850_b.field_73012_v.nextInt(20);
    }

    public void func_145845_h() {
        if (this.next_check-- <= 0) {
            this.setNextCheck();
            if (this.field_145850_b.field_72995_K) {
                this.is_lit = this.hasSun();
                if (this.is_lit != this.last_drawn_as_lit && FzConfig.mirror_sunbeams && this.reflection_target != null) {
                    new Coord(this).markBlockForUpdate();
                }
                return;
            }
            try {
                if (this.reflection_target == null) {
                    this.findTarget();
                    if (this.reflection_target == null) {
                        return;
                    }
                } else {
                    this.reflection_target.setWorld(this.field_145850_b);
                }
                IReflectionTarget target = null;
                target = this.reflection_target.getTE(IReflectionTarget.class);
                if (target == null) {
                    if (this.reflection_target.blockExists()) {
                        this.reflection_target = null;
                        this.is_lit = false;
                    }
                    return;
                }
                if (!this.myTrace(this.reflection_target.x, this.reflection_target.z) && this.is_lit) {
                    this.is_lit = false;
                    target.addReflector(-this.getPower());
                    this.reflection_target = null;
                    this.setRotationTarget(-99);
                    return;
                }
                boolean has_sun = this.hasSun();
                if (has_sun != this.is_lit) {
                    this.is_lit = has_sun;
                    target.addReflector(this.is_lit ? this.getPower() : -this.getPower());
                }
            }
            finally {
                this.broadcastTargetInfoIfChanged(false);
            }
        }
    }

    void findTarget() {
        if (this.reflection_target != null) {
            IReflectionTarget target = this.reflection_target.getTE(IReflectionTarget.class);
            if (target != null) {
                if (this.is_lit) {
                    target.addReflector(-this.getPower());
                }
                this.reflection_target = null;
            }
            this.is_lit = false;
        }
        int search_distance = 11;
        ICoord closest = null;
        int last_dist = Integer.MAX_VALUE;
        Coord me = this.getCoord();
        double maxRadiusSq = 79.21000000000001;
        for (int x = this.field_145851_c - search_distance; x <= this.field_145851_c + search_distance; ++x) {
            for (int z = this.field_145849_e - search_distance; z <= this.field_145849_e + search_distance; ++z) {
                int new_dist;
                Coord here = new Coord(this.field_145850_b, x, this.field_145848_d, z);
                IReflectionTarget target = here.getTE(IReflectionTarget.class);
                if (target == null || !this.myTrace(x, z) || (new_dist = me.distanceSq(here)) >= last_dist || !((double)new_dist <= maxRadiusSq)) continue;
                last_dist = new_dist;
                closest = target;
            }
        }
        if (closest != null) {
            this.reflection_target = closest.getCoord();
            this.updateRotation();
        } else {
            this.setRotationTarget(-99);
        }
    }

    void updateRotation() {
        DeltaCoord dc = this.getCoord().difference(this.reflection_target);
        int new_target = this.clipAngle((int)Math.toDegrees(dc.getAngleHorizontal()));
        this.setRotationTarget(new_target);
    }

    double div(double a, double b) {
        if (b == 0.0) {
            return Math.signum(a) * 4095.0;
        }
        return a / b;
    }

    boolean myTrace(double x, double z) {
        double offset_x = (x += 0.5) - ((double)this.field_145851_c + 0.5);
        double offset_z = (z += 0.5) - ((double)this.field_145849_e + 0.5);
        double length = Math.hypot(offset_x, offset_z);
        double dx = offset_x / length;
        double dz = offset_z / length;
        x -= dx;
        z -= dz;
        int bx = 0;
        int bz = 0;
        int i = 0;
        while ((double)i < length) {
            bx = (int)Math.round(x + 0.5) - 1;
            bz = (int)Math.round(z + 0.5) - 1;
            if (bx == this.field_145851_c && bz == this.field_145849_e) {
                return true;
            }
            Block b = this.field_145850_b.func_147439_a(bx, this.field_145848_d, bz);
            boolean air_like = false;
            if (b == null) {
                air_like = true;
            } else {
                air_like = b.isAir((IBlockAccess)this.field_145850_b, bx, this.field_145848_d, bz);
                air_like |= b.func_149668_a(this.field_145850_b, bx, this.field_145848_d, bz) == null;
            }
            if (!air_like) {
                return false;
            }
            x -= dx;
            z -= dz;
            ++i;
        }
        return false;
    }

    @Override
    public boolean isBlockSolidOnSide(int side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ForgeDirection dir) {
        return BlockIcons.mirror_front;
    }

    @Override
    public ItemStack getDroppedBlock() {
        return new ItemStack((Item)Core.registry.mirror);
    }

    public static ItemStack[] getSilver() {
        if (_silver_blocks != null) {
            return _silver_blocks;
        }
        ArrayList<ItemStack> foundSilver = new ArrayList<ItemStack>();
        for (String oreName : Arrays.asList("blockSilver", "blockGold", "blockCopper", "factorization:mirrorBoost")) {
            for (ItemStack ag : OreDictionary.getOres((String)oreName)) {
                Block b = DataUtil.getBlock(ag);
                if (b == null) continue;
                foundSilver.add(ag);
            }
        }
        _silver_blocks = foundSilver.toArray(new ItemStack[foundSilver.size()]);
        return _silver_blocks;
    }

    private byte countSilver() {
        byte ret = 1;
        block0: for (Coord c : this.getCoord().getNeighborsAdjacent()) {
            if (c.isAir() || !c.isSolid()) continue;
            ItemStack is = c.getPickBlock(ForgeDirection.DOWN);
            for (ItemStack ag : TileEntityMirror.getSilver()) {
                if (!ItemUtil.wildcardSimilar(ag, is)) continue;
                if ((ret = (byte)(ret + 2)) <= 6) continue block0;
                return 6;
            }
        }
        return ret;
    }
}

