/*
 * Decompiled with CFR 0.152.
 */
package factorization.charge;

import factorization.api.Coord;
import factorization.api.IMeterInfo;
import factorization.api.IReflectionTarget;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.common.FzConfig;
import factorization.shared.BlockClass;
import factorization.shared.NetworkFactorization;
import factorization.shared.TileEntityCommon;
import factorization.util.FluidUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntitySolarBoiler
extends TileEntityCommon
implements IReflectionTarget,
IFluidHandler,
IMeterInfo {
    public static Fluid steam;
    public static FluidStack water_stack;
    public static FluidStack steam_stack;
    FluidTank waterTank = new FluidTank(water_stack.copy(), 2000);
    FluidTank steamTank = new FluidTank(steam_stack.copy(), 1000);
    int reflector_count = 0;
    public transient short given_heat = 0;
    public transient short last_synced_heat = 0;
    IFluidHandler above = this;

    public static void setupSteam() {
        if (water_stack == null) {
            water_stack = new FluidStack(FluidRegistry.WATER, 0);
            steam_stack = FluidRegistry.getFluidStack((String)"steam", (int)0);
            steam = steam_stack.getFluid();
        }
    }

    public TileEntitySolarBoiler() {
        this.waterTank.getFluid().amount = 0;
        this.steamTank.getFluid().amount = 0;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SOLARBOILER;
    }

    @Override
    public IIcon getIcon(ForgeDirection dir) {
        switch (dir) {
            case UP: {
                return BlockIcons.boiler_top;
            }
        }
        return BlockIcons.boiler_side;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        this.waterTank = data.as(Share.PRIVATE, "water").putTank(this.waterTank);
        this.steamTank = data.as(Share.PRIVATE, "steam").putTank(this.steamTank);
        if (data.isReader()) {
            this.sanitize();
        }
        this.given_heat = data.as(Share.VISIBLE_TRANSIENT, "givenHeat").putShort(this.given_heat);
    }

    private FluidTank getTank(ForgeDirection from) {
        if (from == ForgeDirection.UP) {
            return this.steamTank;
        }
        return this.waterTank;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource.isFluidEqual(water_stack)) {
            return this.waterTank.fill(resource, doFill);
        }
        if (resource.isFluidEqual(steam_stack)) {
            return this.steamTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.getTank(from).drain(maxDrain, doDrain);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (from == ForgeDirection.UP) {
            return false;
        }
        return fluid == null || fluid == water_stack.getFluid();
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (from != ForgeDirection.UP) {
            return null;
        }
        FluidTank tank = this.getTank(from);
        if (resource == null || tank.getFluid() != resource) {
            return null;
        }
        return tank.drain(tank.getCapacity(), doDrain);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getTank(from).getInfo()};
    }

    @Override
    public void addReflector(int strength) {
        this.reflector_count = Math.max(0, this.reflector_count + strength);
    }

    int getWater() {
        return this.waterTank.getFluid().amount;
    }

    int getSteam() {
        return this.steamTank.getFluid().amount;
    }

    int getHeat() {
        return Math.max(this.reflector_count - 3, 0);
    }

    void sanitize() {
        if (this.waterTank.getFluid() == null) {
            this.waterTank.setFluid(water_stack.copy());
        }
        if (this.steamTank.getFluid() == null) {
            this.steamTank.setFluid(steam_stack.copy());
        }
    }

    IFluidHandler getAbove() {
        if (this.above == this) {
            this.above = this.getCoord().add(0, 1, 0).getTE(IFluidHandler.class);
        }
        return this.above;
    }

    @Override
    public void onNeighborTileChanged(int tilex, int tiley, int tilez) {
        this.above = this;
    }

    public void func_145845_h() {
        IFluidHandler aboveTank;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.sanitize();
        FluidStack water = this.waterTank.getFluid();
        FluidStack steam = this.steamTank.getFluid();
        Coord here = this.getCoord();
        long seed = (long)here.seed() + this.field_145850_b.func_82737_E();
        int measure_time = 5;
        if (seed % (long)measure_time == 0L) {
            short m = (short)(this.given_heat / measure_time);
            this.given_heat = 0;
            if (m != this.last_synced_heat) {
                this.last_synced_heat = m;
                this.broadcastMessage(null, NetworkFactorization.MessageType.BoilerHeat, this.last_synced_heat);
            }
        }
        if ((aboveTank = this.getAbove()) != null) {
            FluidStack sending_steam = steam.copy();
            sending_steam.amount = Math.min(sending_steam.amount, 1000);
            steam.amount -= aboveTank.fill(ForgeDirection.DOWN, steam.copy(), true);
            steam.amount = Math.max(0, steam.amount);
        }
        if (water.amount < 1000) {
            Coord below = here.add(0, -1, 0);
            IFluidHandler tc = below.getTE(IFluidHandler.class);
            boolean water_below = below.is((Block)Blocks.field_150358_i) || below.is(Blocks.field_150355_j);
            if ((water_below &= !here.isPowered()) && FzConfig.boilers_suck_water) {
                if (below.getMd() == 0) {
                    below.setAir();
                    water.amount += 1000;
                    water.amount = Math.min(water.amount, this.waterTank.getCapacity());
                }
            } else if (tc != null) {
                ForgeDirection dir = ForgeDirection.UP;
                if (below.getTE(TileEntitySolarBoiler.class) != null) {
                    dir = ForgeDirection.DOWN;
                }
                int free = Math.max(0, this.waterTank.getCapacity() - water.amount);
                FluidStack avail = tc.drain(dir, free = Math.min(100, free), false);
                if (avail != null && avail.isFluidEqual(water_stack)) {
                    water.amount += tc.drain((ForgeDirection)dir, (int)free, (boolean)true).amount;
                }
            }
            return;
        }
        int time_scale = 1;
        if (this.getHeat() <= 0) {
            return;
        }
        this.applyHeat(this.getHeat() * time_scale);
    }

    public void applyHeat(int heat) {
        int water_to_steam;
        this.given_heat = (short)(this.given_heat + (heat *= 5));
        this.sanitize();
        FluidStack water = this.waterTank.getFluid();
        FluidStack steam = this.steamTank.getFluid();
        if (steam.amount >= this.steamTank.getCapacity()) {
            return;
        }
        int toBoil = Math.min(heat, water.amount);
        toBoil = Math.min(this.steamTank.getCapacity() - steam.amount, toBoil);
        int water_to_remove = Math.max(toBoil / (water_to_steam = 160), 1);
        if (water_to_remove > water.amount) {
            return;
        }
        water.amount -= water_to_remove;
        steam.amount += (int)((double)toBoil * FzConfig.steam_output_adjust);
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        Coord here = this.getCoord();
        FluidUtil.spill(here, this.waterTank.getFluid());
        FluidUtil.spill(here, this.steamTank.getFluid());
    }

    @Override
    public String getInfo() {
        this.sanitize();
        float w = (float)this.waterTank.getFluid().amount / 1000.0f;
        float s = (float)this.steamTank.getFluid().amount / 1000.0f;
        return "Power: " + this.reflector_count + "\nSteam: " + String.format("%.1f", Float.valueOf(s)) + "\nWater: " + String.format("%.1f", Float.valueOf(w));
    }

    @Override
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (messageType == NetworkFactorization.MessageType.BoilerHeat) {
            this.given_heat = this.last_synced_heat = input.readShort();
            return true;
        }
        return super.handleMessageFromServer(messageType, input);
    }

    static {
        water_stack = null;
        steam_stack = null;
    }
}

