/*
 * Decompiled with CFR 0.152.
 */
package factorization.charge;

import factorization.api.Charge;
import factorization.api.IChargeConductor;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.charge.TileEntitySolarBoiler;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockClass;
import factorization.shared.NetworkFactorization;
import factorization.shared.TileEntityCommon;
import factorization.util.NumUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntitySteamTurbine
extends TileEntityCommon
implements IFluidHandler,
IChargeConductor {
    FluidTank steamTank = new FluidTank(TileEntitySolarBoiler.steam_stack.copy(), 16000);
    Charge charge = new Charge(this);
    int fan_speed = 0;
    public int fan_rotation = 0;
    int last_speed = -9999;
    transient double rotation_power_buffer = 0.0;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.STEAMTURBINE;
    }

    @Override
    public IIcon getIcon(ForgeDirection dir) {
        switch (dir) {
            case UP: {
                return BlockIcons.turbine_top;
            }
            case DOWN: {
                return BlockIcons.turbine_bottom;
            }
        }
        return BlockIcons.turbine_side;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        this.charge.serialize("", data);
        this.fan_speed = data.as(Share.VISIBLE, "fan").putInt(this.fan_speed);
        this.steamTank = data.as(Share.PRIVATE, "steam").putTank(this.steamTank);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.steamTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.steamTank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (from == ForgeDirection.UP) {
            return false;
        }
        return fluid == null || fluid.getID() == TileEntitySolarBoiler.steam.getID();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.steamTank.getInfo()};
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        float s = (float)(this.steamTank.getFluid().amount * 16) / (float)this.steamTank.getCapacity();
        return "Steam: " + String.format("%.1f", Float.valueOf(s)) + "\nFan: " + this.fan_speed;
    }

    public void shareFanSpeed() {
        if (this.last_speed == this.fan_speed) {
            return;
        }
        if (NumUtil.significantChange(this.last_speed, this.fan_speed, 0.1f)) {
            this.last_speed = this.fan_speed;
            this.broadcastMessage(null, NetworkFactorization.MessageType.TurbineSpeed, this.fan_speed);
        }
    }

    public void func_145845_h() {
        long seed;
        this.fan_rotation += Math.min(35, this.fan_speed / 5);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.shareFanSpeed();
        this.charge.update();
        if (this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0) {
            this.fan_speed = Math.max(0, this.fan_speed - 1);
            return;
        }
        FluidStack steam = this.steamTank.getFluid();
        if (steam == null) {
            steam = FluidRegistry.getFluidStack((String)"steam", (int)0);
            this.steamTank.setFluid(steam);
        }
        if ((seed = (long)this.getCoord().seed() + this.field_145850_b.func_82737_E()) % 5L == 0L) {
            if (this.fan_speed > steam.amount) {
                this.fan_speed = (int)Math.max((double)this.fan_speed * 0.8 - 1.0, 0.0);
                steam.amount = 0;
            } else {
                int delta = (int)Math.max(0.0, Math.log(steam.amount));
                this.fan_speed += delta;
                steam.amount -= this.fan_speed;
            }
        }
        this.rotation_power_buffer = this.fan_speed;
        if (this.fan_speed <= 0) {
            this.fan_speed = 0;
            return;
        }
        if (3 * this.charge.getValue() > this.fan_speed) {
            return;
        }
        this.charge.setValue(this.fan_speed);
    }

    @Override
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.TurbineSpeed) {
            this.fan_speed = input.readInt();
            return true;
        }
        return false;
    }
}

