/*
 * Decompiled with CFR 0.152.
 */
package factorization.charge;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.charge.WireConnections;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.NetworkFactorization;
import factorization.shared.TileEntityCommon;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWire
extends TileEntityCommon
implements IChargeConductor {
    public byte supporting_side;
    private boolean extended_wire = false;
    Charge charge = new Charge(this);

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.LEADWIRE;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Wire;
    }

    @Override
    public boolean activate(EntityPlayer entityplayer, ForgeDirection side) {
        return false;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        return null;
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        this.supporting_side = data.as(Share.VISIBLE, "side").putByte(this.supporting_side);
        this.charge.serialize("", data);
    }

    boolean find_support() {
        if (!this.extended_wire) {
            return false;
        }
        for (int side = 0; side < 6; side = (int)((byte)(side + 1))) {
            if (!this.canPlaceAgainst(null, this.getCoord().towardSide(side), side)) continue;
            this.supporting_side = (byte)side;
            this.shareInfo();
            return true;
        }
        return false;
    }

    boolean is_directly_supported() {
        Coord supporter = this.getCoord().towardSide(this.supporting_side);
        if (!supporter.blockExists()) {
            return true;
        }
        return supporter.isSolidOnSide(this.supporting_side);
    }

    boolean is_supported() {
        if (this.is_directly_supported()) {
            return true;
        }
        Coord supporter = this.getCoord().towardSide(this.supporting_side);
        TileEntityWire parent = supporter.getTE(TileEntityWire.class);
        if (parent != null) {
            this.extended_wire = true;
            return parent.is_supported();
        }
        return false;
    }

    @Override
    public boolean canPlaceAgainst(EntityPlayer player, Coord supporter, int side) {
        if (supporter.isSolidOnSide(side)) {
            return true;
        }
        TileEntityWire parent = supporter.getTE(TileEntityWire.class);
        if (parent != null && parent.is_directly_supported()) {
            int opposite = ForgeDirection.getOrientation((int)side).getOpposite().ordinal();
            return parent.supporting_side != side && parent.supporting_side != opposite;
        }
        return false;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.charge.update();
    }

    @Override
    public void neighborChanged() {
        if (!this.is_supported()) {
            Core.registry.factory_block.func_149697_b(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, BlockClass.Wire.md, 0);
            Coord here = this.getCoord();
            here.setAir();
            here.rmTE();
        }
    }

    int getComplexity(byte new_side) {
        this.supporting_side = new_side;
        int complexity = new WireConnections(this).getComplexity();
        for (Coord ne : this.getCoord().getNeighborsAdjacent()) {
            TileEntityWire w = ne.getTE(TileEntityWire.class);
            if (w == null) continue;
            complexity += new WireConnections(w).getComplexity();
        }
        TileEntityWire below = this.getCoord().add(ForgeDirection.getOrientation((int)this.supporting_side)).getTE(TileEntityWire.class);
        if (below != null && below.supporting_side == this.supporting_side) {
            complexity += 16;
        }
        return complexity;
    }

    @Override
    public void onPlacedBy(EntityPlayer player, ItemStack is, int side, float hitX, float hitY, float hitZ) {
        side = (new int[]{1, 0, 3, 2, 5, 4})[side];
        if (player.func_70093_af()) {
            this.supporting_side = (byte)side;
            if (this.is_supported()) {
                this.shareInfo();
                return;
            }
        }
        byte best_side = (byte)side;
        int best_complexity = this.getComplexity(best_side) - 1;
        if (!this.is_supported()) {
            best_complexity = 2457;
        }
        for (byte s = 0; s < 6; s = (byte)((byte)(s + 1))) {
            int test;
            if (s == side) continue;
            this.supporting_side = s;
            if (!this.is_supported() || (test = this.getComplexity(s)) >= best_complexity) continue;
            best_complexity = test;
            best_side = s;
        }
        this.supporting_side = best_side;
        this.shareInfo();
    }

    void shareInfo() {
        this.broadcastMessage(null, NetworkFactorization.MessageType.WireFace, this.supporting_side);
    }

    @Override
    public boolean isBlockSolidOnSide(int side) {
        return false;
    }

    @Override
    public MovingObjectPosition collisionRayTrace(Vec3 startVec, Vec3 endVec) {
        return new WireConnections(this).collisionRayTrace(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, startVec, endVec);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return null;
    }

    @Override
    public void setBlockBounds(Block b) {
        new WireConnections(this).setBlockBounds(b);
    }

    @Override
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.WireFace) {
            byte new_side = input.readByte();
            if (new_side != this.supporting_side) {
                this.supporting_side = new_side;
                this.getCoord().redraw();
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ForgeDirection dir) {
        return BlockIcons.wire;
    }
}

