/*
 * Decompiled with CFR 0.152.
 */
package factorization.citizen;

import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.fzds.interfaces.Interpolation;
import factorization.notify.Notice;
import factorization.servo.ItemMatrixProgrammer;
import factorization.shared.Core;
import factorization.shared.EntityFz;
import factorization.shared.EntityReference;
import factorization.util.InvUtil;
import factorization.util.ItemUtil;
import factorization.util.LangUtil;
import factorization.util.SpaceUtil;
import java.io.IOException;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityCitizen
extends EntityFz {
    public ItemStack held = new ItemStack(Blocks.field_150348_b, 0);
    private int ticks = 0;
    boolean spinning = false;
    boolean visible = false;
    boolean player_lost_visibility_state = false;
    public transient int spinning_ticks = 0;
    public transient int appearing_ticks = 0;
    public static final float TICKS_PER_SPIN = 90.0f;
    private static final Quaternion NORMAL = new Quaternion();
    private static final Quaternion POINT1 = Quaternion.fromOrientation(FzOrientation.FACE_UP_POINT_EAST);
    private static final Quaternion POINT2 = Quaternion.fromOrientation(FzOrientation.FACE_NORTH_POINT_DOWN).multiply(Quaternion.getRotationQuaternionRadians(Math.PI * 9, 0.0, 1.0, 0.0));
    private static final Quaternion POINT3 = Quaternion.fromOrientation(FzOrientation.FACE_UP_POINT_SOUTH).multiply(Quaternion.getRotationQuaternionRadians(Math.PI * -9, 0.0, 0.0, -1.0));
    Quaternion rotation_start = NORMAL;
    Quaternion rotation_target = NORMAL;
    final EntityReference<EntityPlayer> playerRef = new EntityReference();
    public static final int WAIT_TIME = 100;
    public static final int SURRENDER_TIME = 40;
    public static final int EXPLODE_TIME = 60;
    private static int script_duration = 0;
    private static final ScriptEvent[] script = new ScriptEvent[]{EntityCitizen.s(140, ScriptKinds.wait), EntityCitizen.s(20, ScriptKinds.potions), EntityCitizen.s(0, ScriptKinds.reveal), EntityCitizen.s(80, ScriptKinds.say, "intruder"), EntityCitizen.s(0, ScriptKinds.spin), EntityCitizen.s(40, ScriptKinds.say, "gotcha"), EntityCitizen.s(45, ScriptKinds.wait), EntityCitizen.s(40, ScriptKinds.say, "young"), EntityCitizen.s(60, ScriptKinds.say, "age"), EntityCitizen.s(80, ScriptKinds.say, "lmp"), EntityCitizen.s(40, ScriptKinds.say, "garbage"), EntityCitizen.s(0, ScriptKinds.unspin), EntityCitizen.s(80, ScriptKinds.say, "cold"), EntityCitizen.s(80, ScriptKinds.say, "lift"), EntityCitizen.s(80, ScriptKinds.say, "mind"), EntityCitizen.s(20, ScriptKinds.wait), EntityCitizen.s(10, ScriptKinds.say, "okay"), EntityCitizen.s(40, ScriptKinds.authenticate), EntityCitizen.s(100, ScriptKinds.say, "authed"), EntityCitizen.s(0, ScriptKinds.give), EntityCitizen.s(80, ScriptKinds.say, "bedrock"), EntityCitizen.s(80, ScriptKinds.say, "power"), EntityCitizen.s(80, ScriptKinds.say, "bye"), EntityCitizen.s(0, ScriptKinds.leave)};
    String current_text = null;
    int text_time = 0;
    int max_text_time = 0;
    int text_msg_index = 0;
    EntityPlayer cinema_player = null;

    public EntityCitizen(World w) {
        super(w);
        this.func_70105_a(1.0f, 1.0f);
        this.playerRef.setWorld(w);
    }

    private static boolean isLmp(ItemStack is) {
        if (is == null) {
            return false;
        }
        return is.func_77973_b() == Core.registry.logicMatrixProgrammer;
    }

    boolean takeLmp(EntityPlayer player) {
        if (EntityCitizen.isLmp(player.func_70694_bm())) {
            this.held = player.func_70694_bm();
            player.func_70062_b(0, null);
            return true;
        }
        InvUtil.FzInv inv = InvUtil.openInventory((Entity)player, true);
        ItemStack gotten = inv.pull(ItemUtil.makeWildcard(Core.registry.logicMatrixProgrammer), 1, false);
        if (gotten == null) {
            return false;
        }
        this.held = gotten;
        return true;
    }

    public static boolean spawnOn(EntityPlayerMP player) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        if (ItemMatrixProgrammer.isUserAuthenticated(player)) {
            return false;
        }
        EntityCitizen citizen = new EntityCitizen(player.field_70170_p);
        new Coord((Entity)player).setAsEntityLocation(citizen);
        if (!citizen.field_70170_p.func_72838_d((Entity)citizen)) {
            return false;
        }
        if (!citizen.takeLmp((EntityPlayer)player)) {
            citizen.func_70106_y();
            return false;
        }
        citizen.func_70078_a((Entity)player);
        citizen.playerRef.trackEntity((EntityPlayer)player);
        return true;
    }

    @Override
    protected void putData(DataHelper data) throws IOException {
        this.held = data.as(Share.VISIBLE, "heldItem").putItemStack(this.held);
        this.ticks = data.as(Share.PRIVATE, "citizenTicks").putInt(this.ticks);
        this.spinning = data.as(Share.VISIBLE, "citizenSpin").putBoolean(this.spinning);
        this.visible = data.as(Share.VISIBLE, "visible").putBoolean(this.visible);
        this.player_lost_visibility_state = data.as(Share.PRIVATE, "playerLostVis").putBoolean(this.player_lost_visibility_state);
        data.as(Share.PRIVATE, "playerRef").putIDS(this.playerRef);
    }

    protected void func_70088_a() {
    }

    private static ScriptEvent s(int duration, ScriptKinds kind, String arg) {
        script_duration += duration;
        return new ScriptEvent(duration, kind, arg);
    }

    private static ScriptEvent s(int duration, ScriptKinds kind) {
        script_duration += duration;
        return new ScriptEvent(duration, kind, "");
    }

    private void doEvent(ScriptEvent se, EntityPlayer player) {
        String arg = se.arg;
        this.current_text = null;
        switch (se.kind) {
            case restart: {
                this.ticks = 0;
                break;
            }
            case wait: {
                break;
            }
            case potions: {
                int potion_duration = script_duration - this.ticks;
                EntityCitizen.pot(player, Potion.field_76440_q, 10, 60);
                EntityCitizen.pot(player, Potion.field_76431_k, 1, 60);
                EntityCitizen.pot(player, Potion.field_76430_j, 2, 60);
                EntityCitizen.pot(player, Potion.field_76428_l, 2, potion_duration);
                EntityCitizen.pot(player, Potion.field_76429_m, 2, potion_duration);
                EntityCitizen.pot(player, Potion.field_76426_n, 1, potion_duration);
                EntityCitizen.pot(player, Potion.field_76427_o, 1, potion_duration);
                if (Core.dev_environ) break;
                EntityCitizen.pot(player, Potion.field_76437_t, 64, potion_duration);
                EntityCitizen.pot(player, Potion.field_76421_d, 64, potion_duration);
                EntityCitizen.pot(player, Potion.field_76419_f, 64, potion_duration);
                break;
            }
            case reveal: {
                this.visible = true;
                this.syncData();
                break;
            }
            case say: {
                this.current_text = LangUtil.translateExact("fz.ent.citizen.say." + arg);
                this.text_time = 0;
                this.max_text_time = se.duration;
                this.text_msg_index = this.ticks;
                break;
            }
            case spin: {
                this.spinning = true;
                this.syncData();
                break;
            }
            case unspin: {
                this.spinning = false;
                this.syncData();
                break;
            }
            case authenticate: {
                if (this.held == null) break;
                Core.registry.logicMatrixProgrammer.setAuthenticated(this.held);
                break;
            }
            case give: {
                ItemStack old = player.func_70694_bm();
                player.func_70062_b(0, this.held);
                this.held = null;
                if (old != null) {
                    InvUtil.FzInv inv = InvUtil.openInventory((Entity)player, true);
                    old = inv.push(old);
                    inv.onInvChanged();
                    if (old != null) {
                        new Coord(this).spawnItem(this.held).func_70100_b_(player);
                    }
                }
                this.syncData();
                break;
            }
            case leave: {
                this.func_70106_y();
            }
        }
    }

    private static void pot(EntityPlayer player, Potion potion, int power, int duration) {
        boolean ambient = potion != Potion.field_76440_q;
        PotionEffect effect = new PotionEffect(potion.func_76396_c(), duration, power, ambient);
        effect.getCurativeItems().clear();
        player.func_70690_d(effect);
    }

    void lockdownClient() {
        if (this.field_70128_L) {
            return;
        }
        EntityPlayer player = (EntityPlayer)this.field_70154_o;
        player.field_70179_y = 0.0;
        player.field_70159_w = 0.0;
        if (player.field_70181_x > 0.0) {
            player.field_70181_x = 0.0;
        }
        player.func_70637_d(false);
        if (player.field_70125_A > -80.0f) {
            int n = 20;
            player.field_70125_A = (player.field_70125_A * (float)n + -90.0f) / (float)(n + 1);
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null && !mc.field_71462_r.func_73868_f()) {
            player.func_71053_j();
        }
        GameSettings settings = mc.field_71474_y;
        settings.field_74326_T = true;
        settings.field_74320_O = 0;
        this.cinema_player = player;
    }

    void decinema() {
        Minecraft mc = Minecraft.func_71410_x();
        GameSettings settings = mc.field_71474_y;
        if (mc.field_71439_g == this.cinema_player) {
            this.cinema_player = null;
            settings.field_74326_T = false;
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70170_p.field_72995_K) {
            this.decinema();
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70170_p.field_72995_K) {
            if (!(this.field_70154_o instanceof EntityPlayer)) {
                return;
            }
            this.lockdownClient();
            int n = this.spinning_ticks++;
            if ((float)n > 90.0f) {
                this.rotation_start = this.rotation_target;
                if (!this.spinning) {
                    this.rotation_target = NORMAL;
                }
                if (this.rotation_target == NORMAL) {
                    this.rotation_target = POINT1;
                } else if (this.rotation_target == POINT1) {
                    this.rotation_target = POINT2;
                } else if (this.rotation_target == POINT2) {
                    this.rotation_target = POINT3;
                } else if (this.rotation_target == POINT3) {
                    this.rotation_target = POINT1;
                }
                this.spinning_ticks = 0;
            }
            return;
        }
        if (!(this.field_70154_o instanceof EntityPlayer)) {
            if (!this.playerRef.trackingEntity()) {
                this.func_70106_y();
                return;
            }
            if (!this.playerRef.entityFound()) {
                EntityPlayer player = this.playerRef.getEntity();
                if (player == null) {
                    if (this.visible) {
                        this.player_lost_visibility_state = true;
                        this.visible = false;
                        this.syncData();
                    }
                    return;
                }
                if (player.field_70170_p != this.field_70170_p || !player.func_70089_S()) {
                    this.func_70106_y();
                    return;
                }
                this.func_70078_a((Entity)player);
                this.visible = this.player_lost_visibility_state;
                this.syncData();
            }
            return;
        }
        EntityPlayer player = (EntityPlayer)this.field_70154_o;
        int acc = 0;
        for (ScriptEvent s : script) {
            if (this.ticks == acc) {
                this.doEvent(s, player);
            }
            acc += s.duration;
        }
        if (this.current_text != null) {
            int clen;
            ++this.text_time;
            float f = (float)this.text_time / (float)this.max_text_time;
            double interp = Interpolation.SMOOTHER.scale(f);
            int boundary = (int)(interp * (double)(clen = this.current_text.length()));
            if (boundary > clen) {
                boundary = clen;
            }
            String head = this.current_text.substring(0, boundary);
            String tail = this.current_text.substring(boundary, clen);
            ChatComponentText headText = new ChatComponentText(head);
            ChatStyle tailFormat = new ChatStyle().func_150237_e(Boolean.valueOf(true)).func_150238_a(EnumChatFormatting.AQUA);
            IChatComponent tailText = new ChatComponentText(tail).func_150255_a(tailFormat);
            IChatComponent toSend = new ChatComponentTranslation("fz.ent.citizen.name", new Object[0]).func_150257_a((IChatComponent)headText).func_150257_a(tailText);
            Notice.chat(player, 90 + this.text_msg_index, toSend);
            if (this.text_time == this.max_text_time) {
                this.current_text = null;
            }
        }
        ++this.ticks;
        if (this.ticks % 5 == 0) {
            this.remove_nearby_hostiles();
        }
        if (this.ticks > acc * 2) {
            this.func_70106_y();
        }
    }

    private void remove_nearby_hostiles() {
        int r = 12;
        AxisAlignedBB range = this.field_70121_D.func_72314_b((double)r, (double)r, (double)r);
        Vec3 me = SpaceUtil.fromEntPos(this);
        for (Entity ent : this.field_70170_p.func_82733_a(Entity.class, range, IMob.field_82192_a)) {
            Vec3 you = SpaceUtil.fromEntPos(ent);
            Vec3 delta = SpaceUtil.subtract(you, me).func_72432_b();
            SpaceUtil.incrScale(delta, (double)(r * 2) + Math.abs(this.field_70146_Z.nextGaussian()));
            Vec3 target = SpaceUtil.add(you, delta);
            EntityCitizen.enderport(ent, target.field_72450_a, target.field_72448_b, target.field_72449_c);
        }
    }

    protected static boolean enderport(Entity ent, double x, double y, double z) {
        int k;
        int j;
        double d3 = ent.field_70165_t;
        double d4 = ent.field_70163_u;
        double d5 = ent.field_70161_v;
        ent.field_70165_t = x;
        ent.field_70163_u = y;
        ent.field_70161_v = z;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)ent.field_70165_t);
        if (ent.field_70170_p.func_72899_e(i, j = MathHelper.func_76128_c((double)ent.field_70163_u), k = MathHelper.func_76128_c((double)ent.field_70161_v))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = ent.field_70170_p.func_147439_a(i, j - 1, k);
                if (block.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                ent.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                ent.func_70107_b(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
                if (ent.field_70170_p.func_72945_a(ent, ent.field_70121_D).isEmpty() && !ent.field_70170_p.func_72953_d(ent.field_70121_D)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            ent.func_70107_b(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        Random rand = ent.field_70170_p.field_73012_v;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (rand.nextFloat() - 0.5f) * 0.2f;
            float f1 = (rand.nextFloat() - 0.5f) * 0.2f;
            float f2 = (rand.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (ent.field_70165_t - d3) * d6 + (rand.nextDouble() - 0.5) * (double)ent.field_70130_N * 2.0;
            double d8 = d4 + (ent.field_70163_u - d4) * d6 + rand.nextDouble() * (double)ent.field_70131_O;
            double d9 = d5 + (ent.field_70161_v - d5) * d6 + (rand.nextDouble() - 0.5) * (double)ent.field_70130_N * 2.0;
            ent.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        ent.field_70170_p.func_72908_a(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
        ent.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    static enum ScriptKinds {
        potions,
        reveal,
        say,
        spin,
        unspin,
        authenticate,
        give,
        leave,
        wait,
        restart;

    }

    private static class ScriptEvent {
        final int duration;
        final ScriptKinds kind;
        final String arg;

        private ScriptEvent(int duration, ScriptKinds kind, String arg) {
            this.duration = duration;
            this.kind = kind;
            this.arg = arg;
        }
    }
}

