/*
 * Decompiled with CFR 0.152.
 */
package factorization.colossi;

import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.colossi.BlockState;
import factorization.colossi.ColossalBuilder;
import factorization.colossi.ColossusController;
import factorization.colossi.ColossusFeature;
import factorization.colossi.LimbInfo;
import factorization.colossi.TileEntityColossalHeart;
import factorization.fzds.DeltaChunk;
import factorization.fzds.interfaces.DeltaCapability;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.notify.Notice;
import factorization.notify.Style;
import factorization.shared.Core;
import factorization.util.FzUtil;
import factorization.util.SpaceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Awakener {
    int arm_size = 0;
    int arm_length = 0;
    int leg_size = 0;
    int leg_length = 0;
    static boolean is_working = false;
    final TileEntityColossalHeart heartTE;
    static Logger log = LogManager.getLogger((String)"Colossus");
    int ground_level = -1;
    BlockState valid_natural_blocks = new BlockState(null, 0){

        @Override
        public boolean matches(Coord at) {
            if (at.y <= Awakener.this.ground_level) {
                return false;
            }
            Block block1 = at.getBlock();
            if (block1 == Core.registry.colossal_block) {
                return false;
            }
            if (block1.func_149688_o() == Material.field_151584_j) {
                return false;
            }
            return !at.isAir() && at.getHardness() >= 0.0f;
        }
    };
    BlockState BODY_ANY = new BlockState(null, 0){

        @Override
        public boolean matches(Coord at) {
            if (at.getBlock() == Core.registry.colossal_block) {
                int md = at.getMd();
                return md == 4 || md == 1 || md == 8;
            }
            return false;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void awaken(Coord src) {
        if (is_working) {
            return;
        }
        try {
            is_working = true;
            if (src.getDimensionID() == DeltaChunk.getDimensionId()) {
                return;
            }
            TileEntityColossalHeart heart = Awakener.findNearestHeart(src);
            if (heart == null) {
                return;
            }
            Awakener.msg("Unknown XR10-class entity detected.", new Object[0]);
            Awakener.msg("Attempting to awaken Colossal Sentinel #" + heart.seed, new Object[0]);
            Coord core = new Coord(heart);
            Awakener awakener = new Awakener(heart);
            boolean success = awakener.abandonedLongAgo_thisAncientGuardianBurnsItsRemainingPower();
            if (!success) {
                Awakener.msg("Body is deformed. Self-destructing.", new Object[0]);
                Awakener.msg("Disconnecting LMP.", new Object[0]);
                ItemStack lmp = new ItemStack((Item)Core.registry.logicMatrixProgrammer);
                core.setAir();
                Awakener.msg("Good-bye, world!", new Object[0]);
                core.w.func_72885_a(null, (double)core.x + 0.5, (double)core.y + 0.5, (double)core.z + 0.5, 0.25f, false, true);
                core.spawnItem(lmp);
                return;
            }
            core.setAir();
            Awakener.msg("Engaging entity.", new Object[0]);
        }
        finally {
            is_working = false;
        }
    }

    Awakener(TileEntityColossalHeart heart) {
        this.heartTE = heart;
    }

    static void msg(String msg, Object ... params) {
        log.info(String.format(msg, params));
    }

    static TileEntityColossalHeart findNearestHeart(Coord src) {
        TileEntityColossalHeart ret = null;
        double ret_dist = 0.0;
        int chunkSearchRadius = 2;
        Coord at = src.copy();
        for (int dxChunk = -chunkSearchRadius; dxChunk <= chunkSearchRadius; ++dxChunk) {
            for (int dzChunk = -chunkSearchRadius; dzChunk <= chunkSearchRadius; ++dzChunk) {
                at.set(src);
                at.adjust(dxChunk * 16, 0, dzChunk * 16);
                Collection tes = at.getChunk().field_150816_i.values();
                for (TileEntity te : tes) {
                    if (!(te instanceof TileEntityColossalHeart)) continue;
                    TileEntityColossalHeart heart = (TileEntityColossalHeart)te;
                    double dist = src.distanceSq(at);
                    if (ret == null) {
                        ret = heart;
                        ret_dist = dist;
                        continue;
                    }
                    if (!(dist < ret_dist)) continue;
                    ret_dist = dist;
                    ret = heart;
                }
            }
        }
        return ret;
    }

    void details(String name, Set<Coord> set) {
        Awakener.msg("    " + name + " made of " + set.size() + " blocks", new Object[0]);
    }

    void limbDetails(String name, ArrayList<Set<Coord>> limbs) {
        int i = 0;
        for (Set<Coord> limb : limbs) {
            this.details(name + i, limb);
            ++i;
        }
    }

    void mark(Set<Coord> set, String msg) {
        for (Coord c : set) {
            new Notice(c, msg, new String[0]).withStyle(Style.FORCE, Style.EXACTPOSITION).sendToAll();
        }
    }

    void markSets(ArrayList<Set<Coord>> sets, String msg) {
        for (Set<Coord> set : sets) {
            this.mark(set, msg);
        }
    }

    public final boolean abandonedLongAgo_thisAncientGuardianBurnsItsRemainingPower() {
        Awakener.msg("Awakening Collossus at %s...", new Coord(this.heartTE));
        HashSet<Coord> heart = new HashSet<Coord>();
        heart.add(new Coord(this.heartTE));
        this.details("heart", heart);
        Set<Coord> body = this.iterateFrom(heart, this.BODY_ANY, false);
        this.details("body", body);
        Set<Coord> mask = this.iterateFrom(body, ColossalBuilder.MASK, true);
        this.details("mask", mask);
        Set<Coord> eyes = this.iterateFrom(mask, ColossalBuilder.EYE, true);
        this.details("eyes", eyes);
        ArrayList<Set<Coord>> arms = this.getConnectedLimbs(body, ColossalBuilder.ARM);
        this.limbDetails("arms", arms);
        ArrayList<Set<Coord>> legs = this.getConnectedLimbs(body, ColossalBuilder.LEG);
        this.limbDetails("legs", legs);
        if (arms.isEmpty() || legs.isEmpty()) {
            return false;
        }
        body.addAll(heart);
        body.addAll(mask);
        body.addAll(eyes);
        eyes = null;
        mask = null;
        heart = null;
        this.details("torso", body);
        if (!this.verifyArmDimensions(arms)) {
            return false;
        }
        if (!this.verifyLegDimensions(legs)) {
            return false;
        }
        Awakener.msg("Limb sizes match", new Object[0]);
        ArrayList<SetAndInfo> limbInfo = new ArrayList<SetAndInfo>();
        for (Set<Coord> set : arms) {
            Vec3 vec3 = this.calculateJointPosition(set, this.arm_size, this.arm_length, ColossusController.LimbType.ARM);
            SetAndInfo sai = new SetAndInfo(set, this.arm_length, this.arm_size, vec3, ColossusController.LimbType.ARM, this.getSide(set));
            limbInfo.add(sai);
        }
        Vec3 leg_sum = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (Set<Coord> set : legs) {
            Vec3 joint = this.calculateJointPosition(set, this.leg_size, this.leg_length, ColossusController.LimbType.LEG);
            SetAndInfo sai = new SetAndInfo(set, this.leg_length, this.leg_size, joint, ColossusController.LimbType.LEG, this.getSide(set));
            limbInfo.add(sai);
            SpaceUtil.incrAdd(leg_sum, joint);
        }
        Vec3 vec3 = leg_sum;
        SpaceUtil.incrScale(vec3, 1.0 / (double)legs.size());
        SetAndInfo setAndInfo = new SetAndInfo(body, this.measure_dim(body, 1), this.leg_size, vec3, ColossusController.LimbType.BODY, ColossusController.BodySide.RIGHT);
        limbInfo.add(setAndInfo);
        ArrayList<Set<Coord>> all_members = new ArrayList<Set<Coord>>();
        all_members.add(body);
        all_members.addAll(arms);
        all_members.addAll(legs);
        boolean first = true;
        Coord min = null;
        Coord max = null;
        Coord work = new Coord(this.heartTE);
        for (Set set : all_members) {
            int l = this.lowest(set);
            if (first) {
                first = false;
                this.ground_level = l;
            } else if (l < this.ground_level) {
                this.ground_level = l;
            }
            for (Coord c : set) {
                if (min == null) {
                    min = c.copy();
                    max = c.copy();
                    continue;
                }
                work.set(c);
                Coord.sort(min, work);
                work.set(c);
                Coord.sort(work, max);
            }
        }
        this.markCoveredBodyBlocks(body);
        int max_iter = this.leg_size + 6;
        int n = 2;
        HashSet<Coord> exclude = this.includeShell(all_members, new HashSet<Coord>(), 2);
        ArrayList<Set<Coord>> justTheBody = new ArrayList<Set<Coord>>();
        justTheBody.add(body);
        this.includeShell(justTheBody, exclude, max_iter - 2);
        Awakener.msg("Attatched adjacent blocks. New body:", new Object[0]);
        this.limbDetails("arm", arms);
        this.limbDetails("leg", legs);
        this.details("torso", body);
        ArrayList<LimbInfo> parts = new ArrayList<LimbInfo>();
        int i = 0;
        IDeltaChunk bodyIdc = null;
        for (SetAndInfo partInfo : limbInfo) {
            String name = (Object)((Object)partInfo.limbType) + " " + (Object)((Object)partInfo.limbSide) + i++;
            IDeltaChunk idc = this.createIDC(partInfo.set, partInfo.rotation, name);
            LimbInfo li = new LimbInfo(partInfo.limbType, partInfo.limbSide, partInfo.length, idc);
            parts.add(li);
            if (li.type != ColossusController.LimbType.BODY) continue;
            li.side = ColossusController.BodySide.CENTER;
            bodyIdc = idc;
        }
        if (bodyIdc == null) {
            throw new NullPointerException();
        }
        for (LimbInfo li : parts) {
            IDeltaChunk idc = li.idc.getEntity();
            if (idc != bodyIdc) {
                idc.setParent(bodyIdc);
            }
            FzUtil.spawn(idc);
        }
        int part_size = parts.size();
        Awakener.msg("Activated with %s parts", part_size);
        LimbInfo[] info = parts.toArray(new LimbInfo[part_size]);
        int body_size = max.z - min.z;
        ColossusController controller = new ColossusController(this.heartTE.func_145831_w(), info, this.arm_size, this.arm_length, this.leg_size, this.leg_length, body_size);
        new Coord(this.heartTE).setAsEntityLocation(controller);
        FzUtil.spawn(controller);
        for (LimbInfo limb : info) {
            Coord at;
            TileEntityColossalHeart beatingHeart;
            if (limb.type != ColossusController.LimbType.BODY || (beatingHeart = Awakener.findNearestHeart(at = limb.idc.getEntity().getCenter())) == null) continue;
            beatingHeart.controllerUuid = controller.func_110124_au();
        }
        this.heartTE.controllerUuid = controller.func_110124_au();
        Awakener.msg("*** WARNING: Energy reserves < 0.1%% ***", new Object[0]);
        return true;
    }

    ColossusController.BodySide getSide(Set<Coord> set) {
        return this.one(set).z > this.heartTE.field_145849_e ? ColossusController.BodySide.RIGHT : ColossusController.BodySide.LEFT;
    }

    Vec3 calculateJointPosition(Set<Coord> limb, int size, int length, ColossusController.LimbType type) {
        ++size;
        Coord corner = null;
        for (Coord c : limb) {
            if (corner == null) {
                corner = c.copy();
                continue;
            }
            if (c.y > corner.y) {
                corner.y = c.y;
            }
            if (c.x < corner.x) {
                corner.x = c.x;
            }
            if (c.z >= corner.z) continue;
            corner.z = c.z;
        }
        if (corner == null) {
            return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        }
        corner = corner.add(ForgeDirection.UP);
        Vec3 ret = corner.createVector();
        ret.field_72450_a += (double)size / 2.0;
        ret.field_72449_c += (double)size / 2.0;
        if (type == ColossusController.LimbType.ARM) {
            ret.field_72448_b -= (double)size / 2.0;
        }
        return ret;
    }

    boolean verifyLegDimensions(ArrayList<Set<Coord>> legs) {
        boolean first = true;
        for (Set<Coord> leg : legs) {
            if (first) {
                this.leg_length = this.measure_dim(leg, 1);
                this.leg_size = this.measure_size(leg);
                first = false;
                continue;
            }
            int new_leg_length = this.measure_dim(leg, 1);
            int new_leg_size = this.measure_size(leg);
            if (this.leg_length == new_leg_length && this.leg_size == new_leg_size) continue;
            Awakener.msg("Mismatched legs!", new Object[0]);
            return false;
        }
        if (this.leg_length == -1 || this.leg_size == -1) {
            Awakener.msg("Invalid legs!", new Object[0]);
            return false;
        }
        return true;
    }

    void markCoveredBodyBlocks(Set<Coord> body) {
        for (Coord c : body) {
            if (c.getBlock() != Core.registry.colossal_block || c.getMd() != 4) continue;
            boolean has_air = false;
            boolean has_arm_or_leg = false;
            for (Coord at : c.getNeighborsAdjacent()) {
                if (at.isAir()) {
                    has_air = true;
                    continue;
                }
                int md = at.getMd();
                if (md != 2 && md != 3 && md != 8) continue;
                has_arm_or_leg = true;
            }
            if (has_air || !has_arm_or_leg) continue;
            c.setMd(8);
        }
    }

    boolean verifyArmDimensions(ArrayList<Set<Coord>> arms) {
        boolean first = true;
        for (Set<Coord> arm : arms) {
            if (first) {
                this.arm_length = this.measure_dim(arm, 1);
                this.arm_size = this.measure_size(arm);
                first = false;
                continue;
            }
            int new_arm_length = this.measure_dim(arm, 1);
            int new_arm_size = this.measure_size(arm);
            if (this.arm_length == new_arm_length && this.arm_size == new_arm_size) continue;
            Awakener.msg("Mismatched arms!", new Object[0]);
            return false;
        }
        if (this.arm_length == -1 || this.arm_size == -1) {
            Awakener.msg("Invalid arms!", new Object[0]);
            return false;
        }
        return true;
    }

    int measure_dim(Set<Coord> set, int axis) {
        Coord min = null;
        Coord max = null;
        for (Coord c : set) {
            if (min == null || max == null) {
                min = c;
                max = c;
                continue;
            }
            if (c.get(axis) < min.get(axis)) {
                min = c;
                continue;
            }
            if (c.get(axis) <= max.get(axis)) continue;
            max = c;
        }
        if (min == null || max == null) {
            return 0;
        }
        return max.get(axis) - min.get(axis);
    }

    int measure_size(Set<Coord> set) {
        int d;
        int w = this.measure_dim(set, 0);
        if (w != (d = this.measure_dim(set, 2))) {
            return 0;
        }
        return w;
    }

    int lowest(Set<Coord> set) {
        Coord min = null;
        for (Coord c : set) {
            if (min == null) {
                min = c;
                continue;
            }
            if (c.y >= min.y) continue;
            min = c;
        }
        if (min == null) {
            return -1;
        }
        return min.y;
    }

    Set<Coord> iterateFrom(Set<Coord> start, BlockState block, boolean diag) {
        ArrayList<Coord> frontier = new ArrayList<Coord>(start.size());
        HashSet<Coord> ret = new HashSet<Coord>();
        frontier.addAll(start);
        for (Coord s : start) {
            if (!block.matches(s)) continue;
            ret.add(s);
        }
        while (!frontier.isEmpty()) {
            Coord at = (Coord)frontier.remove(0);
            ArrayList<Coord> neighbors = diag ? at.getNeighborsDiagonal() : at.getNeighborsAdjacent();
            for (Coord neighbor : neighbors) {
                if (!block.matches(neighbor) || !ret.add(neighbor)) continue;
                frontier.add(neighbor);
            }
        }
        return ret;
    }

    ArrayList<Set<Coord>> getConnectedLimbs(Set<Coord> body, BlockState block) {
        ArrayList<Set<Coord>> ret = new ArrayList<Set<Coord>>();
        for (Coord at : body) {
            for (Coord neighbor : at.getNeighborsAdjacent()) {
                if (body.contains(neighbor) || this.inClasses(ret, neighbor) || !block.matches(neighbor)) continue;
                HashSet<Coord> newSeed = new HashSet<Coord>();
                newSeed.add(neighbor);
                Set<Coord> newTerrain = this.iterateFrom(newSeed, block, false);
                ret.add(newTerrain);
            }
        }
        return ret;
    }

    boolean inClasses(ArrayList<Set<Coord>> lists, Coord at) {
        for (Set<Coord> sc : lists) {
            if (!sc.contains(at)) continue;
            return true;
        }
        return false;
    }

    HashSet<Coord> includeShell(ArrayList<Set<Coord>> sets, HashSet<Coord> exclude, int maxIter) {
        sets = new ArrayList<Set<Coord>>(sets);
        for (Set<Coord> set : sets) {
            exclude.addAll(set);
        }
        boolean found = true;
        ArrayList<Coord> pending = new ArrayList<Coord>();
        while (found && maxIter-- > 0) {
            found = false;
            Iterator<Set<Coord>> iterator = sets.iterator();
            while (iterator.hasNext()) {
                Set<Coord> set = iterator.next();
                for (Coord c : set) {
                    for (Coord neighbor : c.getNeighborsAdjacent()) {
                        if (exclude.contains(neighbor) || !this.valid_natural_blocks.matches(neighbor)) continue;
                        pending.add(neighbor);
                        exclude.add(neighbor);
                    }
                }
                if (pending.isEmpty()) {
                    iterator.remove();
                    continue;
                }
                found = true;
                set.addAll(pending);
                pending.clear();
            }
        }
        return exclude;
    }

    Set<Coord> one(HashMap<Set<Coord>, Set<Coord>> map) {
        Iterator<Set<Coord>> iterator = map.keySet().iterator();
        if (iterator.hasNext()) {
            Set<Coord> ret = iterator.next();
            return ret;
        }
        return null;
    }

    Coord one(Set<Coord> set) {
        Iterator<Coord> iterator = set.iterator();
        if (iterator.hasNext()) {
            Coord ret = iterator.next();
            return ret;
        }
        return null;
    }

    IDeltaChunk createIDC(final Set<Coord> parts, Vec3 rotationCenter, String partName) {
        Coord min = null;
        Coord max = null;
        for (Coord c : parts) {
            if (min == null || max == null) {
                min = c.copy();
                max = c.copy();
                continue;
            }
            min.x = Math.min(min.x, c.x);
            min.y = Math.min(min.y, c.y);
            min.z = Math.min(min.z, c.z);
            max.x = Math.max(max.x, c.x);
            max.y = Math.max(max.y, c.y);
            max.z = Math.max(max.z, c.z);
        }
        if (min == null || max == null) {
            return null;
        }
        Coord.sort(min, max);
        int r = 2;
        min.adjust(new DeltaCoord(-r, -r, -r));
        max.adjust(new DeltaCoord(r, r, r));
        IDeltaChunk ret = DeltaChunk.makeSlice(ColossusFeature.deltachunk_channel, min, max, new DeltaChunk.AreaMap(){

            @Override
            public void fillDse(DeltaChunk.DseDestination destination) {
                for (Coord c : parts) {
                    destination.include(c);
                }
            }
        }, true);
        for (DeltaCapability permit : new DeltaCapability[]{DeltaCapability.INTERACT, DeltaCapability.BLOCK_MINE, DeltaCapability.ROTATE, DeltaCapability.DRAG, DeltaCapability.ENTITY_PHYSICS, DeltaCapability.MOVE, DeltaCapability.PHYSICS_DAMAGE, DeltaCapability.REMOVE_ITEM_ENTITIES, DeltaCapability.REMOVE_ALL_ENTITIES}) {
            ret.permit(permit);
        }
        ret.forbid(DeltaCapability.DIE_WHEN_EMPTY);
        ret.forbid(DeltaCapability.COLLIDE);
        ret.setPartName(partName);
        ret.changeRotationCenter(rotationCenter);
        return ret;
    }

    static class SetAndInfo {
        Set<Coord> set;
        int length;
        int size;
        Vec3 rotation;
        ColossusController.LimbType limbType;
        ColossusController.BodySide limbSide;

        public SetAndInfo(Set<Coord> set, int length, int size, Vec3 rotation, ColossusController.LimbType limbType, ColossusController.BodySide limbSide) {
            this.set = set;
            this.length = length;
            this.size = size;
            this.rotation = rotation;
            this.limbType = limbType;
            this.limbSide = limbSide;
        }
    }
}

