/*
 * Decompiled with CFR 0.152.
 */
package factorization.colossi;

import factorization.coremodhooks.HookTargetsServer;
import factorization.shared.Core;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBlast
extends Block {
    int blast_radius = 1;
    double explosionSize = 8.0;

    public BlockBlast() {
        super(Material.field_151590_u);
        this.func_149663_c("blastBlock");
        this.func_149658_d("factorization:blastBlock");
        this.func_149647_a(Core.tabFactorization);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 1);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        world.func_147464_a(x, y, z, (Block)this, 6 + world.field_73012_v.nextInt(4));
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion explosion) {
        for (int dx = -this.blast_radius; dx <= this.blast_radius; ++dx) {
            for (int dy = -this.blast_radius; dy <= this.blast_radius; ++dy) {
                for (int dz = -this.blast_radius; dz <= this.blast_radius; ++dz) {
                    if (world.func_147439_a(x + dx, y + dy, z + dz) != this) continue;
                    world.func_72921_c(x + dx, y + dy, z + dz, 1, 0);
                    this.func_149695_a(world, x + dx, y + dy, z + dz, this);
                }
            }
        }
    }

    public float getExplosionResistance(Entity explosion, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        world.func_72921_c(x, y, z, 1, 0);
        this.func_149695_a(world, x, y, z, this);
        return super.getExplosionResistance(explosion, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        boolean boom;
        boolean bl = boom = world.func_72805_g(x, y, z) == 1;
        if (!boom) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                int atX = x + dir.offsetX;
                int atY = y + dir.offsetY;
                int atZ = z + dir.offsetZ;
                Block b = world.func_147439_a(atX, atY, atZ);
                Material mat = b.func_149688_o();
                if (mat != Material.field_151587_i && mat != Material.field_151581_o && !b.isBurning((IBlockAccess)world, atX, atY, atZ)) continue;
                boom = true;
                break;
            }
        }
        if (!boom) {
            return;
        }
        this.boom(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        world.func_147468_f(x, y, z);
        this.onBlockExploded(world, x, y, z, null);
    }

    void boom(World world, double explosionX, double explosionY, double explosionZ) {
        world.func_72908_a(explosionX, explosionY, explosionZ, "random.explode", 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        world.func_72869_a("largeexplode", explosionX, explosionY, explosionZ, 1.0, 0.0, 0.0);
        double r = 5.0;
        List list = world.func_72839_b(null, AxisAlignedBB.func_72330_a((double)(explosionX - r), (double)(explosionY - r), (double)(explosionZ - r), (double)(explosionX + r), (double)(explosionY + r), (double)(explosionZ + r)));
        Vec3 vec3 = Vec3.func_72443_a((double)explosionX, (double)explosionY, (double)explosionZ);
        for (Object aList : list) {
            double dz;
            double dy;
            double dx;
            double entDist;
            Entity entity = (Entity)aList;
            double dist = entity.func_70011_f(explosionX, explosionY, explosionZ) / this.explosionSize;
            if (dist > 1.0 || (entDist = (double)MathHelper.func_76133_a((double)((dx = entity.field_70165_t - explosionX) * dx + (dy = entity.field_70163_u + (double)entity.func_70047_e() - explosionY) * dy + (dz = entity.field_70161_v - explosionZ) * dz))) == 0.0) continue;
            dx /= entDist;
            dy /= entDist;
            dz /= entDist;
            double density = world.func_72842_a(vec3, entity.field_70121_D);
            double pain = (1.0 - dist) * density;
            entity.func_70097_a(DamageSource.func_94539_a(null), (float)((int)((pain * pain + pain) / 2.0 * 8.0 * this.explosionSize + 1.0)));
            double blastbackResistance = HookTargetsServer.clipExplosionResistance(entity, pain);
            entity.field_70159_w += dx * blastbackResistance;
            entity.field_70181_x += dy * blastbackResistance;
            entity.field_70179_y += dz * blastbackResistance;
        }
    }
}

