/*
 * Decompiled with CFR 0.152.
 */
package factorization.colossi;

import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.colossi.BlockState;
import factorization.util.NumUtil;
import java.util.Random;

public class Brush {
    BlockState fill;
    BrushMask mask;
    DeltaCoord[] points;
    Random rand;

    public Brush(BlockState fill, BrushMask mask, Random rand) {
        this.fill = fill;
        this.mask = mask;
        this.rand = rand;
        this.points = new DeltaCoord[]{new DeltaCoord(0, 0, 0)};
    }

    public Brush(BlockState fill, BrushMask mask, Random rand, DeltaCoord ... points) {
        this.fill = fill;
        this.mask = mask;
        this.rand = rand;
        this.points = points;
    }

    void paint(Coord target) {
        Coord at = target.copy();
        for (DeltaCoord dc : this.points) {
            target.set(at);
            target.adjust(dc);
            if (!this.mask.applies(at)) continue;
            at.setIdMd(this.fill.block, this.fill.md, true);
        }
    }

    void drag(Coord start, Coord end) {
        double length = Math.sqrt(start.distanceSq(end));
        Coord mid = start.copy();
        int i = 0;
        while ((double)i < length) {
            mid.x = (int)Math.round(NumUtil.interp((double)start.x, (double)start.x, (double)i / length));
            mid.y = (int)Math.round(NumUtil.interp((double)start.y, (double)start.y, (double)i / length));
            mid.z = (int)Math.round(NumUtil.interp((double)start.z, (double)start.z, (double)i / length));
            this.paint(mid);
            ++i;
        }
    }

    public static enum BrushMask {
        ONLY_AIR,
        ONLY_NON_AIR,
        ALL;


        boolean applies(Coord at) {
            switch (this) {
                case ONLY_AIR: {
                    return at.isAir();
                }
                case ONLY_NON_AIR: {
                    return !at.isAir();
                }
            }
            return true;
        }
    }
}

