/*
 * Decompiled with CFR 0.152.
 */
package factorization.colossi;

import factorization.api.Coord;
import factorization.api.ICoordFunction;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.colossi.LimbInfo;
import factorization.colossi.StateMachineExecutor;
import factorization.colossi.Technique;
import factorization.colossi.WalkState;
import factorization.fzds.interfaces.DeltaCapability;
import factorization.fzds.interfaces.IDCController;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.fzds.interfaces.Interpolation;
import factorization.shared.Core;
import factorization.shared.EntityFz;
import factorization.util.LangUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class ColossusController
extends EntityFz
implements IBossDisplayData,
IDCController {
    LimbInfo[] limbs;
    IDeltaChunk body;
    LimbInfo bodyLimbInfo;
    public final StateMachineExecutor walk_controller = new StateMachineExecutor<WalkState>(this, "walk", WalkState.IDLE);
    public final StateMachineExecutor ai_controller = new StateMachineExecutor<Technique>(this, "tech", Technique.STATE_MACHINE_ENTRY);
    boolean setup = false;
    int arm_size = 0;
    int arm_length = 0;
    int leg_size = 0;
    int leg_length = 0;
    int body_width = 0;
    private Coord home = null;
    private boolean been_hurt = false;
    boolean confused = false;
    static String creeper_tag = "fz:colossus_spawned_creeper";
    static Technique[] offensives;
    static Technique[] idlers;
    static Technique[] defensives;
    private Coord path_target = null;
    int turningDirection = 0;
    boolean target_changed = false;
    double walked = 0.0;
    int last_step_direction = -100;
    BodySide spin_direction = BodySide.UNKNOWN_BODY_SIDE;
    transient int last_pos_hash = -1;
    double target_y = Double.NaN;
    int target_count = 0;
    transient Entity target_entity;
    private static final int _destroyed_cracked_block_id = 2;
    private static final int _unbroken_cracked_block_id = 3;
    static int max_names;
    transient int current_name = 0;
    transient int client_ticks = 0;

    public ColossusController(World world) {
        super(world);
        this.field_70158_ak = true;
        this.field_70180_af.func_75682_a(2, (Object)0);
        this.field_70180_af.func_75682_a(3, (Object)0);
    }

    public ColossusController(World world, LimbInfo[] limbInfo, int arm_size, int arm_length, int leg_size, int leg_length, int width) {
        this(world);
        for (LimbInfo li : this.limbs = limbInfo) {
            IDeltaChunk idc = li.idc.getEntity();
            idc.setController(this);
            if (li.type == LimbType.BODY) {
                this.body = idc;
                this.bodyLimbInfo = li;
                continue;
            }
            if (li.type != LimbType.LEG) continue;
            idc.permit(DeltaCapability.VIOLENT_COLLISIONS);
        }
        this.arm_size = arm_size;
        this.arm_length = arm_length;
        this.leg_size = leg_size;
        this.leg_length = leg_length;
        this.body_width = width;
        this.calcLimbParity();
        this.setTotalCracks(this.getNaturalCrackCount() + 1);
    }

    protected void calcLimbParity() {
        int left_leg_parity = 0;
        int left_arm_parity = 0;
        int right_leg_parity = 0;
        int right_arm_parity = 0;
        block4: for (LimbInfo li : this.limbs) {
            int use_parity = 0;
            switch (li.type) {
                default: {
                    continue block4;
                }
                case ARM: {
                    if (li.side == BodySide.RIGHT) {
                        int n = right_arm_parity;
                        right_arm_parity = (byte)(right_arm_parity + 1);
                        use_parity = n;
                        break;
                    }
                    if (li.side != BodySide.LEFT) continue block4;
                    int n = left_arm_parity;
                    left_arm_parity = (byte)(left_arm_parity + 1);
                    use_parity = n;
                    break;
                }
                case LEG: {
                    if (li.side == BodySide.RIGHT) {
                        int n = right_leg_parity;
                        right_leg_parity = (byte)(right_leg_parity + 1);
                        use_parity = n;
                        break;
                    }
                    if (li.side != BodySide.LEFT) continue block4;
                    int n = left_leg_parity;
                    left_leg_parity = (byte)(left_leg_parity + 1);
                    use_parity = n;
                }
            }
            li.parity = (byte)use_parity;
        }
    }

    void loadLimbs() {
        int i = 0;
        for (LimbInfo li : this.limbs) {
            IDeltaChunk idc = li.idc.getEntity();
            if (idc == null) {
                return;
            }
            idc.setController(this);
            if (li.type == LimbType.BODY) {
                this.body = idc;
                this.bodyLimbInfo = li;
            }
            idc.setPartName((Object)((Object)li.side) + " " + (Object)((Object)li.type) + "#" + i++);
        }
        this.setup = true;
    }

    protected void func_70088_a() {
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        int limb_count = data.as(Share.PRIVATE, "limbCount").putInt(this.limbs == null ? 0 : this.limbs.length);
        if (data.isReader()) {
            this.limbs = new LimbInfo[limb_count];
        }
        for (int i = 0; i < this.limbs.length; ++i) {
            if (data.isReader()) {
                this.limbs[i] = new LimbInfo(this.field_70170_p);
            }
            this.limbs[i].putData(data, i);
        }
        this.walk_controller.serialize("walk", data);
        this.ai_controller.serialize("ai", data);
        this.leg_size = data.as(Share.VISIBLE, "legSize").putInt(this.leg_size);
        this.arm_size = data.as(Share.VISIBLE, "armSize").putInt(this.arm_size);
        this.arm_length = data.as(Share.VISIBLE, "armLength").putInt(this.arm_length);
        this.body_width = data.as(Share.VISIBLE, "bodyWidth").putInt(this.body_width);
        if (data.isReader() && data.isNBT() && this.body_width < 1) {
            this.body_width = 5;
        }
        this.home = data.as(Share.PRIVATE, "home").putIDS(this.home);
        if (data.as(Share.PRIVATE, "has_path_target").putBoolean(this.path_target != null)) {
            this.path_target = data.as(Share.PRIVATE, "path_target").putIDS(this.path_target);
        }
        this.setTotalCracks(data.as(Share.VISIBLE, "cracks").putInt(this.getTotalCracks()));
        this.setDestroyedCracks(data.as(Share.VISIBLE, "broken").putInt(this.getDestroyedCracks()));
        this.turningDirection = data.as(Share.PRIVATE, "turningDirection").putInt(this.turningDirection);
        this.target_changed = data.as(Share.PRIVATE, "targetChanged").putBoolean(this.target_changed);
        this.walked = data.as(Share.PRIVATE, "walked").putDouble(this.walked);
        this.target_count = data.as(Share.PRIVATE, "target_count").putInt(this.target_count);
        this.target_y = data.as(Share.PRIVATE, "target_y").putDouble(this.target_y);
        this.last_step_direction = data.as(Share.PRIVATE, "last_step_direction").putInt(this.last_step_direction);
        this.been_hurt = data.as(Share.PRIVATE, "been_hurt").putBoolean(this.been_hurt);
        this.spin_direction = data.as(Share.PRIVATE, "spin_dir").putEnum(this.spin_direction);
        this.confused = data.as(Share.PRIVATE, "confused").putBoolean(this.confused);
    }

    <E extends Enum<E>> EnumSet<E> putEnumSet(DataHelper data, String prefix, EnumSet<E> set, Class<E> elementType) throws IOException {
        if (!data.isNBT()) {
            return set;
        }
        if (data.isWriter()) {
            for (Enum e : set) {
                data.asSameShare(prefix + e.name()).putBoolean(true);
            }
            return set;
        }
        EnumSet<Enum> ret = EnumSet.noneOf(elementType);
        for (Enum e : (Enum[])elementType.getEnumConstants()) {
            if (!data.asSameShare(prefix + e.name()).putBoolean(false)) continue;
            ret.add(e);
        }
        return ret;
    }

    public void func_70030_z() {
        if (this.field_70170_p.field_72995_K) {
            ++this.client_ticks;
            return;
        }
        if (!this.setup) {
            this.loadLimbs();
            if (this.home == null) {
                this.home = new Coord(this);
            }
            if (!this.setup) {
                return;
            }
        }
        if (this.body == null || this.body.field_70128_L) {
            this.func_70106_y();
            return;
        }
        this.walk_controller.tick();
        this.updateBlockClimb();
        this.ai_controller.tick();
        this.func_70107_b(this.body.field_70165_t, this.body.field_70163_u, this.body.field_70161_v);
    }

    public boolean atTarget() {
        if (this.path_target == null) {
            return true;
        }
        double d = 0.1;
        double dx = (double)this.path_target.x - this.body.field_70165_t;
        double dz = (double)this.path_target.z - this.body.field_70161_v;
        return dx < d && dx > -d && dz < d && dz > -d;
    }

    public void setTarget(Coord at) {
        if (at == null && this.path_target == null) {
            return;
        }
        if (at != null && this.path_target != null && at.equals(this.path_target)) {
            return;
        }
        if (at != null) {
            double d = new Coord(this).distance(at);
        }
        this.path_target = at;
        this.target_changed = true;
    }

    public Coord getTarget() {
        return this.path_target;
    }

    boolean targetChanged() {
        boolean ret = this.target_changed;
        this.target_changed = false;
        return ret;
    }

    public void goHome() {
        this.setTarget(this.home.copy());
    }

    public Coord getHome() {
        return this.home;
    }

    public void resetLimbs(int time, Interpolation interp) {
        for (LimbInfo li : this.limbs) {
            if (li.type == LimbType.BODY) continue;
            li.lastTurnDirection = 0;
            IDeltaChunk idc = li.idc.getEntity();
            if (idc == null) continue;
            idc.setRotationalVelocity(new Quaternion());
            li.reset((int)((double)time * this.getSpeedScale()), interp);
        }
    }

    public int getNaturalCrackCount() {
        int ls = this.leg_size + 1;
        int count = ls * ls;
        return count;
    }

    public float func_110138_aP() {
        return this.getTotalCracks() * 3;
    }

    public int getDestroyedCracks() {
        return this.field_70180_af.func_75679_c(2);
    }

    public void setDestroyedCracks(int newCount) {
        this.field_70180_af.func_75692_b(2, (Object)newCount);
    }

    public void setHacked() {
        this.setDestroyedCracks(this.getTotalCracks());
    }

    public int getTotalCracks() {
        return this.field_70180_af.func_75679_c(3);
    }

    public void setTotalCracks(int newCount) {
        this.field_70180_af.func_75692_b(3, (Object)newCount);
    }

    public float func_110143_aJ() {
        float wiggle = 1.0f - 0.1f * ((float)this.current_name / (float)max_names);
        return (float)(this.getTotalCracks() - this.getDestroyedCracks()) * wiggle;
    }

    public void crackBroken() {
        this.setDestroyedCracks(this.getDestroyedCracks() + 1);
        this.been_hurt = true;
    }

    public IChatComponent func_145748_c_() {
        if (this.getDestroyedCracks() == 0) {
            return new ChatComponentTranslation("colossus.name.null", new Object[0]);
        }
        if (max_names == -1) {
            try {
                max_names = Integer.parseInt(LangUtil.translate("colossus.name.count"));
            }
            catch (NumberFormatException e) {
                max_names = 1;
            }
        }
        if (this.func_110143_aJ() <= 0.0f) {
            return new ChatComponentTranslation("colossus.name.true", new Object[0]);
        }
        if (this.client_ticks % 300 < 60 && this.client_ticks % 4 == 0 || this.client_ticks % 50 == 0) {
            this.current_name = this.field_70170_p.field_73012_v.nextInt(max_names);
        }
        return new ChatComponentTranslation("colossus.name." + this.current_name, new Object[0]);
    }

    void updateBlockClimb() {
        int sign;
        if (this.walk_controller.state != WalkState.FORWARD) {
            this.last_pos_hash = -1;
            return;
        }
        if (this.field_70173_aa <= 5) {
            return;
        }
        if (this.func_110143_aJ() <= 0.0f) {
            return;
        }
        int currentPosHash = new Coord(this).hashCode();
        if (currentPosHash != this.last_pos_hash) {
            this.last_pos_hash = currentPosHash;
            int dy = new HeightCalculator().calc();
            double new_target = (int)this.field_70163_u + dy;
            if (new_target != (double)((int)this.target_y)) {
                this.target_y = new_target;
            }
            if (this.last_step_direction != dy) {
                this.last_step_direction = dy;
                if (dy == 0 && this.target_y == this.field_70163_u) {
                    this.body.field_70181_x = 0.0;
                    return;
                }
            }
        }
        double maxV = 0.1875;
        int n = sign = this.field_70163_u > this.target_y ? -1 : 1;
        if (this.field_70163_u == this.target_y) {
            sign = 0;
        }
        double delta = Math.abs(this.field_70163_u - this.target_y);
        this.body.field_70181_x = (double)sign * Math.min(maxV, delta);
    }

    boolean checkHurt(boolean reset) {
        if (this.been_hurt && reset) {
            this.been_hurt = false;
            float pitch = 4.0f * this.func_110143_aJ() / (this.func_110138_aP() + 0.1f);
            this.field_70170_p.func_72956_a((Entity)this, "factorization:colossus.hurt", 1.0f, pitch);
            return true;
        }
        return this.been_hurt;
    }

    boolean canTargetPlayer(Entity player) {
        double max_dist = 576 * this.leg_size;
        double max_home_dist = 1024.0;
        if (this.func_70068_e(player) > max_dist) {
            return false;
        }
        Coord coord = new Coord(player);
        return !((double)this.getHome().distanceSq(coord) > max_home_dist);
    }

    @Override
    public boolean placeBlock(IDeltaChunk idc, EntityPlayer player, Coord at) {
        return false;
    }

    @Override
    public boolean breakBlock(IDeltaChunk idc, EntityPlayer player, Coord at, byte sideHit) {
        if (at.getBlock() != Core.registry.colossal_block) {
            return false;
        }
        int md = at.getMd();
        if (md == 9 || md == 1) {
            this.crackBroken();
        }
        return false;
    }

    @Override
    public boolean hitBlock(IDeltaChunk idc, EntityPlayer player, Coord at, byte sideHit) {
        return false;
    }

    @Override
    public boolean useBlock(IDeltaChunk idc, EntityPlayer player, Coord at, byte sideHit) {
        return false;
    }

    @Override
    public void idcDied(IDeltaChunk idc) {
    }

    @Override
    public void beforeUpdate(IDeltaChunk idc) {
    }

    @Override
    public void afterUpdate(IDeltaChunk idc) {
    }

    public double getStrikeSpeedScale() {
        return 1.0;
    }

    public double getSpeedScale() {
        if (this.peaceful()) {
            return 1.0;
        }
        return 2.0;
    }

    @Override
    public boolean onAttacked(IDeltaChunk idc, DamageSource damageSource, float damage) {
        if (damageSource.func_94541_c()) {
            this.confused = true;
        }
        return false;
    }

    @Override
    public IDCController.CollisionAction collidedWithWorld(World realWorld, AxisAlignedBB realBox, World shadowWorld, AxisAlignedBB shadowBox) {
        return IDCController.CollisionAction.IGNORE;
    }

    public boolean peaceful() {
        return this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL;
    }

    static {
        ArrayList _offensives = new ArrayList();
        ArrayList _idlers = new ArrayList();
        ArrayList<Technique> _defensives = new ArrayList<Technique>();
        block5: for (Technique tech : Technique.values()) {
            ArrayList<Technique> use;
            switch (tech.getKind()) {
                default: {
                    continue block5;
                }
                case DEFENSIVE: {
                    use = _defensives;
                    break;
                }
                case IDLER: {
                    use = _idlers;
                    break;
                }
                case OFFENSIVE: {
                    use = _offensives;
                }
            }
            use.add(tech);
        }
        offensives = _offensives.toArray(new Technique[0]);
        idlers = _idlers.toArray(new Technique[0]);
        defensives = _defensives.toArray(new Technique[0]);
        max_names = -1;
    }

    class HeightCalculator
    implements ICoordFunction {
        int unsupported;
        int supported;
        int inside;

        HeightCalculator() {
        }

        int calc() {
            int leg_height = 0;
            for (LimbInfo limbInfo : ColossusController.this.limbs) {
                if (limbInfo.type != LimbType.LEG) continue;
                leg_height = limbInfo.length + 1;
                break;
            }
            double rage = ColossusController.this.body.field_70163_u - (double)leg_height;
            int y = (int)rage;
            for (LimbInfo li : ColossusController.this.limbs) {
                if (li.type != LimbType.LEG) continue;
                IDeltaChunk idc = li.idc.getEntity();
                Coord at = new Coord(idc);
                at.y = y;
                Coord min = at.copy();
                Coord max = at.copy();
                int half = (ColossusController.this.leg_size + 1) / 2;
                min.x -= half;
                min.z -= half;
                max.x += half;
                max.z += half;
                Coord.iterateCube(min, max, this);
            }
            int n = ColossusController.this.leg_size + 1;
            int leg_area = n * n * 2;
            if ((double)this.unsupported > (double)leg_area * 0.5 && (double)this.supported < (double)leg_area * 0.5) {
                return -1;
            }
            if ((double)this.inside > (double)leg_area * 0.8) {
                return 1;
            }
            return 0;
        }

        @Override
        public void handle(Coord here) {
            if (here.isSolid()) {
                ++this.inside;
            }
            --here.y;
            if (here.isSolid()) {
                ++this.supported;
            } else {
                ++this.unsupported;
            }
        }
    }

    static enum LimbType {
        BODY,
        ARM,
        LEG,
        UNKNOWN_LIMB_TYPE;


        public boolean isArmOrLeg() {
            return this == ARM || this == LEG;
        }
    }

    static enum BodySide {
        LEFT,
        RIGHT,
        CENTER,
        UNKNOWN_BODY_SIDE;

    }
}

