/*
 * Decompiled with CFR 0.152.
 */
package factorization.colossi;

import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.colossi.WorldGenColossus;
import factorization.common.FzConfig;
import factorization.notify.Notice;
import factorization.shared.Core;
import factorization.shared.ItemFactorization;
import factorization.util.PlayerUtil;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemColossusGuide
extends ItemFactorization {
    public ItemColossusGuide(String name, Core.TabType tabType) {
        super(name, tabType);
        Core.loadBus((Object)this);
        this.func_77625_d(1);
        this.func_77656_e(24);
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer player) {
        ArrayList<Coord> nearby;
        if (world.field_72995_K) {
            return is;
        }
        if (player instanceof FakePlayer) {
            return is;
        }
        int msgKey = 888888888;
        if (!WorldGenColossus.genOnWorld(world)) {
            Notice.chat(player, msgKey, (IChatComponent)new ChatComponentTranslation("colossus.is.impossible", new Object[0]));
            return is;
        }
        int range = WorldGenColossus.GENERATION_SPACING * 3 / 2;
        if (MinecraftServer.func_71276_C().func_71233_x() == 1) {
            range = WorldGenColossus.GENERATION_SPACING * 5 / 2;
        }
        Coord playerPos = new Coord((Entity)player);
        try {
            nearby = WorldGenColossus.getCandidatesNear(playerPos, range, true);
        }
        catch (WorldGenColossus.LocationException e) {
            Notice.chat(player, msgKey, (IChatComponent)new ChatComponentTranslation("colossus.is.worldgen_crash", new Object[0]));
            return is;
        }
        if (nearby.isEmpty()) {
            Notice.chat(player, msgKey, (IChatComponent)new ChatComponentTranslation("colossus.is.no_nearby", new Object[0]));
            return is;
        }
        if (PlayerUtil.isPlayerCreative(player) && player.func_70093_af()) {
            int limit = 4;
            for (Coord at : nearby) {
                String t = at.toString();
                t = at.getChunk().field_76646_k + " " + t;
                player.func_146105_b((IChatComponent)new ChatComponentText(t));
                if (limit-- > 0) continue;
                break;
            }
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("colossus.is.creativeFound", new Object[]{nearby.size()}));
        } else {
            IChatComponent msg;
            Coord at = nearby.get(0);
            at.adjust(ForgeDirection.EAST);
            DeltaCoord dc = at.difference(playerPos);
            if (dc.x == 0 && dc.z == 0) {
                String m = dc.y > 0 ? "colossus.is.above" : (dc.y < 0 ? "colossus.is.below" : "colossus.is.mineit");
                msg = new ChatComponentTranslation(m, new Object[0]);
            } else {
                dc.y = 0;
                msg = this.getCompass(dc);
            }
            Notice.chat(player, msgKey, msg);
            if (!FzConfig.infinite_guide_usage) {
                is.func_77972_a(1, (EntityLivingBase)player);
            }
        }
        return is;
    }

    IChatComponent getCompass(DeltaCoord dc) {
        int d = (int)dc.magnitude();
        String pretty = "" + d;
        String unit = ".m";
        if (d > 1000) {
            pretty = String.format("%.1f", Float.valueOf((float)d / 1000.0f));
            unit = ".km";
        }
        return new ChatComponentTranslation(this.getDirection(dc), new Object[]{pretty, new ChatComponentTranslation("colossus.compass.unit" + unit, new Object[0])});
    }

    String getDirection(DeltaCoord dc) {
        double angle = Math.toDegrees(dc.getAngleHorizontal());
        angle = (angle + 360.0) % 360.0;
        angle += 22.5;
        int a = (int)((angle %= 360.0) * 8.0 / 360.0);
        return "colossus.compass." + a;
    }
}

