/*
 * Decompiled with CFR 0.152.
 */
package factorization.colossi;

import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.colossi.ColossusController;
import factorization.fzds.interfaces.DeltaCapability;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.fzds.interfaces.Interpolation;
import factorization.shared.EntityReference;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

class LimbInfo {
    ColossusController.LimbType type = ColossusController.LimbType.UNKNOWN_LIMB_TYPE;
    ColossusController.BodySide side = ColossusController.BodySide.UNKNOWN_BODY_SIDE;
    byte parity = 0;
    int length;
    EntityReference<IDeltaChunk> idc;
    byte lastTurnDirection = 0;
    long next_creak = 0L;
    int creak_delay = 500;

    public LimbInfo(ColossusController.LimbType type, ColossusController.BodySide side, int length, IDeltaChunk ent) {
        this(ent.field_70170_p);
        this.type = type;
        this.side = side;
        this.length = length;
        this.idc.trackEntity(ent);
    }

    public LimbInfo(World world) {
        this.idc = new EntityReference(world);
    }

    void putData(DataHelper data, int index) throws IOException {
        this.type = data.as(Share.VISIBLE, "limbType" + index).putEnum(this.type);
        this.side = data.as(Share.VISIBLE, "limbSide" + index).putEnum(this.side);
        this.parity = data.as(Share.VISIBLE, "limbParity" + index).putByte(this.parity);
        this.length = data.as(Share.VISIBLE, "limbLength" + index).putInt(this.length);
        this.idc = data.as(Share.VISIBLE, "entUuid" + index).putIDS(this.idc);
        this.lastTurnDirection = data.as(Share.VISIBLE, "lastTurnDir" + index).putByte(this.lastTurnDirection);
    }

    boolean limbSwingParity() {
        return this.side == ColossusController.BodySide.RIGHT ^ this.parity % 2 == 0 ^ this.type == ColossusController.LimbType.ARM;
    }

    public void setTargetRotation(Quaternion rot, int time, Interpolation interp) {
        IDeltaChunk dse = this.idc.getEntity();
        if (dse == null) {
            return;
        }
        dse.orderTargetRotation(rot, time, interp);
    }

    public void target(Quaternion rot, double power) {
        this.target(rot, power, Interpolation.SMOOTH);
    }

    public void target(Quaternion rot, double power, Interpolation interp) {
        this.setTargetRotation(rot, (int)(60.0 / power), interp);
    }

    public boolean isTurning() {
        IDeltaChunk dse = this.idc.getEntity();
        if (dse == null) {
            return true;
        }
        return dse.hasOrderedRotation();
    }

    public void reset(int time, Interpolation interp) {
        IDeltaChunk dse = this.idc.getEntity();
        if (dse == null) {
            return;
        }
        Quaternion zero = new Quaternion();
        this.setTargetRotation(zero, time, interp);
    }

    public void causesPain(boolean pain) {
        IDeltaChunk dse = this.idc.getEntity();
        if (dse == null) {
            return;
        }
        if (pain) {
            dse.permit(DeltaCapability.PHYSICS_DAMAGE);
        } else {
            dse.forbid(DeltaCapability.PHYSICS_DAMAGE);
        }
    }

    public String toString() {
        return (Object)((Object)this.type) + " " + (Object)((Object)this.side) + "#" + this.parity;
    }

    public void creak() {
        IDeltaChunk ent = this.idc.getEntity();
        if (ent == null) {
            return;
        }
        long now = ent.field_70170_p.func_82737_E();
        if (now < this.next_creak) {
            return;
        }
        if (ent.field_70170_p.field_73012_v.nextInt(6) != 0) {
            return;
        }
        this.next_creak = now + (long)this.creak_delay;
        float volume = 0.1f + ent.field_70170_p.field_73012_v.nextFloat() * 0.3f;
        float pitch = 0.03125f + 0.0625f * ent.field_70170_p.field_73012_v.nextFloat();
        ent.field_70170_p.func_72956_a((Entity)ent, "factorization:colossus.creak", volume, pitch);
    }
}

