/*
 * Decompiled with CFR 0.152.
 */
package factorization.colossi;

import com.google.common.base.Joiner;
import factorization.colossi.ColossalBuilder;
import factorization.colossi.MaskTemplate;
import factorization.shared.Core;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ReportedException;
import net.minecraftforge.common.util.ForgeDirection;

public class MaskLoader {
    public static ArrayList<MaskTemplate> mask_templates = new ArrayList();
    private static int weight = 100;

    public static void addMask(MaskTemplate mask) {
        mask_templates.add(mask);
    }

    public static MaskTemplate pickMask(Random rand, ForgeDirection anchor_direction, int min_size, int max_size) {
        ArrayList<MaskTemplate> valid = new ArrayList<MaskTemplate>();
        int total_weight = 0;
        for (MaskTemplate mask : mask_templates) {
            if (mask.anchor != anchor_direction || min_size > mask.anchor_points || mask.anchor_points > max_size) continue;
            total_weight += mask.weight;
            valid.add(mask);
        }
        double aim = (double)total_weight * rand.nextDouble();
        int weight = 0;
        for (MaskTemplate mask : valid) {
            if (!(aim < (double)(weight += mask.weight))) continue;
            return mask;
        }
        return null;
    }

    public static void mask(int weight, String ... template) {
        MaskTemplate original = new MaskTemplate(template);
        String[] flipped = new String[template.length];
        boolean any = false;
        for (int i = 0; i < template.length; ++i) {
            String line = template[i];
            String reversed = new StringBuilder(line).reverse().toString();
            flipped[i] = reversed = reversed.replace("<", "L").replace(">", "<").replace("L", ">");
            any |= !reversed.equals(line);
        }
        if (any) {
            MaskTemplate reversedMask = new MaskTemplate(flipped);
            original.weight = weight / 2;
            reversedMask.weight = weight / 2;
            MaskLoader.addMask(original);
            MaskLoader.addMask(reversedMask);
        } else {
            original.weight = weight;
            MaskLoader.addMask(original);
        }
    }

    public static void reloadMasks() {
        mask_templates.clear();
        MaskLoader.loadMasks();
    }

    public static void loadMasks() {
        String resource_name = "/colossus_masks.txt";
        try {
            InputStream is = ColossalBuilder.class.getResourceAsStream(resource_name);
            MaskLoader.readMasks(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load masks", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readMasks(InputStream is) throws IOException {
        if (is == null) {
            throw new NullPointerException();
        }
        try {
            int lineNumber = 0;
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            ArrayList<String> set = new ArrayList<String>();
            while (true) {
                String line = br.readLine();
                ++lineNumber;
                if (line == null) {
                    MaskLoader.emitMask(lineNumber, set);
                    break;
                }
                if ((line = line.replace("\n", "").replace("\r", "")).length() == 0) {
                    MaskLoader.emitMask(lineNumber, set);
                    continue;
                }
                if (line.startsWith("'")) continue;
                if (line.startsWith("weight ")) {
                    weight = Integer.parseInt(line.split(" ")[1]);
                    continue;
                }
                set.add(line);
            }
        }
        finally {
            is.close();
        }
    }

    private static void emitMask(int lineNumber, ArrayList<String> template) {
        if (!template.isEmpty()) {
            String[] mask = template.toArray(new String[template.size()]);
            try {
                MaskLoader.mask(weight, mask);
            }
            catch (Throwable t) {
                if (Core.dev_environ) {
                    Core.logSevere("Near line " + lineNumber, new Object[0]);
                    Core.logSevere("Parsing template: \n" + Joiner.on((String)"\n").join(template), new Object[0]);
                }
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)t, (String)"Loading mask data");
                CrashReportCategory maskInfo = crashreport.func_85058_a("Mask Info");
                maskInfo.func_71507_a("Near line", (Object)lineNumber);
                maskInfo.func_71507_a("Parsing template", (Object)("\n" + Joiner.on((String)"\n").join(template)));
                throw new ReportedException(crashreport);
            }
        }
        weight = 100;
        template.clear();
    }
}

