/*
 * Decompiled with CFR 0.152.
 */
package factorization.colossi;

import factorization.algos.ReservoirSampler;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.ICoordFunction;
import factorization.api.Quaternion;
import factorization.colossi.ColossusController;
import factorization.colossi.IStateMachine;
import factorization.colossi.LimbInfo;
import factorization.colossi.TechniqueKind;
import factorization.colossi.WalkState;
import factorization.fzds.TransferLib;
import factorization.fzds.interfaces.DeltaCapability;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.fzds.interfaces.Interpolation;
import factorization.shared.Core;
import factorization.util.NumUtil;
import factorization.util.SpaceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public enum Technique implements IStateMachine<Technique>
{
    STATE_MACHINE_ENTRY{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (age > 25) {
                return INITIAL_BOW;
            }
            return this;
        }
    }
    ,
    PICK_NEXT_TECHNIQUE{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.IDLER;
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (controller.func_110143_aJ() <= 0.0f) {
                return DEATH_FALL;
            }
            if (age == 0) {
                Vec3 rot = controller.body.getRotation().toRotationVector();
                double err = Math.abs(rot.field_72450_a) + Math.abs(rot.field_72449_c);
                if (err > 1.0E-5) {
                    controller.body.setRotationalVelocity(new Quaternion());
                    Quaternion bodyRot = controller.body.getRotation();
                    double yRot = bodyRot.toRotationVector().field_72448_b;
                    Quaternion straightRot = Quaternion.getRotationQuaternionRadians(yRot, ForgeDirection.UP);
                    if (err > 0.019634954084936207) {
                        controller.bodyLimbInfo.target(straightRot, 1.0 * controller.getSpeedScale());
                    } else {
                        controller.body.setRotation(straightRot);
                    }
                    return FINISH_MOVE;
                }
            }
            if (controller.confused) {
                return CONFUSED;
            }
            boolean use_defense = controller.checkHurt(true);
            if (use_defense && !controller.peaceful()) {
                return SUMMON_RETALIATION;
            }
            List<Technique> avail = Arrays.asList(Technique.values());
            Collections.shuffle(avail);
            Technique chosen_offense = null;
            Technique chosen_defense = null;
            boolean force_idler = this.iteratePotentialPlayers(controller) == null;
            for (Technique tech : avail) {
                TechniqueKind kind = tech.getKind();
                if (use_defense && kind != TechniqueKind.DEFENSIVE) continue;
                switch (kind) {
                    case TRANSITION: {
                        break;
                    }
                    case OFFENSIVE: {
                        chosen_offense = this.grade(chosen_offense, controller, tech);
                        if (chosen_offense == null) break;
                        return chosen_offense;
                    }
                    case DEFENSIVE: 
                    case IDLER: {
                        chosen_defense = this.grade(chosen_defense, controller, tech);
                    }
                }
            }
            if (chosen_defense != null) {
                return chosen_defense;
            }
            return STAND_STILL;
        }

        Technique grade(Technique orig, ColossusController controller, Technique next) {
            if (orig == null && next.usable(controller)) {
                return next;
            }
            return orig;
        }

        @Override
        protected Object visitPlayer(EntityPlayer player, ColossusController controller) {
            return player;
        }
    }
    ,
    STAND_STILL{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.IDLER;
        }

        @Override
        boolean usable(ColossusController controller) {
            return false;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            Quaternion bodyRot = controller.body.getRotation();
            double yRot = bodyRot.toRotationVector().field_72448_b;
            Quaternion straightRot = Quaternion.getRotationQuaternionRadians(yRot, ForgeDirection.UP);
            controller.bodyLimbInfo.target(straightRot, 1.0 * controller.getSpeedScale());
            int time = controller.bodyLimbInfo.idc.getEntity().getRemainingRotationTime();
            for (LimbInfo li : controller.limbs) {
                if (!li.type.isArmOrLeg()) continue;
                Quaternion or = li.idc.getEntity().getRotation();
                li.idc.getEntity().orderTargetRotation(or, time, Interpolation.SMOOTH3);
                li.target(new Quaternion(), 1.0 * controller.getSpeedScale());
            }
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (HIT_WITH_LIMB.usable(controller)) {
                return HIT_WITH_LIMB;
            }
            if (age > 300) {
                return this.finishMove(controller);
            }
            if (controller.checkHurt(false)) {
                return WANDER;
            }
            return this;
        }
    }
    ,
    CONFUSED{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            controller.setTarget(null);
            STAND_STILL.onEnterState(controller, prevState);
            double slight_bend = 0.39269908169872414;
            Random rand = controller.field_70170_p.field_73012_v;
            ForgeDirection dir = rand.nextBoolean() ? ForgeDirection.NORTH : ForgeDirection.SOUTH;
            Quaternion bend = Quaternion.getRotationQuaternionRadians(slight_bend, dir);
            Quaternion rot = controller.body.getRotation().multiply(bend);
            controller.bodyLimbInfo.target(rot, controller.getSpeedScale());
            Quaternion legBack = bend.conjugate();
            legBack = legBack.slerp(legBack.multiply(legBack), 0.5);
            for (LimbInfo limb : controller.limbs) {
                if (limb.type == ColossusController.LimbType.ARM) {
                    this.wiggle(controller, limb, rand);
                }
                if (limb.type != ColossusController.LimbType.LEG) continue;
                limb.target(legBack, controller.getSpeedScale());
            }
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            int end = 500;
            if (age == end || controller.checkHurt(false)) {
                STAND_STILL.onEnterState(controller, this);
                return FINISH_MOVE;
            }
            for (LimbInfo limb : controller.limbs) {
                if (limb.type != ColossusController.LimbType.ARM || limb.isTurning()) continue;
                this.wiggle(controller, limb, controller.field_70170_p.field_73012_v);
            }
            return this;
        }

        @Override
        public void onExitState(ColossusController controller, Technique nextState) {
            controller.confused = false;
        }

        void wiggle(ColossusController controller, LimbInfo arm, Random rand) {
            this.playNoise(controller);
            double MIN_RAISE = 1.5707963267948966;
            double MAX_RAISE = 2.5132741228718345;
            double MIN_CROSS = 0.39269908169872414;
            double MAX_CROSS = 0.7853981633974483;
            double raise = NumUtil.interp(MIN_RAISE, MAX_RAISE, rand.nextDouble());
            double cross = NumUtil.interp(MIN_CROSS, MAX_CROSS, rand.nextDouble());
            double twist = 1.5707963267948966 * rand.nextDouble();
            if (arm.side == ColossusController.BodySide.LEFT) {
                cross = -cross;
            }
            Quaternion rot = Quaternion.getRotationQuaternionRadians(cross, ForgeDirection.UP);
            rot.incrMultiply(Quaternion.getRotationQuaternionRadians(raise, ForgeDirection.SOUTH));
            rot.incrMultiply(Quaternion.getRotationQuaternionRadians(twist, ForgeDirection.UP));
            arm.target(rot, controller.getSpeedScale());
        }
    }
    ,
    SUMMON_RETALIATION{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            STAND_STILL.onEnterState(controller, prevState);
            for (LimbInfo limb : controller.limbs) {
                if (limb.type != ColossusController.LimbType.ARM) continue;
                Quaternion rot = Quaternion.getRotationQuaternionRadians(Math.PI, ForgeDirection.WEST);
                if (limb.side == ColossusController.BodySide.LEFT) {
                    rot.incrConjugate();
                }
                limb.target(rot, controller.getStrikeSpeedScale());
            }
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            return this.finishMove(controller);
        }

        double rng(ColossusController controller) {
            int w = controller.body_width;
            Random rand = controller.field_70170_p.field_73012_v;
            return (rand.nextBoolean() ? -1 : 1) * (w + rand.nextInt(w));
        }

        @Override
        public void onExitState(ColossusController controller, Technique nextState) {
            this.playNoise(controller);
            Random rand = controller.field_70170_p.field_73012_v;
            int mobs = 3 + rand.nextInt(1 + controller.getDestroyedCracks());
            if (mobs > 8) {
                mobs = 8;
            }
            while (mobs-- > 0) {
                EntityCreeper creeper = new EntityCreeper(controller.field_70170_p);
                creeper.func_70690_d(new PotionEffect(Potion.field_76430_j.func_76396_c(), 100, 3, true));
                double ex = controller.field_70165_t + this.rng(controller);
                double ey = controller.field_70163_u + (double)controller.field_70131_O;
                double ez = controller.field_70161_v + this.rng(controller);
                creeper.func_70107_b(ex, ey, ez);
                controller.field_70170_p.func_72838_d((Entity)creeper);
                NBTTagCompound data = creeper.getEntityData();
                data.func_74757_a(ColossusController.creeper_tag, true);
            }
        }
    }
    ,
    FINISH_MOVE{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            return this.finishMove(controller);
        }
    }
    ,
    INITIAL_BOW{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            this.playNoise(controller);
            BOW.onEnterState(controller, this);
            final ReservoirSampler sampler = new ReservoirSampler(1, controller.field_70170_p.field_73012_v);
            Coord.iterateCube(controller.body.getCorner(), controller.body.getFarCorner(), new ICoordFunction(){

                @Override
                public void handle(Coord here) {
                    if (here.getBlock() != Core.registry.colossal_block) {
                        return;
                    }
                    if (here.getMd() != 0) {
                        return;
                    }
                    if (!here.add(ForgeDirection.UP).isAir()) {
                        return;
                    }
                    if (here.add(ForgeDirection.EAST).isAir()) {
                        return;
                    }
                    sampler.give(here.copy());
                }
            });
            Iterator iterator = sampler.iterator();
            if (iterator.hasNext()) {
                Coord found = (Coord)iterator.next();
                if (found.getMd() == 0 && found.getId() == Core.registry.colossal_block) {
                    found.setIdMd(Core.registry.colossal_block, 9, true);
                } else {
                    found.setIdMd(Core.registry.colossal_block, 1, true);
                }
                return;
            }
            controller.crackBroken();
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (controller.checkHurt(false)) {
                return INITIAL_UNBOW;
            }
            return this;
        }

        @Override
        public void onExitState(ColossusController controller, Technique nextState) {
            int count = controller.getNaturalCrackCount();
            final ReservoirSampler sampler = new ReservoirSampler(count, controller.field_70170_p.field_73012_v);
            Coord.iterateCube(controller.body.getCorner(), controller.body.getFarCorner(), new ICoordFunction(){

                @Override
                public void handle(Coord here) {
                    if (this.isExposedSkin(here)) {
                        sampler.give(here.copy());
                    }
                    if (here.getBlock() == Core.registry.colossal_block && here.getMd() == 5) {
                        here.setMd(7, true);
                    }
                }
            });
            for (Coord found : sampler) {
                found.setIdMd(Core.registry.colossal_block, 1, true);
            }
            int newCracks = sampler.size();
            int destroyed = controller.getDestroyedCracks();
            controller.setTotalCracks(newCracks + destroyed);
            controller.confused = false;
        }

        boolean isExposedSkin(Coord cell) {
            if (cell.getBlock() != Core.registry.colossal_block) {
                return false;
            }
            if (cell.getMd() != 4) {
                return false;
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                Coord n = cell.add(dir);
                if (!n.isAir() && !n.isReplacable()) continue;
                return true;
            }
            return false;
        }
    }
    ,
    BOW{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        boolean usable(ColossusController controller) {
            if ((double)controller.field_70170_p.field_73012_v.nextFloat() < 0.5) {
                return false;
            }
            return this.iteratePotentialPlayers(controller) != null;
        }

        @Override
        protected Object visitPlayer(EntityPlayer player, ColossusController controller) {
            if (player.field_70163_u < controller.field_70163_u) {
                return null;
            }
            double height = controller.bodyLimbInfo.length;
            if (player.field_70163_u > controller.field_70163_u + height + 5.0) {
                return null;
            }
            Coord top = controller.body.getFarCorner().copy();
            controller.body.shadow2real(top);
            if (player.field_70163_u > (double)top.y) {
                return null;
            }
            double radius = this.getTotalSize(controller) + 2.0;
            if (controller.func_70068_e((Entity)player) > radius * radius) {
                return null;
            }
            return player;
        }

        double getTotalSize(ColossusController controller) {
            int bodWidth = this.measureWidth(controller.body);
            int armWidth = this.measureWidth(controller.body);
            return (double)(bodWidth + armWidth) / 2.0;
        }

        int measureWidth(IDeltaChunk bod) {
            return bod.getFarCorner().difference((Coord)bod.getCorner()).z;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            if (prevState != INITIAL_BOW) {
                this.playNoise(controller);
            }
            double bowAngle = Math.toRadians(70.0);
            Quaternion bow = Quaternion.getRotationQuaternionRadians(bowAngle, ForgeDirection.NORTH);
            Quaternion bodyBend = controller.body.getRotation().multiply(bow);
            controller.bodyLimbInfo.target(bodyBend, 0.4, bendInterp);
            int bodyBendTime = controller.body.hasOrderedRotation() ? controller.body.getRemainingRotationTime() : 60;
            Quaternion bodyBack = bodyBend.conjugate();
            Quaternion legBend = bodyBack.slerp(bodyBack.multiply(bodyBack), 0.5);
            for (LimbInfo limb : controller.limbs) {
                IDeltaChunk idc = limb.idc.getEntity();
                if (idc == null) continue;
                if (limb.type == ColossusController.LimbType.LEG) {
                    idc.orderTargetRotation(legBend, bodyBendTime, bendInterp);
                    continue;
                }
                if (limb.type != ColossusController.LimbType.ARM) continue;
                double armFlap = Math.toRadians(limb.side == ColossusController.BodySide.RIGHT ? -25.0 : 25.0);
                double armHang = Math.toRadians(-135.0);
                Quaternion flap = Quaternion.getRotationQuaternionRadians(armFlap, ForgeDirection.EAST);
                Quaternion hang = Quaternion.getRotationQuaternionRadians(armHang, ForgeDirection.NORTH);
                idc.orderTargetRotation(flap.multiply(hang).multiply(bow), bodyBendTime, Interpolation.SMOOTH);
            }
            controller.setTarget(null);
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (controller.checkHurt(false)) {
                return UNBOW;
            }
            if (age > 300) {
                return UNBOW;
            }
            return this;
        }
    }
    ,
    INITIAL_UNBOW{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            this.playNoise(controller);
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (age > 100) {
                return INITIAL_UNBOW2;
            }
            return this;
        }
    }
    ,
    INITIAL_UNBOW2{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            UNBOW.onEnterState(controller, this);
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            return UNBOW.tick(controller, age);
        }

        @Override
        public void onExitState(ColossusController controller, Technique nextState) {
            UNBOW.onExitState(controller, nextState);
        }
    }
    ,
    UNBOW{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            double yRot;
            Quaternion straightRot;
            Quaternion bodyRot;
            if (prevState != INITIAL_UNBOW) {
                this.playNoise(controller);
            }
            if ((bodyRot = controller.body.getRotation()).dotProduct(straightRot = Quaternion.getRotationQuaternionRadians(-(yRot = bodyRot.toRotationVector().field_72448_b), ForgeDirection.UP)) < 0.0) {
                straightRot.incrConjugate();
            }
            controller.bodyLimbInfo.target(straightRot, 1.0 * controller.getSpeedScale());
            Quaternion straightenIsh = new Quaternion().slerp(bodyRot, 0.5);
            int time = controller.bodyLimbInfo.idc.getEntity().getRemainingRotationTime();
            for (LimbInfo li : controller.limbs) {
                if (!li.type.isArmOrLeg()) continue;
                li.idc.getEntity().orderTargetRotation(straightenIsh, time, Interpolation.SMOOTH);
            }
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            return this.finishMove(controller);
        }
    }
    ,
    CHASE_PLAYER{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.OFFENSIVE;
        }

        @Override
        boolean usable(ColossusController controller) {
            return this.iteratePotentialPlayers(controller) != null;
        }

        @Override
        protected Object visitPlayer(EntityPlayer player, ColossusController controller) {
            if (!player.field_70122_E) {
                return CONTINUE;
            }
            double dx = controller.field_70165_t - player.field_70165_t;
            double dz = controller.field_70161_v - player.field_70161_v;
            double d = Math.sqrt(dx * dx + dz * dz);
            if (d < (double)(controller.leg_size + 2)) {
                return CONTINUE;
            }
            return player;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            EntityPlayer player = (EntityPlayer)this.iteratePotentialPlayers(controller);
            if (player == null) {
                return;
            }
            controller.setTarget(new Coord((Entity)player));
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (controller.atTarget() || controller.confused) {
                return PICK_NEXT_TECHNIQUE;
            }
            return this;
        }
    }
    ,
    SIT_DOWN{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.IDLER;
        }

        @Override
        boolean usable(ColossusController controller) {
            return this.iteratePotentialPlayers(controller) == null;
        }

        @Override
        protected Object visitPlayer(EntityPlayer player, ColossusController controller) {
            return player;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            double v = (double)controller.leg_length / 60.0;
            controller.body.func_70016_h(0.0, -v * controller.getSpeedScale(), 0.0);
            Quaternion legBend = Quaternion.getRotationQuaternionRadians(1.5707963267948966, ForgeDirection.SOUTH);
            for (LimbInfo limb : controller.limbs) {
                if (limb.type != ColossusController.LimbType.LEG) continue;
                limb.setTargetRotation(legBend, (int)(60.0 * controller.getSpeedScale()), Interpolation.SMOOTH);
            }
        }

        @Override
        public void onExitState(ColossusController controller, Technique nextState) {
            controller.body.func_70016_h(0.0, 0.0, 0.0);
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (age >= 60) {
                return SIT_WAIT;
            }
            return this;
        }
    }
    ,
    SIT_WAIT{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (age % 60 == 0 && this.iteratePotentialPlayers(controller) != null) {
                return STAND_UP;
            }
            if (controller.checkHurt(false)) {
                return STAND_UP;
            }
            return this;
        }

        @Override
        protected Object visitPlayer(EntityPlayer player, ColossusController controller) {
            return player;
        }
    }
    ,
    STAND_UP{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            double v = (double)controller.leg_length / 60.0;
            controller.body.func_70016_h(0.0, v * controller.getSpeedScale(), 0.0);
            for (LimbInfo limb : controller.limbs) {
                if (!limb.type.isArmOrLeg()) continue;
                limb.setTargetRotation(new Quaternion(), (int)(60.0 * controller.getSpeedScale()), Interpolation.SMOOTH);
            }
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (age >= 60) {
                return PICK_NEXT_TECHNIQUE;
            }
            return this;
        }

        @Override
        public void onExitState(ColossusController controller, Technique nextState) {
            controller.body.func_70016_h(0.0, 0.0, 0.0);
        }
    }
    ,
    HIT_WITH_LIMB{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.OFFENSIVE;
        }

        @Override
        boolean usable(ColossusController controller) {
            return this.findSmashable(controller) != null;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            TargetSmash smash = this.findSmashable(controller);
            if (smash == null) {
                return;
            }
            smash.limb.causesPain(true);
            smash.limb.target(smash.rotation, 8.0 * controller.getStrikeSpeedScale(), Interpolation.CUBIC);
            this.playNoise(controller);
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            return this.finishMove(controller, FINISH_HIT);
        }

        TargetSmash findSmashable(ColossusController controller) {
            return (TargetSmash)this.iteratePotentialPlayers(controller);
        }

        @Override
        protected Object visitPlayer(EntityPlayer player, ColossusController controller) {
            DeltaCoord bodySize = controller.body.getFarCorner().difference(controller.body.getCorner());
            double halfBodyWidth = bodySize.x / 2;
            for (LimbInfo li : controller.limbs) {
                IDeltaChunk idc;
                if (li.type != ColossusController.LimbType.ARM && li.type != ColossusController.LimbType.LEG || controller.walk_controller.state != WalkState.IDLE && li.type == ColossusController.LimbType.LEG || (idc = li.idc.getEntity()) == null || idc.hasOrderedRotation() || li.type == ColossusController.LimbType.LEG && player.field_70163_u > idc.field_70163_u) continue;
                double farthest = li.length + 2;
                double nearest = li.length - 2;
                double dist = idc.func_70032_d((Entity)player);
                if (dist > farthest || dist < nearest) continue;
                Vec3 li2player = SpaceUtil.subtract(SpaceUtil.fromEntPos((Entity)player), SpaceUtil.fromEntPos(idc));
                Vec3 localOffset = SpaceUtil.copy(li2player);
                controller.body.getRotation().applyReverseRotation(localOffset);
                if ((li.side != ColossusController.BodySide.LEFT ? localOffset.field_72449_c < -halfBodyWidth : localOffset.field_72449_c > halfBodyWidth) || localOffset.field_72450_a < 0.0) continue;
                Vec3 src = Vec3.func_72443_a((double)0.0, (double)-1.0, (double)0.0);
                Vec3 dst = li2player.func_72432_b();
                Vec3 axis = src.func_72431_c(dst);
                double angle = SpaceUtil.getAngle(src, dst);
                controller.body.getRotation().applyReverseRotation(axis);
                Quaternion hitQuat = Quaternion.getRotationQuaternionRadians(angle *= 1.5, axis);
                TargetSmash smash = new TargetSmash();
                smash.limb = li;
                smash.rotation = hitQuat;
                return smash;
            }
            return CONTINUE;
        }

        class TargetSmash {
            LimbInfo limb;
            Quaternion rotation;

            TargetSmash() {
            }
        }
    }
    ,
    FINISH_HIT{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            Quaternion bodyRotation = controller.body.getRotation();
            for (LimbInfo li : controller.limbs) {
                if (!li.type.isArmOrLeg()) continue;
                li.causesPain(false);
                double error = li.idc.getEntity().getRotation().getAngleBetween(bodyRotation);
                if (error < 0.001) continue;
                li.target(new Quaternion(), 1.0 * controller.getSpeedScale(), Interpolation.SMOOTH);
            }
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            return this.finishMove(controller);
        }
    }
    ,
    WANDER{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.IDLER;
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (controller.atTarget() || controller.confused) {
                return PICK_NEXT_TECHNIQUE;
            }
            return this;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            double range = 32.0;
            Coord target = controller.getHome().copy();
            double dx = this.rng(controller) * range;
            double dz = this.rng(controller) * range;
            target = target.add((int)dx, 0, (int)dz);
            controller.setTarget(target);
        }

        double rng(ColossusController controller) {
            return controller.field_70170_p.field_73012_v.nextDouble() * 2.0 - 1.0;
        }
    }
    ,
    DEATH_FALL{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        boolean usable(ColossusController controller) {
            return controller.func_110143_aJ() <= 0.0f;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            this.playNoise(controller);
            for (LimbInfo li : controller.limbs) {
                IDeltaChunk idc = li.idc.getEntity();
                idc.func_70016_h(0.0, 0.0, 0.0);
                idc.setRotationalVelocity(new Quaternion());
                idc.permit(DeltaCapability.VIOLENT_COLLISIONS);
            }
            Quaternion fallAxis = Quaternion.getRotationQuaternionRadians(1.5707963267948966, ForgeDirection.SOUTH);
            Quaternion rotation = controller.body.getRotation();
            fallAxis = rotation.multiply(fallAxis);
            controller.body.orderTargetRotation(fallAxis, 50, Interpolation.SQUARE);
            controller.setTarget(null);
            this.removeMyCreepers(controller);
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            return controller.body.hasOrderedRotation() ? this : DEATH_EXPLODE;
        }

        @Override
        public void onExitState(ColossusController controller, Technique nextState) {
            for (LimbInfo li : controller.limbs) {
                IDeltaChunk idc = li.idc.getEntity();
                idc.func_70016_h(0.0, 0.0, 0.0);
                idc.setRotationalVelocity(new Quaternion());
            }
        }
    }
    ,
    DEATH_EXPLODE{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (age % 15 != 0) {
                return this;
            }
            boolean any = false;
            double n = 1.0 + (double)controller.leg_size / 2.0 * (double)age * (double)age / 500.0;
            for (LimbInfo li : controller.limbs) {
                final ReservoirSampler sampler = new ReservoirSampler((int)n, null);
                IDeltaChunk idc = li.idc.getEntity();
                Coord.iterateCube(idc.getCorner(), idc.getFarCorner(), new ICoordFunction(){

                    @Override
                    public void handle(Coord here) {
                        if (here.isAir()) {
                            return;
                        }
                        if (here.getBlock() == Core.registry.colossal_block) {
                            int md = here.getMd();
                            if (md == 0) {
                                return;
                            }
                            if (md == 6) {
                                return;
                            }
                        }
                        sampler.give(here.copy());
                    }
                });
                for (Coord c : sampler) {
                    this.dislodge(idc, c);
                    any = true;
                }
            }
            if (any) {
                for (LimbInfo li : controller.limbs) {
                    IDeltaChunk idc = li.idc.getEntity();
                    idc.field_70179_y = 0.0;
                    idc.field_70181_x = 0.0;
                    idc.field_70159_w = 0.0;
                }
            }
            return any ? this : DEATH_EXPIRE;
        }

        void dislodge(IDeltaChunk idc, Coord src) {
            Coord dest = src.copy();
            idc.shadow2real(dest);
            Block b = src.getBlock();
            int md = src.getMd();
            float explosionPower = 2.0f;
            float explodeChance = 0.125f;
            if (b == Core.registry.colossal_block && md == 5) {
                explodeChance = 1.0f;
                explodeChance = 4.0f;
            }
            if (src.w.field_73012_v.nextFloat() < explodeChance) {
                dest.w.func_72876_a(null, (double)dest.x + 0.5, (double)dest.y + 0.5, (double)dest.z + 0.5, explosionPower, false);
            }
            if (!dest.isReplacable() || src.getTE() != null) {
                src.breakBlock();
                src.setAir();
                return;
            }
            if (b == Core.registry.colossal_block || src.getHardness() <= 0.0f) {
                src.setAir();
                return;
            }
            TransferLib.move(src, dest, true, true);
            EntityFallingBlock sand = new EntityFallingBlock(dest.w, (double)dest.x, (double)dest.y, (double)dest.z, dest.getId(), dest.getMd());
            sand.field_145812_b = 1;
            dest.setAir();
            double gs = 0.05;
            sand.field_70159_w = 0.0;
            sand.field_70179_y = 0.0;
            sand.field_70181_x = Math.abs(dest.w.field_73012_v.nextGaussian() * gs);
            sand.field_70170_p.func_72838_d((Entity)sand);
        }
    }
    ,
    DEATH_EXPIRE{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            return this;
        }

        @Override
        public void onEnterState(final ColossusController controller, Technique prevState) {
            final ArrayList lmps = new ArrayList();
            for (LimbInfo limbInfo : controller.limbs) {
                final IDeltaChunk idc = limbInfo.idc.getEntity();
                Coord min = idc.getCorner();
                Coord max = idc.getFarCorner();
                Coord.iterateCube(min, max, new ICoordFunction(){

                    @Override
                    public void handle(Coord here) {
                        if (here.getBlock() != Core.registry.colossal_block) {
                            return;
                        }
                        int md = here.getMd();
                        switch (md) {
                            default: {
                                return;
                            }
                            case 1: 
                            case 5: 
                            case 6: {
                                here.setAir();
                                Vec3 core = idc.shadow2real(here.createVector().func_72441_c(0.5, 0.5, 0.5));
                                controller.field_70170_p.func_72885_a(null, core.field_72450_a, core.field_72448_b, core.field_72449_c, 0.25f, false, true);
                                if (md != 6) break;
                                ItemStack lmp = new ItemStack((Item)Core.registry.logicMatrixProgrammer);
                                EntityItem ei = new EntityItem(controller.field_70170_p, core.field_72450_a, core.field_72448_b, core.field_72449_c, lmp);
                                ei.field_83001_bt = true;
                                ei.field_70181_x = 1.0;
                                lmps.add(ei);
                                EntityFireworkRocket flare = new EntityFireworkRocket(controller.field_70170_p, core.field_72450_a, core.field_72448_b, core.field_72449_c, null);
                                lmps.add(flare);
                                break;
                            }
                            case 0: {
                                here.setAir();
                                Coord real = here.copy();
                                idc.shadow2real(real);
                                if (!real.isReplacable()) break;
                                EntityFallingBlock mask = new EntityFallingBlock(real.w, (double)real.x, (double)real.y, (double)real.z, Core.registry.colossal_block, 0);
                                mask.field_145812_b = 1;
                                lmps.add(mask);
                            }
                        }
                    }
                });
            }
            for (Entity l : lmps) {
                l.field_70170_p.func_72838_d(l);
            }
            for (LimbInfo limbInfo : controller.limbs) {
                limbInfo.idc.getEntity().func_70106_y();
            }
            controller.func_70106_y();
        }
    }
    ,
    HACKED{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            controller.walk_controller.forceState(WalkState.IDLE);
            controller.crackBroken();
            Coord.iterateCube(controller.body.getCorner(), controller.body.getFarCorner(), new ICoordFunction(){

                @Override
                public void handle(Coord here) {
                    if (here.getBlock() == Core.registry.colossal_block && here.getMd() == 5) {
                        here.setMd(7, true);
                    }
                }
            });
            int target_time = 40;
            for (LimbInfo limb : controller.limbs) {
                int angleDeg;
                IDeltaChunk idc = limb.idc.getEntity();
                if (idc == null) continue;
                idc.cancelOrderedRotation();
                idc.setRotationalVelocity(new Quaternion());
                if (limb.type == ColossusController.LimbType.BODY) {
                    double yRot;
                    Quaternion straightRot;
                    Quaternion bodyRot = controller.body.getRotation();
                    if (bodyRot.dotProduct(straightRot = Quaternion.getRotationQuaternionRadians(-(yRot = bodyRot.toRotationVector().field_72448_b), ForgeDirection.UP)) < 0.0) {
                        straightRot.incrConjugate();
                    }
                    idc.orderTargetRotation(straightRot, target_time, Interpolation.SMOOTH);
                    continue;
                }
                int n = angleDeg = limb.type == ColossusController.LimbType.ARM ? 135 : 45;
                if (limb.side == ColossusController.BodySide.RIGHT) {
                    angleDeg = -angleDeg;
                }
                Quaternion target = Quaternion.getRotationQuaternionRadians(Math.toRadians(angleDeg), ForgeDirection.EAST);
                idc.orderTargetRotation(target, target_time, Interpolation.INV_CUBIC);
            }
            this.playNoise(controller);
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            return this.finishMove(controller, HACKED_EXPIRE);
        }
    }
    ,
    HACKED_EXPIRE{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            if (age >= 60) {
                Coord min = null;
                Coord max = null;
                for (LimbInfo limb : controller.limbs) {
                    IDeltaChunk idc = limb.idc.getEntity();
                    if (idc == null) continue;
                    Coord corner = idc.shadow2realCoord(idc.getCorner());
                    Coord farCorner = idc.shadow2realCoord(idc.getFarCorner());
                    Coord.sort(corner, farCorner);
                    if (min == null) {
                        min = corner;
                        max = farCorner;
                        continue;
                    }
                    Coord.sort(min, corner);
                    Coord.sort(farCorner, max);
                }
                final WorldServer world = (WorldServer)min.w;
                Coord.iterateCube(min, max, new ICoordFunction(){

                    @Override
                    public void handle(Coord here) {
                        if (world.field_73012_v.nextInt(5) > 0) {
                            return;
                        }
                        world.func_147487_a("portal", (double)here.x, (double)here.y, (double)here.z, 1, 0.0, 4.0, 0.0, 1.0);
                    }
                });
                return DEAD;
            }
            if (age % 24 == 0) {
                final ReservoirSampler eyes = new ReservoirSampler(1, controller.field_70170_p.field_73012_v);
                Coord.iterateCube(controller.body.getCorner(), controller.body.getFarCorner(), new ICoordFunction(){

                    @Override
                    public void handle(Coord here) {
                        if (here.getBlock() != Core.registry.colossal_block) {
                            return;
                        }
                        int md = here.getMd();
                        if (md == 5 || md == 7) {
                            eyes.give(here.copy());
                        }
                    }
                });
                for (Coord eye : eyes.getSamples()) {
                    eye.setAir();
                    eye.w.func_72876_a(null, (double)eye.x + 0.5, (double)eye.y + 0.5, (double)eye.z + 0.5, 2.0f, false);
                }
            }
            return super.tick(controller, age);
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            super.onEnterState(controller, prevState);
            this.removeMyCreepers(controller);
        }
    }
    ,
    DEAD{

        @Override
        TechniqueKind getKind() {
            return TechniqueKind.TRANSITION;
        }

        @Override
        public void onEnterState(ColossusController controller, Technique prevState) {
            ICoordFunction clear = new ICoordFunction(){

                @Override
                public void handle(Coord here) {
                    here.setAir();
                }
            };
            for (LimbInfo limb : controller.limbs) {
                IDeltaChunk idc = limb.idc.getEntity();
                if (idc == null) continue;
                Coord.iterateChunks(idc.getCorner(), idc.getFarCorner(), clear);
            }
        }

        @Override
        public Technique tick(ColossusController controller, int age) {
            for (LimbInfo limb : controller.limbs) {
                IDeltaChunk idc = limb.idc.getEntity();
                if (idc == null) continue;
                idc.func_70106_y();
            }
            controller.func_70106_y();
            return DEAD;
        }
    };

    static final double bow_power = 0.4;
    static final Interpolation bendInterp;
    private static final double distSq = 1600.0;
    protected static final Object CONTINUE;
    static final int SIT_FALL_TIME = 60;

    abstract TechniqueKind getKind();

    boolean usable(ColossusController controller) {
        return true;
    }

    @Override
    public Technique tick(ColossusController controller, int age) {
        return this;
    }

    @Override
    public void onEnterState(ColossusController controller, Technique prevState) {
    }

    @Override
    public void onExitState(ColossusController controller, Technique nextState) {
    }

    protected Technique finishMove(ColossusController controller, Technique next) {
        for (LimbInfo li : controller.limbs) {
            if (!li.isTurning()) continue;
            return this;
        }
        return next;
    }

    protected Technique finishMove(ColossusController controller) {
        return this.finishMove(controller, PICK_NEXT_TECHNIQUE);
    }

    protected void targetLimb(ColossusController controller, LimbInfo li, ColossusController.BodySide turnDirection) {
        if (li.type != ColossusController.LimbType.ARM) {
            return;
        }
        double d = turnDirection == ColossusController.BodySide.RIGHT ? -1.0 : 1.0;
        Quaternion rot = Quaternion.getRotationQuaternionRadians(1.5707963267948966, ForgeDirection.SOUTH);
        double turn = li.side == turnDirection ? 90.0 : 45.0;
        turn = Math.toRadians(turn) * d;
        rot = Quaternion.getRotationQuaternionRadians(turn, ForgeDirection.UP).multiply(rot);
        li.target(rot, 1.0 * controller.getSpeedScale(), Interpolation.SMOOTH);
    }

    protected <E> E iteratePotentialPlayers(ColossusController controller) {
        ArrayList allPlayers = new ArrayList(controller.field_70170_p.field_73010_i);
        Collections.shuffle(allPlayers, controller.field_70170_p.field_73012_v);
        for (EntityPlayer player : allPlayers) {
            Object res;
            if (!this.targetablePlayer(player, controller) || (res = this.visitPlayer(player, controller)) == CONTINUE) continue;
            return (E)res;
        }
        return null;
    }

    boolean targetablePlayer(EntityPlayer player, ColossusController controller) {
        Coord coord = new Coord((Entity)player);
        if ((double)controller.getHome().distanceSq(coord) > 1600.0) {
            return false;
        }
        return !player.field_71075_bZ.field_75098_d;
    }

    protected Object visitPlayer(EntityPlayer player, ColossusController controller) {
        return null;
    }

    void playNoise(ColossusController controller) {
        float volume = 10.0f;
        float pitch = 1.0f;
        controller.field_70170_p.func_72956_a((Entity)controller, "factorization:colossus.tech_" + this, volume, pitch);
    }

    void removeMyCreepers(ColossusController controller) {
        Coord at = new Coord(controller);
        int d = 64;
        Coord min = at.add(-d, -d, -d);
        Coord max = at.add(d, d, d);
        Coord.iterateChunks(min, max, new ICoordFunction(){

            @Override
            public void handle(Coord here) {
                if (!here.blockExists()) {
                    return;
                }
                for (List list : here.getChunk().field_76645_j) {
                    for (Object obj : list) {
                        EntityCreeper creeper;
                        if (!(obj instanceof EntityCreeper) || !(creeper = (EntityCreeper)obj).getEntityData().func_74767_n(ColossusController.creeper_tag)) continue;
                        creeper.func_70606_j(0.0f);
                    }
                }
            }
        });
    }

    static {
        bendInterp = Interpolation.LINEAR;
        CONTINUE = new Object();
    }
}

