/*
 * Decompiled with CFR 0.152.
 */
package factorization.colossi;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import factorization.api.Coord;
import factorization.colossi.ColossalBuilder;
import factorization.colossi.TileEntityColossalHeart;
import factorization.common.FzConfig;
import factorization.fzds.DeltaChunk;
import factorization.shared.Core;
import factorization.util.NumUtil;
import gnu.trove.map.hash.TIntByteHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.NoiseGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;

public class WorldGenColossus
implements IWorldGenerator {
    static int GENERATION_SPACING = FzConfig.colossus_spacing;
    static int GENERATION_START_X = 9;
    static int GENERATION_START_Z = 9;
    static final double SMOOTH_START = 40.0;
    static final double SMOOTH_END = 24.0;
    static final double SMOOTH_GEN_BORDER = 48.0;
    static final double SMOOTH_END_FUZZ = 56.0;
    static TIntByteHashMap dimensionBlacklist;
    static BiomeDictionary.Type[] forbiddenBiomeTypes;

    public WorldGenColossus() {
        if (FzConfig.gen_colossi) {
            DeltaChunk.assertEnabled();
            Core.loadBus(this);
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
        }
    }

    private static double dist(int generation_spacing, int pos) {
        int n;
        int dist = (pos = Math.abs(pos)) - (n = pos / generation_spacing) * generation_spacing;
        if (dist > generation_spacing / 2) {
            dist = generation_spacing - dist;
        }
        return dist;
    }

    public static double distance(int blockX, int blockZ) {
        double distX = WorldGenColossus.dist(GENERATION_SPACING * 16, blockX - GENERATION_START_X * 16);
        double distZ = WorldGenColossus.dist(GENERATION_SPACING * 16, blockZ - GENERATION_START_Z * 16);
        double distSq = distX * distX + distZ * distZ;
        return Math.sqrt(distSq);
    }

    public static boolean isGenChunk(int chunkX, int chunkZ) {
        boolean x = (chunkX % GENERATION_SPACING + GENERATION_SPACING) % GENERATION_SPACING == GENERATION_START_X;
        boolean z = (chunkZ % GENERATION_SPACING + GENERATION_SPACING) % GENERATION_SPACING == GENERATION_START_Z;
        return x && z;
    }

    public static ArrayList<Coord> getCandidatesNear(final Coord player, int chunkSearchDistance, boolean forceLoad) throws LocationException {
        ArrayList<Coord> ret = new ArrayList<Coord>();
        ChunkCoordIntPair chunkAt = player.getChunk().func_76632_l();
        for (int dx = -chunkSearchDistance; dx <= chunkSearchDistance; ++dx) {
            for (int dz = -chunkSearchDistance; dz <= chunkSearchDistance; ++dz) {
                int cx = chunkAt.field_77276_a + dx;
                int cz = chunkAt.field_77275_b + dz;
                if (!WorldGenColossus.isGenChunk(cx, cz)) continue;
                Chunk chunk = player.w.func_72964_e(cx, cz);
                if (forceLoad && !chunk.field_76646_k) {
                    int r = 1;
                    for (int rx = -r; rx <= r; ++rx) {
                        for (int rz = -r; rz <= r; ++rz) {
                            if (rx == 0 && rz == 0) continue;
                            player.w.func_72964_e(cx + rx, cz + rz);
                        }
                    }
                }
                boolean unload = false;
                if (forceLoad && !chunk.field_76646_k) {
                    try {
                        WorldGenColossus.forceLoadChunk(player.w, cx, cz);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        Core.logSevere("Failed to load chunk at (block coords)" + cx * 16 + " " + cz * 16, new Object[0]);
                        throw new LocationException(t);
                    }
                    chunk = player.w.func_72964_e(cx, cz);
                    unload = true;
                }
                Coord at = new Coord(chunk);
                at.getBlock();
                for (TileEntity te : chunk.field_150816_i.values()) {
                    if (!(te instanceof TileEntityColossalHeart)) continue;
                    ret.add(new Coord(te));
                    break;
                }
                if (!unload) continue;
                WorldGenColossus.releaseChunk(chunk);
            }
        }
        Collections.sort(ret, new Comparator<Coord>(){

            @Override
            public int compare(Coord a, Coord b) {
                return player.distanceSq(a) - player.distanceSq(b);
            }
        });
        return ret;
    }

    private static void forceLoadChunk(World world, int cx, int cz) {
        ChunkProviderServer cps = (ChunkProviderServer)world.func_72863_F();
        cps.func_73153_a((IChunkProvider)cps, cx, cz);
    }

    private static void releaseChunk(Chunk chunk) {
    }

    @SubscribeEvent
    public void injectNoiseSmoothers(InitNoiseGensEvent event) {
        if (!WorldGenColossus.genOnWorld(event.world)) {
            return;
        }
        int[] target_noises = new int[]{0, 1, 2, 5};
        int max = target_noises[0];
        for (int i : target_noises) {
            max = Math.max(max, i);
        }
        if (event.newNoiseGens == null || max >= event.newNoiseGens.length) {
            Core.logWarning("Colossi will not generate in dimension: " + event.world.field_73011_w.field_76574_g, new Object[0]);
            dimensionBlacklist.put(event.world.field_73011_w.field_76574_g, (byte)1);
            return;
        }
        for (int noise_index : target_noises) {
            NoiseGenerator parentGenerator = event.newNoiseGens[noise_index];
            event.newNoiseGens[noise_index] = new SmoothNoiseNearColossi(noise_index, (NoiseGeneratorOctaves)parentGenerator);
        }
    }

    public static boolean genOnWorld(World world) {
        return world.func_72912_H().func_76089_r() && world.field_73011_w.func_76569_d() && FzConfig.gen_colossi && !dimensionBlacklist.containsKey(world.field_73011_w.field_76574_g);
    }

    boolean isBadBiome(World w, int chunkX, int chunkZ) {
        BiomeGenBase biome = w.func_72807_a(8 + chunkX * 16, 8 + chunkZ * 16);
        for (BiomeDictionary.Type bad : forbiddenBiomeTypes) {
            if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)bad)) continue;
            return true;
        }
        return false;
    }

    public void generate(Random worldRandom, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!WorldGenColossus.genOnWorld(world)) {
            return;
        }
        if (!WorldGenColossus.isGenChunk(chunkX, chunkZ)) {
            return;
        }
        int blockX = 8 + chunkX * 16;
        int blockZ = 8 + chunkZ * 16;
        Coord start = new Coord(world, blockX, 0, blockZ);
        start.y = start.getColumnHeight();
        boolean bad_biome = this.isBadBiome(world, chunkX, chunkZ);
        if (bad_biome) {
            return;
        }
        start.moveToTopBlock();
        while (!start.isSolid()) {
            if (start.y <= 0) {
                return;
            }
            Material mat = start.getBlock().func_149688_o();
            if (mat == Material.field_151586_h || mat == Material.field_151587_i) {
                return;
            }
            --start.y;
        }
        ++start.y;
        ColossalBuilder builder = new ColossalBuilder(Math.abs(worldRandom.nextInt()), start);
        builder.construct();
    }

    private boolean cancel(World w, int cx, int cz) {
        int blockX = cx * 16 + 8;
        int blockZ = cz * 16 + 8;
        return WorldGenColossus.distance(blockX, blockZ) < 48.0;
    }

    @SubscribeEvent
    public void cancelDecorations(DecorateBiomeEvent.Decorate event) {
        if (!WorldGenColossus.genOnWorld(event.world)) {
            return;
        }
        DecorateBiomeEvent.Decorate.EventType type = event.type;
        if (type == DecorateBiomeEvent.Decorate.EventType.BIG_SHROOM || type == DecorateBiomeEvent.Decorate.EventType.LAKE || type == DecorateBiomeEvent.Decorate.EventType.PUMPKIN || type == DecorateBiomeEvent.Decorate.EventType.TREE) {
            if (this.cancel(event.world, event.chunkX / 16, event.chunkZ / 16)) {
                event.setResult(Event.Result.DENY);
            }
            return;
        }
    }

    @SubscribeEvent
    public void cancelPopulations(PopulateChunkEvent.Populate event) {
        if (!WorldGenColossus.genOnWorld(event.world)) {
            return;
        }
        PopulateChunkEvent.Populate.EventType type = event.type;
        if ((type == PopulateChunkEvent.Populate.EventType.LAKE || type == PopulateChunkEvent.Populate.EventType.LAVA || type == PopulateChunkEvent.Populate.EventType.ANIMALS || type == PopulateChunkEvent.Populate.EventType.CUSTOM) && this.cancel(event.world, event.chunkX, event.chunkZ)) {
            event.setResult(Event.Result.DENY);
        }
    }

    static {
        if (GENERATION_START_X > GENERATION_SPACING || GENERATION_START_Z > GENERATION_SPACING) {
            throw new IllegalArgumentException("colossus spacing must be at least " + Math.max(GENERATION_START_X, GENERATION_START_Z));
        }
        dimensionBlacklist = new TIntByteHashMap();
        forbiddenBiomeTypes = new BiomeDictionary.Type[]{BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.WATER, BiomeDictionary.Type.RIVER, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.BEACH};
    }

    static class SmoothNoiseNearColossi
    extends NoiseGeneratorOctaves {
        final NoiseGeneratorOctaves parent;
        final int parentIndex;

        public SmoothNoiseNearColossi(int parentIndex, NoiseGeneratorOctaves parent) {
            super(null, 0);
            this.parent = parent;
            this.parentIndex = parentIndex;
        }

        public double[] func_76304_a(double[] noiseOut, int chunkXTimes4, int noiseStartY, int chunkZTimes4, int noiseSizeX, int noiseSizeY, int noiseSizeZ, double scaleX, double scaleY, double scaleZ) {
            double[] ret = this.parent.func_76304_a(noiseOut, chunkXTimes4, noiseStartY, chunkZTimes4, noiseSizeX, noiseSizeY, noiseSizeZ, scaleX, scaleY, scaleZ);
            int noiseSrcX = chunkXTimes4 * 16 / 4;
            int noiseSrcZ = chunkZTimes4 * 16 / 4;
            double noise_src_dist = WorldGenColossus.distance(noiseSrcX + 8, noiseSrcZ + 8);
            if (noise_src_dist > 56.0) {
                return ret;
            }
            int y_count = this.parentIndex == 5 ? 1 : 33;
            int distance_fuzz = 500;
            for (int noiseX = 0; noiseX < 5; ++noiseX) {
                for (int noiseZ = 0; noiseZ < 5; ++noiseZ) {
                    int world_x = noiseSrcX + noiseX * 4;
                    int world_z = noiseSrcZ + noiseZ * 4;
                    int column = (noiseX * 5 + noiseZ) * y_count;
                    double d = WorldGenColossus.distance(world_x, world_z);
                    double dFuzz = 0.0;
                    dFuzz = y_count > 1 ? (ret[column] - ret[column + 1]) / (double)distance_fuzz : ret[column] / (double)distance_fuzz;
                    d -= Math.cos(dFuzz) * 3.0;
                    for (int noiseY = 0; noiseY < y_count; ++noiseY) {
                        ret[column + noiseY] = this.smooth(d, ret[column + noiseY], 500.0);
                    }
                }
            }
            return ret;
        }

        double smooth(double dist, double max, double min) {
            if (dist > 40.0) {
                return max;
            }
            if (dist < 24.0) {
                return min;
            }
            double val = NumUtil.uninterp(24.0, 40.0, dist);
            return NumUtil.interp(min, max, val);
        }
    }

    static class LocationException
    extends Exception {
        public LocationException(Throwable t) {
            super(t);
        }
    }
}

