/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.IWorldGenerator;
import factorization.api.Coord;
import factorization.api.ICoordFunction;
import factorization.common.FzConfig;
import factorization.shared.Core;
import factorization.util.SpaceUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.NoiseGeneratorOctaves;

public class DarkIronOreGenerator
implements IWorldGenerator {
    static final int minMeteorR = 1;
    static final int maxMeteorR = 2;
    static final int maxWidth = 4;
    static final int minBlastR = 20;
    static final int maxBlastR = 28;
    static final int genRange = (int)Math.ceil(3.5);
    static final NoiseGeneratorOctaves noise = new NoiseGeneratorOctaves(new Random(0L), 2);
    static double[] samples = new double[64];

    boolean base(int x, int z) {
        boolean a = (x / 4 + z / 4) % 3 == 0;
        boolean b = x % 4 == 0 && z % 4 == 0;
        return a && b;
    }

    boolean rule(int x, int z) {
        if (x < 0) {
            x = -x;
        }
        if (z < 0) {
            z = -z;
        }
        int n = -1;
        int N = ((x - 1) / 8 + (z + 1) / 8) % 4;
        if (this.base(x, z)) {
            n = 0;
        } else if (this.base(x + 1, z)) {
            n = 1;
        } else if (this.base(x, z + 1)) {
            n = 2;
        } else if (this.base(x + 1, z + 1)) {
            n = 3;
        } else {
            return false;
        }
        return N == n;
    }

    public void generate(Random UNUSABLE_rng, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!FzConfig.gen_dark_iron_ore) {
            return;
        }
        if (!world.field_73011_w.func_76569_d()) {
            return;
        }
        int bedrockX = chunkX * 16 + 8;
        int bedrockZ = chunkZ * 16 + 8;
        if (world.func_147439_a(bedrockX, 0, bedrockZ) != Blocks.field_150357_h) {
            return;
        }
        for (int dcx = -genRange; dcx <= genRange; ++dcx) {
            for (int dcz = -genRange; dcz <= genRange; ++dcz) {
                int srcChunkX = chunkX + dcx;
                int srcChunkZ = chunkZ + dcz;
                if (!this.rule(srcChunkX, srcChunkZ)) continue;
                Coord min = new Coord(world, chunkX * 16, 0, chunkZ * 16);
                Coord max = min.add(16, 256, 16);
                long seed = world.func_72905_C() + (long)(srcChunkX * 1000) + (long)srcChunkZ;
                Random random = new Random(seed);
                new BlitGen(min, max, srcChunkX, srcChunkZ, random).generate();
            }
        }
    }

    static class BlitGen {
        final Coord min;
        final Coord max;
        final int chunkX;
        final int chunkZ;
        final Random random;
        final AxisAlignedBB chunkBox;
        Block stoneId = Blocks.field_150348_b;
        int stoneMd = 0;
        double rSq;
        double rSqEnd;
        Coord origin;
        Coord corner;
        int blobSize;
        ICoordFunction paintMeteor = new ICoordFunction(){

            @Override
            public void handle(Coord here) {
                int sz;
                int sy;
                int sx;
                double sample;
                if (!here.inside(BlitGen.this.min, BlitGen.this.max)) {
                    return;
                }
                if (here.y < 0) {
                    return;
                }
                double distSq = here.distanceSq(BlitGen.this.origin);
                if (distSq > BlitGen.this.rSqEnd) {
                    return;
                }
                if (distSq > BlitGen.this.rSq && (sample = samples[(sx = here.x - BlitGen.this.corner.x) * BlitGen.this.blobSize * BlitGen.this.blobSize + (sy = here.y - BlitGen.this.corner.y) * BlitGen.this.blobSize + (sz = here.z - BlitGen.this.corner.z)]) < 0.0) {
                    return;
                }
                if (here.y == 0) {
                    here.setId(Core.registry.fractured_bedrock_block, false);
                } else {
                    here.setId(Core.registry.dark_iron_ore, false);
                }
            }
        };
        Coord blastOrigin;
        ICoordFunction paintBlast = new ICoordFunction(){

            @Override
            public void handle(Coord here) {
                if (!here.inside(BlitGen.this.min, BlitGen.this.max)) {
                    return;
                }
                double distSq = here.distanceSq(BlitGen.this.blastOrigin);
                if (distSq > BlitGen.this.rSq) {
                    return;
                }
                if (here.getBlock() == Blocks.field_150357_h) {
                    here.setIdMd(BlitGen.this.stoneId, BlitGen.this.stoneMd, false);
                }
            }
        };
        ICoordFunction burnBlast = new ICoordFunction(){

            @Override
            public void handle(Coord here) {
                if (!here.inside(BlitGen.this.min, BlitGen.this.max)) {
                    return;
                }
                if (here.getBlock() != Blocks.field_150357_h) {
                    return;
                }
                double distSq = here.distanceSq(BlitGen.this.origin);
                double threshold = Math.sqrt(distSq) / Math.sqrt(BlitGen.this.rSqEnd);
                if ((double)(here.w.field_73012_v.nextFloat() * 5.0f) > threshold) {
                    here.setIdMd(Core.registry.blasted_bedrock_block, 1, false);
                }
            }
        };

        BlitGen(Coord min, Coord max, int chunkX, int chunkZ, Random random) {
            this.min = min;
            this.max = max;
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            this.random = random;
            this.chunkBox = SpaceUtil.createAABB(min, max);
            Coord here = min.add(8, 0, 8);
            for (int y = 1; y < 8; ++y) {
                ++here.y;
                this.stoneId = here.getBlock();
                if (this.stoneId == Blocks.field_150357_h || !this.stoneId.isReplaceableOreGen(here.w, here.x, here.y, here.z, Blocks.field_150348_b)) continue;
                this.stoneMd = here.getMd();
                break;
            }
        }

        public void generate() {
            int x = this.chunkX * 16 + this.random.nextInt(16);
            int z = this.chunkZ * 16 + this.random.nextInt(16);
            int meteorRadius = this.random.nextInt(1) + 1;
            Coord origin = new Coord(this.min.w, x, 1, z);
            this.meteorBlob(origin, meteorRadius);
            int blastRadius = this.random.nextInt(8) + 20;
            this.meteorBlast(origin, blastRadius);
        }

        void meteorBlob(Coord origin, int r) {
            Coord blobMin = origin.add(-r, -r, -r);
            Coord blobMax = origin.add(r, r, r);
            AxisAlignedBB blobBox = SpaceUtil.createAABB(this.min, this.max);
            if (!blobBox.func_72326_a(this.chunkBox)) {
                return;
            }
            this.origin = origin;
            this.rSq = r * r;
            this.rSqEnd = (r + 1) * (r + 1);
            this.blobSize = r * 2;
            int d = r;
            samples = noise.func_76304_a(samples, origin.x, origin.y, origin.z, this.blobSize, this.blobSize, this.blobSize, (double)(origin.x + d), (double)(origin.y + d), (double)(origin.z + d));
            this.corner = blobMin;
            Coord.iterateCube(blobMin, blobMax, this.paintMeteor);
        }

        void meteorBlast(Coord origin, int r) {
            int blastHeight = 7;
            this.blastOrigin = origin.add(0, r - 2, 0);
            this.rSq = r * r;
            this.rSqEnd = blastHeight * blastHeight;
            Coord min = origin.add(-r, 0, -r);
            Coord max = origin.add(r, blastHeight, r);
            Coord.iterateCube(min, max, this.paintBlast);
            min.y = 0;
            min.adjust(-r / 3, 0, -r / 3);
            max.adjust(r / 3, 0, r / 3);
            Coord.iterateCube(min, max, this.burnBlast);
        }
    }
}

