/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import factorization.api.Coord;
import factorization.artifact.ContainerForge;
import factorization.artifact.GuiArtifactForge;
import factorization.artifact.RenderBrokenArtifact;
import factorization.beauty.BlockRenderAnthrogen;
import factorization.beauty.BlockRenderBiblioGen;
import factorization.beauty.BlockRenderSapExtractor;
import factorization.beauty.BlockRenderShaft;
import factorization.beauty.BlockRenderShaftGen;
import factorization.beauty.BlockRenderSteamShaft;
import factorization.beauty.BlockRenderWaterWheel;
import factorization.beauty.BlockRenderWindMill;
import factorization.beauty.EntityLeafBomb;
import factorization.beauty.TileEntityBiblioGen;
import factorization.beauty.TileEntityBiblioGenRenderer;
import factorization.beauty.TileEntityShaft;
import factorization.beauty.TileEntityShaftRenderer;
import factorization.beauty.TileEntitySteamShaft;
import factorization.beauty.TileEntitySteamShaftRenderer;
import factorization.ceramics.BlockRenderGreenware;
import factorization.ceramics.ItemRenderGlazeBucket;
import factorization.ceramics.TileEntityGreenware;
import factorization.ceramics.TileEntityGreenwareRender;
import factorization.charge.BatteryItemRender;
import factorization.charge.BlockRenderBattery;
import factorization.charge.BlockRenderHeater;
import factorization.charge.BlockRenderLeydenJar;
import factorization.charge.BlockRenderMirrorStand;
import factorization.charge.BlockRenderSolarBoiler;
import factorization.charge.BlockRenderSteamTurbine;
import factorization.charge.BlockRenderWire;
import factorization.charge.TileEntityHeater;
import factorization.charge.TileEntityHeaterRenderer;
import factorization.charge.TileEntityLeydenJar;
import factorization.charge.TileEntityLeydenJarRender;
import factorization.charge.TileEntitySteamTurbine;
import factorization.charge.TileEntitySteamTurbineRender;
import factorization.citizen.EntityCitizen;
import factorization.citizen.RenderCitizen;
import factorization.colossi.ColossusController;
import factorization.colossi.ColossusControllerRenderer;
import factorization.common.ContainerFactorization;
import factorization.common.FactorizationKeyHandler;
import factorization.common.FactorizationProxy;
import factorization.common.FactoryType;
import factorization.common.FzConfig;
import factorization.crafting.BlockRenderCompressionCrafter;
import factorization.crafting.BlockRenderMixer;
import factorization.crafting.ContainerMixer;
import factorization.crafting.GuiMixer;
import factorization.crafting.GuiStamper;
import factorization.crafting.TileEntityCompressionCrafter;
import factorization.crafting.TileEntityCompressionCrafterRenderer;
import factorization.crafting.TileEntityMixer;
import factorization.crafting.TileEntityMixerRenderer;
import factorization.darkiron.BlockDarkIronOre;
import factorization.darkiron.GlintRenderer;
import factorization.mechanics.BlockRenderHinge;
import factorization.mechanics.SocketPoweredCrank;
import factorization.mechanics.TileEntityHinge;
import factorization.mechanics.TileEntityHingeRenderer;
import factorization.oreprocessing.BlockRenderCrystallizer;
import factorization.oreprocessing.ContainerCrystallizer;
import factorization.oreprocessing.ContainerSlagFurnace;
import factorization.oreprocessing.GuiCrystallizer;
import factorization.oreprocessing.GuiSlag;
import factorization.oreprocessing.TileEntityCrystallizer;
import factorization.oreprocessing.TileEntityCrystallizerRender;
import factorization.oreprocessing.TileEntityGrinderRender;
import factorization.redstone.GuiParasieve;
import factorization.rendersorting.RenderSorter;
import factorization.servo.BlockRenderServoRail;
import factorization.servo.RenderServoMotor;
import factorization.servo.ServoMotor;
import factorization.servo.stepper.RenderStepperEngine;
import factorization.servo.stepper.StepperEngine;
import factorization.shared.BlockRenderDefault;
import factorization.shared.BlockRenderEmpty;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.EmptyRender;
import factorization.shared.FactorizationBlockRender;
import factorization.shared.FactorizationGui;
import factorization.shared.FactorizationRender;
import factorization.shared.FactorizationRenderNonTE;
import factorization.shared.ItemRenderCapture;
import factorization.shared.TileEntityFactorization;
import factorization.sockets.BlockRenderSocketBase;
import factorization.sockets.SocketLacerator;
import factorization.sockets.SocketScissors;
import factorization.sockets.TileEntitySocketRenderer;
import factorization.sockets.fanturpeller.SocketFanturpeller;
import factorization.twistedblock.TwistedRender;
import factorization.utiligoo.GooRenderer;
import factorization.weird.BlockRenderDayBarrel;
import factorization.weird.ContainerPocket;
import factorization.weird.DayBarrelItemRenderer;
import factorization.weird.EntityMinecartDayBarrel;
import factorization.weird.GuiPocketTable;
import factorization.weird.RenderMinecartDayBarrel;
import factorization.weird.TileEntityDayBarrel;
import factorization.weird.TileEntityDayBarrelRenderer;
import factorization.weird.poster.EntityPoster;
import factorization.weird.poster.RenderPoster;
import factorization.wrath.BlockRenderLamp;
import factorization.wrath.TileEntityWrathLamp;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.input.Keyboard;

public class FactorizationClientProxy
extends FactorizationProxy {
    public FactorizationKeyHandler keyHandler = new FactorizationKeyHandler();
    public RenderSorter renderSorter;

    public FactorizationClientProxy() {
        Core.loadBus(this);
    }

    @Override
    public Profiler getProfiler() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return Minecraft.func_71410_x().field_71424_I;
        }
        return super.getProfiler();
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == FactoryType.POCKETCRAFTGUI.gui) {
            return new GuiPocketTable(new ContainerPocket(player));
        }
        if (ID == FactoryType.ARTIFACTFORGEGUI.gui) {
            return new GuiArtifactForge(new ContainerForge(new Coord(world, x, y, z), player));
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityFactorization)) {
            return null;
        }
        TileEntityFactorization fac = (TileEntityFactorization)te;
        ContainerFactorization cont = ID == FactoryType.SLAGFURNACE.gui ? new ContainerSlagFurnace(player, fac) : (ID == FactoryType.MIXER.gui ? new ContainerMixer(player, fac) : (ID == FactoryType.CRYSTALLIZER.gui ? new ContainerCrystallizer(player, fac) : new ContainerFactorization(player, fac)));
        FactorizationGui gui = null;
        if (ID == FactoryType.STAMPER.gui) {
            gui = new GuiStamper(cont);
        }
        if (ID == FactoryType.SLAGFURNACE.gui) {
            gui = new GuiSlag(cont);
        }
        if (ID == FactoryType.MIXER.gui && cont instanceof ContainerMixer) {
            gui = new GuiMixer((ContainerMixer)cont);
        }
        if (ID == FactoryType.CRYSTALLIZER.gui) {
            gui = new GuiCrystallizer(cont);
        }
        if (ID == FactoryType.PARASIEVE.gui) {
            gui = new GuiParasieve(cont);
        }
        if (gui == null) {
            return null;
        }
        cont.addSlotsForGui(fac, player.field_71071_by);
        return gui;
    }

    @Override
    public void pokePocketCrafting() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71462_r instanceof GuiPocketTable) {
            GuiPocketTable gui = (GuiPocketTable)minecraft.field_71462_r;
            gui.containerPocket.updateCraft();
        }
    }

    @Override
    public void playSoundFX(String src, float volume, float pitch) {
        PositionedSoundRecord sound2 = new PositionedSoundRecord(new ResourceLocation(src), volume, pitch, 0.0f, 0.0f, 0.0f);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound2);
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    private void setTileEntityRendererDispatcher(Class clazz, TileEntitySpecialRenderer r) {
        ClientRegistry.bindTileEntitySpecialRenderer((Class)clazz, (TileEntitySpecialRenderer)r);
    }

    @Override
    public void registerRenderers() {
        this.setTileEntityRendererDispatcher(TileEntityDayBarrel.class, new TileEntityDayBarrelRenderer());
        this.setTileEntityRendererDispatcher(TileEntityGreenware.class, new TileEntityGreenwareRender());
        if (FzConfig.renderTEs) {
            this.setTileEntityRendererDispatcher(TileEntityHeater.class, new TileEntityHeaterRenderer());
            this.setTileEntityRendererDispatcher(TileEntityMixer.class, new TileEntityMixerRenderer());
            this.setTileEntityRendererDispatcher(TileEntityCrystallizer.class, new TileEntityCrystallizerRender());
            this.setTileEntityRendererDispatcher(TileEntitySteamTurbine.class, new TileEntitySteamTurbineRender());
            this.setTileEntityRendererDispatcher(TileEntityLeydenJar.class, new TileEntityLeydenJarRender());
            this.setTileEntityRendererDispatcher(TileEntityCompressionCrafter.class, new TileEntityCompressionCrafterRenderer());
            this.setTileEntityRendererDispatcher(SocketScissors.class, new TileEntitySocketRenderer());
            this.setTileEntityRendererDispatcher(SocketLacerator.class, new TileEntitySocketRenderer());
            this.setTileEntityRendererDispatcher(SocketFanturpeller.class, new TileEntitySocketRenderer());
            this.setTileEntityRendererDispatcher(TileEntityHinge.class, new TileEntityHingeRenderer());
            this.setTileEntityRendererDispatcher(SocketPoweredCrank.class, new TileEntitySocketRenderer());
            this.setTileEntityRendererDispatcher(TileEntitySteamShaft.class, new TileEntitySteamShaftRenderer());
            this.setTileEntityRendererDispatcher(TileEntityShaft.class, new TileEntityShaftRenderer());
            this.setTileEntityRendererDispatcher(TileEntityBiblioGen.class, new TileEntityBiblioGenRenderer());
        }
        RenderingRegistry.registerEntityRenderingHandler(TileEntityWrathLamp.RelightTask.class, (Render)new EmptyRender());
        RenderingRegistry.registerEntityRenderingHandler(ServoMotor.class, (Render)new RenderServoMotor());
        RenderingRegistry.registerEntityRenderingHandler(StepperEngine.class, (Render)new RenderStepperEngine());
        RenderingRegistry.registerEntityRenderingHandler(ColossusController.class, (Render)new ColossusControllerRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityPoster.class, (Render)new RenderPoster());
        RenderingRegistry.registerEntityRenderingHandler(EntityCitizen.class, (Render)new RenderCitizen());
        RenderingRegistry.registerEntityRenderingHandler(EntityMinecartDayBarrel.class, (Render)new RenderMinecartDayBarrel());
        RenderingRegistry.registerEntityRenderingHandler(EntityLeafBomb.class, (Render)new RenderSnowball((Item)Core.registry.leafBomb, 0));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new FactorizationRender());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new FactorizationRenderNonTE());
        new BlockRenderDefault();
        BlockRenderBattery renderBattery = new BlockRenderBattery();
        BlockRenderDayBarrel renderBarrel = new BlockRenderDayBarrel();
        new BlockRenderLeydenJar();
        new BlockRenderHeater();
        new BlockRenderLamp();
        new BlockRenderMirrorStand();
        new BlockRenderSteamTurbine();
        new BlockRenderWire();
        new BlockRenderMixer();
        new BlockRenderCrystallizer();
        new BlockRenderCompressionCrafter();
        new BlockRenderGreenware().setup();
        new BlockRenderServoRail();
        new BlockRenderHinge();
        new BlockRenderSapExtractor();
        new BlockRenderAnthrogen();
        new BlockRenderSteamShaft();
        new BlockRenderSolarBoiler();
        new BlockRenderShaftGen();
        new BlockRenderShaft();
        new BlockRenderBiblioGen();
        new BlockRenderWindMill();
        new BlockRenderWaterWheel();
        for (FactoryType ft : new FactoryType[]{FactoryType.SOCKET_EMPTY, FactoryType.SOCKET_LACERATOR, FactoryType.SOCKET_ROBOTHAND, FactoryType.SOCKET_SHIFTER, FactoryType.SOCKET_BLOWER, FactoryType.SOCKET_PUMP, FactoryType.SOCKET_BARE_MOTOR, FactoryType.SOCKET_SCISSORS, FactoryType.SOCKET_POWERED_CRANK}) {
            new BlockRenderSocketBase(ft);
        }
        for (FactoryType ft : new FactoryType[]{FactoryType.STAMPER, FactoryType.PACKAGER, FactoryType.SLAGFURNACE, FactoryType.PARASIEVE, FactoryType.CALIOMETRIC_BURNER, FactoryType.CREATIVE_CHARGE, FactoryType.LEGENDARIUM}) {
            FactorizationBlockRender.setDefaultRender(ft);
        }
        new BlockRenderEmpty(FactoryType.EXTENDED);
        ItemRenderCapture capture = new ItemRenderCapture();
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)Core.registry.factory_block), (IItemRenderer)capture);
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)Core.registry.factory_block_barrel), (IItemRenderer)capture);
        MinecraftForgeClient.registerItemRenderer((Item)Core.registry.battery, (IItemRenderer)new BatteryItemRender(renderBattery));
        MinecraftForgeClient.registerItemRenderer((Item)Core.registry.glaze_bucket, (IItemRenderer)new ItemRenderGlazeBucket());
        MinecraftForgeClient.registerItemRenderer((Item)Core.registry.daybarrel, (IItemRenderer)new DayBarrelItemRenderer(renderBarrel));
        MinecraftForgeClient.registerItemRenderer((Item)Core.registry.twistedBlock, (IItemRenderer)new TwistedRender());
        MinecraftForgeClient.registerItemRenderer((Item)Core.registry.brokenTool, (IItemRenderer)new RenderBrokenArtifact());
        this.setTileEntityRendererDispatcher(BlockDarkIronOre.Glint.class, new GlintRenderer());
        Core.loadBus((Object)GooRenderer.INSTANCE);
    }

    @Override
    public void texturepackChanged(IIconRegister reg) {
        TileEntityGrinderRender.remakeModel();
        BlockRenderServoRail.registerColoredIcons(reg);
    }

    @Override
    public boolean BlockRenderHelper_has_texture(BlockRenderHelper block, int f) {
        if (block.textures == null) {
            return true;
        }
        return block.textures[f] != null;
    }

    @Override
    public void BlockRenderHelper_clear_texture(BlockRenderHelper block) {
        block.textures = null;
    }

    @Override
    public String getPocketCraftingTableKey() {
        return GameSettings.func_74298_c((int)FactorizationKeyHandler.pocket_key.func_151463_i());
    }

    @Override
    public boolean isClientHoldingShift() {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        return Keyboard.isKeyDown((int)42);
    }

    @Override
    public void afterLoad() {
        Core.logInfo("Reloading game settings", new Object[0]);
        Minecraft.func_71410_x().field_71474_y.func_74300_a();
    }

    @Override
    public void sendBlockClickPacket() {
        Minecraft mc = Minecraft.func_71410_x();
        MovingObjectPosition mop = mc.field_71476_x;
        new C07PacketPlayerDigging(0, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, mop.field_72310_e);
    }
}

