/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.registry.GameRegistry;
import factorization.artifact.TileEntityLegendarium;
import factorization.astro.TileEntityRocketEngine;
import factorization.beauty.TileEntityAnthroGen;
import factorization.beauty.TileEntityBiblioGen;
import factorization.beauty.TileEntitySapTap;
import factorization.beauty.TileEntityShaft;
import factorization.beauty.TileEntityShaftGen;
import factorization.beauty.TileEntitySteamShaft;
import factorization.beauty.TileEntityWaterWheel;
import factorization.beauty.TileEntityWindMill;
import factorization.ceramics.TileEntityGreenware;
import factorization.charge.InfiniteChargeBlock;
import factorization.charge.TileEntityBattery;
import factorization.charge.TileEntityCaliometricBurner;
import factorization.charge.TileEntityHeater;
import factorization.charge.TileEntityLeydenJar;
import factorization.charge.TileEntityMirror;
import factorization.charge.TileEntitySolarBoiler;
import factorization.charge.TileEntitySteamTurbine;
import factorization.charge.TileEntityWire;
import factorization.common.FzConfig;
import factorization.crafting.TileEntityCompressionCrafter;
import factorization.crafting.TileEntityMixer;
import factorization.crafting.TileEntityPackager;
import factorization.crafting.TileEntityStamper;
import factorization.fzds.DeltaChunk;
import factorization.mechanics.SocketPoweredCrank;
import factorization.mechanics.TileEntityHinge;
import factorization.oreprocessing.TileEntityCrystallizer;
import factorization.oreprocessing.TileEntitySlagFurnace;
import factorization.redstone.TileEntityParaSieve;
import factorization.servo.TileEntityServoRail;
import factorization.shared.Core;
import factorization.shared.TileEntityCommon;
import factorization.shared.TileEntityExtension;
import factorization.shared.TileEntityFactorization;
import factorization.sockets.SocketBareMotor;
import factorization.sockets.SocketEmpty;
import factorization.sockets.SocketLacerator;
import factorization.sockets.SocketRobotHand;
import factorization.sockets.SocketScissors;
import factorization.sockets.SocketShifter;
import factorization.sockets.fanturpeller.BlowEntities;
import factorization.sockets.fanturpeller.PumpLiquids;
import factorization.weird.TileEntityDayBarrel;
import factorization.wrath.TileEntityWrathLamp;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class FactoryType
extends Enum<FactoryType> {
    public static final /* enum */ FactoryType STAMPER = new FactoryType(3, true, TileEntityStamper.class, "factory_stamper");
    public static final /* enum */ FactoryType LAMP = new FactoryType(6, false, TileEntityWrathLamp.class, "factory_lamp");
    public static final /* enum */ FactoryType PACKAGER = new FactoryType(8, true, FactoryType.STAMPER.gui, TileEntityPackager.class, "factory_packager");
    public static final /* enum */ FactoryType SLAGFURNACE = new FactoryType(11, true, TileEntitySlagFurnace.class, "factory_slag");
    public static final /* enum */ FactoryType BATTERY = new FactoryType(12, false, TileEntityBattery.class, "factory_battery");
    public static final /* enum */ FactoryType LEADWIRE = new FactoryType(14, false, TileEntityWire.class, "factory_solder");
    public static final /* enum */ FactoryType HEATER = new FactoryType(15, false, TileEntityHeater.class, "factory_heater");
    public static final /* enum */ FactoryType MIRROR = new FactoryType(16, false, TileEntityMirror.class, "factory_mirror");
    public static final /* enum */ FactoryType MIXER = new FactoryType(18, true, TileEntityMixer.class, "factory_mixer");
    public static final /* enum */ FactoryType CRYSTALLIZER = new FactoryType(19, true, TileEntityCrystallizer.class, "factory_crystal");
    public static final /* enum */ FactoryType STEAMTURBINE = new FactoryType(21, false, TileEntitySteamTurbine.class, "factory_steamturbine");
    public static final /* enum */ FactoryType SOLARBOILER = new FactoryType(22, false, TileEntitySolarBoiler.class, "factory_solarfurnace");
    public static final /* enum */ FactoryType ROCKETENGINE = new FactoryType(23, false, TileEntityRocketEngine.class, "factory_rocketengine");
    public static final /* enum */ FactoryType EXTENDED = new FactoryType(24, false, TileEntityExtension.class, "factory_ext");
    public static final /* enum */ FactoryType CERAMIC = new FactoryType(25, false, TileEntityGreenware.class, "factory_ceramic");
    public static final /* enum */ FactoryType LEYDENJAR = new FactoryType(26, false, TileEntityLeydenJar.class, "factory_leyjar");
    public static final /* enum */ FactoryType SERVORAIL = new FactoryType(27, false, TileEntityServoRail.class, "factory_rail");
    public static final /* enum */ FactoryType PARASIEVE = new FactoryType(28, true, TileEntityParaSieve.class, "factory_sieve");
    public static final /* enum */ FactoryType COMPRESSIONCRAFTER = new FactoryType(29, false, TileEntityCompressionCrafter.class, "factory_compact");
    public static final /* enum */ FactoryType DAYBARREL = new FactoryType(30, false, TileEntityDayBarrel.class, "factory_barrel2");
    public static final /* enum */ FactoryType CALIOMETRIC_BURNER = new FactoryType(31, false, TileEntityCaliometricBurner.class, "factory_calory");
    public static final /* enum */ FactoryType SOCKET_EMPTY = new FactoryType(32, false, SocketEmpty.class, "fzsock_empty");
    public static final /* enum */ FactoryType SOCKET_LACERATOR = new FactoryType(33, false, SocketLacerator.class, "fzsock_lacerate");
    public static final /* enum */ FactoryType SOCKET_ROBOTHAND = new FactoryType(34, false, SocketRobotHand.class, "fzsock_hand");
    public static final /* enum */ FactoryType SOCKET_SHIFTER = new FactoryType(35, true, SocketShifter.class, "fzsock_shift");
    public static final /* enum */ FactoryType SOCKET_PUMP = new FactoryType(37, false, PumpLiquids.class, "fzsock_pump");
    public static final /* enum */ FactoryType SOCKET_BLOWER = new FactoryType(39, true, BlowEntities.class, "fzsock_blow");
    public static final /* enum */ FactoryType SOCKET_BARE_MOTOR = new FactoryType(41, false, SocketBareMotor.class, "fzsock_motor");
    public static final /* enum */ FactoryType SOCKET_SCISSORS = new FactoryType(42, false, SocketScissors.class, "fzsock_scissors");
    public static final /* enum */ FactoryType CREATIVE_CHARGE = new FactoryType(43, false, InfiniteChargeBlock.class, "factory_creative_charge");
    public static final /* enum */ FactoryType HINGE = new FactoryType(44, false, TileEntityHinge.class, "factory_hinge");
    public static final /* enum */ FactoryType SOCKET_POWERED_CRANK = new FactoryType(47, false, SocketPoweredCrank.class, "factory_powered_crank");
    public static final /* enum */ FactoryType SAP_TAP = new FactoryType(49, false, TileEntitySapTap.class, "factory_sap_extractor");
    public static final /* enum */ FactoryType ANTHRO_GEN = new FactoryType(50, false, TileEntityAnthroGen.class, "factory_anthro_gen");
    public static final /* enum */ FactoryType BIBLIO_GEN = new FactoryType(51, false, TileEntityBiblioGen.class, "factory_biblio_gen");
    public static final /* enum */ FactoryType SHAFT_GEN = new FactoryType(52, false, TileEntityShaftGen.class, "factory_shaft_gen");
    public static final /* enum */ FactoryType STEAM_SHAFT = new FactoryType(53, false, TileEntitySteamShaft.class, "factory_steam_shaft");
    public static final /* enum */ FactoryType SHAFT = new FactoryType(54, false, TileEntityShaft.class, "factory_shaft");
    public static final /* enum */ FactoryType WIND_MILL_GEN = new FactoryType(55, false, TileEntityWindMill.class, "factory_fluidmill");
    public static final /* enum */ FactoryType WATER_WHEEL_GEN = new FactoryType(57, false, TileEntityWaterWheel.class, "factory_water_wheel");
    public static final /* enum */ FactoryType LEGENDARIUM = new FactoryType(60, false, TileEntityLegendarium.class, "factory_legendarium");
    public static final /* enum */ FactoryType POCKETCRAFTGUI = new FactoryType(101, true);
    public static final /* enum */ FactoryType NONE = new FactoryType(102, false);
    public static final /* enum */ FactoryType ARTIFACTFORGEGUI = new FactoryType(103, true);
    public static int MAX_ID;
    public final int md;
    public final int gui;
    public final boolean hasGui;
    private final Class<? extends TileEntityCommon> clazz;
    public final String te_id;
    private TileEntityCommon representative;
    private boolean can_represent = true;
    private boolean disabled = false;
    private static final /* synthetic */ FactoryType[] $VALUES;

    public static FactoryType[] values() {
        return (FactoryType[])$VALUES.clone();
    }

    public static FactoryType valueOf(String name) {
        return Enum.valueOf(FactoryType.class, name);
    }

    public TileEntityCommon getRepresentative() {
        if (!this.can_represent || this.disabled) {
            return null;
        }
        if (this.representative == null) {
            if (this.clazz == null) {
                this.can_represent = false;
                return null;
            }
            if (this.can_represent) {
                this.can_represent = TileEntityCommon.class.isAssignableFrom(this.clazz);
                if (!this.can_represent) {
                    return null;
                }
            }
            try {
                this.representative = this.clazz.newInstance();
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Can not instantiate: " + this.toString(), e);
            }
            this.representative.representYoSelf();
        }
        return this.representative;
    }

    public Class<? extends TileEntityCommon> getFactoryTypeClass() {
        return this.clazz;
    }

    private FactoryType(int metadata, boolean use_gui, int gui_id, Class clazz, String name) {
        this.md = metadata;
        this.gui = use_gui ? gui_id : -1;
        this.hasGui = use_gui;
        assert (mapper.mapping[this.md] == null);
        mapper.mapping[this.md] = this;
        this.clazz = clazz;
        this.te_id = name;
        Object rep = null;
        this.representative = rep;
    }

    private FactoryType(int md, boolean use_gui, Class clazz, String name) {
        this(md, use_gui, md, clazz, name);
    }

    private FactoryType(int md, boolean use_gui) {
        this(md, use_gui, md, null, null);
    }

    void disable() {
        this.disabled = true;
    }

    public TileEntityCommon makeTileEntity() {
        if (this.clazz == null) {
            Core.logWarning("Note: " + (Object)((Object)this) + " is a FactoryType with no associated TE", new Object[0]);
            return null;
        }
        try {
            return this.clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean isInstance(TileEntityFactorization ent) {
        if (ent == null) {
            return false;
        }
        return ent.getFactoryType() == this;
    }

    public boolean is(int md) {
        return md == this.md;
    }

    public static FactoryType fromMd(short md) {
        if (md < 0) {
            return null;
        }
        if (md >= mapper.mapping.length) {
            return null;
        }
        return mapper.mapping[md];
    }

    public ItemStack itemStack() {
        if (this.disabled) {
            return null;
        }
        ItemStack ret = new ItemStack((Item)Core.registry.item_factorization, 1, this.md);
        return ret;
    }

    public static void registerTileEntities() {
        for (FactoryType ft : FactoryType.values()) {
            if (ft.clazz == null || ft.te_id == null) continue;
            if (ft == SOCKET_LACERATOR) {
                GameRegistry.registerTileEntityWithAlternatives(ft.clazz, (String)ft.te_id, (String[])new String[]{"factory_grinder"});
                continue;
            }
            if (ft == SOCKET_BLOWER) {
                GameRegistry.registerTileEntityWithAlternatives(ft.clazz, (String)ft.te_id, (String[])new String[]{"fzsock_fanturpeller"});
                continue;
            }
            GameRegistry.registerTileEntity(ft.clazz, (String)ft.te_id);
        }
    }

    public boolean connectRedstone() {
        return this == STAMPER || this == PACKAGER;
    }

    public ItemStack asSocketItem() {
        return new ItemStack((Item)Core.registry.socket_part, 1, this.md);
    }

    static {
        $VALUES = new FactoryType[]{STAMPER, LAMP, PACKAGER, SLAGFURNACE, BATTERY, LEADWIRE, HEATER, MIRROR, MIXER, CRYSTALLIZER, STEAMTURBINE, SOLARBOILER, ROCKETENGINE, EXTENDED, CERAMIC, LEYDENJAR, SERVORAIL, PARASIEVE, COMPRESSIONCRAFTER, DAYBARREL, CALIOMETRIC_BURNER, SOCKET_EMPTY, SOCKET_LACERATOR, SOCKET_ROBOTHAND, SOCKET_SHIFTER, SOCKET_PUMP, SOCKET_BLOWER, SOCKET_BARE_MOTOR, SOCKET_SCISSORS, CREATIVE_CHARGE, HINGE, SOCKET_POWERED_CRANK, SAP_TAP, ANTHRO_GEN, BIBLIO_GEN, SHAFT_GEN, STEAM_SHAFT, SHAFT, WIND_MILL_GEN, WATER_WHEEL_GEN, LEGENDARIUM, POCKETCRAFTGUI, NONE, ARTIFACTFORGEGUI};
        MAX_ID = 0;
        for (FactoryType ft : FactoryType.values()) {
            MAX_ID = Math.max(MAX_ID, ft.md);
        }
        if (!FzConfig.enable_rocketry) {
            ROCKETENGINE.disable();
        }
        if (!DeltaChunk.enabled()) {
            HINGE.disable();
            ROCKETENGINE.disable();
            WIND_MILL_GEN.disable();
            WATER_WHEEL_GEN.disable();
        }
    }

    static class mapper {
        static FactoryType[] mapping = new FactoryType[128];

        mapper() {
        }
    }
}

