/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.EntityRegistry;
import factorization.fzds.DeltaChunk;
import factorization.shared.Core;
import factorization.shared.Graylist;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class FzConfig {
    public static Configuration config;
    public static boolean render_barrel_item;
    public static boolean render_barrel_text;
    public static boolean render_barrel_use_displaylists;
    public static boolean render_barrel_force_entity_render;
    public static boolean render_barrel_force_no_intercept;
    public static boolean render_barrel_close;
    public static int entity_relight_task_id;
    public static boolean gen_silver_ore;
    public static boolean gen_dark_iron_ore;
    public static int silver_ore_node_new_size;
    public static boolean gen_colossi;
    public static int colossus_spacing;
    public static boolean pocket_craft_anywhere;
    public static String pocketActions;
    public static boolean renderTEs;
    public static boolean renderAO;
    public static boolean add_branding;
    public static boolean debug_light_air;
    public static boolean dimension_slice_allow_smooth;
    public static boolean boilers_suck_water;
    public static double steam_output_adjust;
    public static boolean enable_cheat_commands;
    public static boolean enable_sketchy_client_commands;
    public static int tps_reporting_interval;
    public static boolean use_tps_reports;
    public static float lowest_dilation;
    public static boolean lagssie_watcher;
    public static boolean limit_integrated_server;
    public static double lagssie_interval;
    public static int max_rocket_base_size;
    public static int max_rocket_height;
    public static boolean stretchy_clay;
    public static boolean equal_opportunities_for_mobs;
    public static boolean fix_middle_click;
    public static boolean embarken_wood;
    public static boolean mushroomalize;
    public static boolean proper_projectile_physics;
    public static boolean buffed_nametags;
    public static boolean enable_solar_steam;
    public static boolean fanturpeller_works_on_players;
    public static boolean large_servo_instructions;
    public static boolean players_discover_colossus_guides;
    public static boolean disable_endermen_griefing;
    public static boolean blockundo;
    public static boolean blockundo_grab;
    public static boolean debug_fzds_collisions;
    public static boolean enable_rocketry;
    public static boolean sockets_ignore_front_redstone;
    public static boolean show_time_on_fullscreen;
    public static boolean require_book_for_manual;
    public static boolean infinite_guide_usage;
    public static boolean mirror_sunbeams;
    public static boolean ic2_kinetic_compat;
    public static Graylist<Block> lacerator_block_graylist;
    public static int legendarium_queue_size;
    public static int legendarium_delay_hours;
    public static String f;
    public static boolean enable_retrogen;
    public static String retrogen_key;
    public static boolean retrogen_silver;
    public static boolean retrogen_dark_iron;
    public static boolean sort_renderers;
    public static boolean enableRecipeReflection;
    public ArrayList<Property> editable_main = new ArrayList();
    public ArrayList<Property> editable_runtime = new ArrayList();
    private boolean can_edit_main = false;
    private boolean can_edit_runtime = false;
    public static boolean loaded;

    FzConfig editMain() {
        this.can_edit_main = true;
        return this;
    }

    FzConfig editRun() {
        this.can_edit_runtime = true;
        this.can_edit_main = true;
        return this;
    }

    Property putProp(Property prop, String comment) {
        if (this.can_edit_main) {
            this.editable_main.add(prop);
            this.can_edit_main = false;
        }
        if (this.can_edit_runtime) {
            this.editable_runtime.add(prop);
            this.can_edit_runtime = false;
        }
        if (comment != null && !comment.isEmpty()) {
            prop.comment = comment;
        }
        return prop;
    }

    private int getIntConfig(String name, String category, int defaultValue, String comment) {
        Property prop = this.putProp(config.get(category, name, defaultValue), comment);
        return this.putProp(prop, comment).getInt(defaultValue);
    }

    private boolean getBoolConfig(String name, String category, boolean defaultValue, String comment) {
        Property prop = this.putProp(config.get(category, name, defaultValue), comment);
        return this.putProp(prop, comment).getBoolean(defaultValue);
    }

    private double getDoubleConfig(String name, String category, double defaultValue, String comment) {
        Property prop = this.putProp(config.get(category, name, defaultValue), comment);
        return this.putProp(prop, comment).getDouble(defaultValue);
    }

    private String getStringConfig(String name, String category, String defaultValue, String comment) {
        Property prop = this.putProp(config.get(category, name, defaultValue), comment);
        return this.putProp(prop, comment).getString();
    }

    public void load() {
        if (loaded) {
            return;
        }
        loaded = true;
        this.loadConfig(null);
    }

    public void reload() {
        loaded = false;
        this.load();
    }

    public void loadConfig(File configFile) {
        config = new Configuration(configFile);
        try {
            config.load();
        }
        catch (Exception e) {
            Core.logWarning("Error loading config: %s", e.toString());
            e.printStackTrace();
        }
        this.readConfigSettings();
        this.saveConfigSettings();
    }

    public void saveConfigSettings() {
        if (config.hasChanged()) {
            config.save();
        }
    }

    public void readConfigSettings() {
        debug_light_air = this.getBoolConfig("debugLightAir", "client", debug_light_air, "Show invisible lamp-air");
        pocket_craft_anywhere = this.editRun().getBoolConfig("anywherePocketCraft", "client", pocket_craft_anywhere, "Lets you open the pocket crafting table from GUIs");
        render_barrel_item = this.editMain().getBoolConfig("renderBarrelItem", "client", render_barrel_item, null);
        render_barrel_text = this.editMain().getBoolConfig("renderBarrelText", "client", render_barrel_text, null);
        render_barrel_close = this.editMain().getBoolConfig("renderBarrelClose", "client", render_barrel_close, "If true, render barrel info only when nearby");
        render_barrel_use_displaylists = this.editMain().getBoolConfig("renderBarrelUseDisplayLists", "client", render_barrel_use_displaylists, "If true, use OpenGL display lists for rendering barrels. Setting to false may fix some render issues, at the cost of making barrels render less efficiently");
        render_barrel_force_no_intercept = this.editMain().getBoolConfig("renderBarrelForceNoIntercept", "client", render_barrel_force_no_intercept, "If true, don't use hacks to avoid enchantment effect rendering issues. Setting to false may fix some render issues, at the cost of making the enchantment effect from, eg, enchanted books visible through walls.");
        render_barrel_force_entity_render = this.editMain().getBoolConfig("renderBarrelForceItemFrameStyle", "client", render_barrel_force_entity_render, "If true, render barrels the same way as item frames. Setting to false may fix some render issues, at the cost of looking lame.");
        renderTEs = this.editMain().getBoolConfig("renderOtherTileEntities", "client", renderTEs, "If false, most TEs won't draw, making everything look broken but possibly improving FPS");
        renderAO = this.editMain().getBoolConfig("renderAmbientOcclusion", "client", renderAO, "If false, never use smooth lighting for drawing sculptures");
        String attempt = this.getStringConfig("pocketCraftingActionKeys", "client", pocketActions, "4 keys for: removing (x), cycling (c), balancing (b), filling (f)");
        if (attempt.length() == pocketActions.length()) {
            pocketActions = attempt;
        } else {
            Property p = config.get("pocketCraftingActionKeys", "client", pocketActions);
            p.set(pocketActions);
            p.comment = pocketActions.length() + " keys for: removing (x), cycling (c), balancing (b), filling (f)";
        }
        enable_sketchy_client_commands = this.editRun().getBoolConfig("allowUnpureCommands", "client", enable_sketchy_client_commands, null);
        use_tps_reports = this.editRun().getBoolConfig("useTimeDilation", "client", use_tps_reports, "If this is enabled, the client will run as slowly as the server does. This avoids visual artifacts on laggy servers.");
        lowest_dilation = (float)this.editRun().getDoubleConfig("lowestTimeDilation", "client", lowest_dilation, "Sets a lower bound on time dilation. Between 0 and 1.");
        lowest_dilation = Math.max(1.0f, Math.min(0.0f, lowest_dilation));
        lagssie_watcher = this.getBoolConfig("enableLagWatchDog", "client", lagssie_watcher, "If true, enables a thread that dumps a stack trace of Minecraft if it is paused for longer than lagWatchDogInterval");
        lagssie_interval = this.getDoubleConfig("lagWatchDogInterval", "client", lagssie_interval, "If the game is stuck for longer than this amount of time (in seconds), dump a stacktrace of what it is doing.");
        limit_integrated_server = this.getBoolConfig("limitIntegratedServer", "client", limit_integrated_server, "(Broken; don't use this. Attempts to limit integrated server tick speed to match the client's, but can cause deadlocks.)");
        large_servo_instructions = this.editMain().getBoolConfig("largeServoInstructions", "client", large_servo_instructions, "Render servo instructions extra-large. This can also be toggled on and off using '/f servoInstructionSize'.");
        show_time_on_fullscreen = this.editRun().getBoolConfig("showTimeOnFullscreen", "client", show_time_on_fullscreen, "If true, show the time every half hour");
        mirror_sunbeams = this.editRun().getBoolConfig("drawMirrorSunbeams", "client", mirror_sunbeams, "If false, mirrors won't draw sunbeams");
        sort_renderers = this.getBoolConfig("sortRenderers", "client", sort_renderers, "Use advanced Entity & TileEntity sorting techniques to optimize rendering, particularly for FZ entities.");
        enableRecipeReflection = this.getBoolConfig("enableRecipeReflection", "client", enableRecipeReflection, "If true, java reflection will be used as an (ugly) fallback for getting recipe information from unknown recipes");
        add_branding = this.getBoolConfig("addBranding", "general", add_branding, null);
        gen_silver_ore = this.getBoolConfig("generateSilverOre", "general", gen_silver_ore, "Set to false to disable silver ore generation");
        int config_silver_size = this.getIntConfig("silverOreNodeNewSize", "general", silver_ore_node_new_size, "The size of silver ore nodes. Between 5 & 35. Default is " + silver_ore_node_new_size);
        silver_ore_node_new_size = Math.max(5, Math.min(config_silver_size, 35));
        gen_dark_iron_ore = this.getBoolConfig("generateDarkIronOre", "general", gen_dark_iron_ore, "Set to false to disable dark iron ore generation");
        gen_colossi = this.getBoolConfig("generateColossi", "general", gen_colossi, "If true, Colossi will generate in the world. If false, the player will be given an LMP instead of a lost map.");
        colossus_spacing = this.getIntConfig("colossusSpacing", "general", colossus_spacing, "Distance between colossi in chunks");
        enable_retrogen = this.getBoolConfig("enableRetrogen", "retrogen", enable_retrogen, null);
        retrogen_key = this.getStringConfig("retrogenKey", "retrogen", retrogen_key, null);
        retrogen_silver = this.getBoolConfig("retrogenSilver", "retrogen", retrogen_silver, null);
        retrogen_dark_iron = this.getBoolConfig("retrogenDarkIron", "retrogen", retrogen_dark_iron, null);
        entity_relight_task_id = config.get("general", "entityRelightTask", -1).getInt();
        if (entity_relight_task_id == -1) {
            entity_relight_task_id = EntityRegistry.findGlobalUniqueEntityId();
            Property prop = config.get("general", "entityRelightTask", entity_relight_task_id);
            prop.set(entity_relight_task_id);
        }
        boilers_suck_water = this.getBoolConfig("boilersSuckWater", "server", boilers_suck_water, "If false, water must be piped in");
        disable_endermen_griefing = this.getBoolConfig("disableEndermenGriefing", "server", disable_endermen_griefing, "If set to true, then endermen will not pick up blocks.");
        steam_output_adjust = this.getDoubleConfig("steamOutputAdjustment", "server", steam_output_adjust, "Scale how much steam is produced by the solar boiler");
        stretchy_clay = this.getBoolConfig("stretchyClay", "server", stretchy_clay, "If true, maximum clay lump volume is 1 m\u00b3 instead of (1 m\u00b3)/4");
        tps_reporting_interval = this.getIntConfig("tpsReportInterval", "server", tps_reporting_interval, "How many ticks the server will wait before sending out TPS reports. 20 ticks = 1 second, unless it's lagging.");
        equal_opportunities_for_mobs = this.getBoolConfig("equalOpportunitiesForMobs", "server", equal_opportunities_for_mobs, "Causes some mobs to rarely spawn wearing your armor");
        embarken_wood = this.getBoolConfig("barkRecipes", "server", embarken_wood, "Adds recipes for bark variants of logs");
        mushroomalize = this.getBoolConfig("mushroomNormalize", "server", mushroomalize, "Textures giant mushroom blocks when placed");
        blockundo = this.getBoolConfig("blockUndo", "server", blockundo, "If true, then recently placed blocks break easily");
        blockundo_grab = this.getBoolConfig("blockUndoGrab", "server", blockundo_grab, "If true, then blocks broken with blockundo will be instantly picked up");
        config.getCategory("server").remove((Object)"hotBlocks");
        config.getCategory("server").remove((Object)"hotBlocksGrab");
        proper_projectile_physics = this.getBoolConfig("properProjectilePhysics", "server", proper_projectile_physics, "Makes projectiles start with the velocity of the thrower");
        buffed_nametags = this.getBoolConfig("buffedNametags", "server", buffed_nametags, "Naming entities gives them +5 hearts");
        players_discover_colossus_guides = this.getBoolConfig("playersDiscoverColossusGuides", "server", players_discover_colossus_guides, "If set to true, players will find a lost map after getting the diamonds achievement. If colossi are disabled, they'll get an LMP instead.");
        infinite_guide_usage = this.getBoolConfig("infiniteGuideUse", "server", infinite_guide_usage, "If set to true, the Lost Map won't take damage");
        enable_solar_steam = this.getBoolConfig("enableSolarSteam", "server", enable_solar_steam, "Set to false to disable the crafting recipe for solar2steam machines");
        fanturpeller_works_on_players = this.getBoolConfig("fanturpellerWorksOnPlayers", "server", fanturpeller_works_on_players, "If set to false, fanturpellers will not move players.");
        sockets_ignore_front_redstone = this.getBoolConfig("socketsIgnoreFacePower", "server", sockets_ignore_front_redstone, "Set to false to let socket blocks detect redstone from their front; provided for legacy worlds.");
        require_book_for_manual = this.getBoolConfig("requireBookForManual", "general", require_book_for_manual, "If set to true, then you must have a manual in your inventory to look up items");
        lacerator_block_graylist = Graylist.ofBlocks(this.getStringConfig("laceratorBlockGraylist", "server", "-minecraft:bedrock,minecraft:end_portal", "Comma-separated list of block names. In front of the list must be either a +, for white-listing, or a -, for black-listing."));
        f = this.getStringConfig("miscClientCommand", "client", f, "Use this to change the /f command to avoid conflict with the Factions bukkit plugin");
        ic2_kinetic_compat = this.getBoolConfig("ic2KineticCompat", "server", ic2_kinetic_compat, "Compatability with IC2's IKineticSource");
        this.getStringConfig("README", "fzds", "See hammerChannels.cfg for FZDS-related configuration", "");
        legendarium_delay_hours = this.getIntConfig("legendariumDelayHours", "server", legendarium_delay_hours, "How many hours must pass before the legendarium can be used again");
        legendarium_queue_size = this.getIntConfig("legendariumQueueSize", "server", legendarium_queue_size, "The legendarium must have this many items before an artifact can be reforged.");
        if (!DeltaChunk.enabled()) {
            gen_colossi = false;
            enable_rocketry = false;
        }
    }

    static {
        render_barrel_item = true;
        render_barrel_text = true;
        render_barrel_use_displaylists = true;
        render_barrel_force_entity_render = false;
        render_barrel_force_no_intercept = false;
        render_barrel_close = false;
        entity_relight_task_id = -1;
        gen_silver_ore = true;
        gen_dark_iron_ore = true;
        silver_ore_node_new_size = 18;
        gen_colossi = true;
        colossus_spacing = 48;
        pocket_craft_anywhere = true;
        pocketActions = "xcbf";
        renderTEs = true;
        renderAO = true;
        add_branding = false;
        debug_light_air = false;
        dimension_slice_allow_smooth = true;
        boilers_suck_water = true;
        steam_output_adjust = 1.0;
        enable_cheat_commands = Core.dev_environ;
        enable_sketchy_client_commands = true;
        tps_reporting_interval = 20;
        use_tps_reports = true;
        lowest_dilation = 0.6f;
        lagssie_watcher = false;
        limit_integrated_server = false;
        lagssie_interval = 0.25;
        max_rocket_base_size = 400;
        max_rocket_height = 64;
        stretchy_clay = true;
        equal_opportunities_for_mobs = true;
        fix_middle_click = false;
        embarken_wood = true;
        mushroomalize = true;
        proper_projectile_physics = true;
        buffed_nametags = true;
        enable_solar_steam = true;
        fanturpeller_works_on_players = true;
        large_servo_instructions = false;
        players_discover_colossus_guides = true;
        disable_endermen_griefing = false;
        blockundo = true;
        blockundo_grab = true;
        debug_fzds_collisions = false;
        enable_rocketry = Core.dev_environ;
        sockets_ignore_front_redstone = true;
        show_time_on_fullscreen = true;
        require_book_for_manual = true;
        infinite_guide_usage = false;
        mirror_sunbeams = true;
        ic2_kinetic_compat = true;
        legendarium_queue_size = 7;
        legendarium_delay_hours = 120;
        f = "f";
        enable_retrogen = false;
        retrogen_key = "DEFAULT";
        retrogen_silver = false;
        retrogen_dark_iron = false;
        sort_renderers = !Loader.isModLoaded((String)"optifine");
        enableRecipeReflection = true;
        loaded = false;
    }
}

