/*
 * Decompiled with CFR 0.152.
 */
package factorization.compat;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import factorization.compat.CompatBase;
import factorization.shared.Core;
import java.util.ArrayList;
import java.util.Locale;

public class CompatModuleLoader
extends CompatBase {
    ArrayList<CompatBase> modules = new ArrayList();
    String[] mod_compats = new String[]{"IC2", "Railcraft", "erebus"};
    String base_name = this.getClass().getCanonicalName().replace(this.getClass().getSimpleName(), "");

    public void loadCompat() {
        ClassLoader cl = this.getClass().getClassLoader();
        for (String mod : this.mod_compats) {
            if (!Loader.isModLoaded((String)mod)) {
                Core.logInfo(mod + " not loaded; not loading compatibility module", new Object[0]);
                continue;
            }
            try {
                String name = this.base_name + mod.toLowerCase(Locale.ROOT) + ".Compat_" + mod;
                Class<?> compatClass = cl.loadClass(name);
                this.modules.add((CompatBase)compatClass.newInstance());
            }
            catch (Throwable e) {
                Core.logWarning("Failed to load compatability module for " + mod, new Object[0]);
                e.printStackTrace();
                continue;
            }
            Core.logInfo(mod + " compatibility module loaded", new Object[0]);
        }
    }

    @Override
    public void preinit(FMLPreInitializationEvent event) {
        for (CompatBase mod : this.modules) {
            try {
                mod.preinit(event);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        for (CompatBase mod : this.modules) {
            try {
                mod.init(event);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public void postinit(FMLPostInitializationEvent event) {
        for (CompatBase mod : this.modules) {
            try {
                mod.postinit(event);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

