/*
 * Decompiled with CFR 0.152.
 */
package factorization.compat.ic2;

import factorization.api.IRotationalEnergySource;
import factorization.api.adapter.Adapter;
import ic2.api.energy.tile.IKineticSource;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class RotationalEnergySourceAdapter
implements Adapter<TileEntity, IRotationalEnergySource> {
    @Override
    public IRotationalEnergySource adapt(TileEntity val) {
        return new Kinetic2Rotational(val, (IKineticSource)val);
    }

    @Override
    public boolean canAdapt(Class<?> valClass) {
        return IKineticSource.class.isAssignableFrom(valClass);
    }

    @Override
    public int priority() {
        return 0;
    }

    private static class Kinetic2Rotational
    implements IRotationalEnergySource {
        public static double IC2_FZ_RATIO = 1500.0;
        public static double IC2_ANGULAR_VELOCITY_RATIO = 0.001;
        private final TileEntity baseTe;
        private final IKineticSource base;
        private int last_velocity = 0;

        private Kinetic2Rotational(TileEntity baseTe, IKineticSource base) {
            this.baseTe = baseTe;
            this.base = base;
        }

        @Override
        public boolean canConnect(ForgeDirection direction) {
            return true;
        }

        @Override
        public double availableEnergy(ForgeDirection direction) {
            return (double)this.base.maxrequestkineticenergyTick(direction) / IC2_FZ_RATIO;
        }

        @Override
        public double takeEnergy(ForgeDirection direction, double maxPower) {
            int avail;
            this.last_velocity = avail = this.base.requestkineticenergy(direction, (int)(maxPower * IC2_FZ_RATIO));
            return (double)avail / IC2_FZ_RATIO;
        }

        @Override
        public double getVelocity(ForgeDirection direction) {
            double v = (double)this.last_velocity * IC2_ANGULAR_VELOCITY_RATIO;
            if (v > 0.39269908169872414) {
                v = 0.39269908169872414;
            }
            if (v < -0.39269908169872414) {
                v = -0.39269908169872414;
            }
            return v;
        }

        @Override
        public boolean isTileEntityInvalid() {
            return this.baseTe.func_145837_r();
        }
    }
}

