/*
 * Decompiled with CFR 0.152.
 */
package factorization.coremod;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import factorization.coremod.AbstractAsmClassTransform;
import factorization.coremod.AbstractAsmMethodTransform;
import factorization.coremod.MethodSplices;
import factorization.fzds.HammerEnabled;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.TraceClassVisitor;

public class ASMTransformer
implements IClassTransformer {
    public static boolean dev_environ = Launch.blackboard != null ? (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") : false;
    static AbstractAsmClassTransform[] EMPTY = new AbstractAsmClassTransform[0];
    List<MethodNode> apendeeMethods = null;
    static HashMap<Integer, String> opcodeNameMap = new HashMap();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.client.gui.inventory.GuiContainer")) {
            return this.applyTransform(basicClass, new AbstractAsmMethodTransform.Append(name, transformedName, "func_73869_a", "keyTyped"));
        }
        if (transformedName.equals("net.minecraft.block.Block")) {
            return this.applyTransform(basicClass, new AbstractAsmMethodTransform.Append(name, transformedName, "func_149723_a", "onBlockDestroyedByExplosion"), new AbstractAsmMethodTransform.Append(name, transformedName, "func_149659_a", "canDropFromExplosion"));
        }
        if (transformedName.equals("net.minecraft.client.Minecraft") && HammerEnabled.ENABLED) {
            return this.applyTransform(basicClass, new AbstractAsmMethodTransform.Prepend(name, transformedName, "func_147116_af", "func_147116_af"), new AbstractAsmMethodTransform.Prepend(name, transformedName, "func_147121_ag", "func_147121_ag"));
        }
        if (transformedName.equals("net.minecraft.client.renderer.EntityRenderer") && HammerEnabled.ENABLED) {
            try {
                return this.applyTransform(basicClass, new AbstractAsmMethodTransform.MutateCall(name, transformedName, "func_78467_g", "orientCamera").setOwner("net.minecraft.client.multiplayer.WorldClient").setName("rayTraceBlocks", "func_72933_a", "a").setDescr("(Lnet/minecraft/util/Vec3;Lnet/minecraft/util/Vec3;)Lnet/minecraft/util/MovingObjectPosition;", "(Lazw;Lazw;)Lazu;"));
            }
            catch (RuntimeException e) {
                this.log("WARNING: Transformation to " + transformedName + " failed!");
                this.log("This is lame, but ignorable: the camera will pass through solid FZDS blocks in 3rd-person view.");
                e.printStackTrace();
            }
        }
        if (transformedName.equals("net.minecraft.world.chunk.Chunk") && HammerEnabled.ENABLED) {
            return this.applyTransform(basicClass, new AbstractAsmClassTransform.Mixin("factorization.coremodhooks.MixinExtraChunkData", "Lfactorization/coremodhooks/MixinExtraChunkData;"), new AbstractAsmMethodTransform.Append(name, transformedName, "func_76588_a", "getEntitiesWithinAABBForEntity"));
        }
        if (transformedName.equals("net.minecraft.world.World") && HammerEnabled.ENABLED) {
            try {
                return this.applyTransform(basicClass, new AbstractAsmMethodTransform.Append(name, transformedName, "func_72829_c", "checkBlockCollision"));
            }
            catch (RuntimeException e) {
                this.log("WARNING: Transformation to " + transformedName + " failed!");
                this.log("This is lame, but (kind-of?) ignorable: you may be kicked for flying when standing on FZDS blocks ");
                e.printStackTrace();
            }
        }
        if (transformedName.equals("net.minecraft.entity.Entity") && HammerEnabled.ENABLED) {
            return this.applyTransform(basicClass, new AbstractAsmClassTransform.Mixin("factorization.coremodhooks.MixinEntityKinematicsTracker", "Lfactorization/coremodhooks/MixinEntityKinematicsTracker;"), new AbstractAsmMethodTransform[0]);
        }
        if (transformedName.equals("net.minecraft.world.Explosion") && HammerEnabled.ENABLED) {
            return this.applyTransform(basicClass, new AbstractAsmMethodTransform.MutateCall(name, transformedName, "func_77278_a", "doExplosionA").setOwner("net.minecraft.enchantment.EnchantmentProtection").setName("func_92092_a", "func_92092_a", "a").setDescr("(Lnet/minecraft/entity/Entity;D)D", "(Lsa;D)D"));
        }
        if (transformedName.equals("net.minecraft.client.multiplayer.WorldClient") && HammerEnabled.ENABLED) {
            try {
                return this.applyTransform(basicClass, new AbstractAsmMethodTransform.MutateCall(name, transformedName, "<init>", "<init>").setOwner("cpw.mods.fml.common.eventhandler.EventBus").setName("post", "post", "post").setDescr("(Lcpw/mods/fml/common/eventhandler/Event;)Z", "(Lcpw/mods/fml/common/eventhandler/Event;)Z"));
            }
            catch (RuntimeException e) {
                if (FMLClientHandler.instance().hasOptifine()) {
                    this.log("WorldClient FZDS patch failed! This is due to the presence of OptiFine. Minimap mods may crash, however - you'll need to choose one or the other if so.");
                    e.printStackTrace();
                }
                this.log("WorldClient FZDS patch failed! The reason is not known. Minimap mods may crash, however.");
                e.printStackTrace();
            }
        }
        if (transformedName.equals("net.minecraft.block.BlockRailBase") && !Boolean.parseBoolean(System.getProperty("fz.disableRailStairs"))) {
            return this.applyTransform(basicClass, new AbstractAsmClassTransform.Mixin("factorization.coremodhooks.MixinRailStairs", "Lfactorization/coremodhooks/MixinRailStairs;"), new AbstractAsmMethodTransform[0]);
        }
        if (transformedName.equals("cofh.tweak.asmhooks.HooksCore")) {
            String n = "CoFHTweaks_FZ_Hook";
            return this.applyTransform(basicClass, new AbstractAsmMethodTransform.Append(name, transformedName, n, n));
        }
        return basicClass;
    }

    byte[] applyTransform(byte[] basicClass, AbstractAsmMethodTransform ... changes) {
        return this.applyTransform(basicClass, EMPTY, changes);
    }

    byte[] applyTransform(byte[] basicClass, AbstractAsmClassTransform ct, AbstractAsmMethodTransform ... changes) {
        return this.applyTransform(basicClass, new AbstractAsmClassTransform[]{ct}, changes);
    }

    static String renameMethod(String name, String className) {
        if (!name.equals("<init>")) {
            return name;
        }
        return className.replace(".", "$") + "$init";
    }

    byte[] applyTransform(byte[] basicClass, AbstractAsmClassTransform[] classChanges, AbstractAsmMethodTransform ... changes) {
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        for (AbstractAsmClassTransform classTransformer : classChanges) {
            classTransformer.apply(cn);
        }
        for (MethodNode m : cn.methods) {
            for (AbstractAsmMethodTransform change : changes) {
                if (!change.applies(m)) continue;
                MethodNode method = this.getMethod(ASMTransformer.renameMethod(change.srgName, change.obfClassName));
                change.apply(m, method);
                change.satisfied = true;
            }
        }
        for (AbstractAsmMethodTransform change : changes) {
            if (change.satisfied) continue;
            throw new RuntimeException("Unable to find method " + cn.name + "." + change.srgName + " (" + change.mcpName + ")");
        }
        int flags = 0;
        if (dev_environ) {
            flags |= 3;
        }
        ClassWriter cw = new ClassWriter(cr, flags);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    public static ClassNode readClass(String classname) {
        LaunchClassLoader rcl = (LaunchClassLoader)ASMTransformer.class.getClassLoader();
        try {
            byte[] classBytes = rcl.getClassBytes(classname);
            ClassReader cr = new ClassReader(classBytes);
            ClassNode cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            return cn;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    MethodNode getMethod(String methodName) {
        if (this.apendeeMethods == null) {
            ClassNode cn = ASMTransformer.readClass(MethodSplices.class.getCanonicalName());
            this.apendeeMethods = cn.methods;
        }
        for (MethodNode m : this.apendeeMethods) {
            if (!m.name.equals(methodName)) continue;
            return m;
        }
        throw new RuntimeException("Couldn't find method " + methodName);
    }

    static void printInstructions(AbstractInsnNode ins) {
        while (ins != null) {
            int code = ins.getOpcode();
            if (code != -1) {
                Object o = opcodeNameMap.get(code);
                if (o == null) {
                    o = code;
                }
                System.out.println(o + "  " + ins);
            } else if (ins instanceof JumpInsnNode) {
                System.out.println("Jump to " + ((JumpInsnNode)ins).label.getLabel());
            } else if (ins instanceof LabelNode) {
                System.out.println("Label: " + ((LabelNode)ins).getLabel());
            } else {
                System.out.println(ins);
            }
            ins = ins.getNext();
        }
    }

    static void dumpASM(byte[] basicClass) {
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        ClassWriter cw = new ClassWriter(3);
        cn.accept((ClassVisitor)cw);
        File f = new File("/tmp/ASM/" + cn.name.replace("/", "_"));
        try {
            FileOutputStream os = new FileOutputStream(f);
            cr.accept((ClassVisitor)new TraceClassVisitor(new PrintWriter(os)), 0);
            os.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    void log(Object msg) {
        FMLRelaunchLog.info((String)msg.toString(), (Object[])new Object[0]);
    }

    static {
        boolean started = false;
        for (Field f : Opcodes.class.getFields()) {
            if (!started) {
                if (f.getName() != "NOP") continue;
                started = true;
            }
            try {
                opcodeNameMap.put(f.getInt(null), f.getName());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

