/*
 * Decompiled with CFR 0.152.
 */
package factorization.coremod;

import factorization.coremod.ASMTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class AbstractAsmClassTransform {
    public abstract void apply(ClassNode var1);

    public static class Mixin
    extends AbstractAsmClassTransform {
        ClassNode mixin;
        String mixinName;
        String slashedMixinName;
        String mangledMixinName;

        public Mixin(String mixinName, String mangledMixinName) {
            this.mixinName = mixinName;
            this.slashedMixinName = mixinName.replace(".", "/");
            this.mangledMixinName = mangledMixinName;
            this.mixin = ASMTransformer.readClass(mixinName);
        }

        @Override
        public void apply(ClassNode parent) {
            if (this.mixin.fields != null) {
                for (FieldNode field : this.mixin.fields) {
                    parent.fields.add(field);
                }
            }
            if (this.mixin.methods != null) {
                for (MethodNode method : this.mixin.methods) {
                    if (method.name.equals("<init>")) continue;
                    parent.methods.add(method);
                    for (LocalVariableNode var : method.localVariables) {
                        if (!var.desc.equals(this.mangledMixinName)) continue;
                        var.desc = "L" + parent.name + ";";
                    }
                    for (AbstractInsnNode insn : method.instructions) {
                        if (!(insn instanceof FieldInsnNode)) continue;
                        FieldInsnNode field = (FieldInsnNode)insn;
                        if (field.desc.equals(this.mangledMixinName)) {
                            field.desc = parent.name;
                        }
                        if (!field.owner.equals(this.slashedMixinName)) continue;
                        field.owner = parent.name;
                    }
                }
            }
            if (this.mixin.interfaces != null) {
                for (String interf : this.mixin.interfaces) {
                    parent.interfaces.add(interf);
                }
            }
            if (this.mixin.visibleAnnotations != null) {
                for (AnnotationNode annotation : this.mixin.visibleAnnotations) {
                    parent.visibleAnnotations.add(annotation);
                }
            }
            if (this.mixin.invisibleAnnotations != null) {
                for (AnnotationNode annotation : this.mixin.invisibleAnnotations) {
                    parent.invisibleAnnotations.add(annotation);
                }
            }
        }
    }
}

