/*
 * Decompiled with CFR 0.152.
 */
package factorization.coremod;

import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import factorization.coremod.ASMTransformer;
import factorization.coremod.LoadingPlugin;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

abstract class AbstractAsmMethodTransform {
    protected final String obfClassName;
    final String srgName;
    final String mcpName;
    boolean satisfied = false;

    AbstractAsmMethodTransform(String obfClassName, String srgClassName, String srgName, String mcpName) {
        this.obfClassName = obfClassName;
        this.srgName = srgName;
        this.mcpName = mcpName;
    }

    boolean applies(MethodNode method) {
        if (LoadingPlugin.deobfuscatedEnvironment) {
            return method.name.equals(this.mcpName);
        }
        String method_as_srg = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(this.obfClassName, method.name, method.desc);
        return this.srgName.equals(method_as_srg);
    }

    abstract void apply(MethodNode var1, MethodNode var2);

    static boolean isReturn(int op) {
        return op == 172 || op == 173 || op == 174 || op == 175 || op == 176 || op == 177;
    }

    static class MutateCall
    extends AbstractAsmMethodTransform {
        private String find_notch_owner;
        private String find_mcp_owner;
        private String find_mcp_name;
        private String find_mcp_descr;
        private String find_srg_name;
        private String find_notch_name;
        private String find_notch_desc;
        private String find_mcp_desc;

        MutateCall(String obfClassName, String srgClassName, String srgName, String mcpName) {
            super(obfClassName, srgClassName, srgName, mcpName);
        }

        public MutateCall setOwner(String owner) {
            this.find_mcp_owner = owner.replace(".", "/");
            if (!ASMTransformer.dev_environ) {
                owner = FMLDeobfuscatingRemapper.INSTANCE.unmap(this.find_mcp_owner);
            }
            this.find_notch_owner = owner.replace(".", "/");
            return this;
        }

        public MutateCall setName(String mcp_name, String srg_name, String notch_name) {
            this.find_srg_name = srg_name;
            this.find_mcp_name = mcp_name;
            this.find_notch_name = notch_name;
            return this;
        }

        public MutateCall setDescr(String mcp_desc, String notch_desc) {
            this.find_mcp_desc = mcp_desc;
            this.find_notch_desc = notch_desc;
            return this;
        }

        @Override
        void apply(MethodNode base, MethodNode addition) {
            boolean any = false;
            InsnList instructions = base.instructions;
            for (AbstractInsnNode insn = instructions.getFirst(); insn != null; insn = insn.getNext()) {
                boolean match;
                int op = insn.getOpcode();
                if (op != 182 && op != 184) continue;
                MethodInsnNode meth = (MethodInsnNode)insn;
                String name = meth.name;
                if (!meth.desc.equals(this.find_mcp_desc) && !meth.desc.equals(this.find_notch_desc)) continue;
                boolean bl = match = !(!meth.owner.equals(this.find_notch_owner) && !meth.owner.equals(this.find_mcp_owner) || !name.equals(this.find_mcp_name) && !name.equals(this.find_srg_name) && !name.equals(this.find_notch_name));
                if (!match) continue;
                meth.setOpcode(184);
                meth.owner = "factorization/coremod/MethodSplices";
                meth.name = addition.name;
                meth.desc = addition.desc;
                any = true;
            }
            if (!any) {
                throw new RuntimeException("Method mutation failed: did not find " + this.find_mcp_owner + "." + this.find_mcp_name + " / " + this.find_mcp_desc);
            }
        }
    }

    static class Prepend
    extends AbstractAsmMethodTransform {
        Prepend(String obfClassName, String srgClassName, String srgName, String mcpName) {
            super(obfClassName, srgClassName, srgName, mcpName);
        }

        @Override
        void apply(MethodNode base, MethodNode addition) {
            AbstractInsnNode head = base.instructions.getFirst();
            AbstractInsnNode addition_end = addition.instructions.getLast();
            while (!Prepend.isReturn(addition_end.getOpcode())) {
                addition_end = addition_end.getPrevious();
            }
            while (Prepend.isReturn(addition_end.getOpcode())) {
                addition_end = addition_end.getPrevious();
            }
            AbstractInsnNode cleaner = addition_end.getNext();
            while (cleaner != null) {
                AbstractInsnNode next = cleaner.getNext();
                addition.instructions.remove(cleaner);
                cleaner = next;
            }
            base.instructions.insertBefore(head, addition.instructions);
        }
    }

    static class Append
    extends AbstractAsmMethodTransform {
        Append(String obfClassName, String srgClassName, String srgName, String mcpName) {
            super(obfClassName, srgClassName, srgName, mcpName);
        }

        @Override
        void apply(MethodNode base, MethodNode addition) {
            AbstractInsnNode base_end = base.instructions.getLast();
            while (!Append.isReturn(base_end.getOpcode())) {
                base_end = base_end.getPrevious();
            }
            AbstractInsnNode ins = addition.instructions.getFirst();
            while (ins != null) {
                AbstractInsnNode next = ins.getNext();
                if (!(ins instanceof LineNumberNode)) {
                    base.instructions.insertBefore(base_end, ins);
                }
                ins = next;
            }
            base.instructions.remove(base_end);
        }
    }
}

