/*
 * Decompiled with CFR 0.152.
 */
package factorization.coremodhooks;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventBus;
import factorization.coremodhooks.HandleAttackKeyEvent;
import factorization.coremodhooks.HandleUseKeyEvent;
import factorization.coremodhooks.IExtraChunkData;
import factorization.coremodhooks.UnhandledGuiKeyEvent;
import factorization.util.SpaceUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public class HookTargetsClient {
    public static ThreadLocal<Boolean> clientWorldLoadEventAbort = new ThreadLocal();

    public static void keyTyped(char chr, int keysym) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null) {
            return;
        }
        MinecraftForge.EVENT_BUS.post((Event)new UnhandledGuiKeyEvent(chr, keysym, (EntityPlayer)mc.field_71439_g, mc.field_71462_r));
    }

    public static boolean attackButtonPressed() {
        return MinecraftForge.EVENT_BUS.post((Event)new HandleAttackKeyEvent());
    }

    public static boolean useButtonPressed() {
        return MinecraftForge.EVENT_BUS.post((Event)new HandleUseKeyEvent());
    }

    private static boolean hasColliders(World world, Vec3 traceStart) {
        Chunk c = world.func_72938_d((int)traceStart.field_72450_a, (int)traceStart.field_72449_c);
        if (c == null) {
            return false;
        }
        IExtraChunkData cd = (IExtraChunkData)c;
        Entity[] colliders = cd.getConstantColliders();
        return colliders != null && colliders.length != 0;
    }

    public static MovingObjectPosition boxTrace(World world, Vec3 traceStart, Vec3 traceEnd) {
        MovingObjectPosition ret = world.func_72933_a(SpaceUtil.copy(traceStart), SpaceUtil.copy(traceEnd));
        if (!HookTargetsClient.hasColliders(world, traceStart) && !HookTargetsClient.hasColliders(world, traceEnd)) {
            return ret;
        }
        Entity box = new Entity(world){

            protected void func_70088_a() {
            }

            protected void func_70037_a(NBTTagCompound tag) {
            }

            protected void func_70014_b(NBTTagCompound tag) {
            }
        };
        double d = 0.2;
        box.func_70107_b(traceStart.field_72450_a, traceStart.field_72448_b, traceStart.field_72449_c);
        box.field_70121_D.field_72340_a = traceStart.field_72450_a - d;
        box.field_70121_D.field_72338_b = traceStart.field_72448_b - d;
        box.field_70121_D.field_72339_c = traceStart.field_72449_c - d;
        box.field_70121_D.field_72336_d = traceStart.field_72450_a + d;
        box.field_70121_D.field_72337_e = traceStart.field_72448_b + d;
        box.field_70121_D.field_72334_f = traceStart.field_72449_c + d;
        double dx = traceEnd.field_72450_a - traceStart.field_72450_a;
        double dy = traceEnd.field_72448_b - traceStart.field_72448_b;
        double dz = traceEnd.field_72449_c - traceStart.field_72449_c;
        int iterations = 8;
        double meh = 1.0 / (double)(iterations + 1);
        for (int i = 0; i < iterations; ++i) {
            box.func_70091_d(dx * meh, dy * meh, dz * meh);
        }
        Vec3 hit = Vec3.func_72443_a((double)box.field_70165_t, (double)box.field_70163_u, (double)box.field_70161_v);
        box.field_70121_D.field_72340_a = box.field_70165_t - d;
        box.field_70121_D.field_72338_b = box.field_70163_u - d;
        box.field_70121_D.field_72339_c = box.field_70161_v - d;
        box.field_70121_D.field_72336_d = box.field_70165_t + d;
        box.field_70121_D.field_72337_e = box.field_70163_u + d;
        box.field_70121_D.field_72334_f = box.field_70161_v + d;
        if (ret == null || ret.field_72307_f == null || ret.field_72313_a == MovingObjectPosition.MovingObjectType.MISS) {
            return new MovingObjectPosition(null, hit);
        }
        double retLen = ret.field_72307_f.func_72433_c();
        if (retLen * retLen > (dx = box.field_70165_t - traceStart.field_72450_a) * dx + (dy = box.field_70163_u - traceStart.field_72448_b) * dy + (dz = box.field_70161_v - traceStart.field_72449_c) * dz) {
            return ret;
        }
        return new MovingObjectPosition(null, hit);
    }

    public static boolean abortClientLoadEvent(EventBus bus, WorldEvent.Load event) {
        if (clientWorldLoadEventAbort.get() == Boolean.TRUE) {
            return false;
        }
        return bus.post((Event)event);
    }
}

