/*
 * Decompiled with CFR 0.152.
 */
package factorization.coremodhooks;

import factorization.api.Coord;
import factorization.coremodhooks.IExtraChunkData;
import factorization.shared.Core;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class HookTargetsServer {
    public static void diamondExploded(Object dis, World world, int x, int y, int z) {
        int spawn;
        if (dis != Blocks.field_150484_ah) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        Coord c = new Coord(world, x, y, z);
        c.setAir();
        for (int i = 18; i > 0; i -= spawn) {
            spawn = world.field_73012_v.nextInt(3) + 2;
            spawn = Math.min(spawn, i);
            Entity ent = c.spawnItem(new ItemStack((Item)Core.registry.diamond_shard, spawn));
            ent.field_83001_bt = true;
            ent.field_70159_w = HookTargetsServer.randShardVelocity(world);
            ent.field_70181_x = HookTargetsServer.randShardVelocity(world);
            ent.field_70179_y = HookTargetsServer.randShardVelocity(world);
        }
    }

    private static double randShardVelocity(World world) {
        double max;
        double r = world.field_73012_v.nextGaussian() / 4.0;
        if (r > (max = 0.3)) {
            r = max;
        } else if (r < -max) {
            r = -max;
        }
        return r;
    }

    public static void addConstantColliders(Object me, Entity collider, AxisAlignedBB box, List found, IEntitySelector filter) {
        Entity[] constant_colliders = ((IExtraChunkData)me).getConstantColliders();
        if (constant_colliders == null) {
            return;
        }
        for (Entity ent : constant_colliders) {
            if (ent == collider || filter != null && !filter.func_82704_a(ent)) continue;
            found.add(ent);
            Entity[] parts = ent.func_70021_al();
            if (parts == null) continue;
            for (Entity part : parts) {
                found.add(part);
            }
        }
    }

    public static void addConstantCollidersCOFH(Object me, Entity collider, AxisAlignedBB box, List found) {
        Entity[] constant_colliders = ((IExtraChunkData)me).getConstantColliders();
        if (constant_colliders == null) {
            return;
        }
        for (Entity ent : constant_colliders) {
            Entity[] parts;
            if (ent == collider) continue;
            AxisAlignedBB bb = ent.func_70046_E();
            if (bb != null && bb.func_72326_a(box)) {
                found.add(bb);
            }
            if ((parts = ent.func_70021_al()) == null) continue;
            for (Entity part : parts) {
                bb = part.func_70046_E();
                if (bb == null || !bb.func_72326_a(box)) continue;
                found.add(bb);
            }
        }
    }

    public static boolean checkHammerCollision(World world, AxisAlignedBB box) {
        Chunk c4;
        Chunk c3;
        Chunk c2;
        int minX = MathHelper.func_76128_c((double)box.field_72340_a);
        int minZ = MathHelper.func_76128_c((double)box.field_72339_c);
        int maxX = MathHelper.func_76128_c((double)(box.field_72336_d + 1.0));
        int maxZ = MathHelper.func_76128_c((double)(box.field_72334_f + 1.0));
        if (box.field_72340_a < 0.0) {
            --minX;
        }
        if (box.field_72339_c < 0.0) {
            --minZ;
        }
        boolean expanded = false;
        Chunk c1 = world.func_72938_d(minX, minZ);
        if (HookTargetsServer.workableChunk(c1)) {
            expanded = true;
            if (HookTargetsServer.collides((IExtraChunkData)c1, box = box.func_72314_b(1.0, 1.0, 1.0))) {
                return true;
            }
        }
        if ((c2 = world.func_72938_d(minX, maxZ)) != c1 && HookTargetsServer.workableChunk(c2)) {
            if (!expanded) {
                expanded = true;
                box = box.func_72314_b(1.0, 1.0, 1.0);
            }
            if (HookTargetsServer.collides((IExtraChunkData)c2, box)) {
                return true;
            }
        }
        if ((c3 = world.func_72938_d(maxX, minZ)) != c2 && c3 != c1 && HookTargetsServer.workableChunk(c3)) {
            if (!expanded) {
                expanded = true;
                box = box.func_72314_b(1.0, 1.0, 1.0);
            }
            if (HookTargetsServer.collides((IExtraChunkData)c3, box)) {
                return true;
            }
        }
        if ((c4 = world.func_72938_d(maxX, maxZ)) != c3 && c4 != c2 && c4 != c1 && HookTargetsServer.workableChunk(c4)) {
            if (!expanded) {
                expanded = true;
                box = box.func_72314_b(1.0, 1.0, 1.0);
            }
            if (HookTargetsServer.collides((IExtraChunkData)c4, box)) {
                return true;
            }
        }
        return false;
    }

    private static boolean workableChunk(Chunk c) {
        Entity[] colliders = ((IExtraChunkData)c).getConstantColliders();
        return colliders != null;
    }

    private static boolean collides(IExtraChunkData data, AxisAlignedBB box) {
        Entity[] colliders;
        for (Entity ent : colliders = data.getConstantColliders()) {
            if (!ent.func_70046_E().func_72326_a(box)) continue;
            return true;
        }
        return false;
    }

    public static double clipExplosionResistance(Entity ent, double dmg) {
        double ret = EnchantmentProtection.func_92092_a((Entity)ent, (double)dmg);
        if (ret < 0.0) {
            return 0.0;
        }
        return ret;
    }
}

