/*
 * Decompiled with CFR 0.152.
 */
package factorization.crafting;

import factorization.api.Coord;
import factorization.crafting.TileEntityCompressionCrafter;
import factorization.notify.Notice;
import factorization.notify.Style;
import factorization.shared.Core;
import factorization.shared.NetworkFactorization;
import factorization.util.CraftUtil;
import factorization.util.InvUtil;
import factorization.util.ItemUtil;
import factorization.weird.TileEntityDayBarrel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class CompressionState {
    static int MAX_CRAFT = 32;
    TileEntityCompressionCrafter start;
    TileEntityCompressionCrafter root;
    TileEntityCompressionCrafter otherEdge;
    ForgeDirection up;
    ForgeDirection right;
    ForgeDirection otherEdgeRight;
    CellInfo[] cells = new CellInfo[9];
    HashSet<TileEntityCompressionCrafter> foundWalls = new HashSet(12);
    int height;
    int width;
    EntityPlayer player;
    boolean errored;
    private static ForgeDirection[] forgeDirections = new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.WEST};
    private static final int[][] cellIndices = new int[][]{{0, 1, 2}, {3, 4, 5}, {6, 7, 8}};
    int pair_height = 0;
    ItemStack[] craftingGrid = new ItemStack[9];

    void reset() {
        this.otherEdge = null;
        this.root = null;
        this.start = null;
        this.up = this.right = ForgeDirection.UNKNOWN;
        this.foundWalls.clear();
        this.width = -1;
        this.height = -1;
        Arrays.fill(this.cells, null);
        this.errored = false;
        this.pair_height = -2;
        this.player = null;
    }

    void error(TileEntityCompressionCrafter at, String msg, String ... args) {
        if (this.errored) {
            return;
        }
        new Notice(at, msg, args).withStyle(Style.FORCE).send(this.player);
        this.errored = true;
    }

    boolean populateState(TileEntityCompressionCrafter cc) {
        this.start = cc;
        this.up = cc.getFacing();
        if (this.up == ForgeDirection.UNKNOWN) {
            this.error(cc, "Broken direction", new String[0]);
            return false;
        }
        this.root = CompressionState.findEdgeRoot(cc);
        if (this.root == null) {
            this.error(cc, "Invalid frame\nNo root", new String[0]);
            return false;
        }
        this.right = this.getRightDirection();
        if (this.right == ForgeDirection.UNKNOWN) {
            this.error(this.root, "No friendly compressors", new String[0]);
            return false;
        }
        this.height = this.checkPairs(this.foundWalls, this.root, this.up, this.right);
        int local_pair_width = this.pair_height;
        if (this.height == -1) {
            this.error(this.root, "no height", new String[0]);
            return false;
        }
        this.otherEdge = this.getOtherSideRoot();
        if (this.otherEdge == null) {
            this.error(this.root, "Missing compressors on the left or right", new String[0]);
            return false;
        }
        this.width = this.checkPairs(this.foundWalls, this.otherEdge, this.right, this.otherEdgeRight);
        if (this.width == -1) {
            this.error(this.root, "No width", new String[0]);
            return false;
        }
        if (this.pair_height != this.height || local_pair_width != this.width) {
            this.error(this.root, "Missing compression crafters", new String[0]);
            return false;
        }
        InvUtil.FzInv[] inv = cc.getAdjacentInventories();
        if (inv[0] == null) {
            return false;
        }
        this.getCells();
        return true;
    }

    private static TileEntityCompressionCrafter findEdgeRoot(TileEntityCompressionCrafter at) {
        ForgeDirection cd = at.getFacing();
        TileEntityCompressionCrafter first = at;
        for (int directionIndex = 0; directionIndex < forgeDirections.length; ++directionIndex) {
            TileEntityCompressionCrafter l;
            ForgeDirection d = forgeDirections[directionIndex];
            if (d == cd || d.getOpposite() == cd) continue;
            boolean found = false;
            for (int i = 0; i < 2 && (l = at.look(d)) != null && l.getFacing() == cd; ++i) {
                at = l;
                found = true;
            }
            if (!found) continue;
            return at;
        }
        return first;
    }

    private ForgeDirection getRightDirection() {
        Coord here = this.root.getCoord();
        ForgeDirection[] validDirections = ForgeDirection.VALID_DIRECTIONS;
        for (int i = 0; i < validDirections.length; ++i) {
            ForgeDirection dir = validDirections[i];
            if (dir == this.up || dir == this.up.getOpposite()) continue;
            TileEntityCompressionCrafter cc = here.add(dir).getTE(TileEntityCompressionCrafter.class);
            if (cc != null && cc.getFacing() == this.up) {
                return dir;
            }
            if (cc == null) continue;
            this.error(cc, "Inconsistent direction", new String[0]);
            return ForgeDirection.UNKNOWN;
        }
        Coord front = here.add(this.up);
        for (int i = 0; i < validDirections.length; ++i) {
            TileEntityCompressionCrafter cc;
            ForgeDirection dir = validDirections[i];
            if (dir == this.up || dir == this.up.getOpposite() || (cc = front.add(dir).getTE(TileEntityCompressionCrafter.class)) == null || cc.getFacing().getOpposite() != dir) continue;
            return dir;
        }
        return ForgeDirection.UNKNOWN;
    }

    private int pickSize() {
        double f = Math.random();
        if (f > 0.5) {
            return 3;
        }
        if (f > 0.2) {
            return 2;
        }
        return 1;
    }

    void showTutorial(EntityPlayer player, TileEntityCompressionCrafter cc) {
        this.reset();
        this.player = player;
        this.errored = true;
        this.populateState(cc);
        this.showExample();
        this.reset();
    }

    private void showExample() {
        Notice.clear(this.player);
        int width = this.pickSize();
        int height = this.pickSize();
        ForgeDirection r = ForgeDirection.WEST;
        if (this.up.offsetX * r.offsetX != 0) {
            r = ForgeDirection.NORTH;
        }
        Coord c = this.root.getCoord();
        Coord d = c.copy();
        for (int _ = 0; _ < height + 1; ++_) {
            d.adjust(this.up);
        }
        for (int x = 0; x < width; ++x) {
            this.mark(c);
            c.adjust(r);
            this.mark(d);
            d.adjust(r);
        }
        Coord hypoRoot = this.root.getCoord();
        hypoRoot.adjust(this.up);
        hypoRoot.adjust(r.getOpposite());
        c = hypoRoot;
        d = c.copy();
        for (int _ = 0; _ < width + 1; ++_) {
            d.adjust(r);
        }
        for (int x = 0; x < height; ++x) {
            this.mark(c);
            c.adjust(this.up);
            this.mark(d);
            d.adjust(this.up);
        }
        this.errored = false;
        this.error(this.root, "Place as marked for %sx%s crafting grid\nThen give a redstone signal", "" + width, "" + height);
    }

    void mark(Coord c) {
        if (c.getTE(TileEntityCompressionCrafter.class) != null) {
            return;
        }
        new Notice(c, "", new String[0]).withItem(Core.registry.compression_crafter_item).withStyle(Style.FORCE, Style.EXACTPOSITION, Style.DRAWITEM, Style.DRAWFAR).send(this.player);
    }

    private TileEntityCompressionCrafter getOtherSideRoot() {
        Coord c = this.root.getCoord();
        c.adjust(this.right.getOpposite());
        c.adjust(this.up);
        TileEntityCompressionCrafter cc = c.getTE(TileEntityCompressionCrafter.class);
        if (cc == null) {
            return null;
        }
        TileEntityCompressionCrafter newRoot = CompressionState.findEdgeRoot(cc);
        this.otherEdgeRight = newRoot == cc ? this.up : this.up.getOpposite();
        return newRoot;
    }

    private void getCells() {
        Coord corner = this.root.getCoord();
        corner.adjust(this.up);
        ForgeDirection out = this.right.getRotation(this.up);
        for (int dx = 0; dx < this.width; ++dx) {
            for (int dy = 0; dy < this.height; ++dy) {
                Coord c = corner.add(dx * this.right.offsetX + dy * this.up.offsetX, dx * this.right.offsetY + dy * this.up.offsetY, dx * this.right.offsetZ + dy * this.up.offsetZ);
                this.cells[CompressionState.cellIndex((int)dx, (int)dy)] = new CellInfo(c, out);
            }
        }
    }

    private static int cellIndex(int x, int y) {
        return cellIndices[2 - y][x];
    }

    int checkPairs(HashSet<TileEntityCompressionCrafter> walls, TileEntityCompressionCrafter local_root, ForgeDirection up, ForgeDirection right) {
        int distance = this.getPairDistance(walls, local_root);
        if (distance <= 0) {
            return -1;
        }
        Coord here = local_root.getCoord();
        for (int i = 0; i < 3; ++i) {
            here.adjust(right);
            TileEntityCompressionCrafter other = here.getTE(TileEntityCompressionCrafter.class);
            this.pair_height = i + 1;
            if (other == null) break;
            if (other.getFacing() != up) {
                this.error(other, "Inconsistent direction", new String[0]);
                return -1;
            }
            if (this.getPairDistance(walls, other) == distance) continue;
            this.error(other, "Inconsistent height", new String[0]);
            return -1;
        }
        return distance;
    }

    static boolean isFrame(Coord c) {
        return c.getTE(TileEntityCompressionCrafter.class) != null;
    }

    int getPairDistance(HashSet<TileEntityCompressionCrafter> walls, TileEntityCompressionCrafter start) {
        ForgeDirection cd = start.getFacing();
        if (!start.buffer.isEmpty()) {
            this.error(start, "Buffered output", new String[0]);
            return -1;
        }
        Coord here = start.getCoord();
        here.adjust(cd);
        for (int i = 1; i < 4; ++i) {
            here.adjust(cd);
            TileEntityCompressionCrafter cc = here.getTE(TileEntityCompressionCrafter.class);
            if (cc == null) continue;
            if (cc.getFacing().getOpposite() != cd) {
                this.error(cc, "Facing the wrong way", new String[0]);
                return -1;
            }
            if (!cc.buffer.isEmpty()) {
                this.error(cc, "Buffered output", new String[0]);
                return -1;
            }
            walls.add(start);
            walls.add(cc);
            return i;
        }
        if (start.getCoord().add(start.getFacing()).getTE(TileEntityCompressionCrafter.class) != null) {
            this.error(start, "Must be 1-3 blocks away from\nthe other Compression Crafter", new String[0]);
            return -1;
        }
        this.error(start, "Not facing another Compression Crafter", new String[0]);
        return -1;
    }

    public void craft(boolean fake, TileEntityCompressionCrafter start) {
        this.reset();
        if (!this.populateState(start)) {
            return;
        }
        this.do_craft(fake);
        this.reset();
    }

    private boolean do_craft(boolean fake) {
        Arrays.fill(this.craftingGrid, null);
        block0: for (int mode = 0; mode < 4; ++mode) {
            boolean any = false;
            int maxCraft = MAX_CRAFT;
            boolean[] containerItem = new boolean[9];
            for (int i = 0; i < 9; ++i) {
                ItemStack is;
                CellInfo ci = this.cells[i];
                if (ci == null) {
                    this.craftingGrid[i] = null;
                    continue;
                }
                this.craftingGrid[i] = is = ci.items[ci.getBestMode(mode)];
                if (is == null) {
                    if (ci.airBlock) continue;
                    continue block0;
                }
                any = true;
                Item it = is.func_77973_b();
                if (is.func_77976_d() == 1 && it.hasContainerItem(is) && it.func_77612_l() > 1) {
                    int useCount;
                    int origDamage = is.func_77960_j();
                    for (useCount = 0; useCount < maxCraft && is.func_77960_j() <= is.func_77958_k() && (is = it.getContainerItem(is)) != null && is.field_77994_a != 0 && is.func_77960_j() != origDamage && is.func_77973_b() == it; ++useCount) {
                    }
                    if (useCount > 0) {
                        containerItem[i] = true;
                    }
                    maxCraft = Math.min(maxCraft, useCount);
                    continue;
                }
                maxCraft = Math.min(maxCraft, is.field_77994_a);
            }
            if (!any) continue;
            CraftUtil.craft3x3(this.root, true, true, this.craftingGrid);
            if (!CraftUtil.craft_succeeded) continue;
            ArrayList<ItemStack> total = new ArrayList<ItemStack>(maxCraft + 4);
            int items_used = 0;
            for (int craftCount = 0; craftCount < maxCraft; ++craftCount) {
                if (craftCount == 0) {
                    for (int i = 0; i < 9; ++i) {
                        CellInfo ci = this.cells[i];
                        if (ci == null) continue;
                        ci.updateBarrelExtraction(maxCraft);
                    }
                }
                List<ItemStack> result = CraftUtil.craft3x3(this.root, fake, !fake && craftCount != maxCraft - 1, this.craftingGrid);
                if (!CraftUtil.craft_succeeded) {
                    if (craftCount != 0) break;
                    continue block0;
                }
                for (int i = 0; i < 9; ++i) {
                    ItemStack got;
                    if (!containerItem[i] || (got = this.craftingGrid[i]) == null) continue;
                    this.craftingGrid[i] = got.func_77973_b().getContainerItem(got);
                }
                if (fake) {
                    this.spreadCraftingAction();
                    return true;
                }
                ++items_used;
                total.addAll(result);
            }
            for (int i = 0; i < 9; ++i) {
                CellInfo ci = this.cells[i];
                if (ci == null) continue;
                ci.consume(ci.getBestMode(mode), items_used);
            }
            InvUtil.collapseItemList(total);
            this.start.buffer = total;
            return true;
        }
        return false;
    }

    void spreadCraftingAction() {
        for (TileEntityCompressionCrafter cc : this.foundWalls) {
            cc.informClient();
        }
        int maxZ = 0;
        int maxY = 0;
        int maxX = 0;
        int minZ = 0;
        int minY = 0;
        int minX = 0;
        boolean first = true;
        for (int i = 0; i < this.cells.length; ++i) {
            CellInfo ci = this.cells[i];
            if (ci == null) continue;
            Coord c = ci.cell;
            if (first) {
                minX = maxX = c.x;
                minY = maxY = c.y;
                minZ = maxZ = c.z;
                first = false;
                continue;
            }
            minX = Math.min(c.x, minX);
            minY = Math.min(c.y, minY);
            minZ = Math.min(c.z, minZ);
            maxX = Math.max(c.x, maxX);
            maxY = Math.max(c.y, maxY);
            maxZ = Math.max(c.z, maxZ);
        }
        ForgeDirection axis = this.right.getRotation(this.up);
        this.start.broadcastMessage(null, NetworkFactorization.MessageType.CompressionCrafterBounds, minX, minY, minZ, maxX, maxY, maxZ, (byte)axis.ordinal());
    }

    static class CellInfo {
        static final int BARREL = 0;
        static final int BREAK = 1;
        static final int SMACKED = 2;
        static final int PICKED = 3;
        static final int length = 4;
        final Coord cell;
        ItemStack[] items = new ItemStack[4];
        boolean airBlock = true;
        private static final ArrayList<ItemStack> empty = new ArrayList();

        public CellInfo(Coord cell, ForgeDirection top) {
            ItemStack b;
            List<ItemStack> craftRes;
            this.cell = cell;
            if (cell.isAir() || cell.getHardness() < 0.0f) {
                this.airBlock = true;
                return;
            }
            TileEntityDayBarrel barrel = cell.getTE(TileEntityDayBarrel.class);
            if (barrel != null) {
                if (barrel.item == null) {
                    return;
                }
                ItemStack b2 = barrel.item.func_77946_l();
                b2.field_77994_a = Math.min(MAX_CRAFT, barrel.getItemCountSticky());
                b2.field_77994_a = Math.min(b2.field_77994_a, b2.func_77976_d());
                this.items[0] = b2;
                this.airBlock = false;
                return;
            }
            this.items[3] = cell.getPickBlock(top);
            this.items[1] = cell.getBrokenBlock();
            if (this.items[1] != null && (craftRes = CraftUtil.craft1x1(null, true, b = this.items[1])) != null && craftRes.size() == 1) {
                this.items[2] = craftRes.get(0);
            }
            this.airBlock = this.items[3] == null && this.items[1] == null && this.items[2] == null;
        }

        List<ItemStack> consume(int mode, int amount) {
            ItemStack leftOvers = this.items[mode];
            if (leftOvers == null) {
                return empty;
            }
            switch (mode) {
                case 3: {
                    this.cell.setAir();
                    break;
                }
                case 1: {
                    --leftOvers.field_77994_a;
                    this.cell.setAir();
                    break;
                }
                case 0: {
                    this.cell.getTE(TileEntityDayBarrel.class).changeItemCount(-amount);
                    break;
                }
                case 2: {
                    List<ItemStack> craftRes = CraftUtil.craft1x1(null, true, this.items[1]);
                    Iterator<ItemStack> it = craftRes.iterator();
                    while (it.hasNext()) {
                        ItemStack is = it.next();
                        if (!ItemUtil.couldMerge(is, leftOvers)) continue;
                        is.field_77994_a = leftOvers.field_77994_a;
                        if (is.field_77994_a > 0) break;
                        it.remove();
                        break;
                    }
                    this.cell.setAir();
                    return craftRes;
                }
            }
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>(1);
            leftOvers = ItemUtil.normalize(leftOvers);
            if (leftOvers != null) {
                ret.add(leftOvers);
            }
            return ret;
        }

        int getBestMode(int lastModeAllowed) {
            int last_valid = lastModeAllowed;
            for (int i = 0; i <= lastModeAllowed; ++i) {
                if (this.items[i] == null) continue;
                last_valid = i;
            }
            return last_valid;
        }

        public void updateBarrelExtraction(int maxCraft) {
            if (ItemUtil.getStackSize(this.items[0]) > maxCraft) {
                this.items[0].field_77994_a = Math.min(this.items[0].field_77994_a, maxCraft);
            }
        }
    }
}

