/*
 * Decompiled with CFR 0.152.
 */
package factorization.crafting;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.crafting.CompressionState;
import factorization.notify.Notice;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.NetworkFactorization;
import factorization.shared.TileEntityCommon;
import factorization.util.InvUtil;
import factorization.util.ItemUtil;
import factorization.util.SpaceUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCompressionCrafter
extends TileEntityCommon {
    static ThreadLocal<CompressionState> states = new ThreadLocal();
    ArrayList<ItemStack> buffer = new ArrayList();
    byte progress = 0;
    byte b_facing = (byte)ForgeDirection.UP.ordinal();
    boolean isCrafterRoot = false;
    boolean powered = false;
    public Coord upperCorner;
    public Coord lowerCorner;
    public ForgeDirection craftingAxis = ForgeDirection.UP;

    CompressionState getStateHelper() {
        CompressionState cs = states.get();
        if (cs == null) {
            cs = new CompressionState();
            states.set(cs);
        }
        return cs;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.COMPRESSIONCRAFTER;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.DarkIron;
    }

    public ForgeDirection getFacing() {
        return ForgeDirection.getOrientation((int)this.b_facing);
    }

    public float getProgressPerc() {
        if (this.progress == 0) {
            return 0.0f;
        }
        if (this.progress > 0) {
            return (float)Math.sqrt((float)this.progress / 20.0f);
        }
        return Math.min(1.0f, (float)this.progress * 1.0f / -10.0f);
    }

    public boolean isPrimaryCrafter() {
        return this.isCrafterRoot && this.progress > 0;
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        this.progress = data.as(Share.PRIVATE, "prog").putByte(this.progress);
        this.b_facing = data.as(Share.VISIBLE, "dir").putByte(this.b_facing);
        this.isCrafterRoot = data.as(Share.VISIBLE, "root").putBoolean(this.isCrafterRoot);
        this.powered = data.as(Share.PRIVATE, "rs").putBoolean(this.powered);
        this.buffer = data.as(Share.PRIVATE, "buff").putItemList(this.buffer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ForgeDirection dir) {
        ForgeDirection f = this.getFacing();
        if (dir == f) {
            return BlockIcons.compactFace;
        }
        if (dir == f.getOpposite()) {
            return BlockIcons.compactBack;
        }
        return BlockIcons.compactSide;
    }

    @Override
    public void onPlacedBy(EntityPlayer player, ItemStack is, int side, float hitX, float hitY, float hitZ) {
        super.onPlacedBy(player, is, side, hitX, hitY, hitZ);
        this.b_facing = SpaceUtil.getOpposite(SpaceUtil.determineOrientation(player));
    }

    public void func_145845_h() {
        if (this.progress != 0) {
            byte by = this.progress;
            this.progress = (byte)(by + 1);
            if (by == 20) {
                if (!this.field_145850_b.field_72995_K && this.getFacing() != ForgeDirection.UNKNOWN && this.isCrafterRoot) {
                    this.getStateHelper().craft(false, this);
                    this.isCrafterRoot = false;
                    boolean signal = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    if (!signal) {
                        this.powered = false;
                    }
                } else {
                    this.lowerCorner = null;
                    this.upperCorner = null;
                }
                this.progress = (byte)-10;
            }
        }
        this.dumpBuffer();
    }

    void dumpBuffer() {
        if (this.buffer.isEmpty()) {
            return;
        }
        block0: for (InvUtil.FzInv fz : this.getAdjacentInventories()) {
            if (fz == null) break;
            while (!this.buffer.isEmpty()) {
                ItemStack is = ItemUtil.normalize(this.buffer.get(0));
                if (is != null) {
                    is = ItemUtil.normalize(fz.push(is));
                }
                if (is != null) continue block0;
                this.buffer.remove(0);
            }
        }
    }

    InvUtil.FzInv[] getAdjacentInventories() {
        InvUtil.FzInv[] ret = new InvUtil.FzInv[30];
        int i = 0;
        Coord me = this.getCoord();
        ForgeDirection facing = this.getFacing();
        ForgeDirection behind = facing.getOpposite();
        for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
            TileEntityCompressionCrafter neighbor;
            if (fd == facing) continue;
            ForgeDirection back = fd.getOpposite();
            Coord sc = me.add(fd);
            IInventory inv = sc.getTE(IInventory.class);
            if (inv != null) {
                ret[i++] = InvUtil.openInventory(inv, back);
                continue;
            }
            if (fd == behind || (neighbor = sc.getTE(TileEntityCompressionCrafter.class)) == null || neighbor.getFacing() != facing) continue;
            for (ForgeDirection nfd : ForgeDirection.VALID_DIRECTIONS) {
                if (nfd == facing || nfd == back) continue;
                Coord sd = sc.add(nfd);
                ForgeDirection newBack = nfd.getOpposite();
                IInventory newInv = sd.getTE(IInventory.class);
                if (newInv == null) continue;
                ret[i++] = InvUtil.openInventory(newInv, newBack);
            }
        }
        return ret;
    }

    @Override
    public void neighborChanged() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean signal = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (signal != this.powered && signal && this.progress == 0) {
            this.getStateHelper().craft(true, this);
            this.isCrafterRoot = true;
        }
        this.powered = signal;
    }

    @Override
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.CompressionCrafter) {
            this.b_facing = input.readByte();
            this.progress = input.readByte();
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.CompressionCrafterBeginCrafting) {
            this.progress = 1;
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.CompressionCrafterBounds) {
            this.upperCorner = new Coord(this.field_145850_b, input.readInt(), input.readInt(), input.readInt());
            this.lowerCorner = new Coord(this.field_145850_b, input.readInt(), input.readInt(), input.readInt());
            this.craftingAxis = ForgeDirection.getOrientation((int)input.readByte());
            Coord.sort(this.lowerCorner, this.upperCorner);
            if (this.lowerCorner.distanceSq(this.upperCorner) > 25) {
                Core.logWarning("Server wanted us to render a large area!?", new Object[0]);
                this.upperCorner = null;
                this.lowerCorner = null;
            } else {
                this.isCrafterRoot = true;
            }
            return true;
        }
        return false;
    }

    void informClient() {
        this.broadcastMessage(null, NetworkFactorization.MessageType.CompressionCrafterBeginCrafting, new Object[0]);
        this.progress = 1;
        this.powered = true;
    }

    TileEntityCompressionCrafter look(ForgeDirection d) {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + d.offsetX, this.field_145848_d + d.offsetY, this.field_145849_e + d.offsetZ);
        if (te instanceof TileEntityCompressionCrafter) {
            return (TileEntityCompressionCrafter)te;
        }
        return null;
    }

    @Override
    public boolean rotate(ForgeDirection axis) {
        byte new_b = (byte)axis.ordinal();
        if (new_b == this.b_facing) {
            return false;
        }
        this.b_facing = new_b;
        return true;
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        Coord here = this.getCoord();
        while (!this.buffer.isEmpty()) {
            here.spawnItem(this.buffer.remove(0));
        }
    }

    @Override
    public boolean activate(EntityPlayer entityplayer, ForgeDirection side) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        if (entityplayer.func_70093_af()) {
            return false;
        }
        if (!this.buffer.isEmpty()) {
            new Notice(this, "Buffered output", new String[0]).sendTo(entityplayer);
            return false;
        }
        Coord c = this.getCoord();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    if (Math.abs(dx) + Math.abs(dy) + Math.abs(dz) == 3) continue;
                    c.set(this.field_145850_b, this.field_145851_c + dx, this.field_145848_d + dy, this.field_145849_e + dz);
                    TileEntity te = c.getTE(TileEntityCompressionCrafter.class);
                    if (te == this || te == null) continue;
                    return false;
                }
            }
        }
        this.getStateHelper().showTutorial(entityplayer, this);
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.isPrimaryCrafter()) {
            AxisAlignedBB ab = super.getRenderBoundingBox();
            int d = 7;
            ab.field_72336_d += (double)d;
            ab.field_72337_e += (double)d;
            ab.field_72334_f += (double)d;
            ab.field_72340_a -= (double)d;
            ab.field_72338_b -= (double)d;
            ab.field_72339_c -= (double)d;
            return ab;
        }
        return super.getRenderBoundingBox();
    }

    @Override
    public void click(EntityPlayer entityplayer) {
        InvUtil.emptyBuffer(entityplayer, this.buffer, this);
    }
}

