/*
 * Decompiled with CFR 0.152.
 */
package factorization.crafting;

import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import factorization.api.crafting.CraftingManagerGeneric;
import factorization.api.crafting.IVexatiousCrafting;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.NetworkFactorization;
import factorization.shared.TileEntityFactorization;
import factorization.util.CraftUtil;
import factorization.util.InvUtil;
import factorization.util.ItemUtil;
import factorization.util.PlayerUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class TileEntityMixer
extends TileEntityFactorization
implements IChargeConductor {
    public static final int INPUT_SIZE = 4;
    public ItemStack[] input = new ItemStack[4];
    public ItemStack[] output = new ItemStack[4];
    public static final int[] IN_s = new int[]{0, 1, 2, 3};
    public static final int[] OUT_s = new int[]{4, 5, 6, 7};
    public ArrayList<ItemStack> outputBuffer = new ArrayList();
    public int progress = 0;
    public int speed = 0;
    Charge charge = new Charge(this);
    int last_speed = -1;
    float rotation = 0.0f;
    public static final CraftingManagerGeneric<TileEntityMixer> recipes = CraftingManagerGeneric.get(TileEntityMixer.class);
    private static boolean recipes_loaded = false;
    IVexatiousCrafting<TileEntityMixer> cache = null;
    boolean dirty = true;

    @Override
    public IIcon getIcon(ForgeDirection dir) {
        switch (dir) {
            case UP: {
                return BlockIcons.mixer.top;
            }
            case DOWN: {
                return BlockIcons.mixer.bottom;
            }
        }
        return BlockIcons.mixer.side;
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        super.putData(data);
        this.charge.serialize("", data);
        this.progress = data.as(Share.PRIVATE, "progress").putInt(this.progress);
        this.speed = data.as(Share.VISIBLE, "speed").putInt(this.speed);
        this.outputBuffer = data.as(Share.PRIVATE, "outBuffer").putItemList(this.outputBuffer);
        this.putSlots(data);
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
            return;
        }
        this.dirty = true;
        this.cache = null;
    }

    @Override
    public void dropContents() {
        super.dropContents();
        Coord here = this.getCoord();
        for (ItemStack is : this.outputBuffer) {
            InvUtil.spawnItemStack(here, is);
        }
        this.func_70296_d();
    }

    public int func_70302_i_() {
        return this.input.length + this.output.length;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= 0 && slot < this.input.length) {
            return this.input[slot];
        }
        if ((slot -= this.input.length) >= 0 && slot < this.output.length) {
            return this.output[slot];
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack is) {
        this.func_70296_d();
        if (slot >= 0 && slot < this.input.length) {
            this.input[slot] = is;
            return;
        }
        if ((slot -= this.input.length) >= 0 && slot < this.output.length) {
            this.output[slot] = is;
        }
    }

    @Override
    public ItemStack func_70298_a(int i, int amount) {
        this.func_70296_d();
        return super.func_70298_a(i, amount);
    }

    public String func_145825_b() {
        return "Mixer";
    }

    public int[] func_94128_d(int s) {
        ForgeDirection side = ForgeDirection.getOrientation((int)s);
        if (side == ForgeDirection.DOWN) {
            return OUT_s;
        }
        return IN_s;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return slotIndex < this.input.length;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        return null;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.MIXER;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.charge.update();
        this.rotation += (float)this.speed;
        this.shareRotationSpeed();
    }

    void shareRotationSpeed() {
        if (this.speed != this.last_speed) {
            this.broadcastMessage(null, NetworkFactorization.MessageType.MixerSpeed, this.speed);
            this.last_speed = this.speed;
        }
    }

    @Override
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.MixerSpeed) {
            this.speed = input.readInt();
            return true;
        }
        return false;
    }

    @Override
    protected int getLogicSpeed() {
        return 4;
    }

    int getRemainingProgress() {
        return 250 - this.progress;
    }

    public float getRotation() {
        return this.rotation;
    }

    public static void loadShapelessRecipes() {
        if (recipes_loaded) {
            return;
        }
        recipes_loaded = true;
        ArrayList<RecipeMatchInfo> found = new ArrayList<RecipeMatchInfo>();
        block2: for (Object o : CraftingManager.func_77594_a().func_77592_b()) {
            ShapelessRecipes sr;
            IRecipe recipe = (IRecipe)o;
            List inputList = null;
            ItemStack output = null;
            if (recipe instanceof ShapelessRecipes) {
                sr = (ShapelessRecipes)recipe;
                inputList = sr.field_77579_b;
                output = sr.func_77571_b();
            }
            if (recipe instanceof ShapelessOreRecipe) {
                sr = (ShapelessOreRecipe)recipe;
                inputList = sr.getInput();
                output = sr.func_77571_b();
            }
            if (inputList == null || output == null) continue;
            output = output.func_77946_l();
            int s = inputList.size();
            if (s <= 1 || s > 9) continue;
            for (int i = 0; i < inputList.size(); ++i) {
                Object p = inputList.get(i);
                if (p instanceof String) {
                    ArrayList ores = OreDictionary.getOres((String)((String)p));
                    for (int X = 0; X < ores.size(); ++X) {
                        ores.set(X, ((ItemStack)ores.get(X)).func_77946_l());
                    }
                    p = ores;
                }
                if (p instanceof List) {
                    for (ItemStack is : (List)p) {
                        if (TileEntityMixer.isOkayRecipeItem(is)) continue;
                        continue block2;
                    }
                }
                if (p instanceof ItemStack && !TileEntityMixer.isOkayRecipeItem((ItemStack)p)) continue block2;
            }
            try {
                found.add(new RecipeMatchInfo(inputList, output, recipe));
            }
            catch (WeirdRecipeException weirdRecipeException) {}
        }
        Collections.sort(found, new Comparator<RecipeMatchInfo>(){

            @Override
            public int compare(RecipeMatchInfo o1, RecipeMatchInfo o2) {
                return o2.size - o1.size;
            }
        });
        for (RecipeMatchInfo rmi : found) {
            recipes.add(rmi);
        }
    }

    public static boolean isOkayRecipeItem(ItemStack is) {
        if (is == null) {
            return false;
        }
        Item item = (is = is.func_77946_l()).func_77973_b();
        if (item == null) {
            return false;
        }
        if (item == Items.field_151121_aF || item == Items.field_151122_aG) {
            return false;
        }
        if (item.hasContainerItem(is)) {
            ItemStack container = ItemUtil.normalize(item.getContainerItem(is));
            if (container == null) {
                return true;
            }
            if (container.func_77973_b() != item) {
                return true;
            }
            if (container.func_77984_f() || container.func_77951_h()) {
                return false;
            }
            if (container.func_77969_a(is)) {
                return false;
            }
        }
        return true;
    }

    IVexatiousCrafting<TileEntityMixer> getRecipe() {
        boolean empty = true;
        for (int i = 0; i < this.input.length; ++i) {
            if (this.input[i] == null) continue;
            empty = false;
            break;
        }
        if (empty) {
            return null;
        }
        TileEntityMixer.loadShapelessRecipes();
        return recipes.find(this);
    }

    static ItemStack[] copyArray(ItemStack[] src) {
        ItemStack[] clone = new ItemStack[src.length];
        for (int i = 0; i < src.length; ++i) {
            if (src[i] == null) continue;
            clone[i] = src[i].func_77946_l();
        }
        return clone;
    }

    static boolean addItems(ItemStack[] out, ItemStack[] src) {
        for (ItemStack is : src) {
            int i;
            for (i = 0; i < out.length; ++i) {
                if (out[i] == null || !ItemUtil.couldMerge(is, out[i])) continue;
                int free = out[i].func_77976_d() - out[i].field_77994_a;
                int delta = Math.min(free, is.field_77994_a);
                is.field_77994_a -= delta;
                out[i].field_77994_a += delta;
                if ((is = ItemUtil.normalize(is)) == null) break;
            }
            if (is == null) continue;
            for (i = 0; i < out.length; ++i) {
                if (out[i] != null) continue;
                out[i] = is.func_77946_l();
                is = null;
                break;
            }
            if (is == null) continue;
            TileEntityMixer.normalize(out);
            TileEntityMixer.normalize(src);
            return false;
        }
        TileEntityMixer.normalize(out);
        TileEntityMixer.normalize(src);
        return true;
    }

    IVexatiousCrafting<TileEntityMixer> getCachedRecipe() {
        if (!this.dirty) {
            return this.cache;
        }
        this.dirty = false;
        this.cache = this.getRecipe();
        return this.cache;
    }

    void slow() {
        if (this.progress > 0) {
            this.progress = (int)Math.max(0.0, (double)this.progress * 0.8 - 5.0);
        }
        if (this.speed > 0) {
            --this.speed;
        }
    }

    boolean extractEnergy() {
        int i = Math.max(2, this.speed);
        return this.charge.tryTake(i) > 0;
    }

    int add(InventoryCrafting craft, int craft_slot, ItemStack is) {
        if (is == null) {
            return craft_slot;
        }
        if (is.field_77994_a > is.func_77976_d() || is.field_77994_a < 1) {
            Core.logWarning("%s: Trying to craft with %s, which has a stack size of %s", this.getCoord(), is, is.field_77994_a);
            craft.func_70299_a(craft_slot++, is);
            return craft_slot;
        }
        while (is.field_77994_a > 0) {
            craft.func_70299_a(craft_slot++, is.func_77979_a(1));
        }
        return craft_slot;
    }

    boolean dumpBuffer() {
        if (this.outputBuffer.size() > 0) {
            ItemStack toAdd = this.outputBuffer.get(0);
            InvUtil.FzInv out = InvUtil.openInventory((IInventory)this, ForgeDirection.DOWN);
            out.setInsertForce(true);
            Iterator<ItemStack> it = this.outputBuffer.iterator();
            while (it.hasNext()) {
                if (out.push(it.next()) != null) continue;
                it.remove();
            }
        }
        return this.outputBuffer.size() > 0;
    }

    @Override
    protected void doLogic() {
        this.needLogic();
        if (this.dumpBuffer()) {
            return;
        }
        IVexatiousCrafting<TileEntityMixer> mr = this.getCachedRecipe();
        if (mr == null) {
            this.slow();
            return;
        }
        if (!mr.isUnblocked(this)) {
            this.slow();
            return;
        }
        if (this.speed < 5 && this.extractEnergy()) {
            ++this.speed;
        } else if (!this.extractEnergy() && this.speed > 0) {
            int ns = Math.min(this.speed - 1, (int)((double)this.speed * 0.8));
            this.speed = ns = Math.max(ns, 0);
        }
        if (this.progress == 0 && this.speed > 0) {
            mr.onCraftingStart(this);
        }
        this.progress += this.speed;
        if (this.getRemainingProgress() <= 0 || Core.cheat) {
            if (!mr.matches(this)) {
                this.func_70296_d();
                this.dirty = true;
                this.progress = 0;
                return;
            }
            this.progress = 0;
            mr.onCraftingComplete(this);
            TileEntityMixer.normalize(this.input);
            this.speed = Math.min(50, this.speed + 1);
            this.dumpBuffer();
        }
    }

    static void normalize(ItemStack[] is) {
        for (int i = 0; i < is.length; ++i) {
            is[i] = ItemUtil.normalize(is[i]);
        }
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    public int getMixProgressScaled(int scale) {
        return this.progress * scale / (this.progress + this.getRemainingProgress());
    }

    public static class RecipeMatchInfo
    implements IVexatiousCrafting<TileEntityMixer> {
        public ArrayList inputs = new ArrayList();
        public ItemStack output;
        public IRecipe theRecipe;
        public int size = 0;

        public void add(Object o) {
            if (o instanceof ItemStack) {
                int s;
                ItemStack it = (ItemStack)o;
                it = it.func_77946_l();
                o = it;
                it.field_77994_a = s = Math.min(1, it.field_77994_a);
                for (int i = 0; i < this.inputs.size(); ++i) {
                    ItemStack here;
                    Object h = this.inputs.get(i);
                    if (!(h instanceof ItemStack) || !ItemUtil.couldMerge(here = (ItemStack)h, it)) continue;
                    here.field_77994_a += s;
                    this.size += s;
                    return;
                }
                this.inputs.add(it);
                this.size += s;
                return;
            }
            this.inputs.add(o);
            ++this.size;
        }

        public RecipeMatchInfo(List<Object> recipeInput, ItemStack recipeOutput, IRecipe theRecipe) throws WeirdRecipeException {
            for (Object o : recipeInput) {
                if (o instanceof ItemStack) {
                    this.add(o);
                    continue;
                }
                if (o instanceof Collection) {
                    if (((Collection)o).size() == 0) {
                        throw new WeirdRecipeException();
                    }
                    ArrayList<ItemStack> parts = new ArrayList<ItemStack>();
                    for (Object p : (Collection)o) {
                        if (!(p instanceof ItemStack)) continue;
                        parts.add((ItemStack)p);
                    }
                    this.add(parts);
                    continue;
                }
                Core.logSevere("Don't know how to use %s in a recipe", o);
                throw new WeirdRecipeException();
            }
            this.output = recipeOutput;
            this.theRecipe = theRecipe;
        }

        @Override
        public boolean matches(TileEntityMixer machine) {
            ItemStack[] input = machine.input;
            ItemStack[] in = new ItemStack[input.length];
            int inputCount = 0;
            for (int i = 0; i < input.length; ++i) {
                if (input[i] == null) continue;
                in[i] = input[i].func_77946_l();
                ++inputCount;
            }
            int foundCount = 0;
            for (int i = 0; i < this.inputs.size(); ++i) {
                List<Object> all;
                Object o = this.inputs.get(i);
                if (o instanceof ItemStack) {
                    all = Arrays.asList((ItemStack)o);
                } else {
                    all = new ArrayList();
                    all.addAll((List)o);
                }
                boolean found = false;
                for (int R = 0; R < all.size(); ++R) {
                    ItemStack recipeItem = (ItemStack)all.get(R);
                    if (!this.removeMatching(in, recipeItem)) continue;
                    found = true;
                    if (all.size() <= 1) break;
                    all = Arrays.asList(recipeItem);
                    break;
                }
                if (!found) {
                    return false;
                }
                ++foundCount;
            }
            return foundCount >= this.inputs.size();
        }

        public boolean removeMatching(ItemStack[] hay, ItemStack needle) {
            needle = needle.func_77946_l();
            for (int i = 0; i < hay.length; ++i) {
                if (!ItemUtil.wildcardSimilar(needle, hay[i])) continue;
                int delta = Math.min(hay[i].field_77994_a, needle.field_77994_a);
                hay[i].field_77994_a -= delta;
                needle.field_77994_a -= delta;
                hay[i] = ItemUtil.normalize(hay[i]);
                if (needle.field_77994_a > 0) continue;
                return true;
            }
            return false;
        }

        @Override
        public void onCraftingStart(TileEntityMixer machine) {
        }

        @Override
        public void onCraftingComplete(TileEntityMixer machine) {
            InventoryCrafting craft = CraftUtil.makeCraftingGrid();
            int craft_slot = 0;
            InvUtil.FzInv inv = InvUtil.openInventory((IInventory)machine, ForgeDirection.UP);
            ArrayList<Object> recipeInputs = new ArrayList<Object>();
            for (Object o : this.inputs) {
                if (o instanceof ItemStack) {
                    recipeInputs.add(((ItemStack)o).func_77946_l());
                    continue;
                }
                ArrayList<ItemStack> cp = new ArrayList<ItemStack>();
                for (ItemStack is : (Iterable)o) {
                    cp.add(is.func_77946_l());
                }
                recipeInputs.add(cp);
            }
            block2: for (int i_input = 0; i_input < recipeInputs.size(); ++i_input) {
                Object o;
                o = recipeInputs.get(i_input);
                if (o instanceof ItemStack) {
                    ItemStack is = (ItemStack)o;
                    craft_slot = machine.add(craft, craft_slot, inv.pull(is, is.field_77994_a, false));
                    is.field_77994_a = 0;
                    continue;
                }
                for (ItemStack is : (Iterable)o) {
                    ItemStack got = ItemUtil.normalize(inv.pull(is, 1, false));
                    if (got == null) continue;
                    Iterator iterator = ((Iterable)o).iterator();
                    while (iterator.hasNext()) {
                        ItemStack others = (ItemStack)iterator.next();
                        if (others == is) continue;
                        iterator.remove();
                    }
                    --is.field_77994_a;
                    craft_slot = machine.add(craft, craft_slot, got);
                    continue block2;
                }
            }
            EntityPlayer fakePlayer = PlayerUtil.makePlayer(machine.getCoord(), "Mixer");
            InventoryCraftResult craftResult = new InventoryCraftResult();
            ItemStack out = this.output.func_77946_l();
            if (out.field_77994_a < 1) {
                out.field_77994_a = 1;
            }
            craftResult.func_70299_a(0, out);
            SlotCrafting slot = new SlotCrafting(fakePlayer, (IInventory)craft, (IInventory)craftResult, 0, 0, 0);
            slot.func_82870_a(fakePlayer, out);
            machine.outputBuffer.add(out);
            CraftUtil.addInventoryToArray((IInventory)craft, machine.outputBuffer);
            CraftUtil.addInventoryToArray((IInventory)fakePlayer.field_71071_by, machine.outputBuffer);
            machine.func_70296_d();
            PlayerUtil.recycleFakePlayer(fakePlayer);
        }

        @Override
        public boolean isUnblocked(TileEntityMixer machine) {
            return TileEntityMixer.addItems(TileEntityMixer.copyArray(machine.output), new ItemStack[]{this.output.func_77946_l()});
        }
    }

    public static class WeirdRecipeException
    extends Throwable {
    }
}

