/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

public class AllocationHandler {
    private final String name;
    private final int squishySize;
    private MemoryBlock head;
    private MemoryBlock rover;

    public AllocationHandler(String name, int squishySize) {
        this.name = name;
        this.squishySize = squishySize;
    }

    public int allocate(int size) {
        return this.allocBlock(size).start;
    }

    private MemoryBlock allocBlock(int size) {
        if (this.head == null) {
            this.head = new MemoryBlock();
            this.head.start = size;
            this.head.size = size;
            this.head.isFree = false;
            this.head.next = null;
            return this.head;
        }
        if (this.rover != null) {
            this.rover = AllocationHandler.tryTake(this.rover, null, size, this.squishySize);
            if (this.rover != null) {
                return this.rover;
            }
        }
        this.rover = AllocationHandler.tryTake(this.head, this.rover, size, this.squishySize);
        if (this.rover != null) {
            return this.rover;
        }
        this.rover = this.extendArea(size);
        return this.rover;
    }

    private static MemoryBlock tryTake(MemoryBlock here, MemoryBlock end, int needSize, int squishyBugSize) {
        while (here != end) {
            if (here.isFree && needSize <= here.size) {
                here.isFree = false;
                if (here.size < needSize + squishyBugSize) {
                    return here;
                }
                here.split(needSize);
                return here;
            }
            here = here.next;
        }
        return null;
    }

    private MemoryBlock extendArea(int needSize) {
        MemoryBlock ret = new MemoryBlock();
        ret.start = this.head.start + this.head.size;
        ret.size = needSize;
        ret.isFree = false;
        ret.next = this.head;
        this.head = ret;
        return ret;
    }

    public void free(int start) {
        if (this.findAndFree(this.rover, null, start)) {
            return;
        }
        if (this.findAndFree(this.head, this.rover, start)) {
            return;
        }
        System.err.println("AllocationHandler for " + this.name + " was asked to free area starting at " + start + ", but it was not found!");
    }

    private boolean findAndFree(MemoryBlock block, MemoryBlock endBlock, int start) {
        MemoryBlock prevBlock = null;
        do {
            if (block.start == start) {
                block.isFree = true;
                this.mergeContiguous(prevBlock != null ? prevBlock : block);
                return true;
            }
            prevBlock = block;
        } while ((block = block.next) != endBlock);
        return false;
    }

    private void mergeContiguous(MemoryBlock here) {
        while (this.collapse(here)) {
        }
    }

    private boolean collapse(MemoryBlock block) {
        if (block == null) {
            return false;
        }
        if (block.next == null) {
            return false;
        }
        MemoryBlock after = block.next;
        if (block.isFree && after.isFree) {
            if (this.rover == after) {
                this.rover = after.next;
            }
            block.start = after.start;
            MemoryBlock memoryBlock = block;
            memoryBlock.size = memoryBlock.size + after.size;
            block.next = after.next;
            return true;
        }
        return false;
    }

    private static class MemoryBlock {
        private int start;
        private int size;
        private boolean isFree;
        private MemoryBlock next;

        private MemoryBlock() {
        }

        private void split(int needSize) {
            MemoryBlock remainder = new MemoryBlock();
            remainder.isFree = true;
            remainder.start = this.start;
            remainder.size = this.size - needSize;
            this.start += needSize;
            this.size = needSize;
            this.next = remainder;
        }
    }
}

