/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.fzds.DeltaChunkMap;
import factorization.fzds.DimensionSliceEntity;
import factorization.fzds.Hammer;
import factorization.fzds.HammerEnabled;
import factorization.fzds.HammerInfo;
import factorization.fzds.TransferLib;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.fzds.network.InteractionLiason;
import factorization.fzds.network.PacketProxyingPlayer;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class DeltaChunk {
    private static Vec3 buffer = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    private static Coord shadow = new Coord(null, 0, 0, 0);

    public static boolean enabled() {
        return HammerEnabled.ENABLED;
    }

    public static void assertEnabled() {
        if (!DeltaChunk.enabled()) {
            throw new AssertionError((Object)"Hammer has been disabled by configuration");
        }
    }

    static DeltaChunkMap getSlices(World w) {
        if (w == null) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                return Hammer.clientSlices;
            }
            return Hammer.serverSlices;
        }
        return w.field_72995_K ? Hammer.clientSlices : Hammer.serverSlices;
    }

    public static Iterable<IDeltaChunk> getAllSlices(World w) {
        DeltaChunkMap dm = DeltaChunk.getSlices(w);
        ArrayList<IDeltaChunk> ret = new ArrayList<IDeltaChunk>();
        if (dm == null) {
            return ret;
        }
        for (IDeltaChunk[] array : dm.getIdcs()) {
            Collections.addAll(ret, array);
        }
        return ret;
    }

    public static IDeltaChunk[] getSlicesContainingPoint(Coord at) {
        return DeltaChunk.getSlices(at.w).get(at);
    }

    static boolean addSlice(IDeltaChunk dse) {
        return DeltaChunk.getSlices(dse.field_70170_p).add(dse);
    }

    static Set<IDeltaChunk> getSlicesInRange(World w, int lx, int ly, int lz, int hx, int hy, int hz) {
        THashSet found_deltachunks = new THashSet(10);
        DeltaChunkMap map = DeltaChunk.getSlices(w);
        IDeltaChunk last_found = null;
        for (int x = lx; x <= hx; x += 16) {
            for (int z = lz; z <= hz; z += 16) {
                IDeltaChunk[] new_idcs;
                for (IDeltaChunk idc : new_idcs = map.get(x / 16, z / 16)) {
                    if (idc == last_found) continue;
                    found_deltachunks.add((Object)idc);
                    last_found = idc;
                }
            }
        }
        return found_deltachunks;
    }

    public static World getClientShadowWorld() {
        World ret = Hammer.worldClient;
        if (ret == null) {
            Hammer.proxy.createClientShadowWorld();
            return Hammer.worldClient;
        }
        return ret;
    }

    public static World getServerShadowWorld() {
        return DimensionManager.getWorld((int)DeltaChunk.getDimensionId());
    }

    public static World getClientRealWorld() {
        return Hammer.proxy.getClientRealWorld();
    }

    public static World getWorld(World realWorld) {
        boolean remote = realWorld == null ? FMLCommonHandler.instance().getEffectiveSide().isClient() : realWorld.field_72995_K;
        return remote ? DeltaChunk.getClientShadowWorld() : DeltaChunk.getServerShadowWorld();
    }

    public static IDeltaChunk allocateSlice(World spawnWorld, int channel, DeltaCoord size) {
        if (spawnWorld.field_72995_K) {
            throw new IllegalArgumentException("Attempted client-side DSE allocation!");
        }
        Coord base = Hammer.hammerInfo.takeCell(channel, size);
        Coord end = base.add(size);
        DeltaChunk.wipeRegion(base, end);
        return new DimensionSliceEntity(spawnWorld, base, end);
    }

    public static IDeltaChunk findClosest(Entity target, Coord pos) {
        if (target == null) {
            return null;
        }
        World real_world = target.field_70170_p;
        IDeltaChunk closest = null;
        double dist = Double.POSITIVE_INFINITY;
        for (IDeltaChunk here : DeltaChunk.getSlicesContainingPoint(pos)) {
            if (here.field_70170_p != real_world && !pos.inside(here.getCorner(), here.getFarCorner())) continue;
            if (closest == null) {
                closest = here;
                continue;
            }
            double here_dist = target.func_70068_e((Entity)here);
            if (!(here_dist < dist)) continue;
            dist = here_dist;
            closest = here;
        }
        return closest;
    }

    public static Vec3 shadow2nearestReal(Entity player, double x, double y, double z) {
        IDeltaChunk closest = DeltaChunk.findClosest(player, new Coord(player.field_70170_p, x, y, z));
        if (closest == null) {
            return null;
        }
        DeltaChunk.buffer.field_72450_a = x;
        DeltaChunk.buffer.field_72448_b = y;
        DeltaChunk.buffer.field_72449_c = z;
        Vec3 ret = closest.shadow2real(buffer);
        return ret;
    }

    public static int getDimensionId() {
        DeltaChunk.assertEnabled();
        return HammerInfo.dimension_slice_dimid;
    }

    public static void wipeRegion(Coord min, Coord max) {
        Coord.sort(min, max);
        Coord at = min.copy();
        for (int x = min.x; x <= max.x; ++x) {
            at.x = x;
            for (int y = min.y; y <= max.y; ++y) {
                at.y = y;
                int z = min.z;
                while (z <= max.z) {
                    at.z = z++;
                    at.setAir();
                }
            }
        }
    }

    public static IDeltaChunk makeSlice(int channel, Coord min, Coord max, AreaMap mapper2, final boolean wipeSrc) {
        min = min.copy();
        max = max.copy();
        DeltaCoord size = max.difference(min);
        final IDeltaChunk dse = DeltaChunk.allocateSlice(min.w, channel, size);
        Vec3 vrm = min.centerVec(max);
        dse.field_70165_t = (int)vrm.field_72450_a;
        dse.field_70163_u = (int)vrm.field_72448_b;
        dse.field_70161_v = (int)vrm.field_72449_c;
        final HashSet<Chunk> chunks = new HashSet<Chunk>();
        mapper2.fillDse(new DseDestination(){

            @Override
            public void include(Coord real) {
                shadow.set(real);
                dse.real2shadow(shadow);
                TransferLib.move(real, shadow, false, true);
                chunks.add(real.getChunk());
            }
        });
        DeltaChunk.outsetChunks(chunks);
        DeltaChunk.outsetChunks(chunks);
        mapper2.fillDse(new DseDestination(){

            @Override
            public void include(Coord real) {
                if (wipeSrc) {
                    TransferLib.rawErase(real);
                }
                shadow.set(real);
                dse.real2shadow(shadow);
                shadow.markBlockForUpdate();
                shadow.updateLight();
            }
        });
        if (wipeSrc) {
            mapper2.fillDse(new DseDestination(){

                @Override
                public void include(Coord real) {
                    real.markBlockForUpdate();
                    real.notifyBlockChange();
                }
            });
        }
        return dse;
    }

    static void outsetChunks(Collection<Chunk> chunks) {
        ArrayList<Chunk> edges = new ArrayList<Chunk>();
        for (Chunk chunk : chunks) {
            for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
                if (fd.offsetY != 0) continue;
                edges.add(chunk.field_76637_e.func_72964_e(chunk.field_76635_g + fd.offsetX, chunk.field_76647_h + fd.offsetZ));
            }
        }
        chunks.addAll(edges);
    }

    public static IDeltaChunk construct(World inWorld, Coord min, Coord max) {
        return new DimensionSliceEntity(inWorld, min, max);
    }

    public static void paste(IDeltaChunk selected, boolean overwriteDestination) {
        Coord a = new Coord(DeltaChunk.getServerShadowWorld(), 0, 0, 0);
        Coord b = a.copy();
        Vec3 vShadowMin = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        Vec3 vShadowMax = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        selected.getCorner().setAsVector(vShadowMin);
        selected.getFarCorner().setAsVector(vShadowMax);
        a.set(vShadowMin);
        b.set(vShadowMax);
        Coord dest = new Coord(selected);
        Coord c = new Coord(a.w, 0, 0, 0);
        int minX = 0;
        int minY = 0;
        int minZ = 0;
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        boolean first = true;
        for (int x = a.x; x <= b.x; ++x) {
            for (int y = a.y; y <= b.y; ++y) {
                for (int z = a.z; z <= b.z; ++z) {
                    c.set(a.w, x, y, z);
                    if (c.isAir()) continue;
                    dest.set(c);
                    selected.shadow2real(dest);
                    TransferLib.move(c, dest, false, overwriteDestination);
                    dest.w.func_147471_g(dest.x, dest.y, dest.z);
                    if (first) {
                        minX = maxX = x;
                        minY = maxY = y;
                        minZ = maxZ = z;
                        first = false;
                        continue;
                    }
                    minX = Math.min(minX, x);
                    minY = Math.min(minY, y);
                    minZ = Math.min(minZ, z);
                    maxX = Math.max(maxX, x);
                    maxY = Math.max(maxY, y);
                    maxZ = Math.max(maxZ, z);
                }
            }
        }
    }

    public static void clear(IDeltaChunk selected) {
        Coord a = new Coord(DeltaChunk.getServerShadowWorld(), 0, 0, 0);
        Coord b = a.copy();
        Vec3 vShadowMin = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        Vec3 vShadowMax = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        selected.getCorner().setAsVector(vShadowMin);
        selected.getFarCorner().setAsVector(vShadowMax);
        a.set(vShadowMin);
        b.set(vShadowMax);
        Coord c = new Coord(a.w, 0, 0, 0);
        for (int x = a.x; x < b.x; ++x) {
            for (int y = a.y; y < b.y; ++y) {
                for (int z = a.z; z < b.z; ++z) {
                    c.set(a.w, x, y, z);
                    selected.shadow2real(c);
                    c.markBlockForUpdate();
                }
            }
        }
    }

    public static HammerInfo getHammerRegistry() {
        return Hammer.hammerInfo;
    }

    public static EntityPlayer getRealPlayer(EntityPlayer player) {
        if (player == Hammer.proxy.getFakePlayerWhileInShadow()) {
            return Hammer.proxy.getRealPlayerWhileInShadow();
        }
        if (player instanceof InteractionLiason) {
            return ((InteractionLiason)player).getRealPlayer();
        }
        if (player instanceof PacketProxyingPlayer) {
            return null;
        }
        return player;
    }

    public static interface DseDestination {
        public void include(Coord var1);
    }

    public static interface AreaMap {
        public void fillDse(DseDestination var1);
    }
}

