/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.ICoordFunction;
import factorization.api.Quaternion;
import factorization.fzds.DSTeleporter;
import factorization.fzds.DeltaChunk;
import factorization.fzds.DimensionSliceEntity;
import factorization.fzds.Hammer;
import factorization.fzds.TransferLib;
import factorization.fzds.interfaces.DeltaCapability;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.fzds.interfaces.Interpolation;
import factorization.notify.Notice;
import factorization.shared.Core;
import factorization.util.LangUtil;
import factorization.util.PlayerUtil;
import factorization.util.SpaceUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Vec3;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class FZDSCommand
extends CommandBase {
    private static ArrayList<SubCommand> subCommands = new ArrayList();
    public static SubCommand help;
    private static WeakReference<IDeltaChunk> currentSelection;
    private static Splitter comma;
    private static World visitedWorld;
    static HashMap<String, Coord> positionVariables;

    public String func_71517_b() {
        return "fzds";
    }

    public int func_82362_a() {
        return 2;
    }

    public static SubCommand add(SubCommand cmd, Requires ... reqs) {
        for (Requires r : reqs) {
            r.apply(cmd);
        }
        cmd.reqs = reqs;
        subCommands.add(cmd);
        return cmd;
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/fzds subcommand";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (sender instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)sender;
            boolean op = PlayerUtil.isPlayerOpped((EntityPlayer)player);
            boolean cr = player.field_71075_bZ.field_75098_d;
            if (!op && !cr) {
                LangUtil.sendChatMessage(true, sender, "You must be op or in creative mode to use these commands");
                return;
            }
        }
        if (args.length == 0) {
            this.runSubCommand(help, sender, new String[]{"help"});
            return;
        }
        String cmd = args[0];
        for (SubCommand sc : subCommands) {
            for (String alias2 : sc.altNames) {
                if (!alias2.equalsIgnoreCase(cmd)) continue;
                this.runSubCommand(sc, sender, args);
                return;
            }
        }
        LangUtil.sendChatMessage(true, sender, "Not a command");
    }

    public static void setSelection(IDeltaChunk dse) {
        currentSelection = new WeakReference<IDeltaChunk>(dse);
    }

    public static Coord parseCoord(World world, String src) {
        ArrayList<Integer> parts = new ArrayList<Integer>();
        for (String part : comma.split((CharSequence)src)) {
            parts.add(Integer.parseInt(part));
        }
        if (parts.size() == 4) {
            world = DimensionManager.getWorld((int)((Integer)parts.remove(0)));
        }
        if (world == null) {
            throw new WrongUsageException("No world specified", new Object[0]);
        }
        return new Coord(world, (Integer)parts.get(0), (Integer)parts.get(1), (Integer)parts.get(2));
    }

    void visitWorld(World w) {
        if (visitedWorld == null) {
            visitedWorld = w;
        } else if (visitedWorld != w) {
            throw new CommandException("References to different dimensions", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runSubCommand(SubCommand cmd, ICommandSender sender, String[] args) {
        cmd.reset();
        cmd.setup(sender);
        ArrayList<String> cleanedArgs = new ArrayList<String>();
        visitedWorld = null;
        boolean first = true;
        for (String a : args) {
            if (Strings.isNullOrEmpty((String)a)) continue;
            if (a.startsWith("$")) {
                if (!cmd.op) {
                    throw new CommandException("You are not allowed to use arbitrary players", new Object[0]);
                }
                cmd.player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(a.substring(1));
                if (cmd.player == null) {
                    throw new CommandException("Player not found", new Object[0]);
                }
                this.visitWorld(cmd.player.field_70170_p);
            } else if (a.startsWith("#")) {
                cmd.user = FZDSCommand.parseCoord(sender.func_130014_f_(), a.substring(1));
                this.visitWorld(cmd.user.w);
            } else if (a.startsWith("@") && !first && !a.startsWith("@?") && !a.equals("@")) {
                String name = a.substring(1);
                Coord replace = positionVariables.get(name);
                if (replace == null) {
                    throw new CommandException("Undefined position variable: " + a, new Object[0]);
                }
                this.visitWorld(replace.w);
                String r = "" + replace.x + "," + replace.y + "," + replace.z;
                cleanedArgs.add(r);
            } else {
                cleanedArgs.add(a);
            }
            first = false;
        }
        if (cmd.player != null) {
            cmd.user = new Coord((Entity)cmd.player);
        }
        if (cmd.user != null) {
            cmd.world = cmd.user.w;
        }
        if (cmd.needPlayer && cmd.player == null) {
            throw new CommandException("No player specified", new Object[0]);
        }
        if (cmd.needCoord && cmd.user == null) {
            throw new CommandException("No coordinate specified", new Object[0]);
        }
        if (cmd.needOp && !cmd.op && !Core.dev_environ) {
            throw new CommandException("Insufficient permissions", new Object[0]);
        }
        if (cmd.needSelection && cmd.selected == null) {
            throw new CommandException("No DSE selected", new Object[0]);
        }
        cmd.arg0 = (String)cleanedArgs.remove(0);
        try {
            String[] sc = new String[cleanedArgs.size()];
            cmd.call(cleanedArgs.toArray(sc));
        }
        finally {
            cmd.reset();
        }
    }

    static String join(ArrayList<SubCommand> cmd) {
        String ret = " ";
        boolean first = true;
        for (SubCommand sc : cmd) {
            if (!first) {
                ret = ret + "\n";
            }
            first = false;
            ret = ret + EnumChatFormatting.GREEN;
            if (sc.help.length == 1) {
                ret = ret + sc.help[0];
            } else {
                ret = ret + sc.help[0];
                for (int i = 1; i < sc.help.length; ++i) {
                    ret = ret + " " + sc.help[i];
                }
            }
            ret = ret + EnumChatFormatting.RESET + ": " + sc.details();
        }
        return ret;
    }

    private static void clearDseArea(IDeltaChunk idc) {
        Coord a = idc.getCorner();
        Coord b = idc.getFarCorner();
        if (a.w == null || b.w == null) {
            Core.logSevere("DSE's area doesn't have the worlds set? Can't wipe its area. " + idc, new Object[0]);
            return;
        }
        Coord.iterateCube(a, b, new ICoordFunction(){

            @Override
            public void handle(Coord here) {
                here.setAir();
            }
        });
    }

    static {
        currentSelection = new WeakReference<Object>(null);
        comma = Splitter.on((String)",");
        positionVariables = new HashMap();
        help = FZDSCommand.add(new SubCommand(new String[]{"help", "[subcmd]+"}){

            @Override
            String details() {
                return "Gives a list of all subcommands, or information about the given subcommands";
            }

            @Override
            void call(String[] args) {
                boolean any = false;
                block0: for (String s : args) {
                    any = true;
                    for (SubCommand sc : subCommands) {
                        for (String alt : sc.altNames) {
                            if (!alt.equalsIgnoreCase(s)) continue;
                            sc.arg0 = s;
                            sc.sender = this.sender;
                            sc.inform();
                            if (sc == this) break block0;
                            sc.reset();
                            break block0;
                        }
                    }
                }
                if (any) {
                    return;
                }
                ArrayList<SubCommand> good = new ArrayList<SubCommand>();
                for (SubCommand sc : subCommands) {
                    if (sc != this) {
                        sc.setup(this.sender);
                    }
                    if (sc.appropriate()) {
                        good.add(sc);
                    }
                    if (sc == this) continue;
                    sc.reset();
                }
                for (String msg : FZDSCommand.join(good).split("\n")) {
                    this.sendChat(msg);
                }
                this.sendChat("To specify a Coord or player: #worldId,x,y,z $PlayerName");
                this.sendChat("Best commands: cut d drop");
            }
        }, new Requires[0]);
        FZDSCommand.add(new SubCommand(new String[]{"go|gob|got"}){

            @Override
            String details() {
                return "Teleports player to the center/bottom/top of the selection, in Hammerspace. Be ready to fly.";
            }

            @Override
            public void call(String[] args) {
                DSTeleporter tp = this.getTp();
                tp.destination = this.arg0.equalsIgnoreCase("gob") ? this.selected.getCorner() : (this.arg0.equalsIgnoreCase("got") ? this.selected.getFarCorner() : this.selected.getCenter());
                if (DimensionManager.getWorld((int)DeltaChunk.getDimensionId()) != this.player.field_70170_p) {
                    manager.transferPlayerToDimension(this.player, DeltaChunk.getDimensionId(), (Teleporter)tp);
                } else {
                    --tp.destination.x;
                    tp.destination.moveToTopBlock();
                    this.player.func_70634_a((double)tp.destination.x + 0.5, (double)tp.destination.y, (double)tp.destination.z + 0.5);
                }
            }
        }, Requires.PLAYER, Requires.CREATIVE, Requires.SLICE_SELECTED);
        FZDSCommand.add(new SubCommand(new String[]{"enterhammer"}){

            @Override
            String details() {
                return "Teleports the player into hammerspace";
            }

            @Override
            void call(String[] args) {
                if (this.player.field_71093_bK == DeltaChunk.getDimensionId()) {
                    return;
                }
                DSTeleporter tp = this.getTp();
                tp.destination.set(DeltaChunk.getServerShadowWorld(), 0, 64, 0);
                manager.transferPlayerToDimension(this.player, DeltaChunk.getDimensionId(), (Teleporter)tp);
            }
        }, Requires.PLAYER, Requires.CREATIVE);
        FZDSCommand.add(new SubCommand(new String[]{"leave", "[dest=0]"}){

            @Override
            String details() {
                return "Teleports the player to the overworld";
            }

            @Override
            void call(String[] args) {
                DSTeleporter tp = this.getTp();
                int targetDimId = 0;
                if (args.length == 1) {
                    targetDimId = Integer.parseInt(args[0]);
                }
                WorldServer w = DimensionManager.getWorld((int)targetDimId);
                ChunkCoordinates target = this.player.getBedLocation(targetDimId);
                if (target == null) {
                    target = w.func_72861_E();
                }
                if (target != null) {
                    tp.destination.set(target);
                }
                manager.transferPlayerToDimension(this.player, 0, (Teleporter)tp);
            }
        }, Requires.PLAYER, Requires.CREATIVE);
        FZDSCommand.add(new SubCommand(new String[]{"jump"}){

            @Override
            String details() {
                return "Warps player to the selection";
            }

            @Override
            void call(String[] args) {
                DSTeleporter tp = this.getTp();
                tp.destination = new Coord(this.selected);
                manager.transferPlayerToDimension(this.player, this.selected.field_71093_bK, (Teleporter)tp);
            }
        }, Requires.PLAYER, Requires.CREATIVE, Requires.SLICE_SELECTED);
        FZDSCommand.add(new SubCommand(new String[]{"tome"}){

            @Override
            String details() {
                return "Warps selection to player";
            }

            @Override
            void call(String[] args) {
                this.selected.field_70165_t = this.user.x;
                this.selected.field_70163_u = this.user.y;
                this.selected.field_70161_v = this.user.z;
            }
        }, Requires.COORD, Requires.SLICE_SELECTED);
        FZDSCommand.add(new SubCommand(new String[]{"cut|copy", "x,y,z", "x,y,z"}){

            @Override
            String details() {
                return "Creates a Slice from the range given";
            }

            @Override
            void call(String[] args) {
                Coord base = new Coord(this.user.w, 0, 0, 0);
                boolean copy = this.arg0.contains("copy");
                Coord low = base.add(DeltaCoord.parse(args[0]));
                Coord up = base.add(DeltaCoord.parse(args[1]));
                Coord.sort(low, up);
                DeltaCoord dimensions = up.difference(low);
                int area = Math.abs(dimensions.x * dimensions.y * dimensions.z);
                if (area > Hammer.max_fzds_grab_area) {
                    this.sendChat("The area is too big: " + area + "; max is " + Hammer.max_fzds_grab_area);
                    return;
                }
                final Coord lower = low.copy();
                final Coord upper = up.copy();
                if (this.player != null) {
                    new Notice(lower, "Low", new String[0]).send((EntityPlayer)this.player);
                    new Notice(upper, "High", new String[0]).send((EntityPlayer)this.player);
                }
                IDeltaChunk dse = DeltaChunk.makeSlice(Hammer.fzds_command_channel, lower, upper, new DeltaChunk.AreaMap(){

                    @Override
                    public void fillDse(DeltaChunk.DseDestination destination) {
                        Coord here = user.copy();
                        for (int x = lower.x; x <= upper.x; ++x) {
                            for (int y = lower.y; y <= upper.y; ++y) {
                                for (int z = lower.z; z <= upper.z; ++z) {
                                    here.set(here.w, x, y, z);
                                    destination.include(here);
                                }
                            }
                        }
                    }
                }, !copy);
                dse.loadUsualCapabilities();
                dse.field_70170_p.func_72838_d((Entity)dse);
                FZDSCommand.setSelection(dse);
            }
        }, Requires.COORD);
        FZDSCommand.add(new SubCommand(new String[]{"movecenter", "x,y,z"}){

            @Override
            void call(String[] args) {
                Vec3 newOffset = null;
                try {
                    String[] vecArg = args[0].split(",");
                    newOffset = Vec3.func_72443_a((double)Double.parseDouble(vecArg[0]), (double)Double.parseDouble(vecArg[1]), (double)Double.parseDouble(vecArg[2]));
                }
                catch (Throwable e) {
                    Vec3 v = this.selected.getRotationalCenterOffset();
                    this.sendChat("Current rotational center: " + v.field_72450_a + "," + v.field_72448_b + "," + v.field_72449_c);
                }
                if (newOffset != null) {
                    this.selected.setRotationalCenterOffset(newOffset);
                }
            }
        }, Requires.SLICE_SELECTED);
        FZDSCommand.add(new SubCommand(new String[]{"grabchunk"}){

            @Override
            String details() {
                return "Cuts out the chunk you're standing in";
            }

            @Override
            void call(String[] args) {
                Coord min = this.user.copy();
                min.x &= 0xFFFFFFF0;
                min.z &= 0xFFFFFFF0;
                min.y = 0;
                Coord max = min.copy();
                max.x += 15;
                max.z += 15;
                max.y = 255;
                final Coord lower = min.copy();
                final Coord upper = max.copy();
                IDeltaChunk dse = DeltaChunk.makeSlice(Hammer.fzds_command_channel, lower, upper, new DeltaChunk.AreaMap(){

                    @Override
                    public void fillDse(DeltaChunk.DseDestination destination) {
                        Coord here = user.copy();
                        for (int x = lower.x; x <= upper.x; ++x) {
                            for (int y = lower.y; y <= upper.y; ++y) {
                                for (int z = lower.z; z <= upper.z; ++z) {
                                    here.set(here.w, x, y, z);
                                    destination.include(here);
                                }
                            }
                        }
                    }
                }, true);
                dse.loadUsualCapabilities();
                dse.field_70170_p.func_72838_d((Entity)dse);
                FZDSCommand.setSelection(dse);
            }
        }, Requires.COORD);
        FZDSCommand.add(new SubCommand(new String[]{"include"}){

            @Override
            void call(String[] args) {
            }
        }, Requires.SLICE_SELECTED);
        FZDSCommand.add(new SubCommand(new String[]{"drop", "[overwrite?]"}){

            @Override
            String details() {
                return "Returns a Slice's blocks to the world, destroying the Slice";
            }

            @Override
            void call(String[] args) {
                DeltaChunk.paste(this.selected, args.length >= 1);
                DeltaChunk.clear(this.selected);
                this.selected.func_70106_y();
                FZDSCommand.setSelection(null);
            }
        }, Requires.SLICE_SELECTED);
        FZDSCommand.add(new SubCommand(new String[]{"paste", "[overwrite?]"}){

            @Override
            String details() {
                return "Clones a Slice's blocks into the world";
            }

            @Override
            void call(String[] args) {
                DeltaChunk.paste(this.selected, args.length > 1);
            }
        }, Requires.SLICE_SELECTED, Requires.CREATIVE);
        FZDSCommand.add(new SubCommand(new String[]{"oracle", "x,y,z", "x,y,z"}){

            @Override
            void call(String[] args) {
                Coord base = new Coord(this.user.w, 0, 0, 0);
                Coord low = base.add(DeltaCoord.parse(args[0]));
                Coord up = base.add(DeltaCoord.parse(args[1]));
                DeltaChunk.AreaMap do_nothing = new DeltaChunk.AreaMap(){

                    @Override
                    public void fillDse(DeltaChunk.DseDestination destination) {
                    }
                };
                IDeltaChunk dse = DeltaChunk.makeSlice(Hammer.fzds_command_channel, low, up, do_nothing, false);
                dse.permit(DeltaCapability.ORACLE);
                dse.forbid(DeltaCapability.COLLIDE);
                this.user.setAsEntityLocation(dse);
                dse.field_70170_p.func_72838_d((Entity)dse);
            }
        }, Requires.OP);
        FZDSCommand.add(new SubCommand(new String[]{"grass"}){

            @Override
            String details() {
                return "Places a grass block at the user's feet";
            }

            @Override
            void call(String[] args) {
                this.user.add(0, -1, 0).setId((Block)Blocks.field_150349_c);
            }
        }, Requires.COORD, Requires.CREATIVE);
        FZDSCommand.add(new SubCommand(new String[]{"snap"}){

            @Override
            String details() {
                return "Rounds the Slice's position down to integers";
            }

            @Override
            void call(String[] args) {
                this.selected.field_70165_t = (int)this.selected.field_70165_t;
                this.selected.field_70163_u = (int)this.selected.field_70163_u;
                this.selected.field_70161_v = (int)this.selected.field_70161_v;
            }
        }, Requires.SLICE_SELECTED);
        FZDSCommand.add(new SubCommand(new String[]{"removeall"}){

            @Override
            String details() {
                return "Removes all Slices";
            }

            @Override
            void call(String[] args) {
                int i = 0;
                for (WorldServer w : MinecraftServer.func_71276_C().field_71305_c) {
                    for (Entity ent : w.field_72996_f) {
                        if (!(ent instanceof DimensionSliceEntity)) continue;
                        ent.func_70106_y();
                        ++i;
                        FZDSCommand.clearDseArea((DimensionSliceEntity)ent);
                    }
                }
                DeltaChunk.getSlices((World)MinecraftServer.func_71276_C().func_71218_a(0)).clear();
                this.sendChat("Removed " + i);
            }
        }, Requires.OP);
        FZDSCommand.add(new SubCommand(new String[]{"selection"}){

            @Override
            String details() {
                return "Prints the selection";
            }

            @Override
            void call(String[] args) {
                this.sendChat("> " + this.selected);
                FZDSCommand.setSelection(this.selected);
            }
        }, Requires.SLICE_SELECTED);
        FZDSCommand.add(new SubCommand(new String[]{"rot?"}){

            @Override
            String details() {
                return "Shows the rotation & angular velocity of the selection";
            }

            @Override
            void call(String[] args) {
                this.sendChat("r = " + this.selected.getRotation());
                this.sendChat("\u03c9 = " + this.selected.getRotationalVelocity());
                if (!this.selected.can(DeltaCapability.ROTATE)) {
                    this.sendChat("(Does not have the ROTATE cap, so this is meaningless)");
                }
            }
        }, Requires.SLICE_SELECTED);
        FZDSCommand.add(new SubCommand(new String[]{"+|-"}){

            @Override
            String details() {
                return "Changes which (loaded) Slice is selected";
            }

            @Override
            void call(String[] args) {
                boolean add = this.arg0.equals("+");
                ArrayList<List> entityLists = new ArrayList<List>();
                for (WorldServer world : MinecraftServer.func_71276_C().field_71305_c) {
                    if (world.field_72995_K) continue;
                    entityLists.add(world.field_72996_f);
                }
                IDeltaChunk first = null;
                IDeltaChunk prev = null;
                IDeltaChunk next = null;
                IDeltaChunk last = null;
                boolean found_current = false;
                for (Entity ent : Iterables.concat(entityLists)) {
                    IDeltaChunk here;
                    if (!(ent instanceof IDeltaChunk)) continue;
                    last = here = (IDeltaChunk)ent;
                    if (first == null) {
                        first = last;
                    }
                    if (!found_current) {
                        prev = last;
                    }
                    if (found_current && next == null) {
                        next = last;
                    }
                    if (last != this.selected) continue;
                    found_current = true;
                }
                if (first == null) {
                    this.sendChat("There are no DSEs loaded");
                    FZDSCommand.setSelection(null);
                    return;
                }
                this.selected = this.selected == null ? (add ? first : last) : (this.selected == last && add ? first : (this.selected == first && !add ? last : (add ? next : prev)));
                this.sendChat("> " + this.selected);
                FZDSCommand.setSelection(this.selected);
                if (this.selected != null && this.player != null) {
                    new Notice(this.selected, "Selection", new String[0]).send((EntityPlayer)this.player);
                }
            }
        }, new Requires[0]);
        FZDSCommand.add(new SubCommand(new String[]{"select-nearest"}){

            @Override
            void call(String[] args) {
                IDeltaChunk selected = null;
                double dist = Double.POSITIVE_INFINITY;
                for (IDeltaChunk idc : DeltaChunk.getAllSlices(this.user.w)) {
                    double d = this.user.distanceSq(new Coord(idc));
                    if (d > dist) continue;
                    dist = d;
                    selected = idc;
                }
                FZDSCommand.setSelection(selected);
            }
        }, Requires.COORD);
        FZDSCommand.add(new SubCommand(new String[]{"remove", "[part]"}){

            @Override
            String details() {
                return "Destroys the selection and everything attatched, unless 'part' is given";
            }

            @Override
            void call(String[] args) {
                boolean recursive = true;
                if (args.length == 1 && args[0].equalsIgnoreCase("part")) {
                    recursive = false;
                }
                HashSet<IDeltaChunk> toKill = new HashSet<IDeltaChunk>();
                toKill.add(this.selected);
                if (recursive) {
                    boolean any = true;
                    while (any) {
                        any = false;
                        ArrayList<IDeltaChunk> toAdd = new ArrayList<IDeltaChunk>();
                        for (IDeltaChunk idc : toKill) {
                            List<IDeltaChunk> children;
                            IDeltaChunk parent = idc.getParent();
                            if (parent != null) {
                                toAdd.add(parent);
                            }
                            if ((children = idc.getChildren()) == null) continue;
                            toAdd.addAll(children);
                        }
                        int firstSize = toKill.size();
                        toKill.addAll(toAdd);
                        any = firstSize != toKill.size();
                    }
                }
                for (IDeltaChunk idc : toKill) {
                    idc.func_70106_y();
                    FZDSCommand.clearDseArea(idc);
                }
                FZDSCommand.setSelection(null);
                this.sendChat("Made dead");
            }
        }, Requires.SLICE_SELECTED);
        FZDSCommand.add(new SubCommand(new String[]{"sr|sw", "angle\u00b0", "[direction=UP]"}){

            @Override
            String details() {
                return "Sets the Slice's rotation";
            }

            @Override
            void call(String[] args) {
                ForgeDirection dir;
                if (args.length != 2 && args.length != 1) {
                    throw new SyntaxErrorException();
                }
                if (!this.selected.can(DeltaCapability.ROTATE)) {
                    this.sendChat("Selection does not have the rotation cap");
                    return;
                }
                double theta = Math.toRadians(Double.parseDouble(args[0]));
                try {
                    dir = args.length == 2 ? ForgeDirection.valueOf((String)args[1].toUpperCase(Locale.ROOT)) : ForgeDirection.UP;
                }
                catch (IllegalArgumentException e) {
                    String msg = "Direction must be:";
                    for (ForgeDirection d : ForgeDirection.values()) {
                        if (d == ForgeDirection.UNKNOWN) continue;
                        msg = msg + " " + d;
                    }
                    this.sendChat(msg);
                    return;
                }
                Quaternion newVal = Quaternion.getRotationQuaternionRadians(theta, dir);
                if (this.arg0.equalsIgnoreCase("sr")) {
                    this.selected.setRotation(newVal);
                } else if (this.arg0.equalsIgnoreCase("sw")) {
                    this.selected.setRotationalVelocity(newVal);
                } else {
                    throw new SyntaxErrorException();
                }
            }
        }, Requires.SLICE_SELECTED);
        FZDSCommand.add(new SubCommand(new String[]{"d|s|v|r|w", "+|=", "[W=1]", "X", "Y", "Z"}){

            @Override
            String details() {
                return "Changes or sets displacement/velocity/rotation/angular_velocity";
            }

            @Override
            void call(String[] args) {
                int type = this.arg0.charAt(0);
                int n = type = type == 115 ? 100 : (int)type;
                if (args.length != 4 && args.length != 5) {
                    if (type == 100 || type == 118) {
                        this.sendChat("Usage: /fzds d(isplacement)|v(elocity) +|= X Y Z");
                    }
                    if (type == 114 || type == 119) {
                        this.sendChat("Usage: /fzds r(otation)|w(rotational velocity) +|= [W=1] X Y Z (a quaternion; cmds sr & sw are simpler)");
                    }
                    return;
                }
                int i = 0;
                double w = 1.0;
                if (args.length == 5) {
                    w = Double.parseDouble(args[1]);
                    i = 1;
                }
                double x = Double.parseDouble(args[1 + i]);
                double y = Double.parseDouble(args[2 + i]);
                double z = Double.parseDouble(args[3 + i]);
                if (!(type != 114 && type != 119 || this.selected.can(DeltaCapability.ROTATE))) {
                    this.sendChat("Selection does not have the ROTATE cap");
                    return;
                }
                if (args[0].equals("+")) {
                    if (type == 100 || type == 115) {
                        this.selected.func_70107_b(this.selected.field_70165_t + x, this.selected.field_70163_u + y, this.selected.field_70161_v + z);
                    } else if (type == 118) {
                        this.selected.func_70024_g(x / 20.0, y / 20.0, z / 20.0);
                    } else if (type == 114) {
                        this.selected.getRotation().incrAdd(new Quaternion(w, x, y, z));
                    } else if (type == 119) {
                        this.selected.getRotationalVelocity().incrAdd(new Quaternion(w, x, y, z));
                    } else {
                        this.sendChat("Not a command?");
                    }
                } else if (args[0].equals("=")) {
                    if (type == 100 || type == 115) {
                        this.selected.func_70107_b(x, y, z);
                    } else if (type == 118) {
                        this.selected.field_70159_w = 0.0;
                        this.selected.field_70181_x = 0.0;
                        this.selected.field_70179_y = 0.0;
                        this.selected.func_70024_g(x / 20.0, y / 20.0, z / 20.0);
                    } else if (type == 114) {
                        this.selected.setRotation(new Quaternion(w, x, y, z));
                    } else if (type == 119) {
                        Quaternion omega = new Quaternion(w, x, y, z);
                        this.selected.setRotationalVelocity(omega);
                    } else {
                        this.sendChat("Not a command?");
                    }
                    this.selected.getRotation().incrNormalize();
                    this.selected.getRotationalVelocity().incrNormalize();
                } else {
                    this.sendChat("+ or =?");
                }
            }
        }, Requires.SLICE_SELECTED);
        FZDSCommand.add(new SubCommand(new String[]{"dirty"}){

            @Override
            String details() {
                return "[Moves the selection back and forth]";
            }

            @Override
            void call(String[] args) {
                this.selected.getRotationalVelocity().w *= -1.0;
                this.selected.getRotation().w *= -1.0;
                this.selected.getRotation().w += 0.1;
            }
        }, Requires.SLICE_SELECTED);
        FZDSCommand.add(new SubCommand(new String[]{"caps"}){

            @Override
            String details() {
                return "Lists the available capabilities";
            }

            @Override
            void call(String[] args) {
                String r = "";
                for (DeltaCapability cap : DeltaCapability.values()) {
                    r = r + " " + (Object)((Object)cap);
                }
                this.sendChat(r);
            }
        }, new Requires[0]);
        FZDSCommand.add(new SubCommand(new String[]{"cap?"}){

            @Override
            String details() {
                return "Lists the capabilities enabled on the selection";
            }

            @Override
            void call(String[] args) {
                String r = "";
                for (DeltaCapability cap : DeltaCapability.values()) {
                    if (!this.selected.can(cap)) continue;
                    r = r + " " + (Object)((Object)cap);
                }
                this.sendChat(r);
            }
        }, Requires.SLICE_SELECTED);
        FZDSCommand.add(new SubCommand(new String[]{"cap+|cap-", "CAP+"}){

            @Override
            String details() {
                return "Gives or takes away capabilities. (May cause client desyncing.)";
            }

            @Override
            void call(String[] args) {
                for (String a : args) {
                    DeltaCapability cap = DeltaCapability.valueOf(a);
                    if (this.arg0.equalsIgnoreCase("cap+")) {
                        this.selected.permit(cap);
                        continue;
                    }
                    this.selected.forbid(cap);
                }
            }
        }, Requires.SLICE_SELECTED, Requires.OP);
        FZDSCommand.add(new SubCommand(new String[]{"incrScale", "newScale"}){

            @Override
            void call(String[] args) {
                if (!this.selected.can(DeltaCapability.SCALE)) {
                    this.sendChat("Selection doesn't have the SCALE cap");
                    return;
                }
                ((DimensionSliceEntity)this.selected).scale = Float.parseFloat(args[0]);
            }
        }, Requires.SLICE_SELECTED, Requires.CREATIVE);
        FZDSCommand.add(new SubCommand(new String[]{"alpha", "newOpacity"}){

            @Override
            void call(String[] args) {
                if (!this.selected.can(DeltaCapability.TRANSPARENT)) {
                    this.sendChat("Selection doesn't have the TRANSPARENT cap");
                    return;
                }
                ((DimensionSliceEntity)this.selected).opacity = Float.parseFloat(args[0]);
            }
        }, Requires.SLICE_SELECTED, Requires.CREATIVE);
        FZDSCommand.add(new SubCommand(new String[]{"setBlockMethod", "mode"}){

            @Override
            String details() {
                return "0=lowlevel 1=world.isRemote 2=world.setBlock 3=world.setBlock2+flags";
            }

            @Override
            void call(String[] args) {
                int mode = Integer.parseInt(args[0]);
                this.sendChat("setBlockMethod was " + TransferLib.default_set_method + ", is now " + mode);
                TransferLib.default_set_method = mode;
            }
        }, Requires.OP, Requires.CREATIVE);
        FZDSCommand.add(new SubCommand(new String[]{"@", "name [position|'unset']"}){

            @Override
            String details() {
                return "Set position variables ('@name' gets replaced with position)";
            }

            @Override
            void call(String[] args) {
                String name = args[0];
                Coord val = this.user;
                if (args.length == 2) {
                    String parse = args[1];
                    if (parse.equalsIgnoreCase("unset")) {
                        if (positionVariables.remove(name) != null) {
                            this.sendChat("Unset: " + name);
                        } else {
                            this.sendChat("Didn't exist: " + name);
                        }
                        return;
                    }
                    val = FZDSCommand.parseCoord(this.user.w, parse);
                }
                positionVariables.put(name, val);
                this.sendChat("@" + name + " = " + val);
                if (this.player != null) {
                    new Notice(val, name, new String[0]).send((EntityPlayer)this.player);
                }
            }
        }, Requires.COORD);
        FZDSCommand.add(new SubCommand(new String[]{"@?|@??", "[search]"}){

            @Override
            String details() {
                return "Show, and maybe list, position variables";
            }

            @Override
            void call(String[] args) {
                boolean print = this.arg0.equalsIgnoreCase("@??");
                String search = "";
                if (args.length == 1) {
                    search = args[0];
                }
                for (Map.Entry<String, Coord> var : positionVariables.entrySet()) {
                    String name = var.getKey();
                    Coord pos = var.getValue();
                    if (pos.w != this.user.w || !name.contains(search)) continue;
                    if (this.player != null) {
                        new Notice(pos, name, new String[0]).send((EntityPlayer)this.player);
                    }
                    if (!print) continue;
                    this.sendChat(name + ": " + pos);
                }
            }
        }, Requires.COORD, Requires.PLAYER);
        FZDSCommand.add(new SubCommand(new String[]{"construct", "x,y,z", "x,y,z"}){

            @Override
            String details() {
                return "Create a DSE from Hammerspace coordinates";
            }

            @Override
            void call(String[] args) {
                Coord origin = new Coord(DeltaChunk.getServerShadowWorld(), 0, 0, 0);
                Coord low = origin.add(DeltaCoord.parse(args[0]));
                Coord upr = origin.add(DeltaCoord.parse(args[1]));
                Coord.sort(low, upr);
                IDeltaChunk dse = DeltaChunk.construct(this.user.w, low, upr);
                dse.loadUsualCapabilities();
                this.user.setAsEntityLocation(dse);
                this.user.w.func_72838_d((Entity)dse);
            }
        }, Requires.COORD);
        FZDSCommand.add(new SubCommand(new String[]{"orbitme"}){

            @Override
            void call(String[] args) {
                Vec3 p = Vec3.func_72443_a((double)this.player.field_70165_t, (double)this.player.field_70163_u, (double)this.player.field_70161_v);
                this.selected.changeRotationCenter(p);
            }
        }, Requires.SLICE_SELECTED, Requires.PLAYER);
        FZDSCommand.add(new SubCommand(new String[]{"resetbody"}){

            @Override
            String details() {
                return "Resets the rotation of a DSE & its children";
            }

            @Override
            void call(String[] args) {
                this.selected.cancelOrderedRotation();
                this.selected.setRotation(new Quaternion());
                this.selected.setRotationalVelocity(new Quaternion());
                for (IDeltaChunk idc : this.selected.getChildren()) {
                    Vec3 base = idc.getParentJoint();
                    Vec3 snapTo = idc.shadow2real(base);
                    SpaceUtil.toEntPos(idc, snapTo);
                    this.selected = idc;
                    this.call(args);
                }
            }
        }, Requires.SLICE_SELECTED);
        FZDSCommand.add(new SubCommand(new String[]{"setParent"}){

            @Override
            String details() {
                return "Sets the selected DSE's parent by the parent's ID";
            }

            @Override
            void call(String[] args) {
                int id = Integer.parseInt(args[0]);
                Entity ent = this.selected.field_70170_p.func_73045_a(id);
                if (!(ent instanceof IDeltaChunk)) {
                    this.sendChat("ID did not point to a DSE");
                    return;
                }
                IDeltaChunk parent = (IDeltaChunk)ent;
                if (parent == this.selected) {
                    this.sendChat("Can't parent to itself");
                    return;
                }
                this.selected.setParent(parent);
            }
        }, Requires.SLICE_SELECTED);
        if (Core.dev_environ) {
            FZDSCommand.add(new SubCommand(new String[]{"test"}){

                @Override
                void call(String[] args) {
                    if (args.length > 0 && args[0].equals("cam")) {
                        Minecraft.func_71410_x().field_71474_y.field_74325_U ^= true;
                        return;
                    }
                    double angle = Math.PI * this.selected.field_70170_p.field_73012_v.nextDouble();
                    ForgeDirection up = ForgeDirection.UP;
                    int time = 30;
                    if (this.selected.getParent() == null) {
                        up = ForgeDirection.NORTH;
                        time = 300;
                    }
                    Quaternion quat = Quaternion.getRotationQuaternionRadians(angle, up);
                    this.selected.orderTargetRotation(quat, time, Interpolation.SMOOTH);
                }
            }, Requires.SLICE_SELECTED);
        }
        FZDSCommand.add(new SubCommand(new String[]{"setbiome", "x,y,z", "x,y,z", "biomeId"}){

            @Override
            String details() {
                return "Changes the biome ID; see the manual's reference section for biomes";
            }

            @Override
            void call(String[] args) {
                Coord origin = new Coord(this.world, 0, 0, 0);
                Coord low = origin.add(DeltaCoord.parse(args[0]));
                Coord upr = origin.add(DeltaCoord.parse(args[1]));
                Coord.sort(low, upr);
                low.y = upr.y;
                int biomeId = Integer.parseInt(args[2]);
                final BiomeGenBase biome = BiomeGenBase.func_150568_d((int)biomeId);
                Coord.iterateCube(low, upr, new ICoordFunction(){

                    @Override
                    public void handle(Coord here) {
                        here.setBiome(biome);
                    }
                });
                Coord.iterateChunks(low, upr, new ICoordFunction(){

                    @Override
                    public void handle(Coord here) {
                        here.resyncChunksFull();
                    }
                });
            }
        }, Requires.CREATIVE, Requires.PLAYER);
    }

    public static enum Requires {
        OP,
        PLAYER,
        COORD,
        SLICE_SELECTED,
        CREATIVE;


        void apply(SubCommand sc) {
            switch (this) {
                case OP: {
                    sc.needOp = true;
                    break;
                }
                case PLAYER: {
                    sc.needPlayer = true;
                    break;
                }
                case COORD: {
                    sc.needCoord = true;
                    break;
                }
                case SLICE_SELECTED: {
                    sc.needSelection = true;
                    break;
                }
                case CREATIVE: {
                    sc.needCreative = true;
                }
            }
        }
    }

    public static abstract class SubCommand {
        String[] help;
        ArrayList<String> altNames = new ArrayList();
        private boolean needOp;
        private boolean needPlayer;
        private boolean needCoord;
        private boolean needSelection;
        private boolean needCreative;
        Requires[] reqs;
        private static Splitter pipe = Splitter.on((char)'|');
        static ServerConfigurationManager manager = MinecraftServer.func_71276_C().func_71203_ab();
        String arg0;
        ICommandSender sender;
        EntityPlayerMP player;
        World world;
        Coord user;
        boolean op;
        boolean creative;
        IDeltaChunk selected;

        public SubCommand(String ... help2) {
            this.help = help2;
            if (help2.length == 0) {
                throw new IllegalArgumentException("No subcommand name");
            }
            for (String s : pipe.split((CharSequence)help2[0])) {
                this.altNames.add(s);
            }
        }

        public SubCommand() {
        }

        abstract void call(String[] var1);

        private void reset() {
            this.sender = null;
            this.player = null;
            this.world = null;
            this.user = null;
            this.op = false;
            this.creative = false;
            this.selected = null;
        }

        private void setup(ICommandSender sender) {
            this.sender = sender;
            if (sender instanceof EntityPlayerMP) {
                this.player = (EntityPlayerMP)sender;
            }
            if (sender instanceof TileEntity) {
                this.user = new Coord((TileEntity)sender);
            }
            this.selected = (IDeltaChunk)currentSelection.get();
            if (sender.func_70003_b(4, "stop")) {
                this.op = true;
            }
            if (sender instanceof TileEntityCommandBlock) {
                this.op = true;
            }
            if (this.op) {
                this.creative = true;
            }
        }

        DSTeleporter getTp() {
            DSTeleporter tp = new DSTeleporter((WorldServer)this.player.field_70170_p);
            tp.destination = new Coord(this.player.field_70170_p, 0, 0, 0);
            return tp;
        }

        boolean appropriate() {
            if (this.needOp && !this.op) {
                return false;
            }
            return !this.needCreative || this.creative;
        }

        String details() {
            return null;
        }

        final String getHelp() {
            String msg = "";
            boolean first = true;
            for (String m : this.help) {
                if (first) {
                    first = false;
                } else {
                    msg = msg + " ";
                }
                msg = msg + m;
            }
            return msg;
        }

        final String getNeeds() {
            if (this.reqs.length == 0) {
                return "";
            }
            String ret = "[Need:";
            for (Requires r : this.reqs) {
                ret = ret + " " + (Object)((Object)r);
            }
            return ret + "]";
        }

        void inform() {
            String msg = this.getHelp();
            String d = this.details();
            if (d != null) {
                msg = msg + ": " + d;
            }
            this.sendChat(msg);
        }

        void sendChat(String msg) {
            LangUtil.sendChatMessage(true, this.sender, msg);
        }
    }
}

