/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import factorization.fzds.DimensionSliceEntity;
import factorization.fzds.interfaces.IFzdsShenanigans;
import factorization.shared.Core;
import factorization.util.NumUtil;
import factorization.util.SpaceUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class MetaAxisAlignedBB
extends AxisAlignedBB
implements IFzdsShenanigans {
    private DimensionSliceEntity idc;
    private World shadowWorld;
    private static final List<AxisAlignedBB> EMPTY = new ArrayList<AxisAlignedBB>();
    private AxisAlignedBB real2shadowBox = SpaceUtil.newBox();
    private Vec3 realMiddle = SpaceUtil.newVec3();
    private Vec3 minMinusMiddle = SpaceUtil.newVec3();
    private Vec3 maxMinusMiddle = SpaceUtil.newVec3();
    private AxisAlignedBB shadowWorker = SpaceUtil.newBox();
    private Vec3 shadowMiddle = SpaceUtil.newVec3();
    private final AxisAlignedBB worker = SpaceUtil.newBox();

    public MetaAxisAlignedBB(DimensionSliceEntity idc, World shadowWorld) {
        super(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.idc = idc;
        this.shadowWorld = shadowWorld;
    }

    public MetaAxisAlignedBB setUnderlying(AxisAlignedBB bb) {
        this.func_72328_c(bb);
        return this;
    }

    List<AxisAlignedBB> getShadowBoxesWithinShadowBox(AxisAlignedBB box) {
        double averageEdgeLength = box.func_72320_b();
        if (averageEdgeLength > 1024.0) {
            Core.logSevere("Giant MetaAABB!? {}", this);
            Thread.dumpStack();
            return EMPTY;
        }
        ArrayList<AxisAlignedBB> ret = new ArrayList<AxisAlignedBB>();
        int R = 30000000;
        int boxMinX = NumUtil.clip(MathHelper.func_76128_c((double)(box.field_72340_a + 0.0)), -30000000, 30000000);
        int boxMaxX = NumUtil.clip(MathHelper.func_76128_c((double)(box.field_72336_d + 1.0)), -30000000, 30000000);
        int boxMinY = NumUtil.clip(MathHelper.func_76128_c((double)(box.field_72338_b + 0.0)), 0, 255);
        int boxMaxY = NumUtil.clip(MathHelper.func_76128_c((double)(box.field_72337_e + 1.0)), 0, 255);
        int boxMinZ = NumUtil.clip(MathHelper.func_76128_c((double)(box.field_72339_c + 0.0)), -30000000, 30000000);
        int boxMaxZ = NumUtil.clip(MathHelper.func_76128_c((double)(box.field_72334_f + 1.0)), -30000000, 30000000);
        int chunkMinX = boxMinX >> 4;
        int chunkMaxX = (boxMaxX >> 4) + 1;
        int chunkMinZ = boxMinZ >> 4;
        int chunkMaxZ = (boxMaxZ >> 4) + 1;
        for (int chunkX = chunkMinX; chunkX < chunkMaxX; ++chunkX) {
            for (int chunkZ = chunkMinZ; chunkZ < chunkMaxZ; ++chunkZ) {
                Chunk chunk = this.shadowWorld.func_72964_e(chunkX, chunkZ);
                int cornerX = chunk.field_76635_g << 4;
                int cornerZ = chunk.field_76647_h << 4;
                int lx = NumUtil.clip(boxMinX, cornerX, cornerX + 16);
                int hx = NumUtil.clip(boxMaxX + 1, cornerX, cornerX + 16);
                int lz = NumUtil.clip(boxMinZ, cornerZ, cornerZ + 16);
                int hz = NumUtil.clip(boxMaxZ + 1, cornerZ, cornerZ + 16);
                for (int y = boxMinY; y < boxMaxY; ++y) {
                    for (int z = lz; z < hz; ++z) {
                        for (int x = lx; x < hx; ++x) {
                            if (!NumUtil.intersect(x, x + 1, box.field_72340_a, box.field_72336_d) || !NumUtil.intersect(y, y + 1, box.field_72338_b, box.field_72337_e) || !NumUtil.intersect(z, z + 1, box.field_72339_c, box.field_72334_f)) continue;
                            Block block = chunk.func_150810_a(x & 0xF, y, z & 0xF);
                            block.func_149743_a(this.shadowWorld, x, y, z, box, ret, (Entity)this.idc);
                        }
                    }
                }
            }
        }
        return ret;
    }

    List<AxisAlignedBB> getShadowBoxesInRealBox(AxisAlignedBB realBox) {
        double expansion = 0.3660254037844387;
        AxisAlignedBB shadowBox = this.convertRealBoxToShadowBox(realBox);
        if (!this.idc.getRotation().isZero()) {
            shadowBox = this.outset(shadowBox, expansion, expansion, expansion);
        }
        return this.getShadowBoxesWithinShadowBox(shadowBox);
    }

    AxisAlignedBB convertRealBoxToShadowBox(AxisAlignedBB realBox) {
        SpaceUtil.setMiddle(realBox, this.realMiddle);
        double d = SpaceUtil.getDiagonalLength(realBox);
        Vec3 shadowMiddle = this.convertRealVecToShadowVec(this.realMiddle);
        this.real2shadowBox.field_72340_a = shadowMiddle.field_72450_a - d;
        this.real2shadowBox.field_72338_b = shadowMiddle.field_72448_b - d;
        this.real2shadowBox.field_72339_c = shadowMiddle.field_72449_c - d;
        this.real2shadowBox.field_72336_d = shadowMiddle.field_72450_a + d;
        this.real2shadowBox.field_72337_e = shadowMiddle.field_72448_b + d;
        this.real2shadowBox.field_72334_f = shadowMiddle.field_72449_c + d;
        return this.real2shadowBox;
    }

    AxisAlignedBB convertShadowBoxToRealBox(AxisAlignedBB shadowBox) {
        SpaceUtil.setMiddle(shadowBox, this.shadowMiddle);
        SpaceUtil.getMin(shadowBox, this.minMinusMiddle);
        SpaceUtil.getMax(shadowBox, this.maxMinusMiddle);
        SpaceUtil.incrSubtract(this.minMinusMiddle, this.shadowMiddle);
        SpaceUtil.incrSubtract(this.maxMinusMiddle, this.shadowMiddle);
        Vec3 realMiddle = this.convertShadowVecToRealVec(this.shadowMiddle);
        SpaceUtil.incrAdd(this.minMinusMiddle, realMiddle);
        SpaceUtil.incrAdd(this.maxMinusMiddle, realMiddle);
        SpaceUtil.updateAABB(this.shadowWorker, this.minMinusMiddle, this.maxMinusMiddle);
        return this.shadowWorker;
    }

    Vec3 convertRealVecToShadowVec(Vec3 real) {
        return this.idc.real2shadow(real);
    }

    Vec3 convertShadowVecToRealVec(Vec3 shadow) {
        return this.idc.shadow2real(shadow);
    }

    private AxisAlignedBB expand(AxisAlignedBB collider, double dx, double dy, double dz) {
        if (dx >= 0.0) {
            this.worker.field_72340_a = collider.field_72340_a;
            this.worker.field_72336_d = collider.field_72336_d + dx;
        } else {
            this.worker.field_72340_a = collider.field_72340_a + dx;
            this.worker.field_72336_d = collider.field_72336_d;
        }
        if (dy >= 0.0) {
            this.worker.field_72338_b = collider.field_72338_b;
            this.worker.field_72337_e = collider.field_72337_e + dy;
        } else {
            this.worker.field_72338_b = collider.field_72338_b + dy;
            this.worker.field_72337_e = collider.field_72337_e;
        }
        if (dz >= 0.0) {
            this.worker.field_72339_c = collider.field_72339_c;
            this.worker.field_72334_f = collider.field_72334_f + dz;
        } else {
            this.worker.field_72339_c = collider.field_72339_c + dz;
            this.worker.field_72334_f = collider.field_72334_f;
        }
        return this.worker;
    }

    private AxisAlignedBB outset(AxisAlignedBB box, double dx, double dy, double dz) {
        box.field_72340_a -= dx;
        box.field_72338_b -= dy;
        box.field_72339_c -= dz;
        box.field_72336_d += dx;
        box.field_72337_e += dy;
        box.field_72334_f += dz;
        return box;
    }

    public double func_72316_a(AxisAlignedBB collider, double currentOffset) {
        collider = collider.func_72329_c();
        List<AxisAlignedBB> shadowBoxes = this.getShadowBoxesInRealBox(this.expand(collider, currentOffset, 0.0, 0.0));
        for (AxisAlignedBB shadowBox : shadowBoxes) {
            AxisAlignedBB realShadow = this.convertShadowBoxToRealBox(shadowBox);
            currentOffset = realShadow.func_72316_a(collider, currentOffset);
        }
        return currentOffset;
    }

    public double func_72323_b(AxisAlignedBB collider, double currentOffset) {
        collider = collider.func_72329_c();
        List<AxisAlignedBB> shadowBoxes = this.getShadowBoxesInRealBox(this.expand(collider, 0.0, currentOffset, 0.0));
        for (AxisAlignedBB shadowBox : shadowBoxes) {
            AxisAlignedBB realShadow = this.convertShadowBoxToRealBox(shadowBox);
            currentOffset = realShadow.func_72323_b(collider, currentOffset);
        }
        return currentOffset;
    }

    public double func_72322_c(AxisAlignedBB collider, double currentOffset) {
        collider = collider.func_72329_c();
        List<AxisAlignedBB> shadowBoxes = this.getShadowBoxesInRealBox(this.expand(collider, 0.0, 0.0, currentOffset));
        for (AxisAlignedBB shadowBox : shadowBoxes) {
            AxisAlignedBB realShadow = this.convertShadowBoxToRealBox(shadowBox);
            currentOffset = realShadow.func_72322_c(collider, currentOffset);
        }
        return currentOffset;
    }

    public AxisAlignedBB intersectsWithGet(AxisAlignedBB collider) {
        if (!this.idc.realArea.func_72326_a(collider)) {
            return null;
        }
        List<AxisAlignedBB> shadowBoxes = this.getShadowBoxesInRealBox(collider);
        for (AxisAlignedBB shadowBox : shadowBoxes) {
            AxisAlignedBB realShadow = this.convertShadowBoxToRealBox(shadowBox);
            if (!realShadow.func_72326_a(collider)) continue;
            return shadowBox;
        }
        return null;
    }

    public boolean func_72326_a(AxisAlignedBB collider) {
        return this.intersectsWithGet(collider) != null;
    }

    public String toString() {
        return "META" + super.toString();
    }
}

