/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import factorization.aabbdebug.AabbDebugger;
import factorization.api.Coord;
import factorization.api.Quaternion;
import factorization.common.FzConfig;
import factorization.fzds.DeltaChunk;
import factorization.fzds.DimensionSliceEntity;
import factorization.fzds.Hammer;
import factorization.fzds.HammerClientProxy;
import factorization.fzds.interfaces.DeltaCapability;
import factorization.fzds.interfaces.IFzdsShenanigans;
import factorization.shared.Core;
import factorization.util.NumUtil;
import factorization.util.RenderUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;

public class RenderDimensionSliceEntity
extends Render
implements IFzdsShenanigans {
    public static int update_frequency = 16;
    public static RenderDimensionSliceEntity instance;
    private Set<DSRenderInfo> renderInfoTracker = new HashSet<DSRenderInfo>();
    private static long megatickCount;
    Vec3 shadowEyeVec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    EntityLivingBase shadowEye = new EntityLivingBase(null){

        protected void func_70088_a() {
        }

        public void func_70037_a(NBTTagCompound var1) {
        }

        public void func_70014_b(NBTTagCompound var1) {
        }

        public ItemStack func_70694_bm() {
            return null;
        }

        public ItemStack func_71124_b(int var1) {
            return null;
        }

        public void func_70062_b(int var1, ItemStack var2) {
        }

        public ItemStack[] func_70035_c() {
            return null;
        }

        public void func_70606_j(float par1) {
        }
    };
    public static int nest;
    private int tickDelay = 0;

    public RenderDimensionSliceEntity() {
        instance = this;
        Core.loadBus(this);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return null;
    }

    static void markBlocksForUpdate(DimensionSliceEntity dse, int lx, int ly, int lz, int hx, int hy, int hz) {
        if (dse.renderInfo == null) {
            RenderDimensionSliceEntity renderDimensionSliceEntity = instance;
            renderDimensionSliceEntity.getClass();
            dse.renderInfo = renderDimensionSliceEntity.new DSRenderInfo(dse);
        }
        DSRenderInfo renderInfo = (DSRenderInfo)dse.renderInfo;
        renderInfo.anyRenderersDirty = true;
        for (int i = 0; i < renderInfo.renderers.length; ++i) {
            WorldRenderer wr = renderInfo.renderers[i];
            if (!NumUtil.intersect(lx, hx, wr.field_78923_c, wr.field_78923_c + 16) || !NumUtil.intersect(ly, hy, wr.field_78920_d, wr.field_78920_d + 16) || !NumUtil.intersect(lz, hz, wr.field_78921_e, wr.field_78921_e + 16)) continue;
            wr.func_78914_f();
        }
    }

    DSRenderInfo getRenderInfo(DimensionSliceEntity dse) {
        if (dse.renderInfo == null) {
            dse.renderInfo = new DSRenderInfo(dse);
        }
        return (DSRenderInfo)dse.renderInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_76986_a(Entity ent, double x, double y, double z, float yaw, float partialTicks) {
        if (ent.field_70128_L) {
            return;
        }
        DimensionSliceEntity dse = (DimensionSliceEntity)ent;
        DSRenderInfo renderInfo = this.getRenderInfo(dse);
        if (nest == 0) {
            if (RenderManager.field_85095_o) {
                AabbDebugger.addBox(dse.realArea);
            }
            Core.profileStart("fzds");
            RenderUtil.checkGLError("FZDS before render -- somebody left us a mess!");
            renderInfo.lastRenderInMegaticks = megatickCount;
        } else if (nest == 1) {
            Core.profileStart("recursion");
        } else if (nest > 3) {
            return;
        }
        EntityClientPlayerMP real_player = Minecraft.func_71410_x().field_71439_g;
        ++nest;
        try {
            boolean oracle;
            block37: {
                oracle = dse.can(DeltaCapability.ORACLE);
                if (nest == 1) {
                    Core.profileStart("update");
                    try {
                        if (oracle) {
                            renderInfo.update();
                            break block37;
                        }
                        Hammer.proxy.setShadowWorld();
                        try {
                            renderInfo.update();
                        }
                        finally {
                            Hammer.proxy.restoreRealWorld();
                        }
                    }
                    finally {
                        Core.profileEnd();
                    }
                }
            }
            GL11.glPushMatrix();
            try {
                GL11.glTranslated((double)x, (double)y, (double)z);
                Quaternion rotation = dse.getRotation();
                if (!rotation.isZero() || !dse.prevTickRotation.isZero()) {
                    Quaternion rot = dse.prevTickRotation.slerp(rotation, partialTicks);
                    rot.incrNormalize();
                    rot.glRotate();
                }
                Vec3 centerOffset = dse.getRotationalCenterOffset();
                GL11.glTranslated((double)(-centerOffset.field_72450_a), (double)(-centerOffset.field_72448_b), (double)(-centerOffset.field_72449_c));
                if (dse.scale != 1.0f) {
                    GL11.glScalef((float)dse.scale, (float)dse.scale, (float)dse.scale);
                }
                if (dse.opacity != 1.0f) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)dse.opacity);
                }
                Core.profileStart("renderTerrain");
                renderInfo.renderTerrain();
                Core.profileEnd();
                RenderUtil.checkGLError("FZDS terrain display list render");
                GL11.glTranslated((double)(dse.field_70165_t - x), (double)(dse.field_70163_u - y), (double)(dse.field_70161_v - z));
                Coord c = dse.getCorner();
                GL11.glTranslated((double)(-c.x), (double)(-c.y), (double)(-c.z));
                if (nest == 1) {
                    renderInfo.updateRelativeEyePosition();
                    if (oracle) {
                        renderInfo.renderBreakingBlocks((EntityPlayer)real_player, partialTicks);
                        renderInfo.renderEntities(partialTicks);
                    } else {
                        Hammer.proxy.setShadowWorld();
                        try {
                            renderInfo.renderBreakingBlocks((EntityPlayer)real_player, partialTicks);
                            renderInfo.renderEntities(partialTicks);
                        }
                        finally {
                            Hammer.proxy.restoreRealWorld();
                        }
                    }
                } else {
                    renderInfo.renderEntities(partialTicks);
                }
                RenderUtil.checkGLError("FZDS entity render");
            }
            finally {
                if (dse.opacity != 1.0f) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                GL11.glPopMatrix();
            }
        }
        catch (Exception e) {
            Core.logSevere("FZDS failed to render", new Object[0]);
            e.printStackTrace(System.err);
        }
        finally {
            if (--nest == 0) {
                RenderUtil.checkGLError("FZDS after render");
                Core.profileEnd();
            } else if (nest == 1) {
                Core.profileEnd();
            }
        }
    }

    void discardOldRenderLists() {
        Iterator<DSRenderInfo> it = this.renderInfoTracker.iterator();
        while (it.hasNext()) {
            DSRenderInfo renderInfo = it.next();
            if (renderInfo.lastRenderInMegaticks >= megatickCount - 1L) continue;
            renderInfo.discardRenderList();
            it.remove();
        }
    }

    @SubscribeEvent
    public void worldChanged(WorldEvent.Unload unloadEvent) {
        megatickCount += 100L;
    }

    @SubscribeEvent
    public void tick(TickEvent.RenderTickEvent event) {
        if (this.tickDelay++ <= 20) {
            return;
        }
        this.tickDelay = 0;
        if (event.phase == TickEvent.Phase.START) {
            this.tickStart();
        } else if (event.phase == TickEvent.Phase.END) {
            this.tickEnd();
        }
    }

    public void tickStart() {
        ++megatickCount;
        if (nest != 0) {
            nest = 0;
            Core.logSevere("FZDS render nesting depth was not 0", new Object[0]);
        }
    }

    public void tickEnd() {
        this.discardOldRenderLists();
    }

    static /* synthetic */ long access$000() {
        return megatickCount;
    }

    static {
        megatickCount = 0L;
        nest = 0;
    }

    class DSRenderInfo {
        private final int wr_display_list_size = 3;
        final int entity_buffer = 8;
        int renderCounts = 0;
        long lastRenderInMegaticks = RenderDimensionSliceEntity.access$000();
        boolean anyRenderersDirty = true;
        private int renderList = -1;
        private WorldRenderer[] renderers = null;
        Coord corner;
        Coord far;
        DimensionSliceEntity dse;
        int xSize;
        int ySize;
        int zSize;
        int xSizeChunk;
        int ySizeChunk;
        int zSizeChunk;
        int cubicChunkCount;
        RenderBlocks rb = new RenderBlocks((IBlockAccess)DeltaChunk.getClientShadowWorld());
        int last_update_index = 0;
        int render_skips = 0;

        public DSRenderInfo(DimensionSliceEntity dse) {
            this.dse = dse;
            this.corner = dse.getCorner();
            this.far = dse.getFarCorner();
            this.xSize = this.far.x - this.corner.x;
            this.ySize = this.far.y - this.corner.y;
            this.zSize = this.far.z - this.corner.z;
            int DSC = 16;
            this.xSizeChunk = (this.xSize + DSC) / 16;
            this.ySizeChunk = (this.ySize + DSC) / 16;
            this.zSizeChunk = (this.zSize + DSC) / 16;
            if (this.xSizeChunk <= 0 || this.ySizeChunk <= 0 || this.zSizeChunk <= 0) {
                throw new AssertionError();
            }
            this.cubicChunkCount = this.xSizeChunk * this.ySizeChunk * this.zSizeChunk;
            this.renderers = new WorldRenderer[this.cubicChunkCount];
            int i = 0;
            RenderUtil.checkGLError("FZDS before render");
            int DC = 16;
            for (int y = this.corner.y; y <= this.far.y; y += DC) {
                for (int x = this.corner.x; x <= this.far.x; x += DC) {
                    for (int z = this.corner.z; z <= this.far.z; z += DC) {
                        this.renderers[i] = new WorldRenderer(this.corner.w, this.corner.w.field_147482_g, x, y, z, this.getRenderList() + i * 3);
                        this.renderers[i].field_78932_i = x - this.corner.x;
                        this.renderers[i].field_78929_j = y - this.corner.y;
                        this.renderers[i].field_78930_k = z - this.corner.z;
                        this.renderers[i].func_78914_f();
                        RenderUtil.checkGLError("FZDS WorldRenderer init");
                        ++i;
                    }
                }
            }
            if (i != this.cubicChunkCount) {
                throw new AssertionError();
            }
        }

        void updateRelativeEyePosition() {
            EntityLivingBase player = Minecraft.func_71410_x().field_71451_h;
            RenderDimensionSliceEntity.this.shadowEyeVec.field_72450_a = player.field_70165_t;
            RenderDimensionSliceEntity.this.shadowEyeVec.field_72448_b = player.field_70163_u;
            RenderDimensionSliceEntity.this.shadowEyeVec.field_72449_c = player.field_70161_v;
            Vec3 eyepos = this.dse.real2shadow(RenderDimensionSliceEntity.this.shadowEyeVec);
            RenderDimensionSliceEntity.this.shadowEye.field_70165_t = eyepos.field_72450_a;
            RenderDimensionSliceEntity.this.shadowEye.field_70163_u = eyepos.field_72448_b;
            RenderDimensionSliceEntity.this.shadowEye.field_70161_v = eyepos.field_72449_c;
        }

        void update() {
            if (this.far.getChunk().func_76621_g()) {
                return;
            }
            if (!this.anyRenderersDirty) {
                this.last_update_index = 0;
                return;
            }
            boolean start_from_begining = this.last_update_index == 0;
            Core.profileStart("updateFzdsTerrain");
            RenderUtil.checkGLError("FZDS before WorldRender update");
            int update_limit = 20;
            int updates = 0;
            while (this.last_update_index < this.renderers.length) {
                WorldRenderer wr = this.renderers[this.last_update_index++];
                if (!wr.field_78939_q) continue;
                if (updates == 0) {
                    this.updateRelativeEyePosition();
                }
                wr.func_147892_a(RenderDimensionSliceEntity.this.shadowEye);
                if (++updates != 20) continue;
                break;
            }
            if (this.last_update_index == this.renderers.length) {
                this.last_update_index = 0;
            }
            if (start_from_begining) {
                this.anyRenderersDirty = false;
            }
            Core.profileEnd();
        }

        void renderTerrain() {
            GL11.glPushAttrib((int)16448);
            RenderHelper.func_74518_a();
            Minecraft mc = Minecraft.func_71410_x();
            if (Minecraft.func_71379_u() && FzConfig.dimension_slice_allow_smooth) {
                GL11.glShadeModel((int)7425);
            }
            for (int pass = 0; pass < 2; ++pass) {
                if (pass == 1) {
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glEnable((int)3042);
                }
                for (int i = 0; i < this.renderers.length; ++i) {
                    WorldRenderer wr = this.renderers[i];
                    wr.field_78927_l = true;
                    int displayList = wr.func_78909_a(pass);
                    if (displayList < 0) continue;
                    RenderDimensionSliceEntity.this.func_110776_a(Core.blockAtlas);
                    GL11.glCallList((int)displayList);
                }
            }
            GL11.glPopAttrib();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void renderEntities(float partialTicks) {
            RenderHelper.func_74519_b();
            double sx = TileEntityRendererDispatcher.field_147554_b;
            double sy = TileEntityRendererDispatcher.field_147555_c;
            double sz = TileEntityRendererDispatcher.field_147552_d;
            double px = TileEntityRendererDispatcher.field_147556_a.field_147560_j;
            double py = TileEntityRendererDispatcher.field_147556_a.field_147561_k;
            double pz = TileEntityRendererDispatcher.field_147556_a.field_147558_l;
            TileEntityRendererDispatcher.field_147556_a.field_147560_j = RenderDimensionSliceEntity.this.shadowEye.field_70165_t;
            TileEntityRendererDispatcher.field_147556_a.field_147561_k = RenderDimensionSliceEntity.this.shadowEye.field_70163_u;
            TileEntityRendererDispatcher.field_147556_a.field_147558_l = RenderDimensionSliceEntity.this.shadowEye.field_70161_v;
            try {
                int xwidth = this.far.x - this.corner.x;
                int height = this.far.y - this.corner.y;
                int zwidth = this.far.z - this.corner.z;
                for (int cdx = 0; cdx < xwidth; ++cdx) {
                    for (int cdz = 0; cdz < zwidth; ++cdz) {
                        Chunk here = this.corner.w.func_72938_d(this.corner.x + cdx * 16, this.corner.z + cdz * 16);
                        Core.profileStart("entity");
                        for (int i1 = 0; i1 < here.field_76645_j.length; ++i1) {
                            List ents = here.field_76645_j[i1];
                            for (int i2 = 0; i2 < ents.size(); ++i2) {
                                Entity e = (Entity)ents.get(i2);
                                if (e.field_70163_u < (double)(this.corner.y - 8) || e.field_70163_u > (double)(this.far.y + 8) || nest == 3 && e instanceof DimensionSliceEntity) continue;
                                RenderManager.field_78727_a.func_147937_a(e, partialTicks);
                            }
                        }
                        Core.profileEnd();
                        Core.profileStart("tesr");
                        for (TileEntity te : here.field_150816_i.values()) {
                            TileEntityRendererDispatcher.field_147556_a.func_147544_a(te, partialTicks);
                        }
                        Core.profileEnd();
                    }
                }
            }
            finally {
                TileEntityRendererDispatcher.field_147554_b = sx;
                TileEntityRendererDispatcher.field_147555_c = sy;
                TileEntityRendererDispatcher.field_147552_d = sz;
                TileEntityRendererDispatcher.field_147556_a.field_147560_j = px;
                TileEntityRendererDispatcher.field_147556_a.field_147561_k = py;
                TileEntityRendererDispatcher.field_147556_a.field_147558_l = pz;
            }
        }

        void renderBreakingBlocks(EntityPlayer player, float partial) {
            HashMap<Integer, DestroyBlockProgress> damagedBlocks = HammerClientProxy.shadowRenderGlobal.damagedBlocks;
            if (damagedBlocks.isEmpty()) {
                return;
            }
            Coord a = this.dse.getCorner();
            Coord b = this.dse.getFarCorner();
            Tessellator tess = Tessellator.field_78398_a;
            this.startDamageDrawing(tess, player, partial);
            Minecraft mc = Minecraft.func_71410_x();
            RenderGlobal realRg = HammerClientProxy.getRealRenderGlobal();
            for (DestroyBlockProgress damage : damagedBlocks.values()) {
                if (a.x > damage.func_73110_b() || damage.func_73110_b() > b.x || a.y > damage.func_73109_c() || damage.func_73109_c() > b.y || a.z > damage.func_73108_d() || damage.func_73108_d() > b.z) continue;
                this.renderDamage(a.w, damage, realRg.field_94141_F);
            }
            this.endDamageDrawing(tess);
        }

        void renderDamage(World world, DestroyBlockProgress damage, IIcon[] destructionIcons) {
            Block block = world.func_147439_a(damage.func_73110_b(), damage.func_73109_c(), damage.func_73108_d());
            if (block.func_149688_o() != Material.field_151579_a) {
                this.rb.func_147792_a(block, damage.func_73110_b(), damage.func_73109_c(), damage.func_73108_d(), destructionIcons[damage.func_73106_e()]);
            }
        }

        void startDamageDrawing(Tessellator tess, EntityPlayer player, float partial) {
            GL11.glPushAttrib((int)1048575);
            GL11.glShadeModel((int)7424);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
            OpenGlHelper.func_148821_a((int)774, (int)768, (int)1, (int)0);
            RenderDimensionSliceEntity.this.func_110776_a(TextureMap.field_110575_b);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            GL11.glPolygonOffset((float)-3.0f, (float)-3.0f);
            GL11.glEnable((int)32823);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glEnable((int)3008);
            tess.func_78382_b();
            double dx = NumUtil.interp(player.field_70169_q, player.field_70165_t, (double)partial);
            double dy = NumUtil.interp(player.field_70167_r, player.field_70163_u, (double)partial);
            double dz = NumUtil.interp(player.field_70166_s, player.field_70161_v, (double)partial);
            tess.func_78373_b(-dx, -dy, -dz);
            tess.func_78383_c();
        }

        void endDamageDrawing(Tessellator tess) {
            tess.func_78381_a();
            tess.func_78373_b(0.0, 0.0, 0.0);
            GL11.glPopAttrib();
        }

        int getRenderList() {
            if (this.renderList == -1) {
                this.renderList = GLAllocation.func_74526_a((int)(3 * this.cubicChunkCount));
                RenderDimensionSliceEntity.this.renderInfoTracker.add(this);
                if (this.renderList == -1) {
                    Core.logWarning("GL display list allocation failed!", new Object[0]);
                }
            }
            return this.renderList;
        }

        void discardRenderList() {
            if (this.renderList != -1) {
                GLAllocation.func_74523_b((int)this.renderList);
                this.renderList = -1;
            }
            this.dse.renderInfo = null;
        }
    }
}

