/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import factorization.api.Coord;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class TransferLib {
    public static int default_set_method = 0;
    public static final int SET_SNEAKY = 0;
    public static final int SET_SNEAKY_NO_LIGHTING_UPDATES = 1;
    public static final int SET_ISREMOTE = 2;
    public static final int SET_DIRECT = 3;
    public static final int SET_VANILLA_FLAGS = 4;
    public static final int SET_CHUNKY = 5;
    private static TileEntity wiper = new TileEntity();

    public static void setRaw(Coord c, Block id, int md) {
        TransferLib.setRaw(c, id, md, default_set_method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRaw(Coord c, Block id, int md, int use_method) {
        if (c.y < 0) {
            return;
        }
        if (c.y > 255) {
            return;
        }
        switch (use_method) {
            default: {
                TileEntity te;
                Chunk chunk = c.getChunk();
                int blockXChunk = c.x & 0xF;
                int blockZChunk = c.z & 0xF;
                int blockYChunk = c.y & 0xF;
                int xzIndex = blockZChunk << 4 | blockXChunk;
                if (c.y >= chunk.field_76638_b[xzIndex] - 1) {
                    chunk.field_76638_b[xzIndex] = -999;
                }
                if ((te = chunk.getTileEntityUnsafe(blockXChunk, c.y, blockZChunk)) != null) {
                    chunk.field_76637_e.func_147475_p(c.x, c.y, c.z);
                }
                int origColumHeight = chunk.field_76634_f[xzIndex];
                Block origBlock = chunk.func_150810_a(blockXChunk, c.y, blockZChunk);
                int origMd = chunk.func_76628_c(blockXChunk, c.y, blockZChunk);
                if (origBlock == id && origMd == md) {
                    return;
                }
                chunk.func_76630_e();
                ExtendedBlockStorage[] storageArrays = chunk.func_76587_i();
                ExtendedBlockStorage extendedblockstorage = storageArrays[c.y >> 4];
                boolean extendsHeight = false;
                if (extendedblockstorage == null) {
                    if (id == Blocks.field_150350_a) {
                        return;
                    }
                    ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(c.y >> 4 << 4, !chunk.field_76637_e.field_73011_w.field_76576_e);
                    storageArrays[c.y >> 4] = extendedBlockStorage;
                    extendedblockstorage = extendedBlockStorage;
                    extendsHeight = c.y >= origColumHeight;
                }
                extendedblockstorage.func_150818_a(blockXChunk, blockYChunk, blockZChunk, id);
                extendedblockstorage.func_76654_b(blockXChunk, blockYChunk, blockZChunk, md);
                if (extendedblockstorage.func_150819_a(blockXChunk, c.y & 0xF, blockZChunk) != id) {
                    return;
                }
                if (use_method == 1) {
                    return;
                }
                chunk.field_76643_l = true;
                if (extendsHeight) {
                    chunk.func_76603_b();
                    return;
                }
                int newOpacity = id.func_149717_k();
                int oldOpacity = origBlock.func_149717_k();
                if (newOpacity > 0) {
                    if (c.y >= origColumHeight) {
                        chunk.func_76615_h(blockXChunk, c.y + 1, blockZChunk);
                    }
                } else if (c.y == origColumHeight - 1) {
                    chunk.func_76615_h(blockXChunk, c.y, blockZChunk);
                }
                if (newOpacity == oldOpacity) {
                    return;
                }
                if (newOpacity >= oldOpacity && chunk.func_76614_a(EnumSkyBlock.Sky, blockXChunk, c.y, blockZChunk) <= 0 && chunk.func_76614_a(EnumSkyBlock.Block, blockXChunk, c.y, blockZChunk) <= 0) break;
                chunk.func_76595_e(blockXChunk, blockZChunk);
                break;
            }
            case 2: {
                boolean rem = c.w.field_72995_K;
                c.w.field_72995_K = true;
                try {
                    c.setIdMd(id, md, false);
                    break;
                }
                finally {
                    c.w.field_72995_K = rem;
                }
            }
            case 3: {
                c.setIdMd(id, md, false);
                break;
            }
            case 4: {
                c.w.func_147465_d(c.x, c.y, c.z, id, md, 0);
                break;
            }
            case 5: {
                Chunk chunk = c.w.func_72938_d(c.x, c.z);
                chunk.func_150807_a(c.x & 0xF, c.y, c.z & 0xF, id, md);
                c.markBlockForUpdate();
            }
        }
    }

    public static void rawRemoveTE(Coord c) {
        Chunk chunk = c.w.func_72938_d(c.x, c.z);
        chunk.field_150816_i.remove(new ChunkPosition(c.x & 0xF, c.y, c.z & 0xF));
    }

    public static TileEntity move(Coord src, Coord dest, boolean wipeSrc, boolean overwriteDestination) {
        return TransferLib.move(src, dest, wipeSrc, overwriteDestination, default_set_method);
    }

    public static TileEntity move(Coord src, Coord dest, boolean wipeSrc, boolean overwriteDestination, int setMethod) {
        Block id = src.getId();
        int md = src.getMd();
        int blockLight = src.getLightLevelBlock();
        int skyLight = src.getLightLevelSky();
        if (id == null && !overwriteDestination) {
            return null;
        }
        long block_tick_time = -1L;
        int block_tick_priority = -1;
        List pendingTicks = src.w.func_72920_a(src.getChunk(), false);
        if (pendingTicks != null) {
            for (NextTickListEntry tick : pendingTicks) {
                if (tick.field_77183_a != src.x || tick.field_77181_b != src.y || tick.field_77182_c != src.z) continue;
                block_tick_time = tick.field_77180_e - src.w.func_72912_H().func_82573_f();
                block_tick_priority = tick.field_82754_f;
                break;
            }
        }
        TileEntity te = src.getTE();
        NBTTagCompound teData = null;
        if (te != null) {
            teData = new NBTTagCompound();
            te.func_145841_b(teData);
            if (wipeSrc) {
                wiper.func_145829_t();
                src.setTE(wiper);
                TransferLib.rawRemoveTE(src);
            }
        }
        if (wipeSrc) {
            TransferLib.setRaw(src, Blocks.field_150350_a, 0);
        }
        wiper.func_145834_a(null);
        if (dest.getTE() != null) {
            TransferLib.rawRemoveTE(dest);
        }
        TransferLib.setRaw(dest, id, md);
        dest.setLightLevelBlock(blockLight);
        dest.setLightLevelSky(skyLight);
        TileEntity ret = null;
        if (teData != null) {
            teData.func_74768_a("x", dest.x);
            teData.func_74768_a("y", dest.y);
            teData.func_74768_a("z", dest.z);
            ret = TileEntity.func_145827_c((NBTTagCompound)teData);
            ret.func_145829_t();
            dest.setTE(ret);
        }
        if (block_tick_time > -1L) {
            dest.w.func_147454_a(dest.x, dest.y, dest.z, id, (int)block_tick_time, block_tick_priority);
        }
        return ret;
    }

    public static void rawErase(Coord c) {
        TileEntity te = c.getTE();
        if (te != null) {
            c.rmTE();
        }
        TransferLib.setRaw(c, Blocks.field_150350_a, 0);
    }
}

